/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 47 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  Expr * yy386;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
  int yy495;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 588
#define YYNRULE 312
#define YYERRORSYMBOL 138
#define YYERRSYMDT yy495
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   293,  901,  124,  587,  410,  172,    2,  419,   61,   61,
 /*    10 */    61,   61,  519,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  210,  448,  212,  426,  432,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  210,
 /*    40 */   392,  389,  397,  452,   60,   59,  298,  436,  437,  433,
 /*    50 */   433,   62,   62,   61,   61,   61,   61,  263,   63,   63,
 /*    60 */    63,   63,   64,   64,   65,   65,   65,   66,  210,  293,
 /*    70 */   494,  495,  419,  490,  208,   82,   67,  421,   69,  154,
 /*    80 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*    90 */   210,   67,  463,   69,  154,  426,  432,  573,  264,   58,
 /*   100 */    64,   64,   65,   65,   65,   66,  210,  398,  399,  423,
 /*   110 */   423,  423,  293,   60,   59,  298,  436,  437,  433,  433,
 /*   120 */    62,   62,   61,   61,   61,   61,  318,   63,   63,   63,
 /*   130 */    63,   64,   64,   65,   65,   65,   66,  210,  426,  432,
 /*   140 */    94,   65,   65,   65,   66,  210,  397,  210,  415,   34,
 /*   150 */    56,  299,  443,  444,  411,  475,   60,   59,  298,  436,
 /*   160 */   437,  433,  433,   62,   62,   61,   61,   61,   61,  489,
 /*   170 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   180 */   210,  293,  257,  524,  296,  571,  113,  409,  522,  452,
 /*   190 */   332,  318,  408,   20,  239,  341,  519,  397,  491,  531,
 /*   200 */   506,  448,  212,  570,  569,  208,  530,  426,  432,  149,
 /*   210 */   150,  398,  399,  415,   41,  211,  151,  533,  373,  490,
 /*   220 */   261,  568,  259,  421,  293,   60,   59,  298,  436,  437,
 /*   230 */   433,  433,   62,   62,   61,   61,   61,   61,  318,   63,
 /*   240 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  210,
 /*   250 */   426,  432,  448,  334,  215,  423,  423,  423,  364,  550,
 /*   260 */   415,   41,  398,  399,  367,  567,  211,  293,   60,   59,
 /*   270 */   298,  436,  437,  433,  433,   62,   62,   61,   61,   61,
 /*   280 */    61,  340,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   290 */    65,   66,  210,  426,  432,  181,  301,  549,  346,  349,
 /*   300 */   350,  214,  286,  415,    3,  450,  523,  168,   19,  351,
 /*   310 */   144,   60,   59,  298,  436,  437,  433,  433,   62,   62,
 /*   320 */    61,   61,   61,   61,  532,   63,   63,   63,   63,   64,
 /*   330 */    64,   65,   65,   65,   66,  210,  656,  318,  342,   77,
 /*   340 */   293,  581,  291,  524,  485,  153,  230,  374,  269,  268,
 /*   350 */   152,  656,  578,   20,  492,  656,  525,  656,  208,  415,
 /*   360 */    27,  209,  517,  412,  221,  414,  426,  432,   55,  413,
 /*   370 */   164,  118,  243,  344,  248,  345,  176,  237,  656,  416,
 /*   380 */    66,  210,   80,  252,   60,   59,  298,  436,  437,  433,
 /*   390 */   433,   62,   62,   61,   61,   61,   61,  304,   63,   63,
 /*   400 */    63,   63,   64,   64,   65,   65,   65,   66,  210,  293,
 /*   410 */   475,  301,  391,  488,   67,    2,   69,  154,  181,  656,
 /*   420 */   318,  346,  349,  350,  329,  656,  656,  656,  656,  656,
 /*   430 */   656,  656,  351,  656,  571,  426,  432,  244,  656,  656,
 /*   440 */   251,  524,  415,   35,  547,  495,  174,  229,  245,  241,
 /*   450 */   534,   20,  570,   60,   59,  298,  436,  437,  433,  433,
 /*   460 */    62,   62,   61,   61,   61,   61,  468,   63,   63,   63,
 /*   470 */    63,   64,   64,   65,   65,   65,   66,  210,  293,  221,
 /*   480 */   416,  583,  505,  397,  457,  318,  118,  243,  344,  248,
 /*   490 */   345,  176,  175,  160,  236,  318,  458,  339,  252,  171,
 /*   500 */   160,  323,  443,  444,  426,  432,    1,  415,   28,  459,
 /*   510 */   397,  496,    9,  475,  383,  211,  397,  415,   34,  479,
 /*   520 */   584,  497,   60,   59,  298,  436,  437,  433,  433,   62,
 /*   530 */    62,   61,   61,   61,   61,  177,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  210,  293,  398,  399,
 /*   550 */   181,  255,  481,  346,  349,  350,  318,  147,  354,  336,
 /*   560 */   484,  318,  397,  470,  351,  211,  128,  427,  428,   67,
 /*   570 */   201,   69,  154,  426,  432,  398,  399,   18,  415,   49,
 /*   580 */   300,  398,  399,  415,   49,  177,  479,  159,  430,  431,
 /*   590 */   295,   60,   59,  298,  436,  437,  433,  433,   62,   62,
 /*   600 */    61,   61,   61,   61,  416,   63,   63,   63,   63,   64,
 /*   610 */    64,   65,   65,   65,   66,  210,  293,  429,  273,  483,
 /*   620 */    67,   93,   69,  154,  309,  382,    8,  398,  399,  310,
 /*   630 */   158,  318,  450,  324,  168,  588,  392,  389,  517,  155,
 /*   640 */   295,  503,  426,  432,  208,  252,  321,  362,  439,  439,
 /*   650 */   337,  263,  440,  415,   34,  470,  276,  381,  274,  293,
 /*   660 */    60,   59,  298,  436,  437,  433,  433,   62,   62,   61,
 /*   670 */    61,   61,   61,  416,   63,   63,   63,   63,   64,   64,
 /*   680 */    65,   65,   65,   66,  210,  426,  432,  453,  314,  393,
 /*   690 */   585,  892,  385,  892,  207,  332,  585,  891,  238,  891,
 /*   700 */   331,  200,  293,   60,   59,  298,  436,  437,  433,  433,
 /*   710 */    62,   62,   61,   61,   61,   61,  250,   63,   63,   63,
 /*   720 */    63,   64,   64,   65,   65,   65,   66,  210,  426,  432,
 /*   730 */   582,  194,  400,  401,  402,  416,  582,  275,  321,  517,
 /*   740 */   439,  439,  319,  387,  192,  293,   60,   70,  298,  436,
 /*   750 */   437,  433,  433,   62,   62,   61,   61,   61,   61,  380,
 /*   760 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   770 */   210,  426,  432,  321,  222,  439,  439,  396,  416,  321,
 /*   780 */   119,  439,  439,  544,  540,  361,  540,  388,  293,  225,
 /*   790 */    59,  298,  436,  437,  433,  433,   62,   62,   61,   61,
 /*   800 */    61,   61,  372,   63,   63,   63,   63,   64,   64,   65,
 /*   810 */    65,   65,   66,  210,  426,  432,  397,  251,  397,    5,
 /*   820 */   375,  178,  179,  180,  172,  368,  419,  196,  263,  263,
 /*   830 */    84,  371,  312,  123,  298,  436,  437,  433,  433,   62,
 /*   840 */    62,   61,   61,   61,   61,  318,   63,   63,   63,   63,
 /*   850 */    64,   64,   65,   65,   65,   66,  210,   72,  325,  546,
 /*   860 */     4,  416,  517,  318,  297,  457,  419,  415,   23,  557,
 /*   870 */   559,  318,  322,   72,  325,  517,    4,  458,  318,  422,
 /*   880 */   297,  398,  399,  398,  399,  415,   32,  449,  322,  327,
 /*   890 */   459,  419,  328,  415,   53,  318,  223,  305,  824,  452,
 /*   900 */   415,   52,  318,  330,  318,  327,  371,  471,  156,  472,
 /*   910 */   306,  479,  446,  446,  461,  452,  318,  415,   98,   75,
 /*   920 */    74,   76,  517,   78,  415,   96,  415,  101,   73,  316,
 /*   930 */   317,  419,  263,  421,  474,   75,   74,  482,  415,  102,
 /*   940 */   251,  318,  416,  469,   73,  316,  317,   72,  325,  421,
 /*   950 */     4,  208,  318,  251,  297,  318,  183,  307,  165,  478,
 /*   960 */   510,  249,  322,  415,  112,  423,  423,  423,  424,  425,
 /*   970 */    11,  224,  308,  560,  415,  114,  507,  415,   16,  327,
 /*   980 */   511,  423,  423,  423,  424,  425,   11,  292,  414,  452,
 /*   990 */   416,  162,  413,  318,  465,  263,  226,  227,  228,  104,
 /*  1000 */   251,  466,  318,  500,  501,  318,  263,  318,  512,   75,
 /*  1010 */    74,  513,  205,   21,  281,  415,   99,  419,   73,  316,
 /*  1020 */   317,  282,  318,  421,  415,   33,  318,  415,   97,  415,
 /*  1030 */    24,  318,  303,  203,  526,  549,  561,  263,  263,  202,
 /*  1040 */   318,  256,  204,  318,  415,   54,  318,  277,  415,  115,
 /*  1050 */   318,  622,  318,  415,  116,  423,  423,  423,  424,  425,
 /*  1060 */    11,  186,  415,  117,  258,  415,   25,  318,  415,   36,
 /*  1070 */   320,  260,  415,   37,  415,   26,  318,  189,  379,  279,
 /*  1080 */   262,  318,  419,  318,  358,  378,  278,  268,  267,  415,
 /*  1090 */    38,  294,  318,  542,  318,  416,  208,  541,  415,   39,
 /*  1100 */   318,  366,  318,  415,   40,  415,   42,  509,  508,  363,
 /*  1110 */   318,  441,  318,   22,  415,   43,  415,   44,  318,  477,
 /*  1120 */   384,  173,  415,   29,  415,   30,  318,  369,  514,  318,
 /*  1130 */   128,  318,  415,   45,  415,   46,  254,  318,  128,  318,
 /*  1140 */   415,   47,  353,  545,  128,  128,  434,  370,  415,   48,
 /*  1150 */   270,  415,   31,  415,   10,  553,  554,  173,   91,  415,
 /*  1160 */    50,  415,   51,  564,  580,   91,  290,  271,  272,  556,
 /*  1170 */   566,  280,  283,  284,  577,  420,  146,  406,  445,  447,
 /*  1180 */   231,  326,  464,  467,  246,  506,  348,  515,  163,  518,
 /*  1190 */   516,  520,  552,  563,  395,  403,  404,  405,    7,  315,
 /*  1200 */    84,  232,  335,  333,  233,   83,   79,  417,   57,  170,
 /*  1210 */   213,  462,  125,   85,  493,  234,  338,  343,  498,  302,
 /*  1220 */   499,  503,  105,  247,  219,  521,  502,  504,  235,  287,
 /*  1230 */   418,  218,  220,  527,  528,  529,  355,  240,  359,  476,
 /*  1240 */   242,  288,  480,  184,   88,  535,  185,  121,  357,  187,
 /*  1250 */   548,  132,  188,  193,  537,  190,  142,  365,  376,  555,
 /*  1260 */   377,  133,  134,  311,  135,  136,  562,  138,  574,  265,
 /*  1270 */   575,  141,  576,  538,  579,  394,   92,   95,  217,  407,
 /*  1280 */   100,  623,  103,  624,  111,  166,  167,  435,  438,   17,
 /*  1290 */    71,  454,  442,  451,  143,  157,  120,  455,  473,  456,
 /*  1300 */   169,  460,    6,   13,  122,   81,   12,  126,  161,  127,
 /*  1310 */   486,  487,  216,   86,  347,  106,  313,  253,  107,   87,
 /*  1320 */   108,  182,  245,  356,  145,  536,  352,  129,  360,  191,
 /*  1330 */   266,  130,  173,  109,  289,  551,  539,   89,  543,  131,
 /*  1340 */   195,   14,  198,  197,  558,  139,  140,  137,  199,   15,
 /*  1350 */   565,  572,  110,  285,  148,   90,  390,  206,  586,  386,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  139,  140,  141,  168,   21,  144,   23,   69,   70,
 /*    10 */    71,   72,  176,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,   78,   79,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */     1,    2,   23,   58,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  147,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   185,  186,   88,   88,  110,   22,  217,   92,  219,  220,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  217,  218,  219,  220,   42,   43,  238,  188,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,   88,   89,  124,
 /*   110 */   125,  126,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   80,   81,   82,   83,   84,   23,   84,  169,  170,
 /*   150 */    19,  164,  165,  166,   23,  161,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  169,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,   14,  147,  150,  147,   21,  167,  168,   58,
 /*   190 */   211,  147,  156,  157,  200,  216,  176,   23,  169,  176,
 /*   200 */   177,   78,   79,  165,  166,  110,  183,   42,   43,   78,
 /*   210 */    79,   88,   89,  169,  170,  228,  180,  181,  123,   88,
 /*   220 */    52,   98,   54,   92,   16,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,  147,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   78,  209,  210,  124,  125,  126,  224,   11,
 /*   260 */   169,  170,   88,   89,  230,  227,  228,   16,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,  147,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,   90,   16,   49,   93,   94,
 /*   300 */    95,  210,  158,  169,  170,  161,  162,  163,   19,  104,
 /*   310 */    21,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,  181,   74,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,    1,  147,   80,  131,
 /*   340 */    16,  244,  245,  147,   20,  155,  190,   99,  100,  101,
 /*   350 */    22,   16,  156,  157,  160,   20,  181,   22,  110,  169,
 /*   360 */   170,  192,  147,  169,   84,  107,   42,   43,  199,  111,
 /*   370 */    90,   91,   92,   93,   94,   95,   96,  147,   43,  189,
 /*   380 */    83,   84,  131,  103,   60,   61,   62,   63,   64,   65,
 /*   390 */    66,   67,   68,   69,   70,   71,   72,  182,   74,   75,
 /*   400 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   410 */   161,   16,  141,   20,  217,  144,  219,  220,   90,   84,
 /*   420 */   147,   93,   94,   95,  186,   90,   91,   92,   93,   94,
 /*   430 */    95,   96,  104,   98,  147,   42,   43,   92,  103,  104,
 /*   440 */   225,  147,  169,  170,  185,  186,  155,  153,  103,  200,
 /*   450 */   156,  157,  165,   60,   61,   62,   63,   64,   65,   66,
 /*   460 */    67,   68,   69,   70,   71,   72,   22,   74,   75,   76,
 /*   470 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   84,
 /*   480 */   189,   20,   20,   23,   12,  147,   91,   92,   93,   94,
 /*   490 */    95,   96,  201,  202,  221,  147,   24,  206,  103,  201,
 /*   500 */   202,  164,  165,  166,   42,   43,   19,  169,  170,   37,
 /*   510 */    23,   39,   19,  161,  227,  228,   23,  169,  170,  147,
 /*   520 */    59,   49,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   530 */    68,   69,   70,   71,   72,   43,   74,   75,   76,   77,
 /*   540 */    78,   79,   80,   81,   82,   83,   84,   16,   88,   89,
 /*   550 */    90,   20,  200,   93,   94,   95,  147,  113,   16,  211,
 /*   560 */    20,  147,   23,   22,  104,  228,   22,   42,   43,  217,
 /*   570 */   155,  219,  220,   42,   43,   88,   89,   19,  169,  170,
 /*   580 */   208,   88,   89,  169,  170,   43,  147,  147,   63,   64,
 /*   590 */    98,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   600 */    69,   70,   71,   72,  189,   74,   75,   76,   77,   78,
 /*   610 */    79,   80,   81,   82,   83,   84,   16,   92,   14,   80,
 /*   620 */   217,   21,  219,  220,  215,   91,   68,   88,   89,  215,
 /*   630 */    89,  147,  161,  162,  163,    0,    1,    2,  147,  155,
 /*   640 */    98,   97,   42,   43,  110,  103,  106,  208,  108,  109,
 /*   650 */   147,  147,   20,  169,  170,  114,   52,  123,   54,   16,
 /*   660 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   670 */    70,   71,   72,  189,   74,   75,   76,   77,   78,   79,
 /*   680 */    80,   81,   82,   83,   84,   42,   43,   20,  142,  143,
 /*   690 */    19,   20,  188,   22,  148,  211,   19,   20,  147,   22,
 /*   700 */   216,  155,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   710 */    67,   68,   69,   70,   71,   72,  225,   74,   75,   76,
 /*   720 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   730 */    59,   22,    7,    8,    9,  189,   59,  133,  106,  147,
 /*   740 */   108,  109,  147,  239,  155,   16,   60,   61,   62,   63,
 /*   750 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  213,
 /*   760 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   770 */    84,   42,   43,  106,  182,  108,  109,  147,  189,  106,
 /*   780 */   147,  108,  109,   18,   99,  100,  101,  241,   16,  145,
 /*   790 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   800 */    71,   72,  213,   74,   75,   76,   77,   78,   79,   80,
 /*   810 */    81,   82,   83,   84,   42,   43,   23,  225,   23,  191,
 /*   820 */    55,   99,  100,  101,   21,  236,   23,  155,  147,  147,
 /*   830 */   121,  147,  242,  243,   62,   63,   64,   65,   66,   67,
 /*   840 */    68,   69,   70,   71,   72,  147,   74,   75,   76,   77,
 /*   850 */    78,   79,   80,   81,   82,   83,   84,   16,   17,   94,
 /*   860 */    19,  189,  147,  147,   23,   12,   23,  169,  170,  188,
 /*   870 */   188,  147,   31,   16,   17,  147,   19,   24,  147,  147,
 /*   880 */    23,   88,   89,   88,   89,  169,  170,  161,   31,   48,
 /*   890 */    37,   88,   39,  169,  170,  147,  212,  182,  133,   58,
 /*   900 */   169,  170,  147,  147,  147,   48,  147,  114,  155,  114,
 /*   910 */   182,  147,  124,  125,  147,   58,  147,  169,  170,   78,
 /*   920 */    79,  130,  147,  132,  169,  170,  169,  170,   87,   88,
 /*   930 */    89,   88,  147,   92,  147,   78,   79,   80,  169,  170,
 /*   940 */   225,  147,  189,  203,   87,   88,   89,   16,   17,   92,
 /*   950 */    19,  110,  147,  225,   23,  147,  155,  182,   19,  147,
 /*   960 */    30,  147,   31,  169,  170,  124,  125,  126,  127,  128,
 /*   970 */   129,  212,  208,  188,  169,  170,  147,  169,  170,   48,
 /*   980 */    50,  124,  125,  126,  127,  128,  129,  178,  107,   58,
 /*   990 */   189,    5,  111,  147,   27,  147,   10,   11,   12,   13,
 /*  1000 */   225,   34,  147,    7,    8,  147,  147,  147,  178,   78,
 /*  1010 */    79,  178,   26,   19,   28,  169,  170,   23,   87,   88,
 /*  1020 */    89,   35,  147,   92,  169,  170,  147,  169,  170,  169,
 /*  1030 */   170,  147,  102,   47,  147,   49,  188,  147,  147,   53,
 /*  1040 */   147,  147,   56,  147,  169,  170,  147,  188,  169,  170,
 /*  1050 */   147,  112,  147,  169,  170,  124,  125,  126,  127,  128,
 /*  1060 */   129,  155,  169,  170,  147,  169,  170,  147,  169,  170,
 /*  1070 */    16,  147,  169,  170,  169,  170,  147,  232,  188,  188,
 /*  1080 */   147,  147,   88,  147,  233,   99,  100,  101,  147,  169,
 /*  1090 */   170,  105,  147,   25,  147,  189,  110,   29,  169,  170,
 /*  1100 */   147,  147,  147,  169,  170,  169,  170,   91,   92,   41,
 /*  1110 */   147,   20,  147,   22,  169,  170,  169,  170,  147,   20,
 /*  1120 */   134,   22,  169,  170,  169,  170,  147,  147,   20,  147,
 /*  1130 */    22,  147,  169,  170,  169,  170,   20,  147,   22,  147,
 /*  1140 */   169,  170,   20,   20,   22,   22,   92,  147,  169,  170,
 /*  1150 */   147,  169,  170,  169,  170,   20,   20,   22,   22,  169,
 /*  1160 */   170,  169,  170,   20,   20,   22,   22,  147,  147,  147,
 /*  1170 */   147,  147,  147,  147,  147,  161,  191,  149,  229,  229,
 /*  1180 */   193,  223,  172,  172,  172,  177,  173,  172,    6,  172,
 /*  1190 */   161,  161,  194,  194,  146,  146,  146,  146,   22,  154,
 /*  1200 */   121,  194,  118,  116,  195,  119,  130,  189,  120,  112,
 /*  1210 */   222,  152,  152,   98,  171,  196,  115,   98,  171,   40,
 /*  1220 */   179,   97,   19,  171,   84,  179,  173,  171,  197,  174,
 /*  1230 */   198,  226,  226,  171,  171,  171,   15,  204,   38,  205,
 /*  1240 */   204,  174,  205,  151,  130,  152,  151,   60,  152,  151,
 /*  1250 */   184,   19,  152,  184,  152,  151,  214,  152,  152,  194,
 /*  1260 */    15,  187,  187,  152,  187,  187,  194,  184,   33,  234,
 /*  1270 */   152,  214,  152,  235,  137,    1,  237,  237,  175,   20,
 /*  1280 */   159,  112,  175,  112,  240,  112,  112,   92,  107,  231,
 /*  1290 */    19,   11,   20,   20,   19,   19,   32,   20,  114,   20,
 /*  1300 */    22,   20,  117,  117,  243,   22,   22,   19,  112,   20,
 /*  1310 */    20,   20,   44,   19,   44,   19,  246,   20,   19,   19,
 /*  1320 */    19,   96,  103,   16,   21,   17,   44,   98,   36,   98,
 /*  1330 */   133,   45,   22,   19,    5,    1,   51,   68,   45,  102,
 /*  1340 */   122,   19,   14,  113,   17,  102,  122,  113,  115,   19,
 /*  1350 */   123,   20,   14,  136,   19,   68,    3,  135,    4,   57,
};
#define YY_SHIFT_USE_DFLT (-62)
#define YY_SHIFT_MAX 390
static const short yy_shift_ofst[] = {
 /*     0 */    39,  841,  986,  -16,  841,  931,  931,  460,  123,  -36,
 /*    10 */    96,  931,  931,  931,  931,  931,  -45,  248,  174,   19,
 /*    20 */   843,  -54,  -54,   53,  165,  208,  251,  324,  393,  462,
 /*    30 */   531,  600,  643,  686,  643,  643,  643,  643,  643,  643,
 /*    40 */   643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
 /*    50 */   643,  643,  729,  772,  772,  857,  931,  931,  931,  931,
 /*    60 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    70 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    80 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    90 */   931,  931,  931,  931,  931,  931,  -61,  -61,    6,    6,
 /*   100 */   280,   22,   61,  542,  765,   19,   19,   19,   19,   19,
 /*   110 */    19,   19,  297,  843,   63,  -62,  -62,  -62,  131,  395,
 /*   120 */   472,  472,  671,  677,  635,  803,   19,  803,   19,   19,
 /*   130 */    19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
 /*   140 */    19,  534,   95,  -36,  -36,  -36,  -62,  -62,  -62,  -15,
 /*   150 */   -15,  328,  205,  540,  487,  632,  667,  853,  793,  795,
 /*   160 */   493,  539,  725,   19,   19,  258,   19,   19,  994,   19,
 /*   170 */    19,  541,   19,   19,  673,  541,   19,   19,  930,  930,
 /*   180 */   930,   19,   19,  673,   19,   19,  673,   19, 1068,  685,
 /*   190 */    19,   19,  673,   19,   19,   19,  673,   19,   19,   19,
 /*   200 */   673,  673,   19,   19,   19,   19,   19,  289,  881,  444,
 /*   210 */   843,  788,  788,  791,  967,  967,  967,  492,  967,  843,
 /*   220 */   967,  843,  544,  709,  709, 1182, 1182, 1182, 1182, 1176,
 /*   230 */   -36, 1079, 1084, 1086, 1087, 1088, 1076, 1097, 1097, 1115,
 /*   240 */  1101, 1115, 1101, 1119, 1119, 1179, 1119, 1124, 1119, 1203,
 /*   250 */  1140, 1140, 1179, 1119, 1119, 1119, 1203, 1221, 1097, 1221,
 /*   260 */  1097, 1221, 1097, 1097, 1200, 1114, 1221, 1097, 1187, 1187,
 /*   270 */  1232, 1079, 1097, 1245, 1245, 1245, 1245, 1079, 1187, 1232,
 /*   280 */  1097, 1235, 1235, 1097, 1097, 1137,  -62,  -62,  -62,  -62,
 /*   290 */   -62,  -62,  335,  525,  604,  722,  168,  939, 1054, 1091,
 /*   300 */  1099,  345,  996, 1016, 1108, 1116, 1122, 1123, 1135, 1136,
 /*   310 */  1143,  558, 1144,  461, 1274, 1259, 1169, 1171, 1173, 1174,
 /*   320 */  1195, 1181, 1271, 1272, 1273, 1275, 1280, 1276, 1277, 1278,
 /*   330 */  1279, 1281, 1283, 1185, 1284, 1186, 1283, 1184, 1288, 1289,
 /*   340 */  1196, 1290, 1291, 1264, 1268, 1294, 1270, 1296, 1297, 1299,
 /*   350 */  1300, 1282, 1301, 1225, 1219, 1307, 1308, 1303, 1229, 1292,
 /*   360 */  1285, 1286, 1310, 1293, 1197, 1231, 1314, 1329, 1334, 1237,
 /*   370 */  1269, 1287, 1218, 1322, 1230, 1328, 1233, 1327, 1234, 1243,
 /*   380 */  1224, 1330, 1227, 1331, 1338, 1302, 1222, 1217, 1335, 1353,
 /*   390 */  1354,
};
#define YY_REDUCE_USE_DFLT (-165)
#define YY_REDUCE_MAX 291
static const short yy_reduce_ofst[] = {
 /*     0 */  -138,  484,  546,  352,  190,  -21,   44,   36,   38,  291,
 /*    10 */  -141,  273,   91,  348,  409,  414, -126,  589,  287,  294,
 /*    20 */   144,  -13,  337,  403,  403,  403,  403,  403,  403,  403,
 /*    30 */   403,  403,  403,  403,  403,  403,  403,  403,  403,  403,
 /*    40 */   403,  403,  403,  403,  403,  403,  403,  403,  403,  403,
 /*    50 */   403,  403,  403,  403,  403,  134,  338,  698,  716,  724,
 /*    60 */   731,  748,  755,  757,  769,  794,  805,  808,  846,  855,
 /*    70 */   858,  860,  875,  879,  884,  893,  896,  899,  903,  905,
 /*    80 */   920,  929,  934,  936,  945,  947,  953,  955,  963,  965,
 /*    90 */   971,  979,  982,  984,  990,  992,  403,  403,  403,  403,
 /*   100 */    20,  197,  197,   23,   34,  215,  592,  715,  728,  775,
 /*   110 */   504,  196,  197,  471,  197,  197,  197,  197,  194, -164,
 /*   120 */  -115,  259,   97,   97,  271,   -6,  372,  249,  491,  -90,
 /*   130 */   439,  684,  764,  681,  682,  785,  848,  859,  890,  759,
 /*   140 */   891,  415,  672,  753,  801,  906,  169,  298,  590,    0,
 /*   150 */    29,  143,  175,  156,  230,  156,  156,  238,  440,  503,
 /*   160 */   551,  595,  644,  630,  633,  628,  595,  732,  726,  756,
 /*   170 */   767,  740,  787,  812,  156,  740,  814,  829,  809,  830,
 /*   180 */   833,  887,  894,  156,  917,  924,  156,  933,  845,  851,
 /*   190 */   941,  954,  156,  980, 1000, 1003,  156, 1020, 1021, 1022,
 /*   200 */   156,  156, 1023, 1024, 1025, 1026, 1027, 1028,  985,  987,
 /*   210 */  1014,  949,  950,  958, 1010, 1011, 1012, 1008, 1015, 1029,
 /*   220 */  1017, 1030, 1013,  998,  999, 1048, 1049, 1050, 1051, 1045,
 /*   230 */  1018, 1007, 1009, 1019, 1031, 1032,  988, 1059, 1060, 1033,
 /*   240 */  1034, 1036, 1037, 1043, 1047, 1041, 1052, 1053, 1056, 1055,
 /*   250 */  1005, 1006, 1046, 1062, 1063, 1064, 1067, 1092, 1093, 1095,
 /*   260 */  1096, 1098, 1100, 1102, 1035, 1038, 1104, 1105, 1066, 1069,
 /*   270 */  1042, 1065, 1106, 1074, 1075, 1077, 1078, 1072, 1083, 1057,
 /*   280 */  1111, 1039, 1040, 1118, 1120, 1044, 1121, 1103, 1107, 1058,
 /*   290 */  1061, 1070,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   594,  819,  900,  709,  900,  819,  900,  900,  846,  713,
 /*    10 */   875,  817,  900,  900,  900,  900,  791,  900,  846,  900,
 /*    20 */   625,  846,  846,  742,  900,  900,  900,  900,  900,  900,
 /*    30 */   900,  900,  743,  900,  821,  816,  812,  814,  813,  820,
 /*    40 */   744,  733,  740,  747,  725,  859,  749,  750,  756,  757,
 /*    50 */   876,  874,  779,  778,  797,  900,  900,  900,  900,  900,
 /*    60 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*    70 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*    80 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*    90 */   900,  900,  900,  900,  900,  900,  781,  803,  780,  790,
 /*   100 */   618,  782,  783,  678,  613,  900,  900,  900,  900,  900,
 /*   110 */   900,  900,  784,  900,  785,  798,  799,  800,  900,  900,
 /*   120 */   900,  900,  900,  900,  594,  709,  900,  709,  900,  900,
 /*   130 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   140 */   900,  900,  900,  900,  900,  900,  703,  713,  893,  900,
 /*   150 */   900,  669,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   160 */   900,  900,  601,  599,  900,  701,  900,  900,  627,  900,
 /*   170 */   900,  711,  900,  900,  716,  717,  900,  900,  900,  900,
 /*   180 */   900,  900,  900,  615,  900,  900,  690,  900,  852,  900,
 /*   190 */   900,  900,  866,  900,  900,  900,  864,  900,  900,  900,
 /*   200 */   692,  752,  833,  900,  879,  881,  900,  900,  701,  710,
 /*   210 */   900,  900,  900,  815,  736,  736,  736,  648,  736,  900,
 /*   220 */   736,  900,  651,  746,  746,  598,  598,  598,  598,  668,
 /*   230 */   900,  746,  737,  739,  729,  741,  900,  718,  718,  726,
 /*   240 */   728,  726,  728,  680,  680,  665,  680,  651,  680,  825,
 /*   250 */   830,  830,  665,  680,  680,  680,  825,  610,  718,  610,
 /*   260 */   718,  610,  718,  718,  856,  858,  610,  718,  682,  682,
 /*   270 */   758,  746,  718,  689,  689,  689,  689,  746,  682,  758,
 /*   280 */   718,  878,  878,  718,  718,  886,  635,  653,  653,  861,
 /*   290 */   893,  898,  900,  900,  900,  900,  900,  765,  900,  900,
 /*   300 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   310 */   900,  839,  900,  900,  900,  900,  770,  766,  900,  767,
 /*   320 */   900,  695,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   330 */   900,  900,  818,  900,  730,  900,  738,  900,  900,  900,
 /*   340 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   350 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   360 */   900,  854,  855,  900,  900,  900,  900,  900,  900,  900,
 /*   370 */   900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
 /*   380 */   900,  900,  900,  900,  900,  885,  900,  900,  888,  595,
 /*   390 */   900,  589,  592,  591,  593,  597,  600,  622,  623,  624,
 /*   400 */   602,  603,  604,  605,  606,  607,  608,  614,  616,  634,
 /*   410 */   636,  620,  638,  699,  700,  762,  693,  694,  698,  621,
 /*   420 */   773,  764,  768,  769,  771,  772,  786,  787,  789,  795,
 /*   430 */   802,  805,  788,  793,  794,  796,  801,  804,  696,  697,
 /*   440 */   808,  628,  629,  632,  633,  842,  844,  843,  845,  631,
 /*   450 */   630,  774,  777,  810,  811,  867,  868,  869,  870,  871,
 /*   460 */   806,  719,  809,  792,  731,  734,  735,  732,  702,  712,
 /*   470 */   721,  722,  723,  724,  707,  708,  714,  727,  760,  761,
 /*   480 */   715,  704,  705,  706,  807,  763,  775,  776,  639,  640,
 /*   490 */   770,  641,  642,  643,  681,  684,  685,  686,  644,  663,
 /*   500 */   666,  667,  645,  652,  646,  647,  654,  655,  659,  660,
 /*   510 */   661,  662,  657,  658,  826,  827,  831,  829,  828,  649,
 /*   520 */   650,  664,  637,  626,  619,  670,  673,  674,  675,  676,
 /*   530 */   677,  679,  671,  672,  617,  609,  611,  720,  848,  857,
 /*   540 */   853,  849,  850,  851,  612,  822,  823,  683,  754,  755,
 /*   550 */   847,  860,  862,  759,  863,  865,  890,  687,  688,  691,
 /*   560 */   832,  872,  745,  748,  751,  753,  834,  835,  836,  837,
 /*   570 */   840,  841,  838,  873,  877,  880,  882,  883,  884,  887,
 /*   580 */   889,  894,  895,  896,  899,  897,  596,  590,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "idxitem",       "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE ids",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE ids",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT expr",
 /* 210 */ "expr ::= BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= nexprlist",
 /* 231 */ "exprlist ::=",
 /* 232 */ "nexprlist ::= nexprlist COMMA expr",
 /* 233 */ "nexprlist ::= expr",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "collate ::=",
 /* 243 */ "collate ::= COLLATE ids",
 /* 244 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 245 */ "cmd ::= VACUUM",
 /* 246 */ "cmd ::= VACUUM nm",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 250 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 251 */ "cmd ::= PRAGMA nm dbnm",
 /* 252 */ "nmnum ::= plus_num",
 /* 253 */ "nmnum ::= nm",
 /* 254 */ "plus_num ::= plus_opt number",
 /* 255 */ "minus_num ::= MINUS number",
 /* 256 */ "number ::= INTEGER|FLOAT",
 /* 257 */ "plus_opt ::= PLUS",
 /* 258 */ "plus_opt ::=",
 /* 259 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 260 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 261 */ "trigger_time ::= BEFORE",
 /* 262 */ "trigger_time ::= AFTER",
 /* 263 */ "trigger_time ::= INSTEAD OF",
 /* 264 */ "trigger_time ::=",
 /* 265 */ "trigger_event ::= DELETE|INSERT",
 /* 266 */ "trigger_event ::= UPDATE",
 /* 267 */ "trigger_event ::= UPDATE OF inscollist",
 /* 268 */ "foreach_clause ::=",
 /* 269 */ "foreach_clause ::= FOR EACH ROW",
 /* 270 */ "when_clause ::=",
 /* 271 */ "when_clause ::= WHEN expr",
 /* 272 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 273 */ "trigger_cmd_list ::=",
 /* 274 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 277 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 278 */ "trigger_cmd ::= select",
 /* 279 */ "expr ::= RAISE LP IGNORE RP",
 /* 280 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 281 */ "raisetype ::= ROLLBACK",
 /* 282 */ "raisetype ::= ABORT",
 /* 283 */ "raisetype ::= FAIL",
 /* 284 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 285 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 286 */ "cmd ::= DETACH database_kw_opt expr",
 /* 287 */ "key_opt ::=",
 /* 288 */ "key_opt ::= KEY expr",
 /* 289 */ "database_kw_opt ::= DATABASE",
 /* 290 */ "database_kw_opt ::=",
 /* 291 */ "cmd ::= REINDEX",
 /* 292 */ "cmd ::= REINDEX nm dbnm",
 /* 293 */ "cmd ::= ANALYZE",
 /* 294 */ "cmd ::= ANALYZE nm dbnm",
 /* 295 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 296 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 297 */ "add_column_fullname ::= fullname",
 /* 298 */ "kwcolumn_opt ::=",
 /* 299 */ "kwcolumn_opt ::= COLUMNKW",
 /* 300 */ "cmd ::= create_vtab",
 /* 301 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 302 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 303 */ "vtabarglist ::= vtabarg",
 /* 304 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 305 */ "vtabarg ::=",
 /* 306 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 307 */ "vtabargtoken ::= ANY",
 /* 308 */ "vtabargtoken ::= lp anylist RP",
 /* 309 */ "lp ::= LP",
 /* 310 */ "anylist ::=",
 /* 311 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155:
    case 189:
    case 206:
#line 373 "parse.y"
{sqlite3SelectDelete((yypminor->yy219));}
#line 1278 "parse.c"
      break;
    case 169:
    case 170:
    case 194:
    case 196:
    case 204:
    case 210:
    case 218:
    case 221:
    case 223:
    case 235:
#line 633 "parse.y"
{sqlite3ExprDelete((yypminor->yy172));}
#line 1292 "parse.c"
      break;
    case 174:
    case 182:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 211:
    case 212:
    case 215:
    case 216:
    case 222:
#line 891 "parse.y"
{sqlite3ExprListDelete((yypminor->yy174));}
#line 1308 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 490 "parse.y"
{sqlite3SrcListDelete((yypminor->yy373));}
#line 1316 "parse.c"
      break;
    case 205:
    case 208:
    case 214:
#line 507 "parse.y"
{sqlite3IdListDelete((yypminor->yy432));}
#line 1323 "parse.c"
      break;
    case 231:
    case 236:
#line 994 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy243));}
#line 1329 "parse.c"
      break;
    case 233:
#line 980 "parse.y"
{sqlite3IdListDelete((yypminor->yy370).b);}
#line 1334 "parse.c"
      break;
    case 238:
#line 1067 "parse.y"
{sqlite3ExprDelete((yypminor->yy386));}
#line 1339 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1503 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 142, 1 },
  { 141, 1 },
  { 141, 3 },
  { 144, 0 },
  { 144, 1 },
  { 144, 3 },
  { 143, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 143, 4 },
  { 187, 2 },
  { 187, 0 },
  { 143, 8 },
  { 143, 4 },
  { 143, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 143, 4 },
  { 194, 0 },
  { 194, 2 },
  { 143, 6 },
  { 212, 5 },
  { 212, 3 },
  { 143, 8 },
  { 143, 5 },
  { 143, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 143, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 1 },
  { 226, 0 },
  { 226, 2 },
  { 143, 4 },
  { 143, 1 },
  { 143, 2 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 6 },
  { 143, 3 },
  { 227, 1 },
  { 227, 1 },
  { 165, 2 },
  { 166, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 143, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 143, 4 },
  { 143, 6 },
  { 143, 3 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 143, 1 },
  { 143, 3 },
  { 143, 1 },
  { 143, 3 },
  { 143, 6 },
  { 143, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 143, 1 },
  { 143, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
      case 1:
      case 2:
      case 4:
      case 5:
      case 10:
      case 11:
      case 12:
      case 20:
      case 28:
      case 29:
      case 37:
      case 44:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      case 55:
      case 82:
      case 83:
      case 84:
      case 85:
      case 257:
      case 258:
      case 268:
      case 269:
      case 289:
      case 290:
      case 298:
      case 299:
      case 303:
      case 304:
      case 306:
      case 310:
#line 96 "parse.y"
{
}
#line 1958 "parse.c"
        break;
      case 3:
#line 99 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1963 "parse.c"
        break;
      case 6:
#line 102 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1968 "parse.c"
        break;
      case 7:
#line 104 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1973 "parse.c"
        break;
      case 8:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1978 "parse.c"
        break;
      case 9:
#line 111 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 1983 "parse.c"
        break;
      case 13:
#line 116 "parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 1988 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 117 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 1997 "parse.c"
        break;
      case 17:
      case 18:
#line 120 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2003 "parse.c"
        break;
      case 19:
#line 122 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2008 "parse.c"
        break;
      case 21:
#line 127 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 2015 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 213:
      case 216:
#line 131 "parse.y"
{yygotominor.yy46 = 0;}
#line 2030 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 214:
      case 217:
#line 132 "parse.y"
{yygotominor.yy46 = 1;}
#line 2042 "parse.c"
        break;
      case 26:
#line 138 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 2049 "parse.c"
        break;
      case 27:
#line 141 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2057 "parse.c"
        break;
      case 30:
#line 153 "parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 2065 "parse.c"
        break;
      case 31:
#line 157 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 2073 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 256:
#line 167 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 2083 "parse.c"
        break;
      case 38:
#line 228 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 2088 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 241:
      case 243:
      case 252:
      case 253:
      case 254:
      case 255:
#line 229 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2103 "parse.c"
        break;
      case 40:
#line 230 "parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2111 "parse.c"
        break;
      case 41:
#line 234 "parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2119 "parse.c"
        break;
      case 43:
#line 240 "parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2124 "parse.c"
        break;
      case 50:
      case 52:
#line 251 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2130 "parse.c"
        break;
      case 51:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2135 "parse.c"
        break;
      case 53:
#line 254 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2143 "parse.c"
        break;
      case 54:
#line 258 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2151 "parse.c"
        break;
      case 56:
#line 267 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2156 "parse.c"
        break;
      case 57:
#line 269 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2161 "parse.c"
        break;
      case 58:
#line 270 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2166 "parse.c"
        break;
      case 59:
#line 271 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2171 "parse.c"
        break;
      case 60:
#line 273 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2176 "parse.c"
        break;
      case 61:
#line 274 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2181 "parse.c"
        break;
      case 62:
#line 275 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy410);}
#line 2186 "parse.c"
        break;
      case 65:
#line 288 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2191 "parse.c"
        break;
      case 66:
#line 289 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2196 "parse.c"
        break;
      case 67:
#line 291 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2201 "parse.c"
        break;
      case 68:
#line 292 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2206 "parse.c"
        break;
      case 69:
#line 293 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2211 "parse.c"
        break;
      case 70:
#line 294 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2216 "parse.c"
        break;
      case 71:
#line 296 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2221 "parse.c"
        break;
      case 72:
#line 297 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2226 "parse.c"
        break;
      case 73:
#line 298 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2231 "parse.c"
        break;
      case 74:
#line 299 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2236 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 166:
#line 301 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2247 "parse.c"
        break;
      case 80:
#line 311 "parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2252 "parse.c"
        break;
      case 81:
#line 312 "parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2257 "parse.c"
        break;
      case 86:
#line 318 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2262 "parse.c"
        break;
      case 87:
#line 320 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2267 "parse.c"
        break;
      case 88:
#line 321 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2272 "parse.c"
        break;
      case 89:
#line 323 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2280 "parse.c"
        break;
      case 92:
      case 94:
#line 337 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2286 "parse.c"
        break;
      case 97:
#line 342 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2291 "parse.c"
        break;
      case 98:
      case 167:
#line 343 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2297 "parse.c"
        break;
      case 99:
#line 347 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2304 "parse.c"
        break;
      case 102:
#line 357 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-6].minor.yy46, yymsp[-4].minor.yy46);
}
#line 2311 "parse.c"
        break;
      case 103:
#line 360 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2318 "parse.c"
        break;
      case 104:
#line 367 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy219, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2326 "parse.c"
        break;
      case 105:
      case 128:
#line 377 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2332 "parse.c"
        break;
      case 106:
#line 379 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }else{
    sqlite3SelectDelete(yymsp[-2].minor.yy219);
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2345 "parse.c"
        break;
      case 108:
#line 390 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2350 "parse.c"
        break;
      case 110:
#line 394 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2357 "parse.c"
        break;
      case 114:
      case 238:
#line 415 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2363 "parse.c"
        break;
      case 115:
      case 141:
      case 149:
      case 231:
      case 237:
#line 416 "parse.y"
{yygotominor.yy174 = 0;}
#line 2372 "parse.c"
        break;
      case 116:
#line 417 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2379 "parse.c"
        break;
      case 117:
#line 420 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy174, p, 0);
}
#line 2387 "parse.c"
        break;
      case 118:
#line 424 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy174, pDot, 0);
}
#line 2397 "parse.c"
        break;
      case 121:
#line 437 "parse.y"
{yygotominor.yy410.n = 0;}
#line 2402 "parse.c"
        break;
      case 122:
#line 449 "parse.y"
{yygotominor.yy373 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy373));}
#line 2407 "parse.c"
        break;
      case 123:
#line 450 "parse.y"
{
  yygotominor.yy373 = yymsp[0].minor.yy373;
  sqlite3SrcListShiftJoinType(yygotominor.yy373);
}
#line 2415 "parse.c"
        break;
      case 124:
#line 458 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2423 "parse.c"
        break;
      case 125:
#line 462 "parse.y"
{yygotominor.yy373 = 0;}
#line 2428 "parse.c"
        break;
      case 126:
#line 463 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,0,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
}
#line 2435 "parse.c"
        break;
      case 127:
#line 468 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy373,0,0,&yymsp[-2].minor.yy410,yymsp[-4].minor.yy219,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
  }
#line 2442 "parse.c"
        break;
      case 129:
#line 479 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy373);
     yygotominor.yy219 = sqlite3SelectNew(pParse,0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2450 "parse.c"
        break;
      case 130:
#line 486 "parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2455 "parse.c"
        break;
      case 132:
#line 491 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2460 "parse.c"
        break;
      case 133:
#line 495 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2465 "parse.c"
        break;
      case 134:
#line 496 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2470 "parse.c"
        break;
      case 135:
#line 497 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2475 "parse.c"
        break;
      case 136:
#line 499 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2480 "parse.c"
        break;
      case 137:
      case 145:
      case 152:
      case 159:
      case 174:
      case 202:
      case 226:
      case 228:
#line 503 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2492 "parse.c"
        break;
      case 138:
      case 151:
      case 158:
      case 203:
      case 227:
      case 229:
#line 504 "parse.y"
{yygotominor.yy172 = 0;}
#line 2502 "parse.c"
        break;
      case 139:
      case 171:
#line 508 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2508 "parse.c"
        break;
      case 140:
      case 170:
#line 509 "parse.y"
{yygotominor.yy432 = 0;}
#line 2514 "parse.c"
        break;
      case 142:
      case 150:
      case 230:
#line 520 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2521 "parse.c"
        break;
      case 143:
#line 521 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy174,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2529 "parse.c"
        break;
      case 144:
#line 525 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2537 "parse.c"
        break;
      case 146:
      case 148:
#line 533 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2543 "parse.c"
        break;
      case 147:
#line 534 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2548 "parse.c"
        break;
      case 153:
#line 560 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2553 "parse.c"
        break;
      case 154:
#line 561 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2558 "parse.c"
        break;
      case 155:
#line 563 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2563 "parse.c"
        break;
      case 156:
#line 565 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2568 "parse.c"
        break;
      case 157:
#line 569 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2573 "parse.c"
        break;
      case 160:
#line 579 "parse.y"
{
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy174,SQLITE_MAX_COLUMN,"set list"); 
  sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);
}
#line 2581 "parse.c"
        break;
      case 161:
#line 588 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2586 "parse.c"
        break;
      case 162:
#line 590 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2591 "parse.c"
        break;
      case 163:
#line 596 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2596 "parse.c"
        break;
      case 164:
#line 598 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2601 "parse.c"
        break;
      case 165:
#line 600 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy373, 0, 0, yymsp[-2].minor.yy432, yymsp[-5].minor.yy46);}
#line 2606 "parse.c"
        break;
      case 168:
      case 232:
#line 611 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2612 "parse.c"
        break;
      case 169:
      case 233:
#line 613 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy172,0);}
#line 2618 "parse.c"
        break;
      case 172:
#line 623 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2623 "parse.c"
        break;
      case 173:
#line 625 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy410);}
#line 2628 "parse.c"
        break;
      case 175:
#line 636 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2633 "parse.c"
        break;
      case 176:
      case 181:
      case 182:
#line 637 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2640 "parse.c"
        break;
      case 177:
      case 178:
#line 638 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2646 "parse.c"
        break;
      case 179:
#line 640 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2655 "parse.c"
        break;
      case 180:
#line 645 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2666 "parse.c"
        break;
      case 183:
#line 654 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2671 "parse.c"
        break;
      case 184:
#line 655 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2680 "parse.c"
        break;
      case 185:
#line 660 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy172, &yymsp[0].minor.yy410);
}
#line 2687 "parse.c"
        break;
      case 186:
#line 664 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2695 "parse.c"
        break;
      case 187:
#line 669 "parse.y"
{
  if( yymsp[-1].minor.yy174 && yymsp[-1].minor.yy174->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2709 "parse.c"
        break;
      case 188:
#line 679 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2717 "parse.c"
        break;
      case 189:
#line 683 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->op = TK_CONST_FUNC;  
    yygotominor.yy172->span = yymsp[0].minor.yy0;
  }
}
#line 2730 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 692 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy172,yymsp[0].minor.yy172,0);}
#line 2742 "parse.c"
        break;
      case 198:
      case 200:
#line 704 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2748 "parse.c"
        break;
      case 199:
      case 201:
#line 705 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2754 "parse.c"
        break;
      case 204:
#line 712 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2770 "parse.c"
        break;
      case 205:
#line 725 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2778 "parse.c"
        break;
      case 206:
#line 729 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2786 "parse.c"
        break;
      case 207:
#line 733 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2794 "parse.c"
        break;
      case 208:
#line 737 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2802 "parse.c"
        break;
      case 209:
      case 210:
#line 741 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2811 "parse.c"
        break;
      case 211:
#line 749 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2819 "parse.c"
        break;
      case 212:
#line 753 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2827 "parse.c"
        break;
      case 215:
#line 760 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2843 "parse.c"
        break;
      case 218:
#line 776 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2858 "parse.c"
        break;
      case 219:
#line 787 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2872 "parse.c"
        break;
      case 220:
#line 797 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2887 "parse.c"
        break;
      case 221:
#line 808 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 2903 "parse.c"
        break;
      case 222:
#line 820 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(yygotominor.yy172);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 2917 "parse.c"
        break;
      case 223:
#line 833 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
    sqlite3ExprSetHeight(yygotominor.yy172);
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2931 "parse.c"
        break;
      case 224:
#line 845 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2939 "parse.c"
        break;
      case 225:
#line 849 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2947 "parse.c"
        break;
      case 234:
#line 878 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2956 "parse.c"
        break;
      case 235:
      case 282:
#line 885 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2962 "parse.c"
        break;
      case 236:
#line 886 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 2967 "parse.c"
        break;
      case 239:
#line 896 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy410);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, SQLITE_MAX_COLUMN, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2981 "parse.c"
        break;
      case 240:
#line 906 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy410);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy410);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, SQLITE_MAX_COLUMN, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2995 "parse.c"
        break;
      case 242:
#line 919 "parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 3000 "parse.c"
        break;
      case 244:
#line 925 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 3005 "parse.c"
        break;
      case 245:
      case 246:
#line 931 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3011 "parse.c"
        break;
      case 247:
#line 939 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 3016 "parse.c"
        break;
      case 248:
#line 940 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 3021 "parse.c"
        break;
      case 249:
#line 941 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 3028 "parse.c"
        break;
      case 250:
#line 944 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 3033 "parse.c"
        break;
      case 251:
#line 945 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 3038 "parse.c"
        break;
      case 259:
#line 959 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 3048 "parse.c"
        break;
      case 260:
#line 968 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[0].minor.yy172, yymsp[-10].minor.yy46, yymsp[-8].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 3056 "parse.c"
        break;
      case 261:
      case 264:
#line 974 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 3062 "parse.c"
        break;
      case 262:
#line 975 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 3067 "parse.c"
        break;
      case 263:
#line 976 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 3072 "parse.c"
        break;
      case 265:
      case 266:
#line 981 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 3078 "parse.c"
        break;
      case 267:
#line 983 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 3083 "parse.c"
        break;
      case 270:
#line 990 "parse.y"
{ yygotominor.yy172 = 0; }
#line 3088 "parse.c"
        break;
      case 271:
#line 991 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3093 "parse.c"
        break;
      case 272:
#line 995 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3106 "parse.c"
        break;
      case 273:
#line 1004 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3111 "parse.c"
        break;
      case 274:
#line 1010 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3116 "parse.c"
        break;
      case 275:
#line 1015 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3121 "parse.c"
        break;
      case 276:
#line 1018 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3126 "parse.c"
        break;
      case 277:
#line 1022 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3131 "parse.c"
        break;
      case 278:
#line 1025 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy219); }
#line 3136 "parse.c"
        break;
      case 279:
#line 1028 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3147 "parse.c"
        break;
      case 280:
#line 1035 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3158 "parse.c"
        break;
      case 281:
#line 1045 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3163 "parse.c"
        break;
      case 283:
#line 1047 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3168 "parse.c"
        break;
      case 284:
#line 1052 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373,yymsp[-1].minor.yy46);
}
#line 3175 "parse.c"
        break;
      case 285:
#line 1059 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy386);
}
#line 3182 "parse.c"
        break;
      case 286:
#line 1062 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3189 "parse.c"
        break;
      case 287:
#line 1068 "parse.y"
{ yygotominor.yy386 = 0; }
#line 3194 "parse.c"
        break;
      case 288:
#line 1069 "parse.y"
{ yygotominor.yy386 = yymsp[0].minor.yy172; }
#line 3199 "parse.c"
        break;
      case 291:
#line 1077 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3204 "parse.c"
        break;
      case 292:
#line 1078 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3209 "parse.c"
        break;
      case 293:
#line 1083 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3214 "parse.c"
        break;
      case 294:
#line 1084 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3219 "parse.c"
        break;
      case 295:
#line 1089 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3226 "parse.c"
        break;
      case 296:
#line 1092 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3233 "parse.c"
        break;
      case 297:
#line 1095 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3240 "parse.c"
        break;
      case 300:
#line 1104 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3245 "parse.c"
        break;
      case 301:
#line 1105 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3250 "parse.c"
        break;
      case 302:
#line 1106 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3257 "parse.c"
        break;
      case 305:
#line 1111 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3262 "parse.c"
        break;
      case 307:
      case 308:
      case 309:
      case 311:
#line 1113 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3270 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3338 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
