/******************************************************************
 * @file   reader_buf.h
 * @author Richard Luo
 * @date   2008-05-19
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _READER_BUF_H
#define _READER_BUF_H 1

#include <linux/string.h>

#include "card_buf.h"
#include "reader_consts.h"


static inline int circular_inc(int *i)
{
    ++*i;
    if (*i == MAX_NUM_OF_CARD)
        *i = 0;
    return *i;
}

typedef struct {
    card_buf_t cards_[MAX_NUM_OF_CARD];
    int rd_;
    int wr_;
} reader_buf_t;

static inline void reader_buf_init (reader_buf_t *rb)
{
    memset(rb, 0, sizeof(*rb));
}


static inline int reader_buf_empty (reader_buf_t *rb)
{
    return rb->rd_ == rb->wr_;
}

static inline int reader_buf_full (reader_buf_t *rb)
{
    int idx = rb->wr_;
    return (circular_inc(&idx) == rb->rd_);
}

static inline card_buf_t* reader_buf_wr_card (reader_buf_t *rb)
{
    return &rb->cards_[rb->wr_];
}

static inline card_buf_t* reader_buf_rd_card (reader_buf_t *rb)
{
    return reader_buf_empty(rb) ? NULL : &rb->cards_[rb->rd_];
}


//card_buf_t* reader_buf_get_for_write (reader_buf_t *rb);
card_buf_t* reader_buf_get_for_read (reader_buf_t *rb);
void reader_buf_wr_inc (reader_buf_t *rb);



#endif /* _READER_BUF_H */



