/******************************************************************
 * @file   debug_serial.h
 * @author Richard Luo
 * @date   2008-06-11
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _DEBUG_SERIAL_H
#define _DEBUG_SERIAL_H 1

#define DEBUG
#ifdef DEBUG

#undef DPRK

static inline void show_bytes(const char *pbs, int len)
{
    int i=0;

    if (!pbs || len <= 0)
        return;

    for(; i < len; ++i) {
        unsigned int ic = (unsigned char) (pbs[i]);
        printk("%02x ", ic);
        if (i && 0 == (i+1)%16)
            printk("\n");
    }
}

#define DPRK(condi, format, ...) do {                               \
        if (condi) {                                                \
            printk("[%s:%d:%s]", __FILE__, __LINE__, __FUNCTION__); \
            printk(format, ## __VA_ARGS__);                         \
            printk("\n");                                           \
        }                                                           \
    } while(0)

#define DWHERE(condi) do {                                           \
        if(condi)                                                       \
            printk("[%s:%d:%s]\n", __FILE__, __LINE__, __FUNCTION__);   \
    } while (0)

int debug_get_uart_port_num (struct uart_port *port);
extern int __init_or_module port_is_485 (struct platform_device *pdev);

#else
#define DPRK(...) do { } while(0)
#define DWHERE(condi) do { } while(0)
#define show_bytes(...) do { } while(0)
#endif





#endif /* _DEBUG_SERIAL_H */



