/******************************************************************
 * @file   akdebug.h
 * @author Richard Luo
 * @date   2008-08-15
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _AKDEBUG_H
#define _AKDEBUG_H 1


#if !defined AK_PREFIX
#define AK_PREFIX "ak:"
#endif


#if defined _DBGS_


#define PDEBUG(fmt,args...)                         \
    do {                                            \
        printk(KERN_DEBUG "[%s:%d] " fmt,           \
               __FUNCTION__, __LINE__ , ## args);   \
    } while (0)

#define ak_debug(fmt,args...)                       \
    do {                                            \
        printk("%s %d> " fmt,                       \
               __FUNCTION__, __LINE__ , ## args);   \
    } while (0)

static inline void show_bytes (const char *prefix, const void *pbs, int len)
{

    const uint8_t* pc = (const uint8_t*) pbs;

    char info[512] = {0};
    char *pi = info;

    int i=0;
    pi += sprintf(pi, "%s \n", prefix);
    for(; i < len; ++i) {
        pi += sprintf(pi, "%02x ", pc[i]);
        if (i && 0 == (i+1)%16)
            pi += sprintf(pi, "\n");
    }
    printk("%s\n", info);
}

#else  // !!!!!!!!!!!!!!!! _DBGS_ !!!!!!!!!!!!!!!!

#define ak_debug(fmt,arg...)    do {} while(0)
#define show_bytes(...)         do {} while(0)
#define PDEBUG(...)             do {} while(0)

#endif


#define ERR_RETURN(cond)                        \
    do {                                        \
        if ((cond))                             \
            return -1;                          \
    } while (0)

#define ERR_INFO_RETURN(cond,info)                  \
    do {                                            \
        if ((cond)) {                               \
            printk("%s=>%s \n", __func__, (info) ); \
            return -1;                              \
        }                                           \
    } while (0)

#define ERR_INFO(cond,info)                         \
    do {                                            \
        if ((cond)) {                               \
            printk("%s=>%s \n", __func__, (info) ); \
        }                                           \
    } while (0)

#define ERR_INFO_GOTO(cond,info,label)          \
    do {                                        \
        if ((cond)) {                           \
            printk("%s \n", (info) );           \
            goto label;                         \
        }                                       \
    } while (0)



static inline void aways_show_bytes (const char *prefix, const void *pbs, int len)
{

    const uint8_t* pc = (const uint8_t*) pbs;

    char info[512] = {0};
    char *pi = info;

    int i=0;
    pi += sprintf(pi, "%s \n", prefix);
    for(; i < len; ++i) {
        pi += sprintf(pi, "%02x ", pc[i]);
        if (i && 0 == (i+1)%16)
            pi += sprintf(pi, "\n");
    }
    printk("%s\n", info);
}

static inline void show_bytes_f (const void *pbs, int len)
{
    int i;
    const unsigned char *p = (const unsigned char *) pbs;

    for(i=0; i < len; ++i) {
        unsigned int ic = p[i];
        const char *fmt;
        if (i && 0 == (i+1)%16) {
            fmt = "%02x\n";
        }else
            fmt = "%02x ";
        printk(fmt, ic);
    }
}




#endif /* _AKDEBUG_H */



