/******************************************************************
 * @file   t_locked_api.cpp
 * @author Richard Luo, cdominant7@gmail.com
 * @date   2010/10/27 23:57:19
 * 
 * @brief  Did he have passion?
 * 
 ****************************************************************** 
 */


#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <iostream>
// #include <gtest/gtest.h>

#include "logic_error.h"
#include <libconfig.h>
#include <strings.h>
#include <string.h>

static const char *g_file = "./locked.cfg";
static const char *g_key = "loops";
static bool g_continue = true;

#define USING_LOCKED_API


#ifdef USING_LOCKED_API
#define CONFIG_READ_FILE_LOCKED config_read_file_locked
#define CONFIG_WRITE_FILE_LOCKED config_write_file_locked
#else
#define CONFIG_READ_FILE_LOCKED config_read_file
#define CONFIG_WRITE_FILE_LOCKED config_write_file
#endif

static int config_read_x(char *buf, int len)
{
    struct config_t cfg;

    /* Initialize the configuration */
    config_init(&cfg);

    /* Load the file */
    ddprint("read...loading %s..\n", g_file);
    if (!CONFIG_READ_FILE_LOCKED(&cfg, g_file) ) {
        ddprint("failed");
        return -99;
    }

    config_setting_t *setting = NULL;
    
    ddprint("ok\n");
    
    /* Get the "x" setting from the configuration.. */
    setting = config_lookup(&cfg, g_key);
    if (!setting) {
        ddprint("read_x failed lookup %s ", g_key);
        return -98;
    }
    else
    {
        const char *value = config_setting_get_string(setting);
        ddprint("read_x got %s = %s", g_key, value);
        bzero(buf, len);
        int sz = strlen(value);
        strncpy(buf, value, sz);

        /* Free the configuration */
        config_destroy(&cfg);
        return sz;
    }

    return -1;
}


static void config_write_x(const char *value)
{
    struct config_t cfg;

    /* Initialize the configuration */
    config_init(&cfg);

    /* Load the file */
    ddprint("write..loading %s..\n", g_file);
    if (!CONFIG_READ_FILE_LOCKED(&cfg, g_file) ) {
        ddprint("failed with CONFIG_READ_FILE_LOCKED \n");
        exit(89);
    }

    config_setting_t *setting = NULL;
    
    ddprint("CONFIG_READ_FILE_LOCKED ok \n");

    /* Get the "x" setting from the configuration.. */
    setting = config_lookup(&cfg, g_key);
    if (!setting) {
        ddprint("write_x failed with lookup %s", g_key);
        exit(88);
    }
    else
    {
        const char *in_value = config_setting_get_string(setting);
        ddprint("write_x got %s = %s", g_key, in_value);

        ddprint("before set string: %s", value);
        config_setting_set_string(setting, value);
        CONFIG_WRITE_FILE_LOCKED(&cfg, g_file);
        ddprint("after write string: %s", value);
        config_destroy(&cfg);
    }
}


static const char *g_values[] = {
    "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
    "BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB",
    "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC",
    "DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD",
    "EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE"
};

static const int g_size = sizeof(g_values)/sizeof(g_values[0]);

static bool is_valid(const char *buf, int len)
{
    for (int i=0; i < g_size; i++) 
        if (strcmp(buf, g_values[i]) == 0 )
            return true;

    ddprint("invalid buf=[%s]", buf);

    return false;
}

static void loop_write(int times)
{
    for (int i=0; i < times; ++i) {
        const int idx = random()%(sizeof(g_values)/sizeof(g_values[0]));
        ddprint("g_values[%d] = %s", idx, g_values[idx] );
        config_write_x(g_values[idx]);
    }
}

static void loop_check(int times)
{
    char buf[256] = {0};
    for (int i=0; i < times; ++i) {
        int len = config_read_x(buf, sizeof(buf));
        if (is_valid(buf, len) == false) {
            // test is failed
            g_continue = false;
            exit(100);
        }
    }
}


typedef void (*my_task_t)(int);

static void fork_tasks(int n, my_task_t handler)
{
    for (int i=0; i < n && g_continue; ++i) {
        pid_t pid = fork();
        if (pid == 0) {         // child process
            int times = random()%30 + 1;
            return handler(times);
        }
    }
}


/***************************************************************************/

int main()
{
    fork_tasks(20, loop_write);
    fork_tasks(20, loop_check);
    sleep(5);
    return 0;
}

