/*
 * (C) Copyright 2006
 * M Amine SAYA ATMEL Rousset, France.
 * include/asm/arch/pio.h contains pio config and management functions
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef AT91SAM9260_H
#define AT91SAM9260_H

typedef volatile unsigned int AT91_REG;/* Hardware register definition */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR System Peripherals */
/* ***************************************************************************** */
typedef struct _AT91S_SYS {
	AT91_REG	 SDRAMC_MR; 	/* SDRAM Controller Mode Register */
	AT91_REG	 SDRAMC_TR; 	/* SDRAM Controller Refresh Timer Register */
	AT91_REG	 SDRAMC_CR; 	/* SDRAM Controller Configuration Register */
	AT91_REG	 SDRAMC_HSR; 	/* SDRAM Controller High Speed Register */
	AT91_REG	 SDRAMC_LPR; 	/* SDRAM Controller Low Power Register */
	AT91_REG	 SDRAMC_IER; 	/* SDRAM Controller Interrupt Enable Register */
	AT91_REG	 SDRAMC_IDR; 	/* SDRAM Controller Interrupt Disable Register */
	AT91_REG	 SDRAMC_IMR; 	/* SDRAM Controller Interrupt Mask Register */
	AT91_REG	 SDRAMC_ISR; 	/* SDRAM Controller Interrupt Mask Register */
	AT91_REG	 SDRAMC_MDR; 	/* SDRAM Memory Device Register */
	AT91_REG	 Reserved0[118]; 	/*  */
	AT91_REG	 SMC_SETUP0; 	/*  Setup Register for CS 0 */
	AT91_REG	 SMC_PULSE0; 	/*  Pulse Register for CS 0 */
	AT91_REG	 SMC_CYCLE0; 	/*  Cycle Register for CS 0 */
	AT91_REG	 SMC_CTRL0; 	/*  Control Register for CS 0 */
	AT91_REG	 SMC_SETUP1; 	/*  Setup Register for CS 1 */
	AT91_REG	 SMC_PULSE1; 	/*  Pulse Register for CS 1 */
	AT91_REG	 SMC_CYCLE1; 	/*  Cycle Register for CS 1 */
	AT91_REG	 SMC_CTRL1; 	/*  Control Register for CS 1 */
	AT91_REG	 SMC_SETUP2; 	/*  Setup Register for CS 2 */
	AT91_REG	 SMC_PULSE2; 	/*  Pulse Register for CS 2 */
	AT91_REG	 SMC_CYCLE2; 	/*  Cycle Register for CS 2 */
	AT91_REG	 SMC_CTRL2; 	/*  Control Register for CS 2 */
	AT91_REG	 SMC_SETUP3; 	/*  Setup Register for CS 3 */
	AT91_REG	 SMC_PULSE3; 	/*  Pulse Register for CS 3 */
	AT91_REG	 SMC_CYCLE3; 	/*  Cycle Register for CS 3 */
	AT91_REG	 SMC_CTRL3; 	/*  Control Register for CS 3 */
	AT91_REG	 SMC_SETUP4; 	/*  Setup Register for CS 4 */
	AT91_REG	 SMC_PULSE4; 	/*  Pulse Register for CS 4 */
	AT91_REG	 SMC_CYCLE4; 	/*  Cycle Register for CS 4 */
	AT91_REG	 SMC_CTRL4; 	/*  Control Register for CS 4 */
	AT91_REG	 SMC_SETUP5; 	/*  Setup Register for CS 5 */
	AT91_REG	 SMC_PULSE5; 	/*  Pulse Register for CS 5 */
	AT91_REG	 SMC_CYCLE5; 	/*  Cycle Register for CS 5 */
	AT91_REG	 SMC_CTRL5; 	/*  Control Register for CS 5 */
	AT91_REG	 SMC_SETUP6; 	/*  Setup Register for CS 6 */
	AT91_REG	 SMC_PULSE6; 	/*  Pulse Register for CS 6 */
	AT91_REG	 SMC_CYCLE6; 	/*  Cycle Register for CS 6 */
	AT91_REG	 SMC_CTRL6; 	/*  Control Register for CS 6 */
	AT91_REG	 SMC_SETUP7; 	/*  Setup Register for CS 7 */
	AT91_REG	 SMC_PULSE7; 	/*  Pulse Register for CS 7 */
	AT91_REG	 SMC_CYCLE7; 	/*  Cycle Register for CS 7 */
	AT91_REG	 SMC_CTRL7; 	/*  Control Register for CS 7 */
	AT91_REG	 Reserved1[96]; 	/*  */
	AT91_REG	 MATRIX_MCFG0; 	/*  Master Configuration Register 0 (ram96k)      */
	AT91_REG	 MATRIX_MCFG1; 	/*  Master Configuration Register 1 (rom)     */
	AT91_REG	 MATRIX_MCFG2; 	/*  Master Configuration Register 2 (hperiphs)  */
	AT91_REG	 MATRIX_MCFG3; 	/*  Master Configuration Register 3 (ebi) */
	AT91_REG	 MATRIX_MCFG4; 	/*  Master Configuration Register 4 (bridge)     */
	AT91_REG	 MATRIX_MCFG5; 	/*  Master Configuration Register 5 (mailbox)     */
	AT91_REG	 MATRIX_MCFG6; 	/*  Master Configuration Register 6 (ram16k)   */
	AT91_REG	 MATRIX_MCFG7; 	/*  Master Configuration Register 7 (teak_prog)      */
	AT91_REG	 Reserved2[8]; 	/*  */
	AT91_REG	 MATRIX_SCFG0; 	/*  Slave Configuration Register 0 (ram96k)      */
	AT91_REG	 MATRIX_SCFG1; 	/*  Slave Configuration Register 1 (rom)     */
	AT91_REG	 MATRIX_SCFG2; 	/*  Slave Configuration Register 2 (hperiphs)  */
	AT91_REG	 MATRIX_SCFG3; 	/*  Slave Configuration Register 3 (ebi) */
	AT91_REG	 MATRIX_SCFG4; 	/*  Slave Configuration Register 4 (bridge)     */
	AT91_REG	 Reserved3[11]; 	/*  */
	AT91_REG	 MATRIX_PRAS0; 	/*  PRAS0 (ram0)  */
	AT91_REG	 MATRIX_PRBS0; 	/*  PRBS0 (ram0)  */
	AT91_REG	 MATRIX_PRAS1; 	/*  PRAS1 (ram1)  */
	AT91_REG	 MATRIX_PRBS1; 	/*  PRBS1 (ram1)  */
	AT91_REG	 MATRIX_PRAS2; 	/*  PRAS2 (ram2)  */
	AT91_REG	 MATRIX_PRBS2; 	/*  PRBS2 (ram2)  */
	AT91_REG	 Reserved4[26]; 	/*  */
	AT91_REG	 MATRIX_MRCR; 	/*  Master Remp Control Register  */
	AT91_REG	 Reserved5[6]; 	/*  */
	AT91_REG	 CCFG_EBICSA; 	/*  EBI Chip Select Assignement Register */
	AT91_REG	 Reserved6[3]; 	/*  */
	AT91_REG	 MATRIX_TEAKCFG; 	/*  Slave 7 (teak_prog) Special Function Register */
	AT91_REG	 Reserved7[51]; 	/*  */
	AT91_REG	 CCFG_MATRIXVERSION; 	/*  Version Register */
	AT91_REG	 AIC_SMR[32]; 	/* Source Mode Register */
	AT91_REG	 AIC_SVR[32]; 	/* Source Vector Register */
	AT91_REG	 AIC_IVR; 	/* IRQ Vector Register */
	AT91_REG	 AIC_FVR; 	/* FIQ Vector Register */
	AT91_REG	 AIC_ISR; 	/* Interrupt Status Register */
	AT91_REG	 AIC_IPR; 	/* Interrupt Pending Register */
	AT91_REG	 AIC_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 AIC_CISR; 	/* Core Interrupt Status Register */
	AT91_REG	 Reserved8[2]; 	/*  */
	AT91_REG	 AIC_IECR; 	/* Interrupt Enable Command Register */
	AT91_REG	 AIC_IDCR; 	/* Interrupt Disable Command Register */
	AT91_REG	 AIC_ICCR; 	/* Interrupt Clear Command Register */
	AT91_REG	 AIC_ISCR; 	/* Interrupt Set Command Register */
	AT91_REG	 AIC_EOICR; 	/* End of Interrupt Command Register */
	AT91_REG	 AIC_SPU; 	/* Spurious Vector Register */
	AT91_REG	 AIC_DCR; 	/* Debug Control Register (Protect) */
	AT91_REG	 Reserved9[1]; 	/*  */
	AT91_REG	 AIC_FFER; 	/* Fast Forcing Enable Register */
	AT91_REG	 AIC_FFDR; 	/* Fast Forcing Disable Register */
	AT91_REG	 AIC_FFSR; 	/* Fast Forcing Status Register */
	AT91_REG	 Reserved10[45]; 	/*  */
	AT91_REG	 DBGU_CR; 	/* Control Register */
	AT91_REG	 DBGU_MR; 	/* Mode Register */
	AT91_REG	 DBGU_IER; 	/* Interrupt Enable Register */
	AT91_REG	 DBGU_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 DBGU_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 DBGU_CSR; 	/* Channel Status Register */
	AT91_REG	 DBGU_RHR; 	/* Receiver Holding Register */
	AT91_REG	 DBGU_THR; 	/* Transmitter Holding Register */
	AT91_REG	 DBGU_BRGR; 	/* Baud Rate Generator Register */
	AT91_REG	 Reserved11[7]; 	/*  */
	AT91_REG	 DBGU_CIDR; 	/* Chip ID Register */
	AT91_REG	 DBGU_EXID; 	/* Chip ID Extension Register */
	AT91_REG	 DBGU_FNTR; 	/* Force NTRST Register */
	AT91_REG	 Reserved12[45]; 	/*  */
	AT91_REG	 DBGU_RPR; 	/* Receive Pointer Register */
	AT91_REG	 DBGU_RCR; 	/* Receive Counter Register */
	AT91_REG	 DBGU_TPR; 	/* Transmit Pointer Register */
	AT91_REG	 DBGU_TCR; 	/* Transmit Counter Register */
	AT91_REG	 DBGU_RNPR; 	/* Receive Next Pointer Register */
	AT91_REG	 DBGU_RNCR; 	/* Receive Next Counter Register */
	AT91_REG	 DBGU_TNPR; 	/* Transmit Next Pointer Register */
	AT91_REG	 DBGU_TNCR; 	/* Transmit Next Counter Register */
	AT91_REG	 DBGU_PTCR; 	/* PDC Transfer Control Register */
	AT91_REG	 DBGU_PTSR; 	/* PDC Transfer Status Register */
	AT91_REG	 Reserved13[54]; 	/*  */
	AT91_REG	 PIOA_PER; 	/* PIO Enable Register */
	AT91_REG	 PIOA_PDR; 	/* PIO Disable Register */
	AT91_REG	 PIOA_PSR; 	/* PIO Status Register */
	AT91_REG	 Reserved14[1]; 	/*  */
	AT91_REG	 PIOA_OER; 	/* Output Enable Register */
	AT91_REG	 PIOA_ODR; 	/* Output Disable Registerr */
	AT91_REG	 PIOA_OSR; 	/* Output Status Register */
	AT91_REG	 Reserved15[1]; 	/*  */
	AT91_REG	 PIOA_IFER; 	/* Input Filter Enable Register */
	AT91_REG	 PIOA_IFDR; 	/* Input Filter Disable Register */
	AT91_REG	 PIOA_IFSR; 	/* Input Filter Status Register */
	AT91_REG	 Reserved16[1]; 	/*  */
	AT91_REG	 PIOA_SODR; 	/* Set Output Data Register */
	AT91_REG	 PIOA_CODR; 	/* Clear Output Data Register */
	AT91_REG	 PIOA_ODSR; 	/* Output Data Status Register */
	AT91_REG	 PIOA_PDSR; 	/* Pin Data Status Register */
	AT91_REG	 PIOA_IER; 	/* Interrupt Enable Register */
	AT91_REG	 PIOA_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 PIOA_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 PIOA_ISR; 	/* Interrupt Status Register */
	AT91_REG	 PIOA_MDER; 	/* Multi-driver Enable Register */
	AT91_REG	 PIOA_MDDR; 	/* Multi-driver Disable Register */
	AT91_REG	 PIOA_MDSR; 	/* Multi-driver Status Register */
	AT91_REG	 Reserved17[1]; 	/*  */
	AT91_REG	 PIOA_PPUDR; 	/* Pull-up Disable Register */
	AT91_REG	 PIOA_PPUER; 	/* Pull-up Enable Register */
	AT91_REG	 PIOA_PPUSR; 	/* Pull-up Status Register */
	AT91_REG	 Reserved18[1]; 	/*  */
	AT91_REG	 PIOA_ASR; 	/* Select A Register */
	AT91_REG	 PIOA_BSR; 	/* Select B Register */
	AT91_REG	 PIOA_ABSR; 	/* AB Select Status Register */
	AT91_REG	 Reserved19[9]; 	/*  */
	AT91_REG	 PIOA_OWER; 	/* Output Write Enable Register */
	AT91_REG	 PIOA_OWDR; 	/* Output Write Disable Register */
	AT91_REG	 PIOA_OWSR; 	/* Output Write Status Register */
	AT91_REG	 Reserved20[85]; 	/*  */
	AT91_REG	 PIOB_PER; 	/* PIO Enable Register */
	AT91_REG	 PIOB_PDR; 	/* PIO Disable Register */
	AT91_REG	 PIOB_PSR; 	/* PIO Status Register */
	AT91_REG	 Reserved21[1]; 	/*  */
	AT91_REG	 PIOB_OER; 	/* Output Enable Register */
	AT91_REG	 PIOB_ODR; 	/* Output Disable Registerr */
	AT91_REG	 PIOB_OSR; 	/* Output Status Register */
	AT91_REG	 Reserved22[1]; 	/*  */
	AT91_REG	 PIOB_IFER; 	/* Input Filter Enable Register */
	AT91_REG	 PIOB_IFDR; 	/* Input Filter Disable Register */
	AT91_REG	 PIOB_IFSR; 	/* Input Filter Status Register */
	AT91_REG	 Reserved23[1]; 	/*  */
	AT91_REG	 PIOB_SODR; 	/* Set Output Data Register */
	AT91_REG	 PIOB_CODR; 	/* Clear Output Data Register */
	AT91_REG	 PIOB_ODSR; 	/* Output Data Status Register */
	AT91_REG	 PIOB_PDSR; 	/* Pin Data Status Register */
	AT91_REG	 PIOB_IER; 	/* Interrupt Enable Register */
	AT91_REG	 PIOB_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 PIOB_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 PIOB_ISR; 	/* Interrupt Status Register */
	AT91_REG	 PIOB_MDER; 	/* Multi-driver Enable Register */
	AT91_REG	 PIOB_MDDR; 	/* Multi-driver Disable Register */
	AT91_REG	 PIOB_MDSR; 	/* Multi-driver Status Register */
	AT91_REG	 Reserved24[1]; 	/*  */
	AT91_REG	 PIOB_PPUDR; 	/* Pull-up Disable Register */
	AT91_REG	 PIOB_PPUER; 	/* Pull-up Enable Register */
	AT91_REG	 PIOB_PPUSR; 	/* Pull-up Status Register */
	AT91_REG	 Reserved25[1]; 	/*  */
	AT91_REG	 PIOB_ASR; 	/* Select A Register */
	AT91_REG	 PIOB_BSR; 	/* Select B Register */
	AT91_REG	 PIOB_ABSR; 	/* AB Select Status Register */
	AT91_REG	 Reserved26[9]; 	/*  */
	AT91_REG	 PIOB_OWER; 	/* Output Write Enable Register */
	AT91_REG	 PIOB_OWDR; 	/* Output Write Disable Register */
	AT91_REG	 PIOB_OWSR; 	/* Output Write Status Register */
	AT91_REG	 Reserved27[85]; 	/*  */
	AT91_REG	 PIOC_PER; 	/* PIO Enable Register */
	AT91_REG	 PIOC_PDR; 	/* PIO Disable Register */
	AT91_REG	 PIOC_PSR; 	/* PIO Status Register */
	AT91_REG	 Reserved28[1]; 	/*  */
	AT91_REG	 PIOC_OER; 	/* Output Enable Register */
	AT91_REG	 PIOC_ODR; 	/* Output Disable Registerr */
	AT91_REG	 PIOC_OSR; 	/* Output Status Register */
	AT91_REG	 Reserved29[1]; 	/*  */
	AT91_REG	 PIOC_IFER; 	/* Input Filter Enable Register */
	AT91_REG	 PIOC_IFDR; 	/* Input Filter Disable Register */
	AT91_REG	 PIOC_IFSR; 	/* Input Filter Status Register */
	AT91_REG	 Reserved30[1]; 	/*  */
	AT91_REG	 PIOC_SODR; 	/* Set Output Data Register */
	AT91_REG	 PIOC_CODR; 	/* Clear Output Data Register */
	AT91_REG	 PIOC_ODSR; 	/* Output Data Status Register */
	AT91_REG	 PIOC_PDSR; 	/* Pin Data Status Register */
	AT91_REG	 PIOC_IER; 	/* Interrupt Enable Register */
	AT91_REG	 PIOC_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 PIOC_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 PIOC_ISR; 	/* Interrupt Status Register */
	AT91_REG	 PIOC_MDER; 	/* Multi-driver Enable Register */
	AT91_REG	 PIOC_MDDR; 	/* Multi-driver Disable Register */
	AT91_REG	 PIOC_MDSR; 	/* Multi-driver Status Register */
	AT91_REG	 Reserved31[1]; 	/*  */
	AT91_REG	 PIOC_PPUDR; 	/* Pull-up Disable Register */
	AT91_REG	 PIOC_PPUER; 	/* Pull-up Enable Register */
	AT91_REG	 PIOC_PPUSR; 	/* Pull-up Status Register */
	AT91_REG	 Reserved32[1]; 	/*  */
	AT91_REG	 PIOC_ASR; 	/* Select A Register */
	AT91_REG	 PIOC_BSR; 	/* Select B Register */
	AT91_REG	 PIOC_ABSR; 	/* AB Select Status Register */
	AT91_REG	 Reserved33[9]; 	/*  */
	AT91_REG	 PIOC_OWER; 	/* Output Write Enable Register */
	AT91_REG	 PIOC_OWDR; 	/* Output Write Disable Register */
	AT91_REG	 PIOC_OWSR; 	/* Output Write Status Register */
	AT91_REG	 Reserved34[213]; 	/*  */
	AT91_REG	 PMC_SCER; 	/* System Clock Enable Register */
	AT91_REG	 PMC_SCDR; 	/* System Clock Disable Register */
	AT91_REG	 PMC_SCSR; 	/* System Clock Status Register */
	AT91_REG	 Reserved35[1]; 	/*  */
	AT91_REG	 PMC_PCER; 	/* Peripheral Clock Enable Register */
	AT91_REG	 PMC_PCDR; 	/* Peripheral Clock Disable Register */
	AT91_REG	 PMC_PCSR; 	/* Peripheral Clock Status Register */
	AT91_REG	 Reserved36[1]; 	/*  */
	AT91_REG	 PMC_MOR; 	/* Main Oscillator Register */
	AT91_REG	 PMC_MCFR; 	/* Main Clock  Frequency Register */
	AT91_REG	 PMC_PLLAR; 	/* PLL A Register */
	AT91_REG	 PMC_PLLBR; 	/* PLL B Register */
	AT91_REG	 PMC_MCKR; 	/* Master Clock Register */
	AT91_REG	 Reserved37[3]; 	/*  */
	AT91_REG	 PMC_PCKR[8]; 	/* Programmable Clock Register */
	AT91_REG	 PMC_IER; 	/* Interrupt Enable Register */
	AT91_REG	 PMC_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 PMC_SR; 	/* Status Register */
	AT91_REG	 PMC_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 Reserved38[36]; 	/*  */
	AT91_REG	 RSTC_RCR; 	/* Reset Control Register */
	AT91_REG	 RSTC_RSR; 	/* Reset Status Register */
	AT91_REG	 RSTC_RMR; 	/* Reset Mode Register */
	AT91_REG	 Reserved39[1]; 	/*  */
	AT91_REG	 SHDWC_SHCR; 	/* Shut Down Control Register */
	AT91_REG	 SHDWC_SHMR; 	/* Shut Down Mode Register */
	AT91_REG	 SHDWC_SHSR; 	/* Shut Down Status Register */
	AT91_REG	 Reserved40[1]; 	/*  */
	AT91_REG	 RTTC_RTMR; 	/* Real-time Mode Register */
	AT91_REG	 RTTC_RTAR; 	/* Real-time Alarm Register */
	AT91_REG	 RTTC_RTVR; 	/* Real-time Value Register */
	AT91_REG	 RTTC_RTSR; 	/* Real-time Status Register */
	AT91_REG	 PITC_PIMR; 	/* Period Interval Mode Register */
	AT91_REG	 PITC_PISR; 	/* Period Interval Status Register */
	AT91_REG	 PITC_PIVR; 	/* Period Interval Value Register */
	AT91_REG	 PITC_PIIR; 	/* Period Interval Image Register */
	AT91_REG	 WDTC_WDCR; 	/* Watchdog Control Register */
	AT91_REG	 WDTC_WDMR; 	/* Watchdog Mode Register */
	AT91_REG	 WDTC_WDSR; 	/* Watchdog Status Register */
	AT91_REG	 Reserved41[1]; 	/*  */
	AT91_REG	 SYS_GPBR0; 	/* General Purpose Register 0 */
	AT91_REG	 SYS_GPBR1; 	/* General Purpose Register 1 */
	AT91_REG	 SYS_GPBR2; 	/* General Purpose Register 2 */
	AT91_REG	 SYS_GPBR3; 	/* General Purpose Register 3 */
} AT91S_SYS, *AT91PS_SYS;

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Error Correction Code controller */
/* ***************************************************************************** */
typedef struct _AT91S_ECC {
	AT91_REG	 ECC_CR; 	/*  ECC reset register */
	AT91_REG	 ECC_MR; 	/*  ECC Page size register */
	AT91_REG	 ECC_SR; 	/*  ECC Status register */
	AT91_REG	 ECC_PR; 	/*  ECC Parity register */
	AT91_REG	 ECC_NPR; 	/*  ECC Parity N register */
	AT91_REG	 Reserved0[58]; 	/*  */
	AT91_REG	 ECC_VR; 	/*  ECC Version register */
} AT91S_ECC, *AT91PS_ECC;

/* -------- ECC_CR : (ECC Offset: 0x0) ECC reset register --------  */
#define AT91C_ECC_RST         ((unsigned int) 0x1 <<  0) /* (ECC) ECC reset parity */
/* -------- ECC_MR : (ECC Offset: 0x4) ECC page size register --------  */
#define AT91C_ECC_PAGE_SIZE   ((unsigned int) 0x3 <<  0) /* (ECC) Nand Flash page size */
/* -------- ECC_SR : (ECC Offset: 0x8) ECC status register --------  */
#define AT91C_ECC_RECERR      ((unsigned int) 0x1 <<  0) /* (ECC) ECC error */
#define AT91C_ECC_ECCERR      ((unsigned int) 0x1 <<  1) /* (ECC) ECC single error */
#define AT91C_ECC_MULERR      ((unsigned int) 0x1 <<  2) /* (ECC) ECC_MULERR */
/* -------- ECC_PR : (ECC Offset: 0xc) ECC parity register --------  */
#define AT91C_ECC_BITADDR     ((unsigned int) 0xF <<  0) /* (ECC) Bit address error */
#define AT91C_ECC_WORDADDR    ((unsigned int) 0xFFF <<  4) /* (ECC) address of the failing bit */
/* -------- ECC_NPR : (ECC Offset: 0x10) ECC N parity register --------  */
#define AT91C_ECC_NPARITY     ((unsigned int) 0xFFFF <<  0) /* (ECC) ECC parity N  */
/* -------- ECC_VR : (ECC Offset: 0xfc) ECC version register --------  */
#define AT91C_ECC_VR          ((unsigned int) 0xF <<  0) /* (ECC) ECC version register */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR SDRAM Controller Interface */
/* ***************************************************************************** */
typedef struct _AT91S_SDRAMC {
	AT91_REG	 SDRAMC_MR; 	/* SDRAM Controller Mode Register */
	AT91_REG	 SDRAMC_TR; 	/* SDRAM Controller Refresh Timer Register */
	AT91_REG	 SDRAMC_CR; 	/* SDRAM Controller Configuration Register */
	AT91_REG	 SDRAMC_HSR; 	/* SDRAM Controller High Speed Register */
	AT91_REG	 SDRAMC_LPR; 	/* SDRAM Controller Low Power Register */
	AT91_REG	 SDRAMC_IER; 	/* SDRAM Controller Interrupt Enable Register */
	AT91_REG	 SDRAMC_IDR; 	/* SDRAM Controller Interrupt Disable Register */
	AT91_REG	 SDRAMC_IMR; 	/* SDRAM Controller Interrupt Mask Register */
	AT91_REG	 SDRAMC_ISR; 	/* SDRAM Controller Interrupt Mask Register */
	AT91_REG	 SDRAMC_MDR; 	/* SDRAM Memory Device Register */
} AT91S_SDRAMC, *AT91PS_SDRAMC;

/* -------- SDRAMC_MR : (SDRAMC Offset: 0x0) SDRAM Controller Mode Register --------  */
#define AT91C_SDRAMC_MODE     ((unsigned int) 0xF <<  0) /* (SDRAMC) Mode */
#define 	AT91C_SDRAMC_MODE_NORMAL_CMD           ((unsigned int) 0x0) /* (SDRAMC) Normal Mode */
#define 	AT91C_SDRAMC_MODE_NOP_CMD              ((unsigned int) 0x1) /* (SDRAMC) Issue a NOP Command at every access */
#define 	AT91C_SDRAMC_MODE_PRCGALL_CMD          ((unsigned int) 0x2) /* (SDRAMC) Issue a All Banks Precharge Command at every access */
#define 	AT91C_SDRAMC_MODE_LMR_CMD              ((unsigned int) 0x3) /* (SDRAMC) Issue a Load Mode Register at every access */
#define 	AT91C_SDRAMC_MODE_RFSH_CMD             ((unsigned int) 0x4) /* (SDRAMC) Issue a Refresh */
#define 	AT91C_SDRAMC_MODE_EXT_LMR_CMD          ((unsigned int) 0x5) /* (SDRAMC) Issue an Extended Load Mode Register */
#define 	AT91C_SDRAMC_MODE_DEEP_CMD             ((unsigned int) 0x6) /* (SDRAMC) Enter Deep Power Mode */
/* -------- SDRAMC_TR : (SDRAMC Offset: 0x4) SDRAMC Refresh Timer Register --------  */
#define AT91C_SDRAMC_COUNT    ((unsigned int) 0xFFF <<  0) /* (SDRAMC) Refresh Counter */
/* -------- SDRAMC_CR : (SDRAMC Offset: 0x8) SDRAM Configuration Register --------  */
#define AT91C_SDRAMC_NC       ((unsigned int) 0x3 <<  0) /* (SDRAMC) Number of Column Bits */
#define 	AT91C_SDRAMC_NC_8                    ((unsigned int) 0x0) /* (SDRAMC) 8 Bits */
#define 	AT91C_SDRAMC_NC_9                    ((unsigned int) 0x1) /* (SDRAMC) 9 Bits */
#define 	AT91C_SDRAMC_NC_10                   ((unsigned int) 0x2) /* (SDRAMC) 10 Bits */
#define 	AT91C_SDRAMC_NC_11                   ((unsigned int) 0x3) /* (SDRAMC) 11 Bits */
#define AT91C_SDRAMC_NR       ((unsigned int) 0x3 <<  2) /* (SDRAMC) Number of Row Bits */
#define 	AT91C_SDRAMC_NR_11                   ((unsigned int) 0x0 <<  2) /* (SDRAMC) 11 Bits */
#define 	AT91C_SDRAMC_NR_12                   ((unsigned int) 0x1 <<  2) /* (SDRAMC) 12 Bits */
#define 	AT91C_SDRAMC_NR_13                   ((unsigned int) 0x2 <<  2) /* (SDRAMC) 13 Bits */
#define AT91C_SDRAMC_NB       ((unsigned int) 0x1 <<  4) /* (SDRAMC) Number of Banks */
#define 	AT91C_SDRAMC_NB_2_BANKS              ((unsigned int) 0x0 <<  4) /* (SDRAMC) 2 banks */
#define 	AT91C_SDRAMC_NB_4_BANKS              ((unsigned int) 0x1 <<  4) /* (SDRAMC) 4 banks */
#define AT91C_SDRAMC_CAS      ((unsigned int) 0x3 <<  5) /* (SDRAMC) CAS Latency */
#define 	AT91C_SDRAMC_CAS_2                    ((unsigned int) 0x2 <<  5) /* (SDRAMC) 2 cycles */
#define 	AT91C_SDRAMC_CAS_3                    ((unsigned int) 0x3 <<  5) /* (SDRAMC) 3 cycles */
#define AT91C_SDRAMC_DBW      ((unsigned int) 0x1 <<  7) /* (SDRAMC) Data Bus Width */
#define 	AT91C_SDRAMC_DBW_32_BITS              ((unsigned int) 0x0 <<  7) /* (SDRAMC) 32 Bits datas bus */
#define 	AT91C_SDRAMC_DBW_16_BITS              ((unsigned int) 0x1 <<  7) /* (SDRAMC) 16 Bits datas bus */
#define AT91C_SDRAMC_TWR      ((unsigned int) 0xF <<  8) /* (SDRAMC) Number of Write Recovery Time Cycles */
#define 	AT91C_SDRAMC_TWR_0                    ((unsigned int) 0x0 <<  8) /* (SDRAMC) Value :  0 */
#define 	AT91C_SDRAMC_TWR_1                    ((unsigned int) 0x1 <<  8) /* (SDRAMC) Value :  1 */
#define 	AT91C_SDRAMC_TWR_2                    ((unsigned int) 0x2 <<  8) /* (SDRAMC) Value :  2 */
#define 	AT91C_SDRAMC_TWR_3                    ((unsigned int) 0x3 <<  8) /* (SDRAMC) Value :  3 */
#define 	AT91C_SDRAMC_TWR_4                    ((unsigned int) 0x4 <<  8) /* (SDRAMC) Value :  4 */
#define 	AT91C_SDRAMC_TWR_5                    ((unsigned int) 0x5 <<  8) /* (SDRAMC) Value :  5 */
#define 	AT91C_SDRAMC_TWR_6                    ((unsigned int) 0x6 <<  8) /* (SDRAMC) Value :  6 */
#define 	AT91C_SDRAMC_TWR_7                    ((unsigned int) 0x7 <<  8) /* (SDRAMC) Value :  7 */
#define 	AT91C_SDRAMC_TWR_8                    ((unsigned int) 0x8 <<  8) /* (SDRAMC) Value :  8 */
#define 	AT91C_SDRAMC_TWR_9                    ((unsigned int) 0x9 <<  8) /* (SDRAMC) Value :  9 */
#define 	AT91C_SDRAMC_TWR_10                   ((unsigned int) 0xA <<  8) /* (SDRAMC) Value : 10 */
#define 	AT91C_SDRAMC_TWR_11                   ((unsigned int) 0xB <<  8) /* (SDRAMC) Value : 11 */
#define 	AT91C_SDRAMC_TWR_12                   ((unsigned int) 0xC <<  8) /* (SDRAMC) Value : 12 */
#define 	AT91C_SDRAMC_TWR_13                   ((unsigned int) 0xD <<  8) /* (SDRAMC) Value : 13 */
#define 	AT91C_SDRAMC_TWR_14                   ((unsigned int) 0xE <<  8) /* (SDRAMC) Value : 14 */
#define 	AT91C_SDRAMC_TWR_15                   ((unsigned int) 0xF <<  8) /* (SDRAMC) Value : 15 */
#define AT91C_SDRAMC_TRC      ((unsigned int) 0xF << 12) /* (SDRAMC) Number of RAS Cycle Time Cycles */
#define 	AT91C_SDRAMC_TRC_0                    ((unsigned int) 0x0 << 12) /* (SDRAMC) Value :  0 */
#define 	AT91C_SDRAMC_TRC_1                    ((unsigned int) 0x1 << 12) /* (SDRAMC) Value :  1 */
#define 	AT91C_SDRAMC_TRC_2                    ((unsigned int) 0x2 << 12) /* (SDRAMC) Value :  2 */
#define 	AT91C_SDRAMC_TRC_3                    ((unsigned int) 0x3 << 12) /* (SDRAMC) Value :  3 */
#define 	AT91C_SDRAMC_TRC_4                    ((unsigned int) 0x4 << 12) /* (SDRAMC) Value :  4 */
#define 	AT91C_SDRAMC_TRC_5                    ((unsigned int) 0x5 << 12) /* (SDRAMC) Value :  5 */
#define 	AT91C_SDRAMC_TRC_6                    ((unsigned int) 0x6 << 12) /* (SDRAMC) Value :  6 */
#define 	AT91C_SDRAMC_TRC_7                    ((unsigned int) 0x7 << 12) /* (SDRAMC) Value :  7 */
#define 	AT91C_SDRAMC_TRC_8                    ((unsigned int) 0x8 << 12) /* (SDRAMC) Value :  8 */
#define 	AT91C_SDRAMC_TRC_9                    ((unsigned int) 0x9 << 12) /* (SDRAMC) Value :  9 */
#define 	AT91C_SDRAMC_TRC_10                   ((unsigned int) 0xA << 12) /* (SDRAMC) Value : 10 */
#define 	AT91C_SDRAMC_TRC_11                   ((unsigned int) 0xB << 12) /* (SDRAMC) Value : 11 */
#define 	AT91C_SDRAMC_TRC_12                   ((unsigned int) 0xC << 12) /* (SDRAMC) Value : 12 */
#define 	AT91C_SDRAMC_TRC_13                   ((unsigned int) 0xD << 12) /* (SDRAMC) Value : 13 */
#define 	AT91C_SDRAMC_TRC_14                   ((unsigned int) 0xE << 12) /* (SDRAMC) Value : 14 */
#define 	AT91C_SDRAMC_TRC_15                   ((unsigned int) 0xF << 12) /* (SDRAMC) Value : 15 */
#define AT91C_SDRAMC_TRP      ((unsigned int) 0xF << 16) /* (SDRAMC) Number of RAS Precharge Time Cycles */
#define 	AT91C_SDRAMC_TRP_0                    ((unsigned int) 0x0 << 16) /* (SDRAMC) Value :  0 */
#define 	AT91C_SDRAMC_TRP_1                    ((unsigned int) 0x1 << 16) /* (SDRAMC) Value :  1 */
#define 	AT91C_SDRAMC_TRP_2                    ((unsigned int) 0x2 << 16) /* (SDRAMC) Value :  2 */
#define 	AT91C_SDRAMC_TRP_3                    ((unsigned int) 0x3 << 16) /* (SDRAMC) Value :  3 */
#define 	AT91C_SDRAMC_TRP_4                    ((unsigned int) 0x4 << 16) /* (SDRAMC) Value :  4 */
#define 	AT91C_SDRAMC_TRP_5                    ((unsigned int) 0x5 << 16) /* (SDRAMC) Value :  5 */
#define 	AT91C_SDRAMC_TRP_6                    ((unsigned int) 0x6 << 16) /* (SDRAMC) Value :  6 */
#define 	AT91C_SDRAMC_TRP_7                    ((unsigned int) 0x7 << 16) /* (SDRAMC) Value :  7 */
#define 	AT91C_SDRAMC_TRP_8                    ((unsigned int) 0x8 << 16) /* (SDRAMC) Value :  8 */
#define 	AT91C_SDRAMC_TRP_9                    ((unsigned int) 0x9 << 16) /* (SDRAMC) Value :  9 */
#define 	AT91C_SDRAMC_TRP_10                   ((unsigned int) 0xA << 16) /* (SDRAMC) Value : 10 */
#define 	AT91C_SDRAMC_TRP_11                   ((unsigned int) 0xB << 16) /* (SDRAMC) Value : 11 */
#define 	AT91C_SDRAMC_TRP_12                   ((unsigned int) 0xC << 16) /* (SDRAMC) Value : 12 */
#define 	AT91C_SDRAMC_TRP_13                   ((unsigned int) 0xD << 16) /* (SDRAMC) Value : 13 */
#define 	AT91C_SDRAMC_TRP_14                   ((unsigned int) 0xE << 16) /* (SDRAMC) Value : 14 */
#define 	AT91C_SDRAMC_TRP_15                   ((unsigned int) 0xF << 16) /* (SDRAMC) Value : 15 */
#define AT91C_SDRAMC_TRCD     ((unsigned int) 0xF << 20) /* (SDRAMC) Number of RAS to CAS Delay Cycles */
#define 	AT91C_SDRAMC_TRCD_0                    ((unsigned int) 0x0 << 20) /* (SDRAMC) Value :  0 */
#define 	AT91C_SDRAMC_TRCD_1                    ((unsigned int) 0x1 << 20) /* (SDRAMC) Value :  1 */
#define 	AT91C_SDRAMC_TRCD_2                    ((unsigned int) 0x2 << 20) /* (SDRAMC) Value :  2 */
#define 	AT91C_SDRAMC_TRCD_3                    ((unsigned int) 0x3 << 20) /* (SDRAMC) Value :  3 */
#define 	AT91C_SDRAMC_TRCD_4                    ((unsigned int) 0x4 << 20) /* (SDRAMC) Value :  4 */
#define 	AT91C_SDRAMC_TRCD_5                    ((unsigned int) 0x5 << 20) /* (SDRAMC) Value :  5 */
#define 	AT91C_SDRAMC_TRCD_6                    ((unsigned int) 0x6 << 20) /* (SDRAMC) Value :  6 */
#define 	AT91C_SDRAMC_TRCD_7                    ((unsigned int) 0x7 << 20) /* (SDRAMC) Value :  7 */
#define 	AT91C_SDRAMC_TRCD_8                    ((unsigned int) 0x8 << 20) /* (SDRAMC) Value :  8 */
#define 	AT91C_SDRAMC_TRCD_9                    ((unsigned int) 0x9 << 20) /* (SDRAMC) Value :  9 */
#define 	AT91C_SDRAMC_TRCD_10                   ((unsigned int) 0xA << 20) /* (SDRAMC) Value : 10 */
#define 	AT91C_SDRAMC_TRCD_11                   ((unsigned int) 0xB << 20) /* (SDRAMC) Value : 11 */
#define 	AT91C_SDRAMC_TRCD_12                   ((unsigned int) 0xC << 20) /* (SDRAMC) Value : 12 */
#define 	AT91C_SDRAMC_TRCD_13                   ((unsigned int) 0xD << 20) /* (SDRAMC) Value : 13 */
#define 	AT91C_SDRAMC_TRCD_14                   ((unsigned int) 0xE << 20) /* (SDRAMC) Value : 14 */
#define 	AT91C_SDRAMC_TRCD_15                   ((unsigned int) 0xF << 20) /* (SDRAMC) Value : 15 */
#define AT91C_SDRAMC_TRAS     ((unsigned int) 0xF << 24) /* (SDRAMC) Number of RAS Active Time Cycles */
#define 	AT91C_SDRAMC_TRAS_0                    ((unsigned int) 0x0 << 24) /* (SDRAMC) Value :  0 */
#define 	AT91C_SDRAMC_TRAS_1                    ((unsigned int) 0x1 << 24) /* (SDRAMC) Value :  1 */
#define 	AT91C_SDRAMC_TRAS_2                    ((unsigned int) 0x2 << 24) /* (SDRAMC) Value :  2 */
#define 	AT91C_SDRAMC_TRAS_3                    ((unsigned int) 0x3 << 24) /* (SDRAMC) Value :  3 */
#define 	AT91C_SDRAMC_TRAS_4                    ((unsigned int) 0x4 << 24) /* (SDRAMC) Value :  4 */
#define 	AT91C_SDRAMC_TRAS_5                    ((unsigned int) 0x5 << 24) /* (SDRAMC) Value :  5 */
#define 	AT91C_SDRAMC_TRAS_6                    ((unsigned int) 0x6 << 24) /* (SDRAMC) Value :  6 */
#define 	AT91C_SDRAMC_TRAS_7                    ((unsigned int) 0x7 << 24) /* (SDRAMC) Value :  7 */
#define 	AT91C_SDRAMC_TRAS_8                    ((unsigned int) 0x8 << 24) /* (SDRAMC) Value :  8 */
#define 	AT91C_SDRAMC_TRAS_9                    ((unsigned int) 0x9 << 24) /* (SDRAMC) Value :  9 */
#define 	AT91C_SDRAMC_TRAS_10                   ((unsigned int) 0xA << 24) /* (SDRAMC) Value : 10 */
#define 	AT91C_SDRAMC_TRAS_11                   ((unsigned int) 0xB << 24) /* (SDRAMC) Value : 11 */
#define 	AT91C_SDRAMC_TRAS_12                   ((unsigned int) 0xC << 24) /* (SDRAMC) Value : 12 */
#define 	AT91C_SDRAMC_TRAS_13                   ((unsigned int) 0xD << 24) /* (SDRAMC) Value : 13 */
#define 	AT91C_SDRAMC_TRAS_14                   ((unsigned int) 0xE << 24) /* (SDRAMC) Value : 14 */
#define 	AT91C_SDRAMC_TRAS_15                   ((unsigned int) 0xF << 24) /* (SDRAMC) Value : 15 */
#define AT91C_SDRAMC_TXSR     ((unsigned int) 0xF << 28) /* (SDRAMC) Number of Command Recovery Time Cycles */
#define 	AT91C_SDRAMC_TXSR_0                    ((unsigned int) 0x0 << 28) /* (SDRAMC) Value :  0 */
#define 	AT91C_SDRAMC_TXSR_1                    ((unsigned int) 0x1 << 28) /* (SDRAMC) Value :  1 */
#define 	AT91C_SDRAMC_TXSR_2                    ((unsigned int) 0x2 << 28) /* (SDRAMC) Value :  2 */
#define 	AT91C_SDRAMC_TXSR_3                    ((unsigned int) 0x3 << 28) /* (SDRAMC) Value :  3 */
#define 	AT91C_SDRAMC_TXSR_4                    ((unsigned int) 0x4 << 28) /* (SDRAMC) Value :  4 */
#define 	AT91C_SDRAMC_TXSR_5                    ((unsigned int) 0x5 << 28) /* (SDRAMC) Value :  5 */
#define 	AT91C_SDRAMC_TXSR_6                    ((unsigned int) 0x6 << 28) /* (SDRAMC) Value :  6 */
#define 	AT91C_SDRAMC_TXSR_7                    ((unsigned int) 0x7 << 28) /* (SDRAMC) Value :  7 */
#define 	AT91C_SDRAMC_TXSR_8                    ((unsigned int) 0x8 << 28) /* (SDRAMC) Value :  8 */
#define 	AT91C_SDRAMC_TXSR_9                    ((unsigned int) 0x9 << 28) /* (SDRAMC) Value :  9 */
#define 	AT91C_SDRAMC_TXSR_10                   ((unsigned int) 0xA << 28) /* (SDRAMC) Value : 10 */
#define 	AT91C_SDRAMC_TXSR_11                   ((unsigned int) 0xB << 28) /* (SDRAMC) Value : 11 */
#define 	AT91C_SDRAMC_TXSR_12                   ((unsigned int) 0xC << 28) /* (SDRAMC) Value : 12 */
#define 	AT91C_SDRAMC_TXSR_13                   ((unsigned int) 0xD << 28) /* (SDRAMC) Value : 13 */
#define 	AT91C_SDRAMC_TXSR_14                   ((unsigned int) 0xE << 28) /* (SDRAMC) Value : 14 */
#define 	AT91C_SDRAMC_TXSR_15                   ((unsigned int) 0xF << 28) /* (SDRAMC) Value : 15 */
/* -------- SDRAMC_HSR : (SDRAMC Offset: 0xc) SDRAM Controller High Speed Register --------  */
#define AT91C_SDRAMC_DA       ((unsigned int) 0x1 <<  0) /* (SDRAMC) Decode Cycle Enable Bit */
#define 	AT91C_SDRAMC_DA_DISABLE              ((unsigned int) 0x0) /* (SDRAMC) Disable Decode Cycle */
#define 	AT91C_SDRAMC_DA_ENABLE               ((unsigned int) 0x1) /* (SDRAMC) Enable Decode Cycle */
/* -------- SDRAMC_LPR : (SDRAMC Offset: 0x10) SDRAM Controller Low-power Register --------  */
#define AT91C_SDRAMC_LPCB     ((unsigned int) 0x3 <<  0) /* (SDRAMC) Low-power Configurations */
#define 	AT91C_SDRAMC_LPCB_DISABLE              ((unsigned int) 0x0) /* (SDRAMC) Disable Low Power Features */
#define 	AT91C_SDRAMC_LPCB_SELF_REFRESH         ((unsigned int) 0x1) /* (SDRAMC) Enable SELF_REFRESH */
#define 	AT91C_SDRAMC_LPCB_POWER_DOWN           ((unsigned int) 0x2) /* (SDRAMC) Enable POWER_DOWN */
#define 	AT91C_SDRAMC_LPCB_DEEP_POWER_DOWN      ((unsigned int) 0x3) /* (SDRAMC) Enable DEEP_POWER_DOWN */
#define AT91C_SDRAMC_PASR     ((unsigned int) 0x7 <<  4) /* (SDRAMC) Partial Array Self Refresh (only for Low Power SDRAM) */
#define AT91C_SDRAMC_TCSR     ((unsigned int) 0x3 <<  8) /* (SDRAMC) Temperature Compensated Self Refresh (only for Low Power SDRAM) */
#define AT91C_SDRAMC_DS       ((unsigned int) 0x3 << 10) /* (SDRAMC) Drive Strenght (only for Low Power SDRAM) */
#define AT91C_SDRAMC_TIMEOUT  ((unsigned int) 0x3 << 12) /* (SDRAMC) Time to define when Low Power Mode is enabled */
#define 	AT91C_SDRAMC_TIMEOUT_0_CLK_CYCLES         ((unsigned int) 0x0 << 12) /* (SDRAMC) Activate SDRAM Low Power Mode Immediately */
#define 	AT91C_SDRAMC_TIMEOUT_64_CLK_CYCLES        ((unsigned int) 0x1 << 12) /* (SDRAMC) Activate SDRAM Low Power Mode after 64 clock cycles after the end of the last transfer */
#define 	AT91C_SDRAMC_TIMEOUT_128_CLK_CYCLES       ((unsigned int) 0x2 << 12) /* (SDRAMC) Activate SDRAM Low Power Mode after 64 clock cycles after the end of the last transfer */
/* -------- SDRAMC_IER : (SDRAMC Offset: 0x14) SDRAM Controller Interrupt Enable Register --------  */
#define AT91C_SDRAMC_RES      ((unsigned int) 0x1 <<  0) /* (SDRAMC) Refresh Error Status */
/* -------- SDRAMC_IDR : (SDRAMC Offset: 0x18) SDRAM Controller Interrupt Disable Register --------  */
/* -------- SDRAMC_IMR : (SDRAMC Offset: 0x1c) SDRAM Controller Interrupt Mask Register --------  */
/* -------- SDRAMC_ISR : (SDRAMC Offset: 0x20) SDRAM Controller Interrupt Status Register --------  */
/* -------- SDRAMC_MDR : (SDRAMC Offset: 0x24) SDRAM Controller Memory Device Register --------  */
#define AT91C_SDRAMC_MD       ((unsigned int) 0x3 <<  0) /* (SDRAMC) Memory Device Type */
#define 	AT91C_SDRAMC_MD_SDRAM                ((unsigned int) 0x0) /* (SDRAMC) SDRAM Mode */
#define 	AT91C_SDRAMC_MD_LOW_POWER_SDRAM      ((unsigned int) 0x1) /* (SDRAMC) SDRAM Low Power Mode */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Static Memory Controller Interface */
/* ***************************************************************************** */
typedef struct _AT91S_SMC {
	AT91_REG	 SMC_SETUP0; 	/*  Setup Register for CS 0 */
	AT91_REG	 SMC_PULSE0; 	/*  Pulse Register for CS 0 */
	AT91_REG	 SMC_CYCLE0; 	/*  Cycle Register for CS 0 */
	AT91_REG	 SMC_CTRL0; 	/*  Control Register for CS 0 */
	AT91_REG	 SMC_SETUP1; 	/*  Setup Register for CS 1 */
	AT91_REG	 SMC_PULSE1; 	/*  Pulse Register for CS 1 */
	AT91_REG	 SMC_CYCLE1; 	/*  Cycle Register for CS 1 */
	AT91_REG	 SMC_CTRL1; 	/*  Control Register for CS 1 */
	AT91_REG	 SMC_SETUP2; 	/*  Setup Register for CS 2 */
	AT91_REG	 SMC_PULSE2; 	/*  Pulse Register for CS 2 */
	AT91_REG	 SMC_CYCLE2; 	/*  Cycle Register for CS 2 */
	AT91_REG	 SMC_CTRL2; 	/*  Control Register for CS 2 */
	AT91_REG	 SMC_SETUP3; 	/*  Setup Register for CS 3 */
	AT91_REG	 SMC_PULSE3; 	/*  Pulse Register for CS 3 */
	AT91_REG	 SMC_CYCLE3; 	/*  Cycle Register for CS 3 */
	AT91_REG	 SMC_CTRL3; 	/*  Control Register for CS 3 */
	AT91_REG	 SMC_SETUP4; 	/*  Setup Register for CS 4 */
	AT91_REG	 SMC_PULSE4; 	/*  Pulse Register for CS 4 */
	AT91_REG	 SMC_CYCLE4; 	/*  Cycle Register for CS 4 */
	AT91_REG	 SMC_CTRL4; 	/*  Control Register for CS 4 */
	AT91_REG	 SMC_SETUP5; 	/*  Setup Register for CS 5 */
	AT91_REG	 SMC_PULSE5; 	/*  Pulse Register for CS 5 */
	AT91_REG	 SMC_CYCLE5; 	/*  Cycle Register for CS 5 */
	AT91_REG	 SMC_CTRL5; 	/*  Control Register for CS 5 */
	AT91_REG	 SMC_SETUP6; 	/*  Setup Register for CS 6 */
	AT91_REG	 SMC_PULSE6; 	/*  Pulse Register for CS 6 */
	AT91_REG	 SMC_CYCLE6; 	/*  Cycle Register for CS 6 */
	AT91_REG	 SMC_CTRL6; 	/*  Control Register for CS 6 */
	AT91_REG	 SMC_SETUP7; 	/*  Setup Register for CS 7 */
	AT91_REG	 SMC_PULSE7; 	/*  Pulse Register for CS 7 */
	AT91_REG	 SMC_CYCLE7; 	/*  Cycle Register for CS 7 */
	AT91_REG	 SMC_CTRL7; 	/*  Control Register for CS 7 */
} AT91S_SMC, *AT91PS_SMC;

/* -------- SMC_SETUP : (SMC Offset: 0x0) Setup Register for CS x --------  */
#define AT91C_SMC_NWESETUP    ((unsigned int) 0x3F <<  0) /* (SMC) NWE Setup Length */
#define AT91C_SMC_NCSSETUPWR  ((unsigned int) 0x3F <<  8) /* (SMC) NCS Setup Length in WRite Access */
#define AT91C_SMC_NRDSETUP    ((unsigned int) 0x3F << 16) /* (SMC) NRD Setup Length */
#define AT91C_SMC_NCSSETUPRD  ((unsigned int) 0x3F << 24) /* (SMC) NCS Setup Length in ReaD Access */
/* -------- SMC_PULSE : (SMC Offset: 0x4) Pulse Register for CS x --------  */
#define AT91C_SMC_NWEPULSE    ((unsigned int) 0x7F <<  0) /* (SMC) NWE Pulse Length */
#define AT91C_SMC_NCSPULSEWR  ((unsigned int) 0x7F <<  8) /* (SMC) NCS Pulse Length in WRite Access */
#define AT91C_SMC_NRDPULSE    ((unsigned int) 0x7F << 16) /* (SMC) NRD Pulse Length */
#define AT91C_SMC_NCSPULSERD  ((unsigned int) 0x7F << 24) /* (SMC) NCS Pulse Length in ReaD Access */
/* -------- SMC_CYC : (SMC Offset: 0x8) Cycle Register for CS x --------  */
#define AT91C_SMC_NWECYCLE    ((unsigned int) 0x1FF <<  0) /* (SMC) Total Write Cycle Length */
#define AT91C_SMC_NRDCYCLE    ((unsigned int) 0x1FF << 16) /* (SMC) Total Read Cycle Length */
/* -------- SMC_CTRL : (SMC Offset: 0xc) Control Register for CS x --------  */
#define AT91C_SMC_READMODE    ((unsigned int) 0x1 <<  0) /* (SMC) Read Mode */
#define AT91C_SMC_WRITEMODE   ((unsigned int) 0x1 <<  1) /* (SMC) Write Mode */
#define AT91C_SMC_NWAITM      ((unsigned int) 0x3 <<  5) /* (SMC) NWAIT Mode */
#define 	AT91C_SMC_NWAITM_NWAIT_DISABLE        ((unsigned int) 0x0 <<  5) /* (SMC) External NWAIT disabled. */
#define 	AT91C_SMC_NWAITM_NWAIT_ENABLE_FROZEN  ((unsigned int) 0x2 <<  5) /* (SMC) External NWAIT enabled in frozen mode. */
#define 	AT91C_SMC_NWAITM_NWAIT_ENABLE_READY   ((unsigned int) 0x3 <<  5) /* (SMC) External NWAIT enabled in ready mode. */
#define AT91C_SMC_BAT         ((unsigned int) 0x1 <<  8) /* (SMC) Byte Access Type */
#define 	AT91C_SMC_BAT_BYTE_SELECT          ((unsigned int) 0x0 <<  8) /* (SMC) Write controled by ncs, nbs0, nbs1, nbs2, nbs3. Read controled by ncs, nrd, nbs0, nbs1, nbs2, nbs3. */
#define 	AT91C_SMC_BAT_BYTE_WRITE           ((unsigned int) 0x1 <<  8) /* (SMC) Write controled by ncs, nwe0, nwe1, nwe2, nwe3. Read controled by ncs and nrd. */
#define AT91C_SMC_DBW         ((unsigned int) 0x3 << 12) /* (SMC) Data Bus Width */
#define 	AT91C_SMC_DBW_WIDTH_EIGTH_BITS     ((unsigned int) 0x0 << 12) /* (SMC) 8 bits. */
#define 	AT91C_SMC_DBW_WIDTH_SIXTEEN_BITS   ((unsigned int) 0x1 << 12) /* (SMC) 16 bits. */
#define 	AT91C_SMC_DBW_WIDTH_THIRTY_TWO_BITS ((unsigned int) 0x2 << 12) /* (SMC) 32 bits. */
#define AT91C_SMC_TDF         ((unsigned int) 0xF << 16) /* (SMC) Data Float Time. */
#define AT91C_SMC_TDFEN       ((unsigned int) 0x1 << 20) /* (SMC) TDF Enabled. */
#define AT91C_SMC_PMEN        ((unsigned int) 0x1 << 24) /* (SMC) Page Mode Enabled. */
#define AT91C_SMC_PS          ((unsigned int) 0x3 << 28) /* (SMC) Page Size */
#define 	AT91C_SMC_PS_SIZE_FOUR_BYTES      ((unsigned int) 0x0 << 28) /* (SMC) 4 bytes. */
#define 	AT91C_SMC_PS_SIZE_EIGHT_BYTES     ((unsigned int) 0x1 << 28) /* (SMC) 8 bytes. */
#define 	AT91C_SMC_PS_SIZE_SIXTEEN_BYTES   ((unsigned int) 0x2 << 28) /* (SMC) 16 bytes. */
#define 	AT91C_SMC_PS_SIZE_THIRTY_TWO_BYTES ((unsigned int) 0x3 << 28) /* (SMC) 32 bytes. */
/* -------- SMC_SETUP : (SMC Offset: 0x10) Setup Register for CS x --------  */
/* -------- SMC_PULSE : (SMC Offset: 0x14) Pulse Register for CS x --------  */
/* -------- SMC_CYC : (SMC Offset: 0x18) Cycle Register for CS x --------  */
/* -------- SMC_CTRL : (SMC Offset: 0x1c) Control Register for CS x --------  */
/* -------- SMC_SETUP : (SMC Offset: 0x20) Setup Register for CS x --------  */
/* -------- SMC_PULSE : (SMC Offset: 0x24) Pulse Register for CS x --------  */
/* -------- SMC_CYC : (SMC Offset: 0x28) Cycle Register for CS x --------  */
/* -------- SMC_CTRL : (SMC Offset: 0x2c) Control Register for CS x --------  */
/* -------- SMC_SETUP : (SMC Offset: 0x30) Setup Register for CS x --------  */
/* -------- SMC_PULSE : (SMC Offset: 0x34) Pulse Register for CS x --------  */
/* -------- SMC_CYC : (SMC Offset: 0x38) Cycle Register for CS x --------  */
/* -------- SMC_CTRL : (SMC Offset: 0x3c) Control Register for CS x --------  */
/* -------- SMC_SETUP : (SMC Offset: 0x40) Setup Register for CS x --------  */
/* -------- SMC_PULSE : (SMC Offset: 0x44) Pulse Register for CS x --------  */
/* -------- SMC_CYC : (SMC Offset: 0x48) Cycle Register for CS x --------  */
/* -------- SMC_CTRL : (SMC Offset: 0x4c) Control Register for CS x --------  */
/* -------- SMC_SETUP : (SMC Offset: 0x50) Setup Register for CS x --------  */
/* -------- SMC_PULSE : (SMC Offset: 0x54) Pulse Register for CS x --------  */
/* -------- SMC_CYC : (SMC Offset: 0x58) Cycle Register for CS x --------  */
/* -------- SMC_CTRL : (SMC Offset: 0x5c) Control Register for CS x --------  */
/* -------- SMC_SETUP : (SMC Offset: 0x60) Setup Register for CS x --------  */
/* -------- SMC_PULSE : (SMC Offset: 0x64) Pulse Register for CS x --------  */
/* -------- SMC_CYC : (SMC Offset: 0x68) Cycle Register for CS x --------  */
/* -------- SMC_CTRL : (SMC Offset: 0x6c) Control Register for CS x --------  */
/* -------- SMC_SETUP : (SMC Offset: 0x70) Setup Register for CS x --------  */
/* -------- SMC_PULSE : (SMC Offset: 0x74) Pulse Register for CS x --------  */
/* -------- SMC_CYC : (SMC Offset: 0x78) Cycle Register for CS x --------  */
/* -------- SMC_CTRL : (SMC Offset: 0x7c) Control Register for CS x --------  */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR AHB Matrix Interface */
/* ***************************************************************************** */
typedef struct _AT91S_MATRIX {
	AT91_REG	 MATRIX_MCFG0; 	/*  Master Configuration Register 0 (ram96k)      */
	AT91_REG	 MATRIX_MCFG1; 	/*  Master Configuration Register 1 (rom)     */
	AT91_REG	 MATRIX_MCFG2; 	/*  Master Configuration Register 2 (hperiphs)  */
	AT91_REG	 MATRIX_MCFG3; 	/*  Master Configuration Register 3 (ebi) */
	AT91_REG	 MATRIX_MCFG4; 	/*  Master Configuration Register 4 (bridge)     */
	AT91_REG	 MATRIX_MCFG5; 	/*  Master Configuration Register 5 (mailbox)     */
	AT91_REG	 MATRIX_MCFG6; 	/*  Master Configuration Register 6 (ram16k)   */
	AT91_REG	 MATRIX_MCFG7; 	/*  Master Configuration Register 7 (teak_prog)      */
	AT91_REG	 Reserved0[8]; 	/*  */
	AT91_REG	 MATRIX_SCFG0; 	/*  Slave Configuration Register 0 (ram96k)      */
	AT91_REG	 MATRIX_SCFG1; 	/*  Slave Configuration Register 1 (rom)     */
	AT91_REG	 MATRIX_SCFG2; 	/*  Slave Configuration Register 2 (hperiphs)  */
	AT91_REG	 MATRIX_SCFG3; 	/*  Slave Configuration Register 3 (ebi) */
	AT91_REG	 MATRIX_SCFG4; 	/*  Slave Configuration Register 4 (bridge)     */
	AT91_REG	 Reserved1[11]; 	/*  */
	AT91_REG	 MATRIX_PRAS0; 	/*  PRAS0 (ram0)  */
	AT91_REG	 MATRIX_PRBS0; 	/*  PRBS0 (ram0)  */
	AT91_REG	 MATRIX_PRAS1; 	/*  PRAS1 (ram1)  */
	AT91_REG	 MATRIX_PRBS1; 	/*  PRBS1 (ram1)  */
	AT91_REG	 MATRIX_PRAS2; 	/*  PRAS2 (ram2)  */
	AT91_REG	 MATRIX_PRBS2; 	/*  PRBS2 (ram2)  */
	AT91_REG	 Reserved2[26]; 	/*  */
	AT91_REG	 MATRIX_MRCR; 	/*  Master Remp Control Register  */
	AT91_REG	 Reserved3[6]; 	/*  */
	AT91_REG	 MATRIX_EBI; 	/*  Slave 3 (ebi) Special Function Register */
	AT91_REG	 Reserved4[3]; 	/*  */
	AT91_REG	 MATRIX_TEAKCFG; 	/*  Slave 7 (teak_prog) Special Function Register */
	AT91_REG	 Reserved5[51]; 	/*  */
	AT91_REG	 MATRIX_VERSION; 	/*  Version Register */
} AT91S_MATRIX, *AT91PS_MATRIX;

/* -------- MATRIX_SCFG0 : (MATRIX Offset: 0x40) Slave Configuration Register 0 --------  */
#define AT91C_MATRIX_SLOT_CYCLE ((unsigned int) 0xFF <<  0) /* (MATRIX) Maximum Number of Allowed Cycles for a Burst */
#define AT91C_MATRIX_DEFMSTR_TYPE ((unsigned int) 0x3 << 16) /* (MATRIX) Default Master Type */
#define 	AT91C_MATRIX_DEFMSTR_TYPE_NO_DEFMSTR           ((unsigned int) 0x0 << 16) /* (MATRIX) No Default Master. At the end of current slave access, if no other master request is pending, the slave is deconnected from all masters. This results in having a one cycle latency for the first transfer of a burst. */
#define 	AT91C_MATRIX_DEFMSTR_TYPE_LAST_DEFMSTR         ((unsigned int) 0x1 << 16) /* (MATRIX) Last Default Master. At the end of current slave access, if no other master request is pending, the slave stay connected with the last master having accessed it. This results in not having the one cycle latency when the last master re-trying access on the slave. */
#define 	AT91C_MATRIX_DEFMSTR_TYPE_FIXED_DEFMSTR        ((unsigned int) 0x2 << 16) /* (MATRIX) Fixed Default Master. At the end of current slave access, if no other master request is pending, the slave connects with fixed which number is in FIXED_DEFMSTR field. This results in not having the one cycle latency when the fixed master re-trying access on the slave. */
#define AT91C_MATRIX_FIXED_DEFMSTR0 ((unsigned int) 0x7 << 18) /* (MATRIX) Fixed Index of Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR0_ARM926I              ((unsigned int) 0x0 << 18) /* (MATRIX) ARM926EJ-S Instruction Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR0_ARM926D              ((unsigned int) 0x1 << 18) /* (MATRIX) ARM926EJ-S Data Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR0_HPDC3                ((unsigned int) 0x2 << 18) /* (MATRIX) HPDC3 Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR0_LCDC                 ((unsigned int) 0x3 << 18) /* (MATRIX) LCDC Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR0_DMA                  ((unsigned int) 0x4 << 18) /* (MATRIX) DMA Master is Default Master */
/* -------- MATRIX_SCFG1 : (MATRIX Offset: 0x44) Slave Configuration Register 1 --------  */
#define AT91C_MATRIX_FIXED_DEFMSTR1 ((unsigned int) 0x7 << 18) /* (MATRIX) Fixed Index of Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR1_ARM926I              ((unsigned int) 0x0 << 18) /* (MATRIX) ARM926EJ-S Instruction Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR1_ARM926D              ((unsigned int) 0x1 << 18) /* (MATRIX) ARM926EJ-S Data Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR1_HPDC3                ((unsigned int) 0x2 << 18) /* (MATRIX) HPDC3 Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR1_LCDC                 ((unsigned int) 0x3 << 18) /* (MATRIX) LCDC Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR1_DMA                  ((unsigned int) 0x4 << 18) /* (MATRIX) DMA Master is Default Master */
/* -------- MATRIX_SCFG2 : (MATRIX Offset: 0x48) Slave Configuration Register 2 --------  */
#define AT91C_MATRIX_FIXED_DEFMSTR2 ((unsigned int) 0x1 << 18) /* (MATRIX) Fixed Index of Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR2_ARM926I              ((unsigned int) 0x0 << 18) /* (MATRIX) ARM926EJ-S Instruction Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR2_ARM926D              ((unsigned int) 0x1 << 18) /* (MATRIX) ARM926EJ-S Data Master is Default Master */
/* -------- MATRIX_SCFG3 : (MATRIX Offset: 0x4c) Slave Configuration Register 3 --------  */
#define AT91C_MATRIX_FIXED_DEFMSTR3 ((unsigned int) 0x7 << 18) /* (MATRIX) Fixed Index of Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR3_ARM926I              ((unsigned int) 0x0 << 18) /* (MATRIX) ARM926EJ-S Instruction Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR3_ARM926D              ((unsigned int) 0x1 << 18) /* (MATRIX) ARM926EJ-S Data Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR3_HPDC3                ((unsigned int) 0x2 << 18) /* (MATRIX) HPDC3 Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR3_LCDC                 ((unsigned int) 0x3 << 18) /* (MATRIX) LCDC Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR3_DMA                  ((unsigned int) 0x4 << 18) /* (MATRIX) DMA Master is Default Master */
/* -------- MATRIX_SCFG4 : (MATRIX Offset: 0x50) Slave Configuration Register 4 --------  */
#define AT91C_MATRIX_FIXED_DEFMSTR4 ((unsigned int) 0x3 << 18) /* (MATRIX) Fixed Index of Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR4_ARM926I              ((unsigned int) 0x0 << 18) /* (MATRIX) ARM926EJ-S Instruction Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR4_ARM926D              ((unsigned int) 0x1 << 18) /* (MATRIX) ARM926EJ-S Data Master is Default Master */
#define 	AT91C_MATRIX_FIXED_DEFMSTR4_HPDC3                ((unsigned int) 0x2 << 18) /* (MATRIX) HPDC3 Master is Default Master */
/* -------- MATRIX_MRCR : (MATRIX Offset: 0x100) MRCR Register --------  */
#define AT91C_MATRIX_RCA926I  ((unsigned int) 0x1 <<  0) /* (MATRIX) Remap Command for ARM926EJ-S Instruction Master */
#define AT91C_MATRIX_RCA926D  ((unsigned int) 0x1 <<  1) /* (MATRIX) Remap Command for ARM926EJ-S Data Master */
/* -------- MATRIX_EBI : (MATRIX Offset: 0x11c) EBI (Slave 3) Special Function Register --------  */
#define AT91C_MATRIX_CS1A     ((unsigned int) 0x1 <<  1) /* (MATRIX) Chip Select 1 Assignment */
#define 	AT91C_MATRIX_CS1A_SMC                  ((unsigned int) 0x0 <<  1) /* (MATRIX) Chip Select 1 is assigned to the Static Memory Controller. */
#define 	AT91C_MATRIX_CS1A_SDRAMC               ((unsigned int) 0x1 <<  1) /* (MATRIX) Chip Select 1 is assigned to the SDRAM Controller. */
#define AT91C_MATRIX_CS3A     ((unsigned int) 0x1 <<  3) /* (MATRIX) Chip Select 3 Assignment */
#define 	AT91C_MATRIX_CS3A_SMC                  ((unsigned int) 0x0 <<  3) /* (MATRIX) Chip Select 3 is only assigned to the Static Memory Controller and NCS3 behaves as defined by the SMC. */
#define 	AT91C_MATRIX_CS3A_SM                   ((unsigned int) 0x1 <<  3) /* (MATRIX) Chip Select 3 is assigned to the Static Memory Controller and the SmartMedia Logic is activated. */
#define AT91C_MATRIX_CS4A     ((unsigned int) 0x1 <<  4) /* (MATRIX) Chip Select 4 Assignment */
#define 	AT91C_MATRIX_CS4A_SMC                  ((unsigned int) 0x0 <<  4) /* (MATRIX) Chip Select 4 is only assigned to the Static Memory Controller and NCS4 behaves as defined by the SMC. */
#define 	AT91C_MATRIX_CS4A_CF                   ((unsigned int) 0x1 <<  4) /* (MATRIX) Chip Select 4 is assigned to the Static Memory Controller and the CompactFlash Logic (first slot) is activated. */
#define AT91C_MATRIX_CS5A     ((unsigned int) 0x1 <<  5) /* (MATRIX) Chip Select 5 Assignment */
#define 	AT91C_MATRIX_CS5A_SMC                  ((unsigned int) 0x0 <<  5) /* (MATRIX) Chip Select 5 is only assigned to the Static Memory Controller and NCS5 behaves as defined by the SMC */
#define 	AT91C_MATRIX_CS5A_CF                   ((unsigned int) 0x1 <<  5) /* (MATRIX) Chip Select 5 is assigned to the Static Memory Controller and the CompactFlash Logic (second slot) is activated. */
#define AT91C_MATRIX_DBPUC    ((unsigned int) 0x1 <<  8) /* (MATRIX) Data Bus Pull-up Configuration */
/* -------- MATRIX_TEAKCFG : (MATRIX Offset: 0x12c) Slave 7 Special Function Register --------  */
#define AT91C_TEAK_PROGRAM_ACCESS ((unsigned int) 0x1 <<  0) /* (MATRIX) TEAK program memory access from AHB */
#define 	AT91C_TEAK_PROGRAM_ACCESS_DISABLED             ((unsigned int) 0x0) /* (MATRIX) TEAK program access disabled */
#define 	AT91C_TEAK_PROGRAM_ACCESS_ENABLED              ((unsigned int) 0x1) /* (MATRIX) TEAK program access enabled */
#define AT91C_TEAK_BOOT       ((unsigned int) 0x1 <<  1) /* (MATRIX) TEAK program start from boot routine */
#define 	AT91C_TEAK_BOOT_DISABLED             ((unsigned int) 0x0 <<  1) /* (MATRIX) TEAK program starts from boot routine disabled */
#define 	AT91C_TEAK_BOOT_ENABLED              ((unsigned int) 0x1 <<  1) /* (MATRIX) TEAK program starts from boot routine enabled */
#define AT91C_TEAK_NRESET     ((unsigned int) 0x1 <<  2) /* (MATRIX) active low TEAK reset */
#define 	AT91C_TEAK_NRESET_ENABLED              ((unsigned int) 0x0 <<  2) /* (MATRIX) active low TEAK reset enabled */
#define 	AT91C_TEAK_NRESET_DISABLED             ((unsigned int) 0x1 <<  2) /* (MATRIX) active low TEAK reset disabled */
#define AT91C_TEAK_LVECTORP   ((unsigned int) 0x3FFFF << 14) /* (MATRIX) boot routine start address */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Chip Configuration Registers */
/* ***************************************************************************** */
typedef struct _AT91S_CCFG {
	AT91_REG	 Reserved0[3]; 	/*  */
	AT91_REG	 CCFG_EBICSA; 	/*  EBI Chip Select Assignement Register */
	AT91_REG	 Reserved1[55]; 	/*  */
	AT91_REG	 CCFG_MATRIXVERSION; 	/*  Version Register */
} AT91S_CCFG, *AT91PS_CCFG;

/* -------- CCFG_EBICSA : (CCFG Offset: 0xc) EBI Chip Select Assignement Register --------  */
#define AT91C_EBI_CS1A        ((unsigned int) 0x1 <<  1) /* (CCFG) Chip Select 1 Assignment */
#define 	AT91C_EBI_CS1A_SMC                  ((unsigned int) 0x0 <<  1) /* (CCFG) Chip Select 1 is assigned to the Static Memory Controller. */
#define 	AT91C_EBI_CS1A_SDRAMC               ((unsigned int) 0x1 <<  1) /* (CCFG) Chip Select 1 is assigned to the SDRAM Controller. */
#define AT91C_EBI_CS3A        ((unsigned int) 0x1 <<  3) /* (CCFG) Chip Select 3 Assignment */
#define 	AT91C_EBI_CS3A_SMC                  ((unsigned int) 0x0 <<  3) /* (CCFG) Chip Select 3 is only assigned to the Static Memory Controller and NCS3 behaves as defined by the SMC. */
#define 	AT91C_EBI_CS3A_SM                   ((unsigned int) 0x1 <<  3) /* (CCFG) Chip Select 3 is assigned to the Static Memory Controller and the SmartMedia Logic is activated. */
#define AT91C_EBI_CS4A        ((unsigned int) 0x1 <<  4) /* (CCFG) Chip Select 4 Assignment */
#define 	AT91C_EBI_CS4A_SMC                  ((unsigned int) 0x0 <<  4) /* (CCFG) Chip Select 4 is only assigned to the Static Memory Controller and NCS4 behaves as defined by the SMC. */
#define 	AT91C_EBI_CS4A_CF                   ((unsigned int) 0x1 <<  4) /* (CCFG) Chip Select 4 is assigned to the Static Memory Controller and the CompactFlash Logic (first slot) is activated. */
#define AT91C_EBI_CS5A        ((unsigned int) 0x1 <<  5) /* (CCFG) Chip Select 5 Assignment */
#define 	AT91C_EBI_CS5A_SMC                  ((unsigned int) 0x0 <<  5) /* (CCFG) Chip Select 5 is only assigned to the Static Memory Controller and NCS5 behaves as defined by the SMC */
#define 	AT91C_EBI_CS5A_CF                   ((unsigned int) 0x1 <<  5) /* (CCFG) Chip Select 5 is assigned to the Static Memory Controller and the CompactFlash Logic (second slot) is activated. */
#define AT91C_EBI_DBPUC       ((unsigned int) 0x1 <<  8) /* (CCFG) Data Bus Pull-up Configuration */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Peripheral DMA Controller */
/* ***************************************************************************** */
typedef struct _AT91S_PDC {
	AT91_REG	 PDC_RPR; 	/* Receive Pointer Register */
	AT91_REG	 PDC_RCR; 	/* Receive Counter Register */
	AT91_REG	 PDC_TPR; 	/* Transmit Pointer Register */
	AT91_REG	 PDC_TCR; 	/* Transmit Counter Register */
	AT91_REG	 PDC_RNPR; 	/* Receive Next Pointer Register */
	AT91_REG	 PDC_RNCR; 	/* Receive Next Counter Register */
	AT91_REG	 PDC_TNPR; 	/* Transmit Next Pointer Register */
	AT91_REG	 PDC_TNCR; 	/* Transmit Next Counter Register */
	AT91_REG	 PDC_PTCR; 	/* PDC Transfer Control Register */
	AT91_REG	 PDC_PTSR; 	/* PDC Transfer Status Register */
} AT91S_PDC, *AT91PS_PDC;

/* -------- PDC_PTCR : (PDC Offset: 0x20) PDC Transfer Control Register --------  */
#define AT91C_PDC_RXTEN       ((unsigned int) 0x1 <<  0) /* (PDC) Receiver Transfer Enable */
#define AT91C_PDC_RXTDIS      ((unsigned int) 0x1 <<  1) /* (PDC) Receiver Transfer Disable */
#define AT91C_PDC_TXTEN       ((unsigned int) 0x1 <<  8) /* (PDC) Transmitter Transfer Enable */
#define AT91C_PDC_TXTDIS      ((unsigned int) 0x1 <<  9) /* (PDC) Transmitter Transfer Disable */
/* -------- PDC_PTSR : (PDC Offset: 0x24) PDC Transfer Status Register --------  */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Debug Unit */
/* ***************************************************************************** */
typedef struct _AT91S_DBGU {
	AT91_REG	 DBGU_CR; 	/* Control Register */
	AT91_REG	 DBGU_MR; 	/* Mode Register */
	AT91_REG	 DBGU_IER; 	/* Interrupt Enable Register */
	AT91_REG	 DBGU_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 DBGU_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 DBGU_CSR; 	/* Channel Status Register */
	AT91_REG	 DBGU_RHR; 	/* Receiver Holding Register */
	AT91_REG	 DBGU_THR; 	/* Transmitter Holding Register */
	AT91_REG	 DBGU_BRGR; 	/* Baud Rate Generator Register */
	AT91_REG	 Reserved0[7]; 	/*  */
	AT91_REG	 DBGU_CIDR; 	/* Chip ID Register */
	AT91_REG	 DBGU_EXID; 	/* Chip ID Extension Register */
	AT91_REG	 DBGU_FNTR; 	/* Force NTRST Register */
	AT91_REG	 Reserved1[45]; 	/*  */
	AT91_REG	 DBGU_RPR; 	/* Receive Pointer Register */
	AT91_REG	 DBGU_RCR; 	/* Receive Counter Register */
	AT91_REG	 DBGU_TPR; 	/* Transmit Pointer Register */
	AT91_REG	 DBGU_TCR; 	/* Transmit Counter Register */
	AT91_REG	 DBGU_RNPR; 	/* Receive Next Pointer Register */
	AT91_REG	 DBGU_RNCR; 	/* Receive Next Counter Register */
	AT91_REG	 DBGU_TNPR; 	/* Transmit Next Pointer Register */
	AT91_REG	 DBGU_TNCR; 	/* Transmit Next Counter Register */
	AT91_REG	 DBGU_PTCR; 	/* PDC Transfer Control Register */
	AT91_REG	 DBGU_PTSR; 	/* PDC Transfer Status Register */
} AT91S_DBGU, *AT91PS_DBGU;

/* -------- DBGU_CR : (DBGU Offset: 0x0) Debug Unit Control Register --------  */
#define AT91C_US_RSTRX        ((unsigned int) 0x1 <<  2) /* (DBGU) Reset Receiver */
#define AT91C_US_RSTTX        ((unsigned int) 0x1 <<  3) /* (DBGU) Reset Transmitter */
#define AT91C_US_RXEN         ((unsigned int) 0x1 <<  4) /* (DBGU) Receiver Enable */
#define AT91C_US_RXDIS        ((unsigned int) 0x1 <<  5) /* (DBGU) Receiver Disable */
#define AT91C_US_TXEN         ((unsigned int) 0x1 <<  6) /* (DBGU) Transmitter Enable */
#define AT91C_US_TXDIS        ((unsigned int) 0x1 <<  7) /* (DBGU) Transmitter Disable */
#define AT91C_US_RSTSTA       ((unsigned int) 0x1 <<  8) /* (DBGU) Reset Status Bits */
/* -------- DBGU_MR : (DBGU Offset: 0x4) Debug Unit Mode Register --------  */
#define AT91C_US_PAR          ((unsigned int) 0x7 <<  9) /* (DBGU) Parity type */
#define 	AT91C_US_PAR_EVEN                 ((unsigned int) 0x0 <<  9) /* (DBGU) Even Parity */
#define 	AT91C_US_PAR_ODD                  ((unsigned int) 0x1 <<  9) /* (DBGU) Odd Parity */
#define 	AT91C_US_PAR_SPACE                ((unsigned int) 0x2 <<  9) /* (DBGU) Parity forced to 0 (Space) */
#define 	AT91C_US_PAR_MARK                 ((unsigned int) 0x3 <<  9) /* (DBGU) Parity forced to 1 (Mark) */
#define 	AT91C_US_PAR_NONE                 ((unsigned int) 0x4 <<  9) /* (DBGU) No Parity */
#define 	AT91C_US_PAR_MULTI_DROP           ((unsigned int) 0x6 <<  9) /* (DBGU) Multi-drop mode */
#define AT91C_US_CHMODE       ((unsigned int) 0x3 << 14) /* (DBGU) Channel Mode */
#define 	AT91C_US_CHMODE_NORMAL               ((unsigned int) 0x0 << 14) /* (DBGU) Normal Mode: The USART channel operates as an RX/TX USART. */
#define 	AT91C_US_CHMODE_AUTO                 ((unsigned int) 0x1 << 14) /* (DBGU) Automatic Echo: Receiver Data Input is connected to the TXD pin. */
#define 	AT91C_US_CHMODE_LOCAL                ((unsigned int) 0x2 << 14) /* (DBGU) Local Loopback: Transmitter Output Signal is connected to Receiver Input Signal. */
#define 	AT91C_US_CHMODE_REMOTE               ((unsigned int) 0x3 << 14) /* (DBGU) Remote Loopback: RXD pin is internally connected to TXD pin. */
/* -------- DBGU_IER : (DBGU Offset: 0x8) Debug Unit Interrupt Enable Register --------  */
#define AT91C_US_RXRDY        ((unsigned int) 0x1 <<  0) /* (DBGU) RXRDY Interrupt */
#define AT91C_US_TXRDY        ((unsigned int) 0x1 <<  1) /* (DBGU) TXRDY Interrupt */
#define AT91C_US_ENDRX        ((unsigned int) 0x1 <<  3) /* (DBGU) End of Receive Transfer Interrupt */
#define AT91C_US_ENDTX        ((unsigned int) 0x1 <<  4) /* (DBGU) End of Transmit Interrupt */
#define AT91C_US_OVRE         ((unsigned int) 0x1 <<  5) /* (DBGU) Overrun Interrupt */
#define AT91C_US_FRAME        ((unsigned int) 0x1 <<  6) /* (DBGU) Framing Error Interrupt */
#define AT91C_US_PARE         ((unsigned int) 0x1 <<  7) /* (DBGU) Parity Error Interrupt */
#define AT91C_US_TXEMPTY      ((unsigned int) 0x1 <<  9) /* (DBGU) TXEMPTY Interrupt */
#define AT91C_US_TXBUFE       ((unsigned int) 0x1 << 11) /* (DBGU) TXBUFE Interrupt */
#define AT91C_US_RXBUFF       ((unsigned int) 0x1 << 12) /* (DBGU) RXBUFF Interrupt */
#define AT91C_US_COMM_TX      ((unsigned int) 0x1 << 30) /* (DBGU) COMM_TX Interrupt */
#define AT91C_US_COMM_RX      ((unsigned int) 0x1 << 31) /* (DBGU) COMM_RX Interrupt */
/* -------- DBGU_IDR : (DBGU Offset: 0xc) Debug Unit Interrupt Disable Register --------  */
/* -------- DBGU_IMR : (DBGU Offset: 0x10) Debug Unit Interrupt Mask Register --------  */
/* -------- DBGU_CSR : (DBGU Offset: 0x14) Debug Unit Channel Status Register --------  */
/* -------- DBGU_FNTR : (DBGU Offset: 0x48) Debug Unit FORCE_NTRST Register --------  */
#define AT91C_US_FORCE_NTRST  ((unsigned int) 0x1 <<  0) /* (DBGU) Force NTRST in JTAG */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Advanced Interrupt Controller */
/* ***************************************************************************** */
typedef struct _AT91S_AIC {
	AT91_REG	 AIC_SMR[32]; 	/* Source Mode Register */
	AT91_REG	 AIC_SVR[32]; 	/* Source Vector Register */
	AT91_REG	 AIC_IVR; 	/* IRQ Vector Register */
	AT91_REG	 AIC_FVR; 	/* FIQ Vector Register */
	AT91_REG	 AIC_ISR; 	/* Interrupt Status Register */
	AT91_REG	 AIC_IPR; 	/* Interrupt Pending Register */
	AT91_REG	 AIC_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 AIC_CISR; 	/* Core Interrupt Status Register */
	AT91_REG	 Reserved0[2]; 	/*  */
	AT91_REG	 AIC_IECR; 	/* Interrupt Enable Command Register */
	AT91_REG	 AIC_IDCR; 	/* Interrupt Disable Command Register */
	AT91_REG	 AIC_ICCR; 	/* Interrupt Clear Command Register */
	AT91_REG	 AIC_ISCR; 	/* Interrupt Set Command Register */
	AT91_REG	 AIC_EOICR; 	/* End of Interrupt Command Register */
	AT91_REG	 AIC_SPU; 	/* Spurious Vector Register */
	AT91_REG	 AIC_DCR; 	/* Debug Control Register (Protect) */
	AT91_REG	 Reserved1[1]; 	/*  */
	AT91_REG	 AIC_FFER; 	/* Fast Forcing Enable Register */
	AT91_REG	 AIC_FFDR; 	/* Fast Forcing Disable Register */
	AT91_REG	 AIC_FFSR; 	/* Fast Forcing Status Register */
} AT91S_AIC, *AT91PS_AIC;

/* -------- AIC_SMR : (AIC Offset: 0x0) Control Register --------  */
#define AT91C_AIC_PRIOR       ((unsigned int) 0x7 <<  0) /* (AIC) Priority Level */
#define 	AT91C_AIC_PRIOR_LOWEST               ((unsigned int) 0x0) /* (AIC) Lowest priority level */
#define 	AT91C_AIC_PRIOR_HIGHEST              ((unsigned int) 0x7) /* (AIC) Highest priority level */
#define AT91C_AIC_SRCTYPE     ((unsigned int) 0x3 <<  5) /* (AIC) Interrupt Source Type */
#define 	AT91C_AIC_SRCTYPE_INT_LEVEL_SENSITIVE  ((unsigned int) 0x0 <<  5) /* (AIC) Internal Sources Code Label Level Sensitive */
#define 	AT91C_AIC_SRCTYPE_INT_EDGE_TRIGGERED   ((unsigned int) 0x1 <<  5) /* (AIC) Internal Sources Code Label Edge triggered */
#define 	AT91C_AIC_SRCTYPE_EXT_HIGH_LEVEL       ((unsigned int) 0x2 <<  5) /* (AIC) External Sources Code Label High-level Sensitive */
#define 	AT91C_AIC_SRCTYPE_EXT_POSITIVE_EDGE    ((unsigned int) 0x3 <<  5) /* (AIC) External Sources Code Label Positive Edge triggered */
/* -------- AIC_CISR : (AIC Offset: 0x114) AIC Core Interrupt Status Register --------  */
#define AT91C_AIC_NFIQ        ((unsigned int) 0x1 <<  0) /* (AIC) NFIQ Status */
#define AT91C_AIC_NIRQ        ((unsigned int) 0x1 <<  1) /* (AIC) NIRQ Status */
/* -------- AIC_DCR : (AIC Offset: 0x138) AIC Debug Control Register (Protect) --------  */
#define AT91C_AIC_DCR_PROT    ((unsigned int) 0x1 <<  0) /* (AIC) Protection Mode */
#define AT91C_AIC_DCR_GMSK    ((unsigned int) 0x1 <<  1) /* (AIC) General Mask */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Parallel Input Output Controler */
/* ***************************************************************************** */
typedef struct _AT91S_PIO {
	AT91_REG	 PIO_PER; 	/* PIO Enable Register */
	AT91_REG	 PIO_PDR; 	/* PIO Disable Register */
	AT91_REG	 PIO_PSR; 	/* PIO Status Register */
	AT91_REG	 Reserved0[1]; 	/*  */
	AT91_REG	 PIO_OER; 	/* Output Enable Register */
	AT91_REG	 PIO_ODR; 	/* Output Disable Registerr */
	AT91_REG	 PIO_OSR; 	/* Output Status Register */
	AT91_REG	 Reserved1[1]; 	/*  */
	AT91_REG	 PIO_IFER; 	/* Input Filter Enable Register */
	AT91_REG	 PIO_IFDR; 	/* Input Filter Disable Register */
	AT91_REG	 PIO_IFSR; 	/* Input Filter Status Register */
	AT91_REG	 Reserved2[1]; 	/*  */
	AT91_REG	 PIO_SODR; 	/* Set Output Data Register */
	AT91_REG	 PIO_CODR; 	/* Clear Output Data Register */
	AT91_REG	 PIO_ODSR; 	/* Output Data Status Register */
	AT91_REG	 PIO_PDSR; 	/* Pin Data Status Register */
	AT91_REG	 PIO_IER; 	/* Interrupt Enable Register */
	AT91_REG	 PIO_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 PIO_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 PIO_ISR; 	/* Interrupt Status Register */
	AT91_REG	 PIO_MDER; 	/* Multi-driver Enable Register */
	AT91_REG	 PIO_MDDR; 	/* Multi-driver Disable Register */
	AT91_REG	 PIO_MDSR; 	/* Multi-driver Status Register */
	AT91_REG	 Reserved3[1]; 	/*  */
	AT91_REG	 PIO_PPUDR; 	/* Pull-up Disable Register */
	AT91_REG	 PIO_PPUER; 	/* Pull-up Enable Register */
	AT91_REG	 PIO_PPUSR; 	/* Pull-up Status Register */
	AT91_REG	 Reserved4[1]; 	/*  */
	AT91_REG	 PIO_ASR; 	/* Select A Register */
	AT91_REG	 PIO_BSR; 	/* Select B Register */
	AT91_REG	 PIO_ABSR; 	/* AB Select Status Register */
	AT91_REG	 Reserved5[9]; 	/*  */
	AT91_REG	 PIO_OWER; 	/* Output Write Enable Register */
	AT91_REG	 PIO_OWDR; 	/* Output Write Disable Register */
	AT91_REG	 PIO_OWSR; 	/* Output Write Status Register */
} AT91S_PIO, *AT91PS_PIO;


/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Clock Generator Controler */
/* ***************************************************************************** */
typedef struct _AT91S_CKGR {
	AT91_REG	 CKGR_MOR; 	/* Main Oscillator Register */
	AT91_REG	 CKGR_MCFR; 	/* Main Clock  Frequency Register */
	AT91_REG	 CKGR_PLLAR; 	/* PLL A Register */
	AT91_REG	 CKGR_PLLBR; 	/* PLL B Register */
} AT91S_CKGR, *AT91PS_CKGR;

/* -------- CKGR_MOR : (CKGR Offset: 0x0) Main Oscillator Register --------  */
#define AT91C_CKGR_MOSCEN     ((unsigned int) 0x1 <<  0) /* (CKGR) Main Oscillator Enable */
#define AT91C_CKGR_OSCBYPASS  ((unsigned int) 0x1 <<  1) /* (CKGR) Main Oscillator Bypass */
#define AT91C_CKGR_OSCOUNT    ((unsigned int) 0xFF <<  8) /* (CKGR) Main Oscillator Start-up Time */
/* -------- CKGR_MCFR : (CKGR Offset: 0x4) Main Clock Frequency Register --------  */
#define AT91C_CKGR_MAINF      ((unsigned int) 0xFFFF <<  0) /* (CKGR) Main Clock Frequency */
#define AT91C_CKGR_MAINRDY    ((unsigned int) 0x1 << 16) /* (CKGR) Main Clock Ready */
/* -------- CKGR_PLLAR : (CKGR Offset: 0x8) PLL A Register --------  */
#define AT91C_CKGR_DIVA       ((unsigned int) 0xFF <<  0) /* (CKGR) Divider A Selected */
#define 	AT91C_CKGR_DIVA_0                    ((unsigned int) 0x0) /* (CKGR) Divider A output is 0 */
#define 	AT91C_CKGR_DIVA_BYPASS               ((unsigned int) 0x1) /* (CKGR) Divider A is bypassed */
#define AT91C_CKGR_PLLACOUNT  ((unsigned int) 0x3F <<  8) /* (CKGR) PLL A Counter */
#define AT91C_CKGR_OUTA       ((unsigned int) 0x3 << 14) /* (CKGR) PLL A Output Frequency Range */
#define 	AT91C_CKGR_OUTA_0                    ((unsigned int) 0x0 << 14) /* (CKGR) Please refer to the PLLA datasheet */
#define 	AT91C_CKGR_OUTA_1                    ((unsigned int) 0x1 << 14) /* (CKGR) Please refer to the PLLA datasheet */
#define 	AT91C_CKGR_OUTA_2                    ((unsigned int) 0x2 << 14) /* (CKGR) Please refer to the PLLA datasheet */
#define 	AT91C_CKGR_OUTA_3                    ((unsigned int) 0x3 << 14) /* (CKGR) Please refer to the PLLA datasheet */
#define AT91C_CKGR_MULA       ((unsigned int) 0x7FF << 16) /* (CKGR) PLL A Multiplier */
#define AT91C_CKGR_SRCA       ((unsigned int) 0x1 << 29) /* (CKGR)  */
/* -------- CKGR_PLLBR : (CKGR Offset: 0xc) PLL B Register --------  */
#define AT91C_CKGR_DIVB       ((unsigned int) 0xFF <<  0) /* (CKGR) Divider B Selected */
#define 	AT91C_CKGR_DIVB_0                    ((unsigned int) 0x0) /* (CKGR) Divider B output is 0 */
#define 	AT91C_CKGR_DIVB_BYPASS               ((unsigned int) 0x1) /* (CKGR) Divider B is bypassed */
#define AT91C_CKGR_PLLBCOUNT  ((unsigned int) 0x3F <<  8) /* (CKGR) PLL B Counter */
#define AT91C_CKGR_OUTB       ((unsigned int) 0x3 << 14) /* (CKGR) PLL B Output Frequency Range */
#define 	AT91C_CKGR_OUTB_0                    ((unsigned int) 0x0 << 14) /* (CKGR) Please refer to the PLLB datasheet */
#define 	AT91C_CKGR_OUTB_1                    ((unsigned int) 0x1 << 14) /* (CKGR) Please refer to the PLLB datasheet */
#define 	AT91C_CKGR_OUTB_2                    ((unsigned int) 0x2 << 14) /* (CKGR) Please refer to the PLLB datasheet */
#define 	AT91C_CKGR_OUTB_3                    ((unsigned int) 0x3 << 14) /* (CKGR) Please refer to the PLLB datasheet */
#define AT91C_CKGR_MULB       ((unsigned int) 0x7FF << 16) /* (CKGR) PLL B Multiplier */
#define AT91C_CKGR_USBDIV     ((unsigned int) 0x3 << 28) /* (CKGR) Divider for USB Clocks */
#define 	AT91C_CKGR_USBDIV_0                    ((unsigned int) 0x0 << 28) /* (CKGR) Divider output is PLL clock output */
#define 	AT91C_CKGR_USBDIV_1                    ((unsigned int) 0x1 << 28) /* (CKGR) Divider output is PLL clock output divided by 2 */
#define 	AT91C_CKGR_USBDIV_2                    ((unsigned int) 0x2 << 28) /* (CKGR) Divider output is PLL clock output divided by 4 */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Power Management Controler */
/* ***************************************************************************** */
typedef struct _AT91S_PMC {
	AT91_REG	 PMC_SCER; 	/* System Clock Enable Register */
	AT91_REG	 PMC_SCDR; 	/* System Clock Disable Register */
	AT91_REG	 PMC_SCSR; 	/* System Clock Status Register */
	AT91_REG	 Reserved0[1]; 	/*  */
	AT91_REG	 PMC_PCER; 	/* Peripheral Clock Enable Register */
	AT91_REG	 PMC_PCDR; 	/* Peripheral Clock Disable Register */
	AT91_REG	 PMC_PCSR; 	/* Peripheral Clock Status Register */
	AT91_REG	 Reserved1[1]; 	/*  */
	AT91_REG	 PMC_MOR; 	/* Main Oscillator Register */
	AT91_REG	 PMC_MCFR; 	/* Main Clock  Frequency Register */
	AT91_REG	 PMC_PLLAR; 	/* PLL A Register */
	AT91_REG	 PMC_PLLBR; 	/* PLL B Register */
	AT91_REG	 PMC_MCKR; 	/* Master Clock Register */
	AT91_REG	 Reserved2[3]; 	/*  */
	AT91_REG	 PMC_PCKR[8]; 	/* Programmable Clock Register */
	AT91_REG	 PMC_IER; 	/* Interrupt Enable Register */
	AT91_REG	 PMC_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 PMC_SR; 	/* Status Register */
	AT91_REG	 PMC_IMR; 	/* Interrupt Mask Register */
} AT91S_PMC, *AT91PS_PMC;

/* -------- PMC_SCER : (PMC Offset: 0x0) System Clock Enable Register --------  */
#define AT91C_PMC_PCK         ((unsigned int) 0x1 <<  0) /* (PMC) Processor Clock */
#define AT91C_PMC_UHP         ((unsigned int) 0x1 <<  6) /* (PMC) USB Host Port Clock */
#define AT91C_PMC_UDP         ((unsigned int) 0x1 <<  7) /* (PMC) USB Device Port Clock */
#define AT91C_PMC_PCK0        ((unsigned int) 0x1 <<  8) /* (PMC) Programmable Clock Output */
#define AT91C_PMC_PCK1        ((unsigned int) 0x1 <<  9) /* (PMC) Programmable Clock Output */
#define AT91C_PMC_HCK0        ((unsigned int) 0x1 << 16) /* (PMC) AHB UHP Clock Output */
#define AT91C_PMC_HCK1        ((unsigned int) 0x1 << 17) /* (PMC) AHB LCDC Clock Output */
/* -------- PMC_SCDR : (PMC Offset: 0x4) System Clock Disable Register --------  */
/* -------- PMC_SCSR : (PMC Offset: 0x8) System Clock Status Register --------  */
/* -------- CKGR_MOR : (PMC Offset: 0x20) Main Oscillator Register --------  */
/* -------- CKGR_MCFR : (PMC Offset: 0x24) Main Clock Frequency Register --------  */
/* -------- CKGR_PLLAR : (PMC Offset: 0x28) PLL A Register --------  */
/* -------- CKGR_PLLBR : (PMC Offset: 0x2c) PLL B Register --------  */
/* -------- PMC_MCKR : (PMC Offset: 0x30) Master Clock Register --------  */
#define AT91C_PMC_CSS         ((unsigned int) 0x3 <<  0) /* (PMC) Programmable Clock Selection */
#define 	AT91C_PMC_CSS_SLOW_CLK             ((unsigned int) 0x0) /* (PMC) Slow Clock is selected */
#define 	AT91C_PMC_CSS_MAIN_CLK             ((unsigned int) 0x1) /* (PMC) Main Clock is selected */
#define 	AT91C_PMC_CSS_PLLA_CLK             ((unsigned int) 0x2) /* (PMC) Clock from PLL A is selected */
#define 	AT91C_PMC_CSS_PLLB_CLK             ((unsigned int) 0x3) /* (PMC) Clock from PLL B is selected */
#define AT91C_PMC_PRES        ((unsigned int) 0x7 <<  2) /* (PMC) Programmable Clock Prescaler */
#define 	AT91C_PMC_PRES_CLK                  ((unsigned int) 0x0 <<  2) /* (PMC) Selected clock */
#define 	AT91C_PMC_PRES_CLK_2                ((unsigned int) 0x1 <<  2) /* (PMC) Selected clock divided by 2 */
#define 	AT91C_PMC_PRES_CLK_4                ((unsigned int) 0x2 <<  2) /* (PMC) Selected clock divided by 4 */
#define 	AT91C_PMC_PRES_CLK_8                ((unsigned int) 0x3 <<  2) /* (PMC) Selected clock divided by 8 */
#define 	AT91C_PMC_PRES_CLK_16               ((unsigned int) 0x4 <<  2) /* (PMC) Selected clock divided by 16 */
#define 	AT91C_PMC_PRES_CLK_32               ((unsigned int) 0x5 <<  2) /* (PMC) Selected clock divided by 32 */
#define 	AT91C_PMC_PRES_CLK_64               ((unsigned int) 0x6 <<  2) /* (PMC) Selected clock divided by 64 */
#define AT91C_PMC_MDIV        ((unsigned int) 0x3 <<  8) /* (PMC) Master Clock Division */
#define 	AT91C_PMC_MDIV_1                    ((unsigned int) 0x0 <<  8) /* (PMC) The master clock and the processor clock are the same */
#define 	AT91C_PMC_MDIV_2                    ((unsigned int) 0x1 <<  8) /* (PMC) The processor clock is twice as fast as the master clock */
#define 	AT91C_PMC_MDIV_3                    ((unsigned int) 0x2 <<  8) /* (PMC) The processor clock is four times faster than the master clock */
/* -------- PMC_PCKR : (PMC Offset: 0x40) Programmable Clock Register --------  */
/* -------- PMC_IER : (PMC Offset: 0x60) PMC Interrupt Enable Register --------  */
#define AT91C_PMC_MOSCS       ((unsigned int) 0x1 <<  0) /* (PMC) MOSC Status/Enable/Disable/Mask */
#define AT91C_PMC_LOCKA       ((unsigned int) 0x1 <<  1) /* (PMC) PLL A Status/Enable/Disable/Mask */
#define AT91C_PMC_LOCKB       ((unsigned int) 0x1 <<  2) /* (PMC) PLL B Status/Enable/Disable/Mask */
#define AT91C_PMC_MCKRDY      ((unsigned int) 0x1 <<  3) /* (PMC) Master Clock Status/Enable/Disable/Mask */
#define AT91C_PMC_PCK0RDY     ((unsigned int) 0x1 <<  8) /* (PMC) PCK0_RDY Status/Enable/Disable/Mask */
#define AT91C_PMC_PCK1RDY     ((unsigned int) 0x1 <<  9) /* (PMC) PCK1_RDY Status/Enable/Disable/Mask */
/* -------- PMC_IDR : (PMC Offset: 0x64) PMC Interrupt Disable Register --------  */
/* -------- PMC_SR : (PMC Offset: 0x68) PMC Status Register --------  */
#define AT91C_PMC_OSCSEL      ((unsigned int) 0x1 <<  7) /* (PMC) 32kHz Oscillator selection status */
/* -------- PMC_IMR : (PMC Offset: 0x6c) PMC Interrupt Mask Register --------  */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Reset Controller Interface */
/* ***************************************************************************** */
typedef struct _AT91S_RSTC {
	AT91_REG	 RSTC_RCR; 	/* Reset Control Register */
	AT91_REG	 RSTC_RSR; 	/* Reset Status Register */
	AT91_REG	 RSTC_RMR; 	/* Reset Mode Register */
} AT91S_RSTC, *AT91PS_RSTC;

/* -------- RSTC_RCR : (RSTC Offset: 0x0) Reset Control Register --------  */
#define AT91C_RSTC_PROCRST    ((unsigned int) 0x1 <<  0) /* (RSTC) Processor Reset */
#define AT91C_RSTC_ICERST     ((unsigned int) 0x1 <<  1) /* (RSTC) ICE Interface Reset */
#define AT91C_RSTC_PERRST     ((unsigned int) 0x1 <<  2) /* (RSTC) Peripheral Reset */
#define AT91C_RSTC_EXTRST     ((unsigned int) 0x1 <<  3) /* (RSTC) External Reset */
#define AT91C_RSTC_KEY        ((unsigned int) 0xFF << 24) /* (RSTC) Password */
/* -------- RSTC_RSR : (RSTC Offset: 0x4) Reset Status Register --------  */
#define AT91C_RSTC_URSTS      ((unsigned int) 0x1 <<  0) /* (RSTC) User Reset Status */
#define AT91C_RSTC_RSTTYP     ((unsigned int) 0x7 <<  8) /* (RSTC) Reset Type */
#define 	AT91C_RSTC_RSTTYP_GENERAL              ((unsigned int) 0x0 <<  8) /* (RSTC) General reset. Both VDDCORE and VDDBU rising. */
#define 	AT91C_RSTC_RSTTYP_WAKEUP               ((unsigned int) 0x1 <<  8) /* (RSTC) WakeUp Reset. VDDCORE rising. */
#define 	AT91C_RSTC_RSTTYP_WATCHDOG             ((unsigned int) 0x2 <<  8) /* (RSTC) Watchdog Reset. Watchdog overflow occured. */
#define 	AT91C_RSTC_RSTTYP_SOFTWARE             ((unsigned int) 0x3 <<  8) /* (RSTC) Software Reset. Processor reset required by the software. */
#define 	AT91C_RSTC_RSTTYP_USER                 ((unsigned int) 0x4 <<  8) /* (RSTC) User Reset. NRST pin detected low. */
#define AT91C_RSTC_NRSTL      ((unsigned int) 0x1 << 16) /* (RSTC) NRST pin level */
#define AT91C_RSTC_SRCMP      ((unsigned int) 0x1 << 17) /* (RSTC) Software Reset Command in Progress. */
/* -------- RSTC_RMR : (RSTC Offset: 0x8) Reset Mode Register --------  */
#define AT91C_RSTC_URSTEN     ((unsigned int) 0x1 <<  0) /* (RSTC) User Reset Enable */
#define AT91C_RSTC_URSTIEN    ((unsigned int) 0x1 <<  4) /* (RSTC) User Reset Interrupt Enable */
#define AT91C_RSTC_ERSTL      ((unsigned int) 0xF <<  8) /* (RSTC) User Reset Enable */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Shut Down Controller Interface */
/* ***************************************************************************** */
typedef struct _AT91S_SHDWC {
	AT91_REG	 SHDWC_SHCR; 	/* Shut Down Control Register */
	AT91_REG	 SHDWC_SHMR; 	/* Shut Down Mode Register */
	AT91_REG	 SHDWC_SHSR; 	/* Shut Down Status Register */
} AT91S_SHDWC, *AT91PS_SHDWC;

/* -------- SHDWC_SHCR : (SHDWC Offset: 0x0) Shut Down Control Register --------  */
#define AT91C_SHDWC_SHDW      ((unsigned int) 0x1 <<  0) /* (SHDWC) Processor Reset */
#define AT91C_SHDWC_KEY       ((unsigned int) 0xFF << 24) /* (SHDWC) Shut down KEY Password */
/* -------- SHDWC_SHMR : (SHDWC Offset: 0x4) Shut Down Mode Register --------  */
#define AT91C_SHDWC_WKMODE0   ((unsigned int) 0x3 <<  0) /* (SHDWC) Wake Up 0 Mode Selection */
#define 	AT91C_SHDWC_WKMODE0_NONE                 ((unsigned int) 0x0) /* (SHDWC) None. No detection is performed on the wake up input. */
#define 	AT91C_SHDWC_WKMODE0_HIGH                 ((unsigned int) 0x1) /* (SHDWC) High Level. */
#define 	AT91C_SHDWC_WKMODE0_LOW                  ((unsigned int) 0x2) /* (SHDWC) Low Level. */
#define 	AT91C_SHDWC_WKMODE0_ANYLEVEL             ((unsigned int) 0x3) /* (SHDWC) Any level change. */
#define AT91C_SHDWC_CPTWK0    ((unsigned int) 0xF <<  4) /* (SHDWC) Counter On Wake Up 0 */
#define AT91C_SHDWC_WKMODE1   ((unsigned int) 0x3 <<  8) /* (SHDWC) Wake Up 1 Mode Selection */
#define 	AT91C_SHDWC_WKMODE1_NONE                 ((unsigned int) 0x0 <<  8) /* (SHDWC) None. No detection is performed on the wake up input. */
#define 	AT91C_SHDWC_WKMODE1_HIGH                 ((unsigned int) 0x1 <<  8) /* (SHDWC) High Level. */
#define 	AT91C_SHDWC_WKMODE1_LOW                  ((unsigned int) 0x2 <<  8) /* (SHDWC) Low Level. */
#define 	AT91C_SHDWC_WKMODE1_ANYLEVEL             ((unsigned int) 0x3 <<  8) /* (SHDWC) Any level change. */
#define AT91C_SHDWC_CPTWK1    ((unsigned int) 0xF << 12) /* (SHDWC) Counter On Wake Up 1 */
#define AT91C_SHDWC_RTTWKEN   ((unsigned int) 0x1 << 16) /* (SHDWC) Real Time Timer Wake Up Enable */
#define AT91C_SHDWC_RTCWKEN   ((unsigned int) 0x1 << 17) /* (SHDWC) Real Time Clock Wake Up Enable */
/* -------- SHDWC_SHSR : (SHDWC Offset: 0x8) Shut Down Status Register --------  */
#define AT91C_SHDWC_WAKEUP0   ((unsigned int) 0x1 <<  0) /* (SHDWC) Wake Up 0 Status */
#define AT91C_SHDWC_WAKEUP1   ((unsigned int) 0x1 <<  1) /* (SHDWC) Wake Up 1 Status */
#define AT91C_SHDWC_FWKUP     ((unsigned int) 0x1 <<  2) /* (SHDWC) Force Wake Up Status */
#define AT91C_SHDWC_RTTWK     ((unsigned int) 0x1 << 16) /* (SHDWC) Real Time Timer wake Up */
#define AT91C_SHDWC_RTCWK     ((unsigned int) 0x1 << 17) /* (SHDWC) Real Time Clock wake Up */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Real Time Timer Controller Interface */
/* ***************************************************************************** */
typedef struct _AT91S_RTTC {
	AT91_REG	 RTTC_RTMR; 	/* Real-time Mode Register */
	AT91_REG	 RTTC_RTAR; 	/* Real-time Alarm Register */
	AT91_REG	 RTTC_RTVR; 	/* Real-time Value Register */
	AT91_REG	 RTTC_RTSR; 	/* Real-time Status Register */
} AT91S_RTTC, *AT91PS_RTTC;

/* -------- RTTC_RTMR : (RTTC Offset: 0x0) Real-time Mode Register --------  */
#define AT91C_RTTC_RTPRES     ((unsigned int) 0xFFFF <<  0) /* (RTTC) Real-time Timer Prescaler Value */
#define AT91C_RTTC_ALMIEN     ((unsigned int) 0x1 << 16) /* (RTTC) Alarm Interrupt Enable */
#define AT91C_RTTC_RTTINCIEN  ((unsigned int) 0x1 << 17) /* (RTTC) Real Time Timer Increment Interrupt Enable */
#define AT91C_RTTC_RTTRST     ((unsigned int) 0x1 << 18) /* (RTTC) Real Time Timer Restart */
/* -------- RTTC_RTAR : (RTTC Offset: 0x4) Real-time Alarm Register --------  */
#define AT91C_RTTC_ALMV       ((unsigned int) 0x0 <<  0) /* (RTTC) Alarm Value */
/* -------- RTTC_RTVR : (RTTC Offset: 0x8) Current Real-time Value Register --------  */
#define AT91C_RTTC_CRTV       ((unsigned int) 0x0 <<  0) /* (RTTC) Current Real-time Value */
/* -------- RTTC_RTSR : (RTTC Offset: 0xc) Real-time Status Register --------  */
#define AT91C_RTTC_ALMS       ((unsigned int) 0x1 <<  0) /* (RTTC) Real-time Alarm Status */
#define AT91C_RTTC_RTTINC     ((unsigned int) 0x1 <<  1) /* (RTTC) Real-time Timer Increment */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Periodic Interval Timer Controller Interface */
/* ***************************************************************************** */
typedef struct _AT91S_PITC {
	AT91_REG	 PITC_PIMR; 	/* Period Interval Mode Register */
	AT91_REG	 PITC_PISR; 	/* Period Interval Status Register */
	AT91_REG	 PITC_PIVR; 	/* Period Interval Value Register */
	AT91_REG	 PITC_PIIR; 	/* Period Interval Image Register */
} AT91S_PITC, *AT91PS_PITC;

/* -------- PITC_PIMR : (PITC Offset: 0x0) Periodic Interval Mode Register --------  */
#define AT91C_PITC_PIV        ((unsigned int) 0xFFFFF <<  0) /* (PITC) Periodic Interval Value */
#define AT91C_PITC_PITEN      ((unsigned int) 0x1 << 24) /* (PITC) Periodic Interval Timer Enabled */
#define AT91C_PITC_PITIEN     ((unsigned int) 0x1 << 25) /* (PITC) Periodic Interval Timer Interrupt Enable */
/* -------- PITC_PISR : (PITC Offset: 0x4) Periodic Interval Status Register --------  */
#define AT91C_PITC_PITS       ((unsigned int) 0x1 <<  0) /* (PITC) Periodic Interval Timer Status */
/* -------- PITC_PIVR : (PITC Offset: 0x8) Periodic Interval Value Register --------  */
#define AT91C_PITC_CPIV       ((unsigned int) 0xFFFFF <<  0) /* (PITC) Current Periodic Interval Value */
#define AT91C_PITC_PICNT      ((unsigned int) 0xFFF << 20) /* (PITC) Periodic Interval Counter */
/* -------- PITC_PIIR : (PITC Offset: 0xc) Periodic Interval Image Register --------  */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Watchdog Timer Controller Interface */
/* ***************************************************************************** */
typedef struct _AT91S_WDTC {
	AT91_REG	 WDTC_WDCR; 	/* Watchdog Control Register */
	AT91_REG	 WDTC_WDMR; 	/* Watchdog Mode Register */
	AT91_REG	 WDTC_WDSR; 	/* Watchdog Status Register */
} AT91S_WDTC, *AT91PS_WDTC;

/* -------- WDTC_WDCR : (WDTC Offset: 0x0) Periodic Interval Image Register --------  */
#define AT91C_WDTC_WDRSTT     ((unsigned int) 0x1 <<  0) /* (WDTC) Watchdog Restart */
#define AT91C_WDTC_KEY        ((unsigned int) 0xA5 << 24) /* (WDTC) Watchdog KEY Password */
/* -------- WDTC_WDMR : (WDTC Offset: 0x4) Watchdog Mode Register --------  */
#define AT91C_WDTC_WDV        ((unsigned int) 0xFFF <<  0) /* (WDTC) Watchdog Timer Restart */
#define AT91C_WDTC_WDFIEN     ((unsigned int) 0x1 << 12) /* (WDTC) Watchdog Fault Interrupt Enable */
#define AT91C_WDTC_WDRSTEN    ((unsigned int) 0x1 << 13) /* (WDTC) Watchdog Reset Enable */
#define AT91C_WDTC_WDRPROC    ((unsigned int) 0x1 << 14) /* (WDTC) Watchdog Timer Restart */
#define AT91C_WDTC_WDDIS      ((unsigned int) 0x1 << 15) /* (WDTC) Watchdog Disable */
#define AT91C_WDTC_WDD        ((unsigned int) 0xFFF << 16) /* (WDTC) Watchdog Delta Value */
#define AT91C_WDTC_WDDBGHLT   ((unsigned int) 0x1 << 28) /* (WDTC) Watchdog Debug Halt */
#define AT91C_WDTC_WDIDLEHLT  ((unsigned int) 0x1 << 29) /* (WDTC) Watchdog Idle Halt */
/* -------- WDTC_WDSR : (WDTC Offset: 0x8) Watchdog Status Register --------  */
#define AT91C_WDTC_WDUNF      ((unsigned int) 0x1 <<  0) /* (WDTC) Watchdog Underflow */
#define AT91C_WDTC_WDERR      ((unsigned int) 0x1 <<  1) /* (WDTC) Watchdog Error */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Timer Counter Channel Interface */
/* ***************************************************************************** */
typedef struct _AT91S_TC {
	AT91_REG	 TC_CCR; 	/* Channel Control Register */
	AT91_REG	 TC_CMR; 	/* Channel Mode Register (Capture Mode / Waveform Mode) */
	AT91_REG	 Reserved0[2]; 	/*  */
	AT91_REG	 TC_CV; 	/* Counter Value */
	AT91_REG	 TC_RA; 	/* Register A */
	AT91_REG	 TC_RB; 	/* Register B */
	AT91_REG	 TC_RC; 	/* Register C */
	AT91_REG	 TC_SR; 	/* Status Register */
	AT91_REG	 TC_IER; 	/* Interrupt Enable Register */
	AT91_REG	 TC_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 TC_IMR; 	/* Interrupt Mask Register */
} AT91S_TC, *AT91PS_TC;

/* -------- TC_CCR : (TC Offset: 0x0) TC Channel Control Register --------  */
#define AT91C_TC_CLKEN        ((unsigned int) 0x1 <<  0) /* (TC) Counter Clock Enable Command */
#define AT91C_TC_CLKDIS       ((unsigned int) 0x1 <<  1) /* (TC) Counter Clock Disable Command */
#define AT91C_TC_SWTRG        ((unsigned int) 0x1 <<  2) /* (TC) Software Trigger Command */
/* -------- TC_CMR : (TC Offset: 0x4) TC Channel Mode Register: Capture Mode / Waveform Mode --------  */
#define AT91C_TC_CLKS         ((unsigned int) 0x7 <<  0) /* (TC) Clock Selection */
#define 	AT91C_TC_CLKS_TIMER_DIV1_CLOCK     ((unsigned int) 0x0) /* (TC) Clock selected: TIMER_DIV1_CLOCK */
#define 	AT91C_TC_CLKS_TIMER_DIV2_CLOCK     ((unsigned int) 0x1) /* (TC) Clock selected: TIMER_DIV2_CLOCK */
#define 	AT91C_TC_CLKS_TIMER_DIV3_CLOCK     ((unsigned int) 0x2) /* (TC) Clock selected: TIMER_DIV3_CLOCK */
#define 	AT91C_TC_CLKS_TIMER_DIV4_CLOCK     ((unsigned int) 0x3) /* (TC) Clock selected: TIMER_DIV4_CLOCK */
#define 	AT91C_TC_CLKS_TIMER_DIV5_CLOCK     ((unsigned int) 0x4) /* (TC) Clock selected: TIMER_DIV5_CLOCK */
#define 	AT91C_TC_CLKS_XC0                  ((unsigned int) 0x5) /* (TC) Clock selected: XC0 */
#define 	AT91C_TC_CLKS_XC1                  ((unsigned int) 0x6) /* (TC) Clock selected: XC1 */
#define 	AT91C_TC_CLKS_XC2                  ((unsigned int) 0x7) /* (TC) Clock selected: XC2 */
#define AT91C_TC_CLKI         ((unsigned int) 0x1 <<  3) /* (TC) Clock Invert */
#define AT91C_TC_BURST        ((unsigned int) 0x3 <<  4) /* (TC) Burst Signal Selection */
#define 	AT91C_TC_BURST_NONE                 ((unsigned int) 0x0 <<  4) /* (TC) The clock is not gated by an external signal */
#define 	AT91C_TC_BURST_XC0                  ((unsigned int) 0x1 <<  4) /* (TC) XC0 is ANDed with the selected clock */
#define 	AT91C_TC_BURST_XC1                  ((unsigned int) 0x2 <<  4) /* (TC) XC1 is ANDed with the selected clock */
#define 	AT91C_TC_BURST_XC2                  ((unsigned int) 0x3 <<  4) /* (TC) XC2 is ANDed with the selected clock */
#define AT91C_TC_CPCSTOP      ((unsigned int) 0x1 <<  6) /* (TC) Counter Clock Stopped with RC Compare */
#define AT91C_TC_LDBSTOP      ((unsigned int) 0x1 <<  6) /* (TC) Counter Clock Stopped with RB Loading */
#define AT91C_TC_LDBDIS       ((unsigned int) 0x1 <<  7) /* (TC) Counter Clock Disabled with RB Loading */
#define AT91C_TC_CPCDIS       ((unsigned int) 0x1 <<  7) /* (TC) Counter Clock Disable with RC Compare */
#define AT91C_TC_ETRGEDG      ((unsigned int) 0x3 <<  8) /* (TC) External Trigger Edge Selection */
#define 	AT91C_TC_ETRGEDG_NONE                 ((unsigned int) 0x0 <<  8) /* (TC) Edge: None */
#define 	AT91C_TC_ETRGEDG_RISING               ((unsigned int) 0x1 <<  8) /* (TC) Edge: rising edge */
#define 	AT91C_TC_ETRGEDG_FALLING              ((unsigned int) 0x2 <<  8) /* (TC) Edge: falling edge */
#define 	AT91C_TC_ETRGEDG_BOTH                 ((unsigned int) 0x3 <<  8) /* (TC) Edge: each edge */
#define AT91C_TC_EEVTEDG      ((unsigned int) 0x3 <<  8) /* (TC) External Event Edge Selection */
#define 	AT91C_TC_EEVTEDG_NONE                 ((unsigned int) 0x0 <<  8) /* (TC) Edge: None */
#define 	AT91C_TC_EEVTEDG_RISING               ((unsigned int) 0x1 <<  8) /* (TC) Edge: rising edge */
#define 	AT91C_TC_EEVTEDG_FALLING              ((unsigned int) 0x2 <<  8) /* (TC) Edge: falling edge */
#define 	AT91C_TC_EEVTEDG_BOTH                 ((unsigned int) 0x3 <<  8) /* (TC) Edge: each edge */
#define AT91C_TC_ABETRG       ((unsigned int) 0x1 << 10) /* (TC) TIOA or TIOB External Trigger Selection */
#define AT91C_TC_EEVT         ((unsigned int) 0x3 << 10) /* (TC) External Event  Selection */
#define 	AT91C_TC_EEVT_TIOB                 ((unsigned int) 0x0 << 10) /* (TC) Signal selected as external event: TIOB TIOB direction: input */
#define 	AT91C_TC_EEVT_XC0                  ((unsigned int) 0x1 << 10) /* (TC) Signal selected as external event: XC0 TIOB direction: output */
#define 	AT91C_TC_EEVT_XC1                  ((unsigned int) 0x2 << 10) /* (TC) Signal selected as external event: XC1 TIOB direction: output */
#define 	AT91C_TC_EEVT_XC2                  ((unsigned int) 0x3 << 10) /* (TC) Signal selected as external event: XC2 TIOB direction: output */
#define AT91C_TC_ENETRG       ((unsigned int) 0x1 << 12) /* (TC) External Event Trigger enable */
#define AT91C_TC_WAVESEL      ((unsigned int) 0x3 << 13) /* (TC) Waveform  Selection */
#define 	AT91C_TC_WAVESEL_UP                   ((unsigned int) 0x0 << 13) /* (TC) UP mode without atomatic trigger on RC Compare */
#define 	AT91C_TC_WAVESEL_UPDOWN               ((unsigned int) 0x1 << 13) /* (TC) UPDOWN mode without automatic trigger on RC Compare */
#define 	AT91C_TC_WAVESEL_UP_AUTO              ((unsigned int) 0x2 << 13) /* (TC) UP mode with automatic trigger on RC Compare */
#define 	AT91C_TC_WAVESEL_UPDOWN_AUTO          ((unsigned int) 0x3 << 13) /* (TC) UPDOWN mode with automatic trigger on RC Compare */
#define AT91C_TC_CPCTRG       ((unsigned int) 0x1 << 14) /* (TC) RC Compare Trigger Enable */
#define AT91C_TC_WAVE         ((unsigned int) 0x1 << 15) /* (TC)  */
#define AT91C_TC_LDRA         ((unsigned int) 0x3 << 16) /* (TC) RA Loading Selection */
#define 	AT91C_TC_LDRA_NONE                 ((unsigned int) 0x0 << 16) /* (TC) Edge: None */
#define 	AT91C_TC_LDRA_RISING               ((unsigned int) 0x1 << 16) /* (TC) Edge: rising edge of TIOA */
#define 	AT91C_TC_LDRA_FALLING              ((unsigned int) 0x2 << 16) /* (TC) Edge: falling edge of TIOA */
#define 	AT91C_TC_LDRA_BOTH                 ((unsigned int) 0x3 << 16) /* (TC) Edge: each edge of TIOA */
#define AT91C_TC_ACPA         ((unsigned int) 0x3 << 16) /* (TC) RA Compare Effect on TIOA */
#define 	AT91C_TC_ACPA_NONE                 ((unsigned int) 0x0 << 16) /* (TC) Effect: none */
#define 	AT91C_TC_ACPA_SET                  ((unsigned int) 0x1 << 16) /* (TC) Effect: set */
#define 	AT91C_TC_ACPA_CLEAR                ((unsigned int) 0x2 << 16) /* (TC) Effect: clear */
#define 	AT91C_TC_ACPA_TOGGLE               ((unsigned int) 0x3 << 16) /* (TC) Effect: toggle */
#define AT91C_TC_LDRB         ((unsigned int) 0x3 << 18) /* (TC) RB Loading Selection */
#define 	AT91C_TC_LDRB_NONE                 ((unsigned int) 0x0 << 18) /* (TC) Edge: None */
#define 	AT91C_TC_LDRB_RISING               ((unsigned int) 0x1 << 18) /* (TC) Edge: rising edge of TIOA */
#define 	AT91C_TC_LDRB_FALLING              ((unsigned int) 0x2 << 18) /* (TC) Edge: falling edge of TIOA */
#define 	AT91C_TC_LDRB_BOTH                 ((unsigned int) 0x3 << 18) /* (TC) Edge: each edge of TIOA */
#define AT91C_TC_ACPC         ((unsigned int) 0x3 << 18) /* (TC) RC Compare Effect on TIOA */
#define 	AT91C_TC_ACPC_NONE                 ((unsigned int) 0x0 << 18) /* (TC) Effect: none */
#define 	AT91C_TC_ACPC_SET                  ((unsigned int) 0x1 << 18) /* (TC) Effect: set */
#define 	AT91C_TC_ACPC_CLEAR                ((unsigned int) 0x2 << 18) /* (TC) Effect: clear */
#define 	AT91C_TC_ACPC_TOGGLE               ((unsigned int) 0x3 << 18) /* (TC) Effect: toggle */
#define AT91C_TC_AEEVT        ((unsigned int) 0x3 << 20) /* (TC) External Event Effect on TIOA */
#define 	AT91C_TC_AEEVT_NONE                 ((unsigned int) 0x0 << 20) /* (TC) Effect: none */
#define 	AT91C_TC_AEEVT_SET                  ((unsigned int) 0x1 << 20) /* (TC) Effect: set */
#define 	AT91C_TC_AEEVT_CLEAR                ((unsigned int) 0x2 << 20) /* (TC) Effect: clear */
#define 	AT91C_TC_AEEVT_TOGGLE               ((unsigned int) 0x3 << 20) /* (TC) Effect: toggle */
#define AT91C_TC_ASWTRG       ((unsigned int) 0x3 << 22) /* (TC) Software Trigger Effect on TIOA */
#define 	AT91C_TC_ASWTRG_NONE                 ((unsigned int) 0x0 << 22) /* (TC) Effect: none */
#define 	AT91C_TC_ASWTRG_SET                  ((unsigned int) 0x1 << 22) /* (TC) Effect: set */
#define 	AT91C_TC_ASWTRG_CLEAR                ((unsigned int) 0x2 << 22) /* (TC) Effect: clear */
#define 	AT91C_TC_ASWTRG_TOGGLE               ((unsigned int) 0x3 << 22) /* (TC) Effect: toggle */
#define AT91C_TC_BCPB         ((unsigned int) 0x3 << 24) /* (TC) RB Compare Effect on TIOB */
#define 	AT91C_TC_BCPB_NONE                 ((unsigned int) 0x0 << 24) /* (TC) Effect: none */
#define 	AT91C_TC_BCPB_SET                  ((unsigned int) 0x1 << 24) /* (TC) Effect: set */
#define 	AT91C_TC_BCPB_CLEAR                ((unsigned int) 0x2 << 24) /* (TC) Effect: clear */
#define 	AT91C_TC_BCPB_TOGGLE               ((unsigned int) 0x3 << 24) /* (TC) Effect: toggle */
#define AT91C_TC_BCPC         ((unsigned int) 0x3 << 26) /* (TC) RC Compare Effect on TIOB */
#define 	AT91C_TC_BCPC_NONE                 ((unsigned int) 0x0 << 26) /* (TC) Effect: none */
#define 	AT91C_TC_BCPC_SET                  ((unsigned int) 0x1 << 26) /* (TC) Effect: set */
#define 	AT91C_TC_BCPC_CLEAR                ((unsigned int) 0x2 << 26) /* (TC) Effect: clear */
#define 	AT91C_TC_BCPC_TOGGLE               ((unsigned int) 0x3 << 26) /* (TC) Effect: toggle */
#define AT91C_TC_BEEVT        ((unsigned int) 0x3 << 28) /* (TC) External Event Effect on TIOB */
#define 	AT91C_TC_BEEVT_NONE                 ((unsigned int) 0x0 << 28) /* (TC) Effect: none */
#define 	AT91C_TC_BEEVT_SET                  ((unsigned int) 0x1 << 28) /* (TC) Effect: set */
#define 	AT91C_TC_BEEVT_CLEAR                ((unsigned int) 0x2 << 28) /* (TC) Effect: clear */
#define 	AT91C_TC_BEEVT_TOGGLE               ((unsigned int) 0x3 << 28) /* (TC) Effect: toggle */
#define AT91C_TC_BSWTRG       ((unsigned int) 0x3 << 30) /* (TC) Software Trigger Effect on TIOB */
#define 	AT91C_TC_BSWTRG_NONE                 ((unsigned int) 0x0 << 30) /* (TC) Effect: none */
#define 	AT91C_TC_BSWTRG_SET                  ((unsigned int) 0x1 << 30) /* (TC) Effect: set */
#define 	AT91C_TC_BSWTRG_CLEAR                ((unsigned int) 0x2 << 30) /* (TC) Effect: clear */
#define 	AT91C_TC_BSWTRG_TOGGLE               ((unsigned int) 0x3 << 30) /* (TC) Effect: toggle */
/* -------- TC_SR : (TC Offset: 0x20) TC Channel Status Register --------  */
#define AT91C_TC_COVFS        ((unsigned int) 0x1 <<  0) /* (TC) Counter Overflow */
#define AT91C_TC_LOVRS        ((unsigned int) 0x1 <<  1) /* (TC) Load Overrun */
#define AT91C_TC_CPAS         ((unsigned int) 0x1 <<  2) /* (TC) RA Compare */
#define AT91C_TC_CPBS         ((unsigned int) 0x1 <<  3) /* (TC) RB Compare */
#define AT91C_TC_CPCS         ((unsigned int) 0x1 <<  4) /* (TC) RC Compare */
#define AT91C_TC_LDRAS        ((unsigned int) 0x1 <<  5) /* (TC) RA Loading */
#define AT91C_TC_LDRBS        ((unsigned int) 0x1 <<  6) /* (TC) RB Loading */
#define AT91C_TC_ETRGS        ((unsigned int) 0x1 <<  7) /* (TC) External Trigger */
#define AT91C_TC_CLKSTA       ((unsigned int) 0x1 << 16) /* (TC) Clock Enabling */
#define AT91C_TC_MTIOA        ((unsigned int) 0x1 << 17) /* (TC) TIOA Mirror */
#define AT91C_TC_MTIOB        ((unsigned int) 0x1 << 18) /* (TC) TIOA Mirror */
/* -------- TC_IER : (TC Offset: 0x24) TC Channel Interrupt Enable Register --------  */
/* -------- TC_IDR : (TC Offset: 0x28) TC Channel Interrupt Disable Register --------  */
/* -------- TC_IMR : (TC Offset: 0x2c) TC Channel Interrupt Mask Register --------  */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Timer Counter Interface */
/* ***************************************************************************** */
typedef struct _AT91S_TCB {
	AT91S_TC	 TCB_TC0; 	/* TC Channel 0 */
	AT91_REG	 Reserved0[4]; 	/*  */
	AT91S_TC	 TCB_TC1; 	/* TC Channel 1 */
	AT91_REG	 Reserved1[4]; 	/*  */
	AT91S_TC	 TCB_TC2; 	/* TC Channel 2 */
	AT91_REG	 Reserved2[4]; 	/*  */
	AT91_REG	 TCB_BCR; 	/* TC Block Control Register */
	AT91_REG	 TCB_BMR; 	/* TC Block Mode Register */
} AT91S_TCB, *AT91PS_TCB;

/* -------- TCB_BCR : (TCB Offset: 0xc0) TC Block Control Register --------  */
#define AT91C_TCB_SYNC        ((unsigned int) 0x1 <<  0) /* (TCB) Synchro Command */
/* -------- TCB_BMR : (TCB Offset: 0xc4) TC Block Mode Register --------  */
#define AT91C_TCB_TC0XC0S     ((unsigned int) 0x3 <<  0) /* (TCB) External Clock Signal 0 Selection */
#define 	AT91C_TCB_TC0XC0S_TCLK0                ((unsigned int) 0x0) /* (TCB) TCLK0 connected to XC0 */
#define 	AT91C_TCB_TC0XC0S_NONE                 ((unsigned int) 0x1) /* (TCB) None signal connected to XC0 */
#define 	AT91C_TCB_TC0XC0S_TIOA1                ((unsigned int) 0x2) /* (TCB) TIOA1 connected to XC0 */
#define 	AT91C_TCB_TC0XC0S_TIOA2                ((unsigned int) 0x3) /* (TCB) TIOA2 connected to XC0 */
#define AT91C_TCB_TC1XC1S     ((unsigned int) 0x3 <<  2) /* (TCB) External Clock Signal 1 Selection */
#define 	AT91C_TCB_TC1XC1S_TCLK1                ((unsigned int) 0x0 <<  2) /* (TCB) TCLK1 connected to XC1 */
#define 	AT91C_TCB_TC1XC1S_NONE                 ((unsigned int) 0x1 <<  2) /* (TCB) None signal connected to XC1 */
#define 	AT91C_TCB_TC1XC1S_TIOA0                ((unsigned int) 0x2 <<  2) /* (TCB) TIOA0 connected to XC1 */
#define 	AT91C_TCB_TC1XC1S_TIOA2                ((unsigned int) 0x3 <<  2) /* (TCB) TIOA2 connected to XC1 */
#define AT91C_TCB_TC2XC2S     ((unsigned int) 0x3 <<  4) /* (TCB) External Clock Signal 2 Selection */
#define 	AT91C_TCB_TC2XC2S_TCLK2                ((unsigned int) 0x0 <<  4) /* (TCB) TCLK2 connected to XC2 */
#define 	AT91C_TCB_TC2XC2S_NONE                 ((unsigned int) 0x1 <<  4) /* (TCB) None signal connected to XC2 */
#define 	AT91C_TCB_TC2XC2S_TIOA0                ((unsigned int) 0x2 <<  4) /* (TCB) TIOA0 connected to XC2 */
#define 	AT91C_TCB_TC2XC2S_TIOA1                ((unsigned int) 0x3 <<  4) /* (TCB) TIOA2 connected to XC2 */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Usart */
/* ***************************************************************************** */
typedef struct _AT91S_USART {
	AT91_REG	 US_CR; 	/* Control Register */
	AT91_REG	 US_MR; 	/* Mode Register */
	AT91_REG	 US_IER; 	/* Interrupt Enable Register */
	AT91_REG	 US_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 US_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 US_CSR; 	/* Channel Status Register */
	AT91_REG	 US_RHR; 	/* Receiver Holding Register */
	AT91_REG	 US_THR; 	/* Transmitter Holding Register */
	AT91_REG	 US_BRGR; 	/* Baud Rate Generator Register */
	AT91_REG	 US_RTOR; 	/* Receiver Time-out Register */
	AT91_REG	 US_TTGR; 	/* Transmitter Time-guard Register */
	AT91_REG	 Reserved0[5]; 	/*  */
	AT91_REG	 US_FIDI; 	/* FI_DI_Ratio Register */
	AT91_REG	 US_NER; 	/* Nb Errors Register */
	AT91_REG	 Reserved1[1]; 	/*  */
	AT91_REG	 US_IF; 	/* IRDA_FILTER Register */
	AT91_REG	 Reserved2[44]; 	/*  */
	AT91_REG	 US_RPR; 	/* Receive Pointer Register */
	AT91_REG	 US_RCR; 	/* Receive Counter Register */
	AT91_REG	 US_TPR; 	/* Transmit Pointer Register */
	AT91_REG	 US_TCR; 	/* Transmit Counter Register */
	AT91_REG	 US_RNPR; 	/* Receive Next Pointer Register */
	AT91_REG	 US_RNCR; 	/* Receive Next Counter Register */
	AT91_REG	 US_TNPR; 	/* Transmit Next Pointer Register */
	AT91_REG	 US_TNCR; 	/* Transmit Next Counter Register */
	AT91_REG	 US_PTCR; 	/* PDC Transfer Control Register */
	AT91_REG	 US_PTSR; 	/* PDC Transfer Status Register */
} AT91S_USART, *AT91PS_USART;

/* -------- US_CR : (USART Offset: 0x0) Debug Unit Control Register --------  */
#define AT91C_US_STTBRK       ((unsigned int) 0x1 <<  9) /* (USART) Start Break */
#define AT91C_US_STPBRK       ((unsigned int) 0x1 << 10) /* (USART) Stop Break */
#define AT91C_US_STTTO        ((unsigned int) 0x1 << 11) /* (USART) Start Time-out */
#define AT91C_US_SENDA        ((unsigned int) 0x1 << 12) /* (USART) Send Address */
#define AT91C_US_RSTIT        ((unsigned int) 0x1 << 13) /* (USART) Reset Iterations */
#define AT91C_US_RSTNACK      ((unsigned int) 0x1 << 14) /* (USART) Reset Non Acknowledge */
#define AT91C_US_RETTO        ((unsigned int) 0x1 << 15) /* (USART) Rearm Time-out */
#define AT91C_US_DTREN        ((unsigned int) 0x1 << 16) /* (USART) Data Terminal ready Enable */
#define AT91C_US_DTRDIS       ((unsigned int) 0x1 << 17) /* (USART) Data Terminal ready Disable */
#define AT91C_US_RTSEN        ((unsigned int) 0x1 << 18) /* (USART) Request to Send enable */
#define AT91C_US_RTSDIS       ((unsigned int) 0x1 << 19) /* (USART) Request to Send Disable */
/* -------- US_MR : (USART Offset: 0x4) Debug Unit Mode Register --------  */
#define AT91C_US_USMODE       ((unsigned int) 0xF <<  0) /* (USART) Usart mode */
#define 	AT91C_US_USMODE_NORMAL               ((unsigned int) 0x0) /* (USART) Normal */
#define 	AT91C_US_USMODE_RS485                ((unsigned int) 0x1) /* (USART) RS485 */
#define 	AT91C_US_USMODE_HWHSH                ((unsigned int) 0x2) /* (USART) Hardware Handshaking */
#define 	AT91C_US_USMODE_MODEM                ((unsigned int) 0x3) /* (USART) Modem */
#define 	AT91C_US_USMODE_ISO7816_0            ((unsigned int) 0x4) /* (USART) ISO7816 protocol: T = 0 */
#define 	AT91C_US_USMODE_ISO7816_1            ((unsigned int) 0x6) /* (USART) ISO7816 protocol: T = 1 */
#define 	AT91C_US_USMODE_IRDA                 ((unsigned int) 0x8) /* (USART) IrDA */
#define 	AT91C_US_USMODE_SWHSH                ((unsigned int) 0xC) /* (USART) Software Handshaking */
#define AT91C_US_CLKS         ((unsigned int) 0x3 <<  4) /* (USART) Clock Selection (Baud Rate generator Input Clock */
#define 	AT91C_US_CLKS_CLOCK                ((unsigned int) 0x0 <<  4) /* (USART) Clock */
#define 	AT91C_US_CLKS_FDIV1                ((unsigned int) 0x1 <<  4) /* (USART) fdiv1 */
#define 	AT91C_US_CLKS_SLOW                 ((unsigned int) 0x2 <<  4) /* (USART) slow_clock (ARM) */
#define 	AT91C_US_CLKS_EXT                  ((unsigned int) 0x3 <<  4) /* (USART) External (SCK) */
#define AT91C_US_CHRL         ((unsigned int) 0x3 <<  6) /* (USART) Clock Selection (Baud Rate generator Input Clock */
#define 	AT91C_US_CHRL_5_BITS               ((unsigned int) 0x0 <<  6) /* (USART) Character Length: 5 bits */
#define 	AT91C_US_CHRL_6_BITS               ((unsigned int) 0x1 <<  6) /* (USART) Character Length: 6 bits */
#define 	AT91C_US_CHRL_7_BITS               ((unsigned int) 0x2 <<  6) /* (USART) Character Length: 7 bits */
#define 	AT91C_US_CHRL_8_BITS               ((unsigned int) 0x3 <<  6) /* (USART) Character Length: 8 bits */
#define AT91C_US_SYNC         ((unsigned int) 0x1 <<  8) /* (USART) Synchronous Mode Select */
#define AT91C_US_NBSTOP       ((unsigned int) 0x3 << 12) /* (USART) Number of Stop bits */
#define 	AT91C_US_NBSTOP_1_BIT                ((unsigned int) 0x0 << 12) /* (USART) 1 stop bit */
#define 	AT91C_US_NBSTOP_15_BIT               ((unsigned int) 0x1 << 12) /* (USART) Asynchronous (SYNC=0) 2 stop bits Synchronous (SYNC=1) 2 stop bits */
#define 	AT91C_US_NBSTOP_2_BIT                ((unsigned int) 0x2 << 12) /* (USART) 2 stop bits */
#define AT91C_US_MSBF         ((unsigned int) 0x1 << 16) /* (USART) Bit Order */
#define AT91C_US_MODE9        ((unsigned int) 0x1 << 17) /* (USART) 9-bit Character length */
#define AT91C_US_CKLO         ((unsigned int) 0x1 << 18) /* (USART) Clock Output Select */
#define AT91C_US_OVER         ((unsigned int) 0x1 << 19) /* (USART) Over Sampling Mode */
#define AT91C_US_INACK        ((unsigned int) 0x1 << 20) /* (USART) Inhibit Non Acknowledge */
#define AT91C_US_DSNACK       ((unsigned int) 0x1 << 21) /* (USART) Disable Successive NACK */
#define AT91C_US_MAX_ITER     ((unsigned int) 0x1 << 24) /* (USART) Number of Repetitions */
#define AT91C_US_FILTER       ((unsigned int) 0x1 << 28) /* (USART) Receive Line Filter */
/* -------- US_IER : (USART Offset: 0x8) Debug Unit Interrupt Enable Register --------  */
#define AT91C_US_RXBRK        ((unsigned int) 0x1 <<  2) /* (USART) Break Received/End of Break */
#define AT91C_US_TIMEOUT      ((unsigned int) 0x1 <<  8) /* (USART) Receiver Time-out */
#define AT91C_US_ITERATION    ((unsigned int) 0x1 << 10) /* (USART) Max number of Repetitions Reached */
#define AT91C_US_NACK         ((unsigned int) 0x1 << 13) /* (USART) Non Acknowledge */
#define AT91C_US_RIIC         ((unsigned int) 0x1 << 16) /* (USART) Ring INdicator Input Change Flag */
#define AT91C_US_DSRIC        ((unsigned int) 0x1 << 17) /* (USART) Data Set Ready Input Change Flag */
#define AT91C_US_DCDIC        ((unsigned int) 0x1 << 18) /* (USART) Data Carrier Flag */
#define AT91C_US_CTSIC        ((unsigned int) 0x1 << 19) /* (USART) Clear To Send Input Change Flag */
/* -------- US_IDR : (USART Offset: 0xc) Debug Unit Interrupt Disable Register --------  */
/* -------- US_IMR : (USART Offset: 0x10) Debug Unit Interrupt Mask Register --------  */
/* -------- US_CSR : (USART Offset: 0x14) Debug Unit Channel Status Register --------  */
#define AT91C_US_RI           ((unsigned int) 0x1 << 20) /* (USART) Image of RI Input */
#define AT91C_US_DSR          ((unsigned int) 0x1 << 21) /* (USART) Image of DSR Input */
#define AT91C_US_DCD          ((unsigned int) 0x1 << 22) /* (USART) Image of DCD Input */
#define AT91C_US_CTS          ((unsigned int) 0x1 << 23) /* (USART) Image of CTS Input */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Serial Parallel Interface */
/* ***************************************************************************** */
typedef struct _AT91S_SPI {
	AT91_REG	 SPI_CR; 	/* Control Register */
	AT91_REG	 SPI_MR; 	/* Mode Register */
	AT91_REG	 SPI_RDR; 	/* Receive Data Register */
	AT91_REG	 SPI_TDR; 	/* Transmit Data Register */
	AT91_REG	 SPI_SR; 	/* Status Register */
	AT91_REG	 SPI_IER; 	/* Interrupt Enable Register */
	AT91_REG	 SPI_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 SPI_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 Reserved0[4]; 	/*  */
	AT91_REG	 SPI_CSR[4]; 	/* Chip Select Register */
	AT91_REG	 Reserved1[48]; 	/*  */
	AT91_REG	 SPI_RPR; 	/* Receive Pointer Register */
	AT91_REG	 SPI_RCR; 	/* Receive Counter Register */
	AT91_REG	 SPI_TPR; 	/* Transmit Pointer Register */
	AT91_REG	 SPI_TCR; 	/* Transmit Counter Register */
	AT91_REG	 SPI_RNPR; 	/* Receive Next Pointer Register */
	AT91_REG	 SPI_RNCR; 	/* Receive Next Counter Register */
	AT91_REG	 SPI_TNPR; 	/* Transmit Next Pointer Register */
	AT91_REG	 SPI_TNCR; 	/* Transmit Next Counter Register */
	AT91_REG	 SPI_PTCR; 	/* PDC Transfer Control Register */
	AT91_REG	 SPI_PTSR; 	/* PDC Transfer Status Register */
} AT91S_SPI, *AT91PS_SPI;

/* -------- SPI_CR : (SPI Offset: 0x0) SPI Control Register --------  */
#define AT91C_SPI_SPIEN       ((unsigned int) 0x1 <<  0) /* (SPI) SPI Enable */
#define AT91C_SPI_SPIDIS      ((unsigned int) 0x1 <<  1) /* (SPI) SPI Disable */
#define AT91C_SPI_SWRST       ((unsigned int) 0x1 <<  7) /* (SPI) SPI Software reset */
#define AT91C_SPI_LASTXFER    ((unsigned int) 0x1 << 24) /* (SPI) SPI Last Transfer */
/* -------- SPI_MR : (SPI Offset: 0x4) SPI Mode Register --------  */
#define AT91C_SPI_MSTR        ((unsigned int) 0x1 <<  0) /* (SPI) Master/Slave Mode */
#define AT91C_SPI_PS          ((unsigned int) 0x1 <<  1) /* (SPI) Peripheral Select */
#define 	AT91C_SPI_PS_FIXED                ((unsigned int) 0x0 <<  1) /* (SPI) Fixed Peripheral Select */
#define 	AT91C_SPI_PS_VARIABLE             ((unsigned int) 0x1 <<  1) /* (SPI) Variable Peripheral Select */
#define AT91C_SPI_PCSDEC      ((unsigned int) 0x1 <<  2) /* (SPI) Chip Select Decode */
#define AT91C_SPI_FDIV        ((unsigned int) 0x1 <<  3) /* (SPI) Clock Selection */
#define AT91C_SPI_MODFDIS     ((unsigned int) 0x1 <<  4) /* (SPI) Mode Fault Detection */
#define AT91C_SPI_LLB         ((unsigned int) 0x1 <<  7) /* (SPI) Clock Selection */
#define AT91C_SPI_PCS         ((unsigned int) 0xF << 16) /* (SPI) Peripheral Chip Select */
#define AT91C_SPI_DLYBCS      ((unsigned int) 0xFF << 24) /* (SPI) Delay Between Chip Selects */
/* -------- SPI_RDR : (SPI Offset: 0x8) Receive Data Register --------  */
#define AT91C_SPI_RD          ((unsigned int) 0xFFFF <<  0) /* (SPI) Receive Data */
#define AT91C_SPI_RPCS        ((unsigned int) 0xF << 16) /* (SPI) Peripheral Chip Select Status */
/* -------- SPI_TDR : (SPI Offset: 0xc) Transmit Data Register --------  */
#define AT91C_SPI_TD          ((unsigned int) 0xFFFF <<  0) /* (SPI) Transmit Data */
#define AT91C_SPI_TPCS        ((unsigned int) 0xF << 16) /* (SPI) Peripheral Chip Select Status */
/* -------- SPI_SR : (SPI Offset: 0x10) Status Register --------  */
#define AT91C_SPI_RDRF        ((unsigned int) 0x1 <<  0) /* (SPI) Receive Data Register Full */
#define AT91C_SPI_TDRE        ((unsigned int) 0x1 <<  1) /* (SPI) Transmit Data Register Empty */
#define AT91C_SPI_MODF        ((unsigned int) 0x1 <<  2) /* (SPI) Mode Fault Error */
#define AT91C_SPI_OVRES       ((unsigned int) 0x1 <<  3) /* (SPI) Overrun Error Status */
#define AT91C_SPI_ENDRX       ((unsigned int) 0x1 <<  4) /* (SPI) End of Receiver Transfer */
#define AT91C_SPI_ENDTX       ((unsigned int) 0x1 <<  5) /* (SPI) End of Receiver Transfer */
#define AT91C_SPI_RXBUFF      ((unsigned int) 0x1 <<  6) /* (SPI) RXBUFF Interrupt */
#define AT91C_SPI_TXBUFE      ((unsigned int) 0x1 <<  7) /* (SPI) TXBUFE Interrupt */
#define AT91C_SPI_NSSR        ((unsigned int) 0x1 <<  8) /* (SPI) NSSR Interrupt */
#define AT91C_SPI_TXEMPTY     ((unsigned int) 0x1 <<  9) /* (SPI) TXEMPTY Interrupt */
#define AT91C_SPI_SPIENS      ((unsigned int) 0x1 << 16) /* (SPI) Enable Status */
/* -------- SPI_IER : (SPI Offset: 0x14) Interrupt Enable Register --------  */
/* -------- SPI_IDR : (SPI Offset: 0x18) Interrupt Disable Register --------  */
/* -------- SPI_IMR : (SPI Offset: 0x1c) Interrupt Mask Register --------  */
/* -------- SPI_CSR : (SPI Offset: 0x30) Chip Select Register --------  */
#define AT91C_SPI_CPOL        ((unsigned int) 0x1 <<  0) /* (SPI) Clock Polarity */
#define AT91C_SPI_NCPHA       ((unsigned int) 0x1 <<  1) /* (SPI) Clock Phase */
#define AT91C_SPI_CSAAT       ((unsigned int) 0x1 <<  3) /* (SPI) Chip Select Active After Transfer */
#define AT91C_SPI_BITS        ((unsigned int) 0xF <<  4) /* (SPI) Bits Per Transfer */
#define 	AT91C_SPI_BITS_8                    ((unsigned int) 0x0 <<  4) /* (SPI) 8 Bits Per transfer */
#define 	AT91C_SPI_BITS_9                    ((unsigned int) 0x1 <<  4) /* (SPI) 9 Bits Per transfer */
#define 	AT91C_SPI_BITS_10                   ((unsigned int) 0x2 <<  4) /* (SPI) 10 Bits Per transfer */
#define 	AT91C_SPI_BITS_11                   ((unsigned int) 0x3 <<  4) /* (SPI) 11 Bits Per transfer */
#define 	AT91C_SPI_BITS_12                   ((unsigned int) 0x4 <<  4) /* (SPI) 12 Bits Per transfer */
#define 	AT91C_SPI_BITS_13                   ((unsigned int) 0x5 <<  4) /* (SPI) 13 Bits Per transfer */
#define 	AT91C_SPI_BITS_14                   ((unsigned int) 0x6 <<  4) /* (SPI) 14 Bits Per transfer */
#define 	AT91C_SPI_BITS_15                   ((unsigned int) 0x7 <<  4) /* (SPI) 15 Bits Per transfer */
#define 	AT91C_SPI_BITS_16                   ((unsigned int) 0x8 <<  4) /* (SPI) 16 Bits Per transfer */
#define AT91C_SPI_SCBR        ((unsigned int) 0xFF <<  8) /* (SPI) Serial Clock Baud Rate */
#define AT91C_SPI_DLYBS       ((unsigned int) 0xFF << 16) /* (SPI) Delay Before SPCK */
#define AT91C_SPI_DLYBCT      ((unsigned int) 0xFF << 24) /* (SPI) Delay Between Consecutive Transfers */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR Ethernet MAC 10/100 */
/* ***************************************************************************** */
typedef struct _AT91S_EMAC {
	AT91_REG	 EMAC_NCR; 	/* Network Control Register */
	AT91_REG	 EMAC_NCFGR; 	/* Network Configuration Register */
	AT91_REG	 EMAC_NSR; 	/* Network Status Register */
	AT91_REG	 Reserved0[2]; 	/*  */
	AT91_REG	 EMAC_TSR; 	/* Transmit Status Register */
	AT91_REG	 EMAC_RBQP; 	/* Receive Buffer Queue Pointer */
	AT91_REG	 EMAC_TBQP; 	/* Transmit Buffer Queue Pointer */
	AT91_REG	 EMAC_RSR; 	/* Receive Status Register */
	AT91_REG	 EMAC_ISR; 	/* Interrupt Status Register */
	AT91_REG	 EMAC_IER; 	/* Interrupt Enable Register */
	AT91_REG	 EMAC_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 EMAC_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 EMAC_MAN; 	/* PHY Maintenance Register */
	AT91_REG	 EMAC_PTR; 	/* Pause Time Register */
	AT91_REG	 EMAC_PFR; 	/* Pause Frames received Register */
	AT91_REG	 EMAC_FTO; 	/* Frames Transmitted OK Register */
	AT91_REG	 EMAC_SCF; 	/* Single Collision Frame Register */
	AT91_REG	 EMAC_MCF; 	/* Multiple Collision Frame Register */
	AT91_REG	 EMAC_FRO; 	/* Frames Received OK Register */
	AT91_REG	 EMAC_FCSE; 	/* Frame Check Sequence Error Register */
	AT91_REG	 EMAC_ALE; 	/* Alignment Error Register */
	AT91_REG	 EMAC_DTF; 	/* Deferred Transmission Frame Register */
	AT91_REG	 EMAC_LCOL; 	/* Late Collision Register */
	AT91_REG	 EMAC_ECOL; 	/* Excessive Collision Register */
	AT91_REG	 EMAC_TUND; 	/* Transmit Underrun Error Register */
	AT91_REG	 EMAC_CSE; 	/* Carrier Sense Error Register */
	AT91_REG	 EMAC_RRE; 	/* Receive Ressource Error Register */
	AT91_REG	 EMAC_ROV; 	/* Receive Overrun Errors Register */
	AT91_REG	 EMAC_RSE; 	/* Receive Symbol Errors Register */
	AT91_REG	 EMAC_ELE; 	/* Excessive Length Errors Register */
	AT91_REG	 EMAC_RJA; 	/* Receive Jabbers Register */
	AT91_REG	 EMAC_USF; 	/* Undersize Frames Register */
	AT91_REG	 EMAC_STE; 	/* SQE Test Error Register */
	AT91_REG	 EMAC_RLE; 	/* Receive Length Field Mismatch Register */
	AT91_REG	 EMAC_TPF; 	/* Transmitted Pause Frames Register */
	AT91_REG	 EMAC_HRB; 	/* Hash Address Bottom[31:0] */
	AT91_REG	 EMAC_HRT; 	/* Hash Address Top[63:32] */
	AT91_REG	 EMAC_SA1L; 	/* Specific Address 1 Bottom, First 4 bytes */
	AT91_REG	 EMAC_SA1H; 	/* Specific Address 1 Top, Last 2 bytes */
	AT91_REG	 EMAC_SA2L; 	/* Specific Address 2 Bottom, First 4 bytes */
	AT91_REG	 EMAC_SA2H; 	/* Specific Address 2 Top, Last 2 bytes */
	AT91_REG	 EMAC_SA3L; 	/* Specific Address 3 Bottom, First 4 bytes */
	AT91_REG	 EMAC_SA3H; 	/* Specific Address 3 Top, Last 2 bytes */
	AT91_REG	 EMAC_SA4L; 	/* Specific Address 4 Bottom, First 4 bytes */
	AT91_REG	 EMAC_SA4H; 	/* Specific Address 4 Top, Last 2 bytes */
	AT91_REG	 EMAC_TID; 	/* Type ID Checking Register */
	AT91_REG	 EMAC_TPQ; 	/* Transmit Pause Quantum Register */
	AT91_REG	 EMAC_USRIO; 	/* USER Input/Output Register */
	AT91_REG	 EMAC_WOL; 	/* Wake On LAN Register */
	AT91_REG	 Reserved1[13]; 	/*  */
	AT91_REG	 EMAC_REV; 	/* Revision Register */
} AT91S_EMAC, *AT91PS_EMAC;

/* -------- EMAC_NCR : (EMAC Offset: 0x0)  --------  */
#define AT91C_EMAC_LB         ((unsigned int) 0x1 <<  0) /* (EMAC) Loopback. Optional. When set, loopback signal is at high level. */
#define AT91C_EMAC_LLB        ((unsigned int) 0x1 <<  1) /* (EMAC) Loopback local.  */
#define AT91C_EMAC_RE         ((unsigned int) 0x1 <<  2) /* (EMAC) Receive enable.  */
#define AT91C_EMAC_TE         ((unsigned int) 0x1 <<  3) /* (EMAC) Transmit enable.  */
#define AT91C_EMAC_MPE        ((unsigned int) 0x1 <<  4) /* (EMAC) Management port enable.  */
#define AT91C_EMAC_CLRSTAT    ((unsigned int) 0x1 <<  5) /* (EMAC) Clear statistics registers.  */
#define AT91C_EMAC_INCSTAT    ((unsigned int) 0x1 <<  6) /* (EMAC) Increment statistics registers.  */
#define AT91C_EMAC_WESTAT     ((unsigned int) 0x1 <<  7) /* (EMAC) Write enable for statistics registers.  */
#define AT91C_EMAC_BP         ((unsigned int) 0x1 <<  8) /* (EMAC) Back pressure.  */
#define AT91C_EMAC_TSTART     ((unsigned int) 0x1 <<  9) /* (EMAC) Start Transmission.  */
#define AT91C_EMAC_THALT      ((unsigned int) 0x1 << 10) /* (EMAC) Transmission Halt.  */
#define AT91C_EMAC_TPFR       ((unsigned int) 0x1 << 11) /* (EMAC) Transmit pause frame  */
#define AT91C_EMAC_TZQ        ((unsigned int) 0x1 << 12) /* (EMAC) Transmit zero quantum pause frame */
/* -------- EMAC_NCFGR : (EMAC Offset: 0x4) Network Configuration Register --------  */
#define AT91C_EMAC_SPD        ((unsigned int) 0x1 <<  0) /* (EMAC) Speed.  */
#define AT91C_EMAC_FD         ((unsigned int) 0x1 <<  1) /* (EMAC) Full duplex.  */
#define AT91C_EMAC_JFRAME     ((unsigned int) 0x1 <<  3) /* (EMAC) Jumbo Frames.  */
#define AT91C_EMAC_CAF        ((unsigned int) 0x1 <<  4) /* (EMAC) Copy all frames.  */
#define AT91C_EMAC_NBC        ((unsigned int) 0x1 <<  5) /* (EMAC) No broadcast.  */
#define AT91C_EMAC_MTI        ((unsigned int) 0x1 <<  6) /* (EMAC) Multicast hash event enable */
#define AT91C_EMAC_UNI        ((unsigned int) 0x1 <<  7) /* (EMAC) Unicast hash enable.  */
#define AT91C_EMAC_BIG        ((unsigned int) 0x1 <<  8) /* (EMAC) Receive 1522 bytes.  */
#define AT91C_EMAC_EAE        ((unsigned int) 0x1 <<  9) /* (EMAC) External address match enable.  */
#define AT91C_EMAC_CLK        ((unsigned int) 0x3 << 10) /* (EMAC)  */
#define 	AT91C_EMAC_CLK_HCLK_8               ((unsigned int) 0x0 << 10) /* (EMAC) HCLK divided by 8 */
#define 	AT91C_EMAC_CLK_HCLK_16              ((unsigned int) 0x1 << 10) /* (EMAC) HCLK divided by 16 */
#define 	AT91C_EMAC_CLK_HCLK_32              ((unsigned int) 0x2 << 10) /* (EMAC) HCLK divided by 32 */
#define 	AT91C_EMAC_CLK_HCLK_64              ((unsigned int) 0x3 << 10) /* (EMAC) HCLK divided by 64 */
#define AT91C_EMAC_RTY        ((unsigned int) 0x1 << 12) /* (EMAC)  */
#define AT91C_EMAC_PAE        ((unsigned int) 0x1 << 13) /* (EMAC)  */
#define AT91C_EMAC_RBOF       ((unsigned int) 0x3 << 14) /* (EMAC)  */
#define 	AT91C_EMAC_RBOF_OFFSET_0             ((unsigned int) 0x0 << 14) /* (EMAC) no offset from start of receive buffer */
#define 	AT91C_EMAC_RBOF_OFFSET_1             ((unsigned int) 0x1 << 14) /* (EMAC) one byte offset from start of receive buffer */
#define 	AT91C_EMAC_RBOF_OFFSET_2             ((unsigned int) 0x2 << 14) /* (EMAC) two bytes offset from start of receive buffer */
#define 	AT91C_EMAC_RBOF_OFFSET_3             ((unsigned int) 0x3 << 14) /* (EMAC) three bytes offset from start of receive buffer */
#define AT91C_EMAC_RLCE       ((unsigned int) 0x1 << 16) /* (EMAC) Receive Length field Checking Enable */
#define AT91C_EMAC_DRFCS      ((unsigned int) 0x1 << 17) /* (EMAC) Discard Receive FCS */
#define AT91C_EMAC_EFRHD      ((unsigned int) 0x1 << 18) /* (EMAC)  */
#define AT91C_EMAC_IRXFCS     ((unsigned int) 0x1 << 19) /* (EMAC) Ignore RX FCS */
/* -------- EMAC_NSR : (EMAC Offset: 0x8) Network Status Register --------  */
#define AT91C_EMAC_LINKR      ((unsigned int) 0x1 <<  0) /* (EMAC)  */
#define AT91C_EMAC_MDIO       ((unsigned int) 0x1 <<  1) /* (EMAC)  */
#define AT91C_EMAC_IDLE       ((unsigned int) 0x1 <<  2) /* (EMAC)  */
/* -------- EMAC_TSR : (EMAC Offset: 0x14) Transmit Status Register --------  */
#define AT91C_EMAC_UBR        ((unsigned int) 0x1 <<  0) /* (EMAC)  */
#define AT91C_EMAC_COL        ((unsigned int) 0x1 <<  1) /* (EMAC)  */
#define AT91C_EMAC_RLES       ((unsigned int) 0x1 <<  2) /* (EMAC)  */
#define AT91C_EMAC_TGO        ((unsigned int) 0x1 <<  3) /* (EMAC) Transmit Go */
#define AT91C_EMAC_BEX        ((unsigned int) 0x1 <<  4) /* (EMAC) Buffers exhausted mid frame */
#define AT91C_EMAC_COMP       ((unsigned int) 0x1 <<  5) /* (EMAC)  */
#define AT91C_EMAC_UND        ((unsigned int) 0x1 <<  6) /* (EMAC)  */
/* -------- EMAC_RSR : (EMAC Offset: 0x20) Receive Status Register --------  */
#define AT91C_EMAC_BNA        ((unsigned int) 0x1 <<  0) /* (EMAC)  */
#define AT91C_EMAC_REC        ((unsigned int) 0x1 <<  1) /* (EMAC)  */
#define AT91C_EMAC_OVR        ((unsigned int) 0x1 <<  2) /* (EMAC)  */
/* -------- EMAC_ISR : (EMAC Offset: 0x24) Interrupt Status Register --------  */
#define AT91C_EMAC_MFD        ((unsigned int) 0x1 <<  0) /* (EMAC)  */
#define AT91C_EMAC_RCOMP      ((unsigned int) 0x1 <<  1) /* (EMAC)  */
#define AT91C_EMAC_RXUBR      ((unsigned int) 0x1 <<  2) /* (EMAC)  */
#define AT91C_EMAC_TXUBR      ((unsigned int) 0x1 <<  3) /* (EMAC)  */
#define AT91C_EMAC_TUNDR      ((unsigned int) 0x1 <<  4) /* (EMAC)  */
#define AT91C_EMAC_RLEX       ((unsigned int) 0x1 <<  5) /* (EMAC)  */
#define AT91C_EMAC_TXERR      ((unsigned int) 0x1 <<  6) /* (EMAC)  */
#define AT91C_EMAC_TCOMP      ((unsigned int) 0x1 <<  7) /* (EMAC)  */
#define AT91C_EMAC_LINK       ((unsigned int) 0x1 <<  9) /* (EMAC)  */
#define AT91C_EMAC_ROVR       ((unsigned int) 0x1 << 10) /* (EMAC)  */
#define AT91C_EMAC_HRESP      ((unsigned int) 0x1 << 11) /* (EMAC)  */
#define AT91C_EMAC_PFRE       ((unsigned int) 0x1 << 12) /* (EMAC)  */
#define AT91C_EMAC_PTZ        ((unsigned int) 0x1 << 13) /* (EMAC)  */
/* -------- EMAC_IER : (EMAC Offset: 0x28) Interrupt Enable Register --------  */
/* -------- EMAC_IDR : (EMAC Offset: 0x2c) Interrupt Disable Register --------  */
/* -------- EMAC_IMR : (EMAC Offset: 0x30) Interrupt Mask Register --------  */
/* -------- EMAC_MAN : (EMAC Offset: 0x34) PHY Maintenance Register --------  */
#define AT91C_EMAC_DATA       ((unsigned int) 0xFFFF <<  0) /* (EMAC)  */
#define AT91C_EMAC_CODE       ((unsigned int) 0x3 << 16) /* (EMAC)  */
#define AT91C_EMAC_REGA       ((unsigned int) 0x1F << 18) /* (EMAC)  */
#define AT91C_EMAC_PHYA       ((unsigned int) 0x1F << 23) /* (EMAC)  */
#define AT91C_EMAC_RW         ((unsigned int) 0x3 << 28) /* (EMAC)  */
#define AT91C_EMAC_SOF        ((unsigned int) 0x3 << 30) /* (EMAC)  */
/* -------- EMAC_USRIO : (EMAC Offset: 0xc0) USER Input Output Register --------  */
#define AT91C_EMAC_RMII       ((unsigned int) 0x1 <<  0) /* (EMAC) Reduce MII */
#define AT91C_EMAC_CLKEN      ((unsigned int) 0x1 <<  1) /* (EMAC) Clock Enable */
/* -------- EMAC_WOL : (EMAC Offset: 0xc4) Wake On LAN Register --------  */
#define AT91C_EMAC_IP         ((unsigned int) 0xFFFF <<  0) /* (EMAC) ARP request IP address */
#define AT91C_EMAC_MAG        ((unsigned int) 0x1 << 16) /* (EMAC) Magic packet event enable */
#define AT91C_EMAC_ARP        ((unsigned int) 0x1 << 17) /* (EMAC) ARP request event enable */
#define AT91C_EMAC_SA1        ((unsigned int) 0x1 << 18) /* (EMAC) Specific address register 1 event enable */
/* -------- EMAC_REV : (EMAC Offset: 0xfc) Revision Register --------  */
#define AT91C_EMAC_REVREF     ((unsigned int) 0xFFFF <<  0) /* (EMAC)  */
#define AT91C_EMAC_PARTREF    ((unsigned int) 0xFFFF << 16) /* (EMAC)  */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR USB Device Interface */
/* ***************************************************************************** */
typedef struct _AT91S_UDP {
	AT91_REG	 UDP_NUM; 	/* Frame Number Register */
	AT91_REG	 UDP_GLBSTATE; 	/* Global State Register */
	AT91_REG	 UDP_FADDR; 	/* Function Address Register */
	AT91_REG	 Reserved0[1]; 	/*  */
	AT91_REG	 UDP_IER; 	/* Interrupt Enable Register */
	AT91_REG	 UDP_IDR; 	/* Interrupt Disable Register */
	AT91_REG	 UDP_IMR; 	/* Interrupt Mask Register */
	AT91_REG	 UDP_ISR; 	/* Interrupt Status Register */
	AT91_REG	 UDP_ICR; 	/* Interrupt Clear Register */
	AT91_REG	 Reserved1[1]; 	/*  */
	AT91_REG	 UDP_RSTEP; 	/* Reset Endpoint Register */
	AT91_REG	 Reserved2[1]; 	/*  */
	AT91_REG	 UDP_CSR[6]; 	/* Endpoint Control and Status Register */
	AT91_REG	 Reserved3[2]; 	/*  */
	AT91_REG	 UDP_FDR[6]; 	/* Endpoint FIFO Data Register */
	AT91_REG	 Reserved4[3]; 	/*  */
	AT91_REG	 UDP_TXVC; 	/* Transceiver Control Register */
} AT91S_UDP, *AT91PS_UDP;

/* -------- UDP_FRM_NUM : (UDP Offset: 0x0) USB Frame Number Register --------  */
#define AT91C_UDP_FRM_NUM     ((unsigned int) 0x7FF <<  0) /* (UDP) Frame Number as Defined in the Packet Field Formats */
#define AT91C_UDP_FRM_ERR     ((unsigned int) 0x1 << 16) /* (UDP) Frame Error */
#define AT91C_UDP_FRM_OK      ((unsigned int) 0x1 << 17) /* (UDP) Frame OK */
/* -------- UDP_GLB_STATE : (UDP Offset: 0x4) USB Global State Register --------  */
#define AT91C_UDP_FADDEN      ((unsigned int) 0x1 <<  0) /* (UDP) Function Address Enable */
#define AT91C_UDP_CONFG       ((unsigned int) 0x1 <<  1) /* (UDP) Configured */
#define AT91C_UDP_ESR         ((unsigned int) 0x1 <<  2) /* (UDP) Enable Send Resume */
#define AT91C_UDP_RSMINPR     ((unsigned int) 0x1 <<  3) /* (UDP) A Resume Has Been Sent to the Host */
#define AT91C_UDP_RMWUPE      ((unsigned int) 0x1 <<  4) /* (UDP) Remote Wake Up Enable */
/* -------- UDP_FADDR : (UDP Offset: 0x8) USB Function Address Register --------  */
#define AT91C_UDP_FADD        ((unsigned int) 0xFF <<  0) /* (UDP) Function Address Value */
#define AT91C_UDP_FEN         ((unsigned int) 0x1 <<  8) /* (UDP) Function Enable */
/* -------- UDP_IER : (UDP Offset: 0x10) USB Interrupt Enable Register --------  */
#define AT91C_UDP_EPINT0      ((unsigned int) 0x1 <<  0) /* (UDP) Endpoint 0 Interrupt */
#define AT91C_UDP_EPINT1      ((unsigned int) 0x1 <<  1) /* (UDP) Endpoint 0 Interrupt */
#define AT91C_UDP_EPINT2      ((unsigned int) 0x1 <<  2) /* (UDP) Endpoint 2 Interrupt */
#define AT91C_UDP_EPINT3      ((unsigned int) 0x1 <<  3) /* (UDP) Endpoint 3 Interrupt */
#define AT91C_UDP_EPINT4      ((unsigned int) 0x1 <<  4) /* (UDP) Endpoint 4 Interrupt */
#define AT91C_UDP_EPINT5      ((unsigned int) 0x1 <<  5) /* (UDP) Endpoint 5 Interrupt */
#define AT91C_UDP_RXSUSP      ((unsigned int) 0x1 <<  8) /* (UDP) USB Suspend Interrupt */
#define AT91C_UDP_RXRSM       ((unsigned int) 0x1 <<  9) /* (UDP) USB Resume Interrupt */
#define AT91C_UDP_EXTRSM      ((unsigned int) 0x1 << 10) /* (UDP) USB External Resume Interrupt */
#define AT91C_UDP_SOFINT      ((unsigned int) 0x1 << 11) /* (UDP) USB Start Of frame Interrupt */
#define AT91C_UDP_WAKEUP      ((unsigned int) 0x1 << 13) /* (UDP) USB Resume Interrupt */
/* -------- UDP_IDR : (UDP Offset: 0x14) USB Interrupt Disable Register --------  */
/* -------- UDP_IMR : (UDP Offset: 0x18) USB Interrupt Mask Register --------  */
/* -------- UDP_ISR : (UDP Offset: 0x1c) USB Interrupt Status Register --------  */
#define AT91C_UDP_ENDBUSRES   ((unsigned int) 0x1 << 12) /* (UDP) USB End Of Bus Reset Interrupt */
/* -------- UDP_ICR : (UDP Offset: 0x20) USB Interrupt Clear Register --------  */
/* -------- UDP_RST_EP : (UDP Offset: 0x28) USB Reset Endpoint Register --------  */
#define AT91C_UDP_EP0         ((unsigned int) 0x1 <<  0) /* (UDP) Reset Endpoint 0 */
#define AT91C_UDP_EP1         ((unsigned int) 0x1 <<  1) /* (UDP) Reset Endpoint 1 */
#define AT91C_UDP_EP2         ((unsigned int) 0x1 <<  2) /* (UDP) Reset Endpoint 2 */
#define AT91C_UDP_EP3         ((unsigned int) 0x1 <<  3) /* (UDP) Reset Endpoint 3 */
#define AT91C_UDP_EP4         ((unsigned int) 0x1 <<  4) /* (UDP) Reset Endpoint 4 */
#define AT91C_UDP_EP5         ((unsigned int) 0x1 <<  5) /* (UDP) Reset Endpoint 5 */
/* -------- UDP_CSR : (UDP Offset: 0x30) USB Endpoint Control and Status Register --------  */
#define AT91C_UDP_TXCOMP      ((unsigned int) 0x1 <<  0) /* (UDP) Generates an IN packet with data previously written in the DPR */
#define AT91C_UDP_RX_DATA_BK0 ((unsigned int) 0x1 <<  1) /* (UDP) Receive Data Bank 0 */
#define AT91C_UDP_RXSETUP     ((unsigned int) 0x1 <<  2) /* (UDP) Sends STALL to the Host (Control endpoints) */
#define AT91C_UDP_ISOERROR    ((unsigned int) 0x1 <<  3) /* (UDP) Isochronous error (Isochronous endpoints) */
#define AT91C_UDP_TXPKTRDY    ((unsigned int) 0x1 <<  4) /* (UDP) Transmit Packet Ready */
#define AT91C_UDP_FORCESTALL  ((unsigned int) 0x1 <<  5) /* (UDP) Force Stall (used by Control, Bulk and Isochronous endpoints). */
#define AT91C_UDP_RX_DATA_BK1 ((unsigned int) 0x1 <<  6) /* (UDP) Receive Data Bank 1 (only used by endpoints with ping-pong attributes). */
#define AT91C_UDP_DIR         ((unsigned int) 0x1 <<  7) /* (UDP) Transfer Direction */
#define AT91C_UDP_EPTYPE      ((unsigned int) 0x7 <<  8) /* (UDP) Endpoint type */
#define 	AT91C_UDP_EPTYPE_CTRL                 ((unsigned int) 0x0 <<  8) /* (UDP) Control */
#define 	AT91C_UDP_EPTYPE_ISO_OUT              ((unsigned int) 0x1 <<  8) /* (UDP) Isochronous OUT */
#define 	AT91C_UDP_EPTYPE_BULK_OUT             ((unsigned int) 0x2 <<  8) /* (UDP) Bulk OUT */
#define 	AT91C_UDP_EPTYPE_INT_OUT              ((unsigned int) 0x3 <<  8) /* (UDP) Interrupt OUT */
#define 	AT91C_UDP_EPTYPE_ISO_IN               ((unsigned int) 0x5 <<  8) /* (UDP) Isochronous IN */
#define 	AT91C_UDP_EPTYPE_BULK_IN              ((unsigned int) 0x6 <<  8) /* (UDP) Bulk IN */
#define 	AT91C_UDP_EPTYPE_INT_IN               ((unsigned int) 0x7 <<  8) /* (UDP) Interrupt IN */
#define AT91C_UDP_DTGLE       ((unsigned int) 0x1 << 11) /* (UDP) Data Toggle */
#define AT91C_UDP_EPEDS       ((unsigned int) 0x1 << 15) /* (UDP) Endpoint Enable Disable */
#define AT91C_UDP_RXBYTECNT   ((unsigned int) 0x7FF << 16) /* (UDP) Number Of Bytes Available in the FIFO */
/* -------- UDP_TXVC : (UDP Offset: 0x74) Transceiver Control Register --------  */
#define AT91C_UDP_TXVDIS      ((unsigned int) 0x1 <<  8) /* (UDP)  */
#define AT91C_UDP_PUON        ((unsigned int) 0x1 <<  9) /* (UDP) Pull-up ON */

/* ***************************************************************************** */
/*              SOFTWARE API DEFINITION  FOR USB Host Interface */
/* ***************************************************************************** */
typedef struct _AT91S_UHP {
	AT91_REG	 UHP_HcRevision; 	/* Revision */
	AT91_REG	 UHP_HcControl; 	/* Operating modes for the Host Controller */
	AT91_REG	 UHP_HcCommandStatus; 	/* Command & status Register */
	AT91_REG	 UHP_HcInterruptStatus; 	/* Interrupt Status Register */
	AT91_REG	 UHP_HcInterruptEnable; 	/* Interrupt Enable Register */
	AT91_REG	 UHP_HcInterruptDisable; 	/* Interrupt Disable Register */
	AT91_REG	 UHP_HcHCCA; 	/* Pointer to the Host Controller Communication Area */
	AT91_REG	 UHP_HcPeriodCurrentED; 	/* Current Isochronous or Interrupt Endpoint Descriptor */
	AT91_REG	 UHP_HcControlHeadED; 	/* First Endpoint Descriptor of the Control list */
	AT91_REG	 UHP_HcControlCurrentED; 	/* Endpoint Control and Status Register */
	AT91_REG	 UHP_HcBulkHeadED; 	/* First endpoint register of the Bulk list */
	AT91_REG	 UHP_HcBulkCurrentED; 	/* Current endpoint of the Bulk list */
	AT91_REG	 UHP_HcBulkDoneHead; 	/* Last completed transfer descriptor */
	AT91_REG	 UHP_HcFmInterval; 	/* Bit time between 2 consecutive SOFs */
	AT91_REG	 UHP_HcFmRemaining; 	/* Bit time remaining in the current Frame */
	AT91_REG	 UHP_HcFmNumber; 	/* Frame number */
	AT91_REG	 UHP_HcPeriodicStart; 	/* Periodic Start */
	AT91_REG	 UHP_HcLSThreshold; 	/* LS Threshold */
	AT91_REG	 UHP_HcRhDescriptorA; 	/* Root Hub characteristics A */
	AT91_REG	 UHP_HcRhDescriptorB; 	/* Root Hub characteristics B */
	AT91_REG	 UHP_HcRhStatus; 	/* Root Hub Status register */
	AT91_REG	 UHP_HcRhPortStatus[2]; 	/* Root Hub Port Status Register */
} AT91S_UHP, *AT91PS_UHP;

/* ***************************************************************************** */
/*               REGISTER ADDRESS DEFINITION FOR AT91SAM9260 */
/* ***************************************************************************** */
/* ========== Register definition for SYS peripheral ==========  */
#define AT91C_SYS_GPBR3 ((AT91_REG *) 	0xFFFFFFFF) /* (SYS) General Purpose Register 3 */
#define AT91C_SYS_GPBR1 ((AT91_REG *) 	0xFFFFFFFF) /* (SYS) General Purpose Register 1 */
#define AT91C_SYS_GPBR2 ((AT91_REG *) 	0xFFFFFFFF) /* (SYS) General Purpose Register 2 */
#define AT91C_SYS_GPBR0 ((AT91_REG *) 	0xFFFFFFFF) /* (SYS) General Purpose Register 0 */
/* ========== Register definition for HECC peripheral ==========  */
#define AT91C_HECC_PR   ((AT91_REG *) 	0xFFFFE80C) /* (HECC)  ECC Parity register */
#define AT91C_HECC_MR   ((AT91_REG *) 	0xFFFFE804) /* (HECC)  ECC Page size register */
#define AT91C_HECC_NPR  ((AT91_REG *) 	0xFFFFE810) /* (HECC)  ECC Parity N register */
#define AT91C_HECC_SR   ((AT91_REG *) 	0xFFFFE808) /* (HECC)  ECC Status register */
#define AT91C_HECC_CR   ((AT91_REG *) 	0xFFFFE800) /* (HECC)  ECC reset register */
#define AT91C_HECC_VR   ((AT91_REG *) 	0xFFFFE8FC) /* (HECC)  ECC Version register */
/* ========== Register definition for SDRAMC peripheral ==========  */
#define AT91C_SDRAMC_ISR ((AT91_REG *) 	0xFFFFEA20) /* (SDRAMC) SDRAM Controller Interrupt Mask Register */
#define AT91C_SDRAMC_IDR ((AT91_REG *) 	0xFFFFEA18) /* (SDRAMC) SDRAM Controller Interrupt Disable Register */
#define AT91C_SDRAMC_MR ((AT91_REG *) 	0xFFFFEA00) /* (SDRAMC) SDRAM Controller Mode Register */
#define AT91C_SDRAMC_CR ((AT91_REG *) 	0xFFFFEA08) /* (SDRAMC) SDRAM Controller Configuration Register */
#define AT91C_SDRAMC_LPR ((AT91_REG *) 	0xFFFFEA10) /* (SDRAMC) SDRAM Controller Low Power Register */
#define AT91C_SDRAMC_MDR ((AT91_REG *) 	0xFFFFEA24) /* (SDRAMC) SDRAM Memory Device Register */
#define AT91C_SDRAMC_TR ((AT91_REG *) 	0xFFFFEA04) /* (SDRAMC) SDRAM Controller Refresh Timer Register */
#define AT91C_SDRAMC_HSR ((AT91_REG *) 	0xFFFFEA0C) /* (SDRAMC) SDRAM Controller High Speed Register */
#define AT91C_SDRAMC_IER ((AT91_REG *) 	0xFFFFEA14) /* (SDRAMC) SDRAM Controller Interrupt Enable Register */
#define AT91C_SDRAMC_IMR ((AT91_REG *) 	0xFFFFEA1C) /* (SDRAMC) SDRAM Controller Interrupt Mask Register */
/* ========== Register definition for SMC peripheral ==========  */
#define AT91C_SMC_CYCLE1 ((AT91_REG *) 	0xFFFFEC18) /* (SMC)  Cycle Register for CS 1 */
#define AT91C_SMC_CTRL7 ((AT91_REG *) 	0xFFFFEC7C) /* (SMC)  Control Register for CS 7 */
#define AT91C_SMC_CTRL2 ((AT91_REG *) 	0xFFFFEC2C) /* (SMC)  Control Register for CS 2 */
#define AT91C_SMC_PULSE2 ((AT91_REG *) 	0xFFFFEC24) /* (SMC)  Pulse Register for CS 2 */
#define AT91C_SMC_CTRL1 ((AT91_REG *) 	0xFFFFEC1C) /* (SMC)  Control Register for CS 1 */
#define AT91C_SMC_SETUP4 ((AT91_REG *) 	0xFFFFEC40) /* (SMC)  Setup Register for CS 4 */
#define AT91C_SMC_CYCLE3 ((AT91_REG *) 	0xFFFFEC38) /* (SMC)  Cycle Register for CS 3 */
#define AT91C_SMC_SETUP3 ((AT91_REG *) 	0xFFFFEC30) /* (SMC)  Setup Register for CS 3 */
#define AT91C_SMC_CYCLE2 ((AT91_REG *) 	0xFFFFEC28) /* (SMC)  Cycle Register for CS 2 */
#define AT91C_SMC_SETUP2 ((AT91_REG *) 	0xFFFFEC20) /* (SMC)  Setup Register for CS 2 */
#define AT91C_SMC_PULSE5 ((AT91_REG *) 	0xFFFFEC54) /* (SMC)  Pulse Register for CS 5 */
#define AT91C_SMC_CTRL4 ((AT91_REG *) 	0xFFFFEC4C) /* (SMC)  Control Register for CS 4 */
#define AT91C_SMC_PULSE4 ((AT91_REG *) 	0xFFFFEC44) /* (SMC)  Pulse Register for CS 4 */
#define AT91C_SMC_CTRL3 ((AT91_REG *) 	0xFFFFEC3C) /* (SMC)  Control Register for CS 3 */
#define AT91C_SMC_PULSE3 ((AT91_REG *) 	0xFFFFEC34) /* (SMC)  Pulse Register for CS 3 */
#define AT91C_SMC_PULSE0 ((AT91_REG *) 	0xFFFFEC04) /* (SMC)  Pulse Register for CS 0 */
#define AT91C_SMC_CYCLE4 ((AT91_REG *) 	0xFFFFEC48) /* (SMC)  Cycle Register for CS 4 */
#define AT91C_SMC_SETUP5 ((AT91_REG *) 	0xFFFFEC50) /* (SMC)  Setup Register for CS 5 */
#define AT91C_SMC_CYCLE5 ((AT91_REG *) 	0xFFFFEC58) /* (SMC)  Cycle Register for CS 5 */
#define AT91C_SMC_SETUP6 ((AT91_REG *) 	0xFFFFEC60) /* (SMC)  Setup Register for CS 6 */
#define AT91C_SMC_CYCLE6 ((AT91_REG *) 	0xFFFFEC68) /* (SMC)  Cycle Register for CS 6 */
#define AT91C_SMC_SETUP0 ((AT91_REG *) 	0xFFFFEC00) /* (SMC)  Setup Register for CS 0 */
#define AT91C_SMC_CYCLE0 ((AT91_REG *) 	0xFFFFEC08) /* (SMC)  Cycle Register for CS 0 */
#define AT91C_SMC_SETUP1 ((AT91_REG *) 	0xFFFFEC10) /* (SMC)  Setup Register for CS 1 */
#define AT91C_SMC_CTRL5 ((AT91_REG *) 	0xFFFFEC5C) /* (SMC)  Control Register for CS 5 */
#define AT91C_SMC_PULSE6 ((AT91_REG *) 	0xFFFFEC64) /* (SMC)  Pulse Register for CS 6 */
#define AT91C_SMC_CTRL6 ((AT91_REG *) 	0xFFFFEC6C) /* (SMC)  Control Register for CS 6 */
#define AT91C_SMC_PULSE7 ((AT91_REG *) 	0xFFFFEC74) /* (SMC)  Pulse Register for CS 7 */
#define AT91C_SMC_CTRL0 ((AT91_REG *) 	0xFFFFEC0C) /* (SMC)  Control Register for CS 0 */
#define AT91C_SMC_PULSE1 ((AT91_REG *) 	0xFFFFEC14) /* (SMC)  Pulse Register for CS 1 */
#define AT91C_SMC_SETUP7 ((AT91_REG *) 	0xFFFFEC70) /* (SMC)  Setup Register for CS 7 */
#define AT91C_SMC_CYCLE7 ((AT91_REG *) 	0xFFFFEC78) /* (SMC)  Cycle Register for CS 7 */
/* ========== Register definition for MATRIX peripheral ==========  */
#define AT91C_MATRIX_MCFG1 ((AT91_REG *) 	0xFFFFEE04) /* (MATRIX)  Master Configuration Register 1 (rom)     */
#define AT91C_MATRIX_MRCR ((AT91_REG *) 	0xFFFFEF00) /* (MATRIX)  Master Remp Control Register  */
#define AT91C_MATRIX_SCFG4 ((AT91_REG *) 	0xFFFFEE50) /* (MATRIX)  Slave Configuration Register 4 (bridge)     */
#define AT91C_MATRIX_MCFG2 ((AT91_REG *) 	0xFFFFEE08) /* (MATRIX)  Master Configuration Register 2 (hperiphs)  */
#define AT91C_MATRIX_MCFG0 ((AT91_REG *) 	0xFFFFEE00) /* (MATRIX)  Master Configuration Register 0 (ram96k)      */
#define AT91C_MATRIX_EBI ((AT91_REG *) 	0xFFFFEF1C) /* (MATRIX)  Slave 3 (ebi) Special Function Register */
#define AT91C_MATRIX_TEAKCFG ((AT91_REG *) 	0xFFFFEF2C) /* (MATRIX)  Slave 7 (teak_prog) Special Function Register */
#define AT91C_MATRIX_MCFG3 ((AT91_REG *) 	0xFFFFEE0C) /* (MATRIX)  Master Configuration Register 3 (ebi) */
#define AT91C_MATRIX_MCFG4 ((AT91_REG *) 	0xFFFFEE10) /* (MATRIX)  Master Configuration Register 4 (bridge)     */
#define AT91C_MATRIX_MCFG6 ((AT91_REG *) 	0xFFFFEE18) /* (MATRIX)  Master Configuration Register 6 (ram16k)   */
#define AT91C_MATRIX_PRBS0 ((AT91_REG *) 	0xFFFFEE84) /* (MATRIX)  PRBS0 (ram0)  */
#define AT91C_MATRIX_MCFG5 ((AT91_REG *) 	0xFFFFEE14) /* (MATRIX)  Master Configuration Register 5 (mailbox)     */
#define AT91C_MATRIX_MCFG7 ((AT91_REG *) 	0xFFFFEE1C) /* (MATRIX)  Master Configuration Register 7 (teak_prog)      */
#define AT91C_MATRIX_VERSION ((AT91_REG *) 	0xFFFFEFFC) /* (MATRIX)  Version Register */
#define AT91C_MATRIX_PRAS2 ((AT91_REG *) 	0xFFFFEE90) /* (MATRIX)  PRAS2 (ram2)  */
#define AT91C_MATRIX_PRAS0 ((AT91_REG *) 	0xFFFFEE80) /* (MATRIX)  PRAS0 (ram0)  */
#define AT91C_MATRIX_PRAS1 ((AT91_REG *) 	0xFFFFEE88) /* (MATRIX)  PRAS1 (ram1)  */
#define AT91C_MATRIX_SCFG2 ((AT91_REG *) 	0xFFFFEE48) /* (MATRIX)  Slave Configuration Register 2 (hperiphs)  */
#define AT91C_MATRIX_SCFG0 ((AT91_REG *) 	0xFFFFEE40) /* (MATRIX)  Slave Configuration Register 0 (ram96k)      */
#define AT91C_MATRIX_PRBS2 ((AT91_REG *) 	0xFFFFEE94) /* (MATRIX)  PRBS2 (ram2)  */
#define AT91C_MATRIX_PRBS1 ((AT91_REG *) 	0xFFFFEE8C) /* (MATRIX)  PRBS1 (ram1)  */
#define AT91C_MATRIX_SCFG3 ((AT91_REG *) 	0xFFFFEE4C) /* (MATRIX)  Slave Configuration Register 3 (ebi) */
#define AT91C_MATRIX_SCFG1 ((AT91_REG *) 	0xFFFFEE44) /* (MATRIX)  Slave Configuration Register 1 (rom)     */
/* ========== Register definition for CCFG peripheral ==========  */
#define AT91C_CCFG_MATRIXVERSION ((AT91_REG *) 	0xFFFFEFFC) /* (CCFG)  Version Register */
#define AT91C_CCFG_EBICSA ((AT91_REG *) 	0xFFFFEF1C) /* (CCFG)  EBI Chip Select Assignement Register */
/* ========== Register definition for PDC_DBGU peripheral ==========  */
#define AT91C_DBGU_TNCR ((AT91_REG *) 	0xFFFFF31C) /* (PDC_DBGU) Transmit Next Counter Register */
#define AT91C_DBGU_RNCR ((AT91_REG *) 	0xFFFFF314) /* (PDC_DBGU) Receive Next Counter Register */
#define AT91C_DBGU_PTCR ((AT91_REG *) 	0xFFFFF320) /* (PDC_DBGU) PDC Transfer Control Register */
#define AT91C_DBGU_PTSR ((AT91_REG *) 	0xFFFFF324) /* (PDC_DBGU) PDC Transfer Status Register */
#define AT91C_DBGU_RCR  ((AT91_REG *) 	0xFFFFF304) /* (PDC_DBGU) Receive Counter Register */
#define AT91C_DBGU_TCR  ((AT91_REG *) 	0xFFFFF30C) /* (PDC_DBGU) Transmit Counter Register */
#define AT91C_DBGU_RPR  ((AT91_REG *) 	0xFFFFF300) /* (PDC_DBGU) Receive Pointer Register */
#define AT91C_DBGU_TPR  ((AT91_REG *) 	0xFFFFF308) /* (PDC_DBGU) Transmit Pointer Register */
#define AT91C_DBGU_RNPR ((AT91_REG *) 	0xFFFFF310) /* (PDC_DBGU) Receive Next Pointer Register */
#define AT91C_DBGU_TNPR ((AT91_REG *) 	0xFFFFF318) /* (PDC_DBGU) Transmit Next Pointer Register */
/* ========== Register definition for DBGU peripheral ==========  */
#define AT91C_DBGU_EXID ((AT91_REG *) 	0xFFFFF244) /* (DBGU) Chip ID Extension Register */
#define AT91C_DBGU_THR  ((AT91_REG *) 	0xFFFFF21C) /* (DBGU) Transmitter Holding Register */
#define AT91C_DBGU_CSR  ((AT91_REG *) 	0xFFFFF214) /* (DBGU) Channel Status Register */
#define AT91C_DBGU_IDR  ((AT91_REG *) 	0xFFFFF20C) /* (DBGU) Interrupt Disable Register */
#define AT91C_DBGU_MR   ((AT91_REG *) 	0xFFFFF204) /* (DBGU) Mode Register */
#define AT91C_DBGU_FNTR ((AT91_REG *) 	0xFFFFF248) /* (DBGU) Force NTRST Register */
#define AT91C_DBGU_CIDR ((AT91_REG *) 	0xFFFFF240) /* (DBGU) Chip ID Register */
#define AT91C_DBGU_BRGR ((AT91_REG *) 	0xFFFFF220) /* (DBGU) Baud Rate Generator Register */
#define AT91C_DBGU_RHR  ((AT91_REG *) 	0xFFFFF218) /* (DBGU) Receiver Holding Register */
#define AT91C_DBGU_IMR  ((AT91_REG *) 	0xFFFFF210) /* (DBGU) Interrupt Mask Register */
#define AT91C_DBGU_IER  ((AT91_REG *) 	0xFFFFF208) /* (DBGU) Interrupt Enable Register */
#define AT91C_DBGU_CR   ((AT91_REG *) 	0xFFFFF200) /* (DBGU) Control Register */
/* ========== Register definition for AIC peripheral ==========  */
#define AT91C_AIC_ICCR  ((AT91_REG *) 	0xFFFFF128) /* (AIC) Interrupt Clear Command Register */
#define AT91C_AIC_IECR  ((AT91_REG *) 	0xFFFFF120) /* (AIC) Interrupt Enable Command Register */
#define AT91C_AIC_SMR   ((AT91_REG *) 	0xFFFFF000) /* (AIC) Source Mode Register */
#define AT91C_AIC_ISCR  ((AT91_REG *) 	0xFFFFF12C) /* (AIC) Interrupt Set Command Register */
#define AT91C_AIC_EOICR ((AT91_REG *) 	0xFFFFF130) /* (AIC) End of Interrupt Command Register */
#define AT91C_AIC_DCR   ((AT91_REG *) 	0xFFFFF138) /* (AIC) Debug Control Register (Protect) */
#define AT91C_AIC_FFER  ((AT91_REG *) 	0xFFFFF140) /* (AIC) Fast Forcing Enable Register */
#define AT91C_AIC_SVR   ((AT91_REG *) 	0xFFFFF080) /* (AIC) Source Vector Register */
#define AT91C_AIC_SPU   ((AT91_REG *) 	0xFFFFF134) /* (AIC) Spurious Vector Register */
#define AT91C_AIC_FFDR  ((AT91_REG *) 	0xFFFFF144) /* (AIC) Fast Forcing Disable Register */
#define AT91C_AIC_FVR   ((AT91_REG *) 	0xFFFFF104) /* (AIC) FIQ Vector Register */
#define AT91C_AIC_FFSR  ((AT91_REG *) 	0xFFFFF148) /* (AIC) Fast Forcing Status Register */
#define AT91C_AIC_IMR   ((AT91_REG *) 	0xFFFFF110) /* (AIC) Interrupt Mask Register */
#define AT91C_AIC_ISR   ((AT91_REG *) 	0xFFFFF108) /* (AIC) Interrupt Status Register */
#define AT91C_AIC_IVR   ((AT91_REG *) 	0xFFFFF100) /* (AIC) IRQ Vector Register */
#define AT91C_AIC_IDCR  ((AT91_REG *) 	0xFFFFF124) /* (AIC) Interrupt Disable Command Register */
#define AT91C_AIC_CISR  ((AT91_REG *) 	0xFFFFF114) /* (AIC) Core Interrupt Status Register */
#define AT91C_AIC_IPR   ((AT91_REG *) 	0xFFFFF10C) /* (AIC) Interrupt Pending Register */
/* ========== Register definition for PIOA peripheral ==========  */
#define AT91C_PIOA_IMR  ((AT91_REG *) 	0xFFFFF448) /* (PIOA) Interrupt Mask Register */
#define AT91C_PIOA_IER  ((AT91_REG *) 	0xFFFFF440) /* (PIOA) Interrupt Enable Register */
#define AT91C_PIOA_OWDR ((AT91_REG *) 	0xFFFFF4A4) /* (PIOA) Output Write Disable Register */
#define AT91C_PIOA_ISR  ((AT91_REG *) 	0xFFFFF44C) /* (PIOA) Interrupt Status Register */
#define AT91C_PIOA_PPUDR ((AT91_REG *) 	0xFFFFF460) /* (PIOA) Pull-up Disable Register */
#define AT91C_PIOA_MDSR ((AT91_REG *) 	0xFFFFF458) /* (PIOA) Multi-driver Status Register */
#define AT91C_PIOA_MDER ((AT91_REG *) 	0xFFFFF450) /* (PIOA) Multi-driver Enable Register */
#define AT91C_PIOA_PER  ((AT91_REG *) 	0xFFFFF400) /* (PIOA) PIO Enable Register */
#define AT91C_PIOA_PSR  ((AT91_REG *) 	0xFFFFF408) /* (PIOA) PIO Status Register */
#define AT91C_PIOA_OER  ((AT91_REG *) 	0xFFFFF410) /* (PIOA) Output Enable Register */
#define AT91C_PIOA_BSR  ((AT91_REG *) 	0xFFFFF474) /* (PIOA) Select B Register */
#define AT91C_PIOA_PPUER ((AT91_REG *) 	0xFFFFF464) /* (PIOA) Pull-up Enable Register */
#define AT91C_PIOA_MDDR ((AT91_REG *) 	0xFFFFF454) /* (PIOA) Multi-driver Disable Register */
#define AT91C_PIOA_PDR  ((AT91_REG *) 	0xFFFFF404) /* (PIOA) PIO Disable Register */
#define AT91C_PIOA_ODR  ((AT91_REG *) 	0xFFFFF414) /* (PIOA) Output Disable Registerr */
#define AT91C_PIOA_IFDR ((AT91_REG *) 	0xFFFFF424) /* (PIOA) Input Filter Disable Register */
#define AT91C_PIOA_ABSR ((AT91_REG *) 	0xFFFFF478) /* (PIOA) AB Select Status Register */
#define AT91C_PIOA_ASR  ((AT91_REG *) 	0xFFFFF470) /* (PIOA) Select A Register */
#define AT91C_PIOA_PPUSR ((AT91_REG *) 	0xFFFFF468) /* (PIOA) Pull-up Status Register */
#define AT91C_PIOA_ODSR ((AT91_REG *) 	0xFFFFF438) /* (PIOA) Output Data Status Register */
#define AT91C_PIOA_SODR ((AT91_REG *) 	0xFFFFF430) /* (PIOA) Set Output Data Register */
#define AT91C_PIOA_IFSR ((AT91_REG *) 	0xFFFFF428) /* (PIOA) Input Filter Status Register */
#define AT91C_PIOA_IFER ((AT91_REG *) 	0xFFFFF420) /* (PIOA) Input Filter Enable Register */
#define AT91C_PIOA_OSR  ((AT91_REG *) 	0xFFFFF418) /* (PIOA) Output Status Register */
#define AT91C_PIOA_IDR  ((AT91_REG *) 	0xFFFFF444) /* (PIOA) Interrupt Disable Register */
#define AT91C_PIOA_PDSR ((AT91_REG *) 	0xFFFFF43C) /* (PIOA) Pin Data Status Register */
#define AT91C_PIOA_CODR ((AT91_REG *) 	0xFFFFF434) /* (PIOA) Clear Output Data Register */
#define AT91C_PIOA_OWSR ((AT91_REG *) 	0xFFFFF4A8) /* (PIOA) Output Write Status Register */
#define AT91C_PIOA_OWER ((AT91_REG *) 	0xFFFFF4A0) /* (PIOA) Output Write Enable Register */
/* ========== Register definition for PIOB peripheral ==========  */
#define AT91C_PIOB_OWSR ((AT91_REG *) 	0xFFFFF6A8) /* (PIOB) Output Write Status Register */
#define AT91C_PIOB_PPUSR ((AT91_REG *) 	0xFFFFF668) /* (PIOB) Pull-up Status Register */
#define AT91C_PIOB_PPUDR ((AT91_REG *) 	0xFFFFF660) /* (PIOB) Pull-up Disable Register */
#define AT91C_PIOB_MDSR ((AT91_REG *) 	0xFFFFF658) /* (PIOB) Multi-driver Status Register */
#define AT91C_PIOB_MDER ((AT91_REG *) 	0xFFFFF650) /* (PIOB) Multi-driver Enable Register */
#define AT91C_PIOB_IMR  ((AT91_REG *) 	0xFFFFF648) /* (PIOB) Interrupt Mask Register */
#define AT91C_PIOB_OSR  ((AT91_REG *) 	0xFFFFF618) /* (PIOB) Output Status Register */
#define AT91C_PIOB_OER  ((AT91_REG *) 	0xFFFFF610) /* (PIOB) Output Enable Register */
#define AT91C_PIOB_PSR  ((AT91_REG *) 	0xFFFFF608) /* (PIOB) PIO Status Register */
#define AT91C_PIOB_PER  ((AT91_REG *) 	0xFFFFF600) /* (PIOB) PIO Enable Register */
#define AT91C_PIOB_BSR  ((AT91_REG *) 	0xFFFFF674) /* (PIOB) Select B Register */
#define AT91C_PIOB_PPUER ((AT91_REG *) 	0xFFFFF664) /* (PIOB) Pull-up Enable Register */
#define AT91C_PIOB_IFDR ((AT91_REG *) 	0xFFFFF624) /* (PIOB) Input Filter Disable Register */
#define AT91C_PIOB_ODR  ((AT91_REG *) 	0xFFFFF614) /* (PIOB) Output Disable Registerr */
#define AT91C_PIOB_ABSR ((AT91_REG *) 	0xFFFFF678) /* (PIOB) AB Select Status Register */
#define AT91C_PIOB_ASR  ((AT91_REG *) 	0xFFFFF670) /* (PIOB) Select A Register */
#define AT91C_PIOB_IFER ((AT91_REG *) 	0xFFFFF620) /* (PIOB) Input Filter Enable Register */
#define AT91C_PIOB_IFSR ((AT91_REG *) 	0xFFFFF628) /* (PIOB) Input Filter Status Register */
#define AT91C_PIOB_SODR ((AT91_REG *) 	0xFFFFF630) /* (PIOB) Set Output Data Register */
#define AT91C_PIOB_ODSR ((AT91_REG *) 	0xFFFFF638) /* (PIOB) Output Data Status Register */
#define AT91C_PIOB_CODR ((AT91_REG *) 	0xFFFFF634) /* (PIOB) Clear Output Data Register */
#define AT91C_PIOB_PDSR ((AT91_REG *) 	0xFFFFF63C) /* (PIOB) Pin Data Status Register */
#define AT91C_PIOB_OWER ((AT91_REG *) 	0xFFFFF6A0) /* (PIOB) Output Write Enable Register */
#define AT91C_PIOB_IER  ((AT91_REG *) 	0xFFFFF640) /* (PIOB) Interrupt Enable Register */
#define AT91C_PIOB_OWDR ((AT91_REG *) 	0xFFFFF6A4) /* (PIOB) Output Write Disable Register */
#define AT91C_PIOB_MDDR ((AT91_REG *) 	0xFFFFF654) /* (PIOB) Multi-driver Disable Register */
#define AT91C_PIOB_ISR  ((AT91_REG *) 	0xFFFFF64C) /* (PIOB) Interrupt Status Register */
#define AT91C_PIOB_IDR  ((AT91_REG *) 	0xFFFFF644) /* (PIOB) Interrupt Disable Register */
#define AT91C_PIOB_PDR  ((AT91_REG *) 	0xFFFFF604) /* (PIOB) PIO Disable Register */
/* ========== Register definition for PIOC peripheral ==========  */
#define AT91C_PIOC_IFDR ((AT91_REG *) 	0xFFFFF824) /* (PIOC) Input Filter Disable Register */
#define AT91C_PIOC_ODR  ((AT91_REG *) 	0xFFFFF814) /* (PIOC) Output Disable Registerr */
#define AT91C_PIOC_ABSR ((AT91_REG *) 	0xFFFFF878) /* (PIOC) AB Select Status Register */
#define AT91C_PIOC_SODR ((AT91_REG *) 	0xFFFFF830) /* (PIOC) Set Output Data Register */
#define AT91C_PIOC_IFSR ((AT91_REG *) 	0xFFFFF828) /* (PIOC) Input Filter Status Register */
#define AT91C_PIOC_CODR ((AT91_REG *) 	0xFFFFF834) /* (PIOC) Clear Output Data Register */
#define AT91C_PIOC_ODSR ((AT91_REG *) 	0xFFFFF838) /* (PIOC) Output Data Status Register */
#define AT91C_PIOC_IER  ((AT91_REG *) 	0xFFFFF840) /* (PIOC) Interrupt Enable Register */
#define AT91C_PIOC_IMR  ((AT91_REG *) 	0xFFFFF848) /* (PIOC) Interrupt Mask Register */
#define AT91C_PIOC_OWDR ((AT91_REG *) 	0xFFFFF8A4) /* (PIOC) Output Write Disable Register */
#define AT91C_PIOC_MDDR ((AT91_REG *) 	0xFFFFF854) /* (PIOC) Multi-driver Disable Register */
#define AT91C_PIOC_PDSR ((AT91_REG *) 	0xFFFFF83C) /* (PIOC) Pin Data Status Register */
#define AT91C_PIOC_IDR  ((AT91_REG *) 	0xFFFFF844) /* (PIOC) Interrupt Disable Register */
#define AT91C_PIOC_ISR  ((AT91_REG *) 	0xFFFFF84C) /* (PIOC) Interrupt Status Register */
#define AT91C_PIOC_PDR  ((AT91_REG *) 	0xFFFFF804) /* (PIOC) PIO Disable Register */
#define AT91C_PIOC_OWSR ((AT91_REG *) 	0xFFFFF8A8) /* (PIOC) Output Write Status Register */
#define AT91C_PIOC_OWER ((AT91_REG *) 	0xFFFFF8A0) /* (PIOC) Output Write Enable Register */
#define AT91C_PIOC_ASR  ((AT91_REG *) 	0xFFFFF870) /* (PIOC) Select A Register */
#define AT91C_PIOC_PPUSR ((AT91_REG *) 	0xFFFFF868) /* (PIOC) Pull-up Status Register */
#define AT91C_PIOC_PPUDR ((AT91_REG *) 	0xFFFFF860) /* (PIOC) Pull-up Disable Register */
#define AT91C_PIOC_MDSR ((AT91_REG *) 	0xFFFFF858) /* (PIOC) Multi-driver Status Register */
#define AT91C_PIOC_MDER ((AT91_REG *) 	0xFFFFF850) /* (PIOC) Multi-driver Enable Register */
#define AT91C_PIOC_IFER ((AT91_REG *) 	0xFFFFF820) /* (PIOC) Input Filter Enable Register */
#define AT91C_PIOC_OSR  ((AT91_REG *) 	0xFFFFF818) /* (PIOC) Output Status Register */
#define AT91C_PIOC_OER  ((AT91_REG *) 	0xFFFFF810) /* (PIOC) Output Enable Register */
#define AT91C_PIOC_PSR  ((AT91_REG *) 	0xFFFFF808) /* (PIOC) PIO Status Register */
#define AT91C_PIOC_PER  ((AT91_REG *) 	0xFFFFF800) /* (PIOC) PIO Enable Register */
#define AT91C_PIOC_BSR  ((AT91_REG *) 	0xFFFFF874) /* (PIOC) Select B Register */
#define AT91C_PIOC_PPUER ((AT91_REG *) 	0xFFFFF864) /* (PIOC) Pull-up Enable Register */
/* ========== Register definition for CKGR peripheral ==========  */
#define AT91C_CKGR_PLLBR ((AT91_REG *) 	0xFFFFFC2C) /* (CKGR) PLL B Register */
#define AT91C_CKGR_MCFR ((AT91_REG *) 	0xFFFFFC24) /* (CKGR) Main Clock  Frequency Register */
#define AT91C_CKGR_PLLAR ((AT91_REG *) 	0xFFFFFC28) /* (CKGR) PLL A Register */
#define AT91C_CKGR_MOR  ((AT91_REG *) 	0xFFFFFC20) /* (CKGR) Main Oscillator Register */
/* ========== Register definition for PMC peripheral ==========  */
#define AT91C_PMC_SCSR  ((AT91_REG *) 	0xFFFFFC08) /* (PMC) System Clock Status Register */
#define AT91C_PMC_SCER  ((AT91_REG *) 	0xFFFFFC00) /* (PMC) System Clock Enable Register */
#define AT91C_PMC_IMR   ((AT91_REG *) 	0xFFFFFC6C) /* (PMC) Interrupt Mask Register */
#define AT91C_PMC_IDR   ((AT91_REG *) 	0xFFFFFC64) /* (PMC) Interrupt Disable Register */
#define AT91C_PMC_PCDR  ((AT91_REG *) 	0xFFFFFC14) /* (PMC) Peripheral Clock Disable Register */
#define AT91C_PMC_SCDR  ((AT91_REG *) 	0xFFFFFC04) /* (PMC) System Clock Disable Register */
#define AT91C_PMC_SR    ((AT91_REG *) 	0xFFFFFC68) /* (PMC) Status Register */
#define AT91C_PMC_IER   ((AT91_REG *) 	0xFFFFFC60) /* (PMC) Interrupt Enable Register */
#define AT91C_PMC_MCKR  ((AT91_REG *) 	0xFFFFFC30) /* (PMC) Master Clock Register */
#define AT91C_PMC_PLLAR ((AT91_REG *) 	0xFFFFFC28) /* (PMC) PLL A Register */
#define AT91C_PMC_MOR   ((AT91_REG *) 	0xFFFFFC20) /* (PMC) Main Oscillator Register */
#define AT91C_PMC_PCER  ((AT91_REG *) 	0xFFFFFC10) /* (PMC) Peripheral Clock Enable Register */
#define AT91C_PMC_PCSR  ((AT91_REG *) 	0xFFFFFC18) /* (PMC) Peripheral Clock Status Register */
#define AT91C_PMC_PLLBR ((AT91_REG *) 	0xFFFFFC2C) /* (PMC) PLL B Register */
#define AT91C_PMC_MCFR  ((AT91_REG *) 	0xFFFFFC24) /* (PMC) Main Clock  Frequency Register */
#define AT91C_PMC_PCKR  ((AT91_REG *) 	0xFFFFFC40) /* (PMC) Programmable Clock Register */
/* ========== Register definition for RSTC peripheral ==========  */
#define AT91C_RSTC_RSR  ((AT91_REG *) 	0xFFFFFD04) /* (RSTC) Reset Status Register */
#define AT91C_RSTC_RMR  ((AT91_REG *) 	0xFFFFFD08) /* (RSTC) Reset Mode Register */
#define AT91C_RSTC_RCR  ((AT91_REG *) 	0xFFFFFD00) /* (RSTC) Reset Control Register */
/* ========== Register definition for SHDWC peripheral ==========  */
#define AT91C_SHDWC_SHMR ((AT91_REG *) 	0xFFFFFD14) /* (SHDWC) Shut Down Mode Register */
#define AT91C_SHDWC_SHSR ((AT91_REG *) 	0xFFFFFD18) /* (SHDWC) Shut Down Status Register */
#define AT91C_SHDWC_SHCR ((AT91_REG *) 	0xFFFFFD10) /* (SHDWC) Shut Down Control Register */
/* ========== Register definition for RTTC peripheral ==========  */
#define AT91C_RTTC_RTSR ((AT91_REG *) 	0xFFFFFD2C) /* (RTTC) Real-time Status Register */
#define AT91C_RTTC_RTAR ((AT91_REG *) 	0xFFFFFD24) /* (RTTC) Real-time Alarm Register */
#define AT91C_RTTC_RTVR ((AT91_REG *) 	0xFFFFFD28) /* (RTTC) Real-time Value Register */
#define AT91C_RTTC_RTMR ((AT91_REG *) 	0xFFFFFD20) /* (RTTC) Real-time Mode Register */
/* ========== Register definition for PITC peripheral ==========  */
#define AT91C_PITC_PIIR ((AT91_REG *) 	0xFFFFFD3C) /* (PITC) Period Interval Image Register */
#define AT91C_PITC_PISR ((AT91_REG *) 	0xFFFFFD34) /* (PITC) Period Interval Status Register */
#define AT91C_PITC_PIVR ((AT91_REG *) 	0xFFFFFD38) /* (PITC) Period Interval Value Register */
#define AT91C_PITC_PIMR ((AT91_REG *) 	0xFFFFFD30) /* (PITC) Period Interval Mode Register */
/* ========== Register definition for WDTC peripheral ==========  */
#define AT91C_WDTC_WDMR ((AT91_REG *) 	0xFFFFFD44) /* (WDTC) Watchdog Mode Register */
#define AT91C_WDTC_WDSR ((AT91_REG *) 	0xFFFFFD48) /* (WDTC) Watchdog Status Register */
#define AT91C_WDTC_WDCR ((AT91_REG *) 	0xFFFFFD40) /* (WDTC) Watchdog Control Register */
/* ========== Register definition for TC0 peripheral ==========  */
#define AT91C_TC0_IMR   ((AT91_REG *) 	0xFFFA002C) /* (TC0) Interrupt Mask Register */
#define AT91C_TC0_IER   ((AT91_REG *) 	0xFFFA0024) /* (TC0) Interrupt Enable Register */
#define AT91C_TC0_RC    ((AT91_REG *) 	0xFFFA001C) /* (TC0) Register C */
#define AT91C_TC0_RA    ((AT91_REG *) 	0xFFFA0014) /* (TC0) Register A */
#define AT91C_TC0_CMR   ((AT91_REG *) 	0xFFFA0004) /* (TC0) Channel Mode Register (Capture Mode / Waveform Mode) */
#define AT91C_TC0_IDR   ((AT91_REG *) 	0xFFFA0028) /* (TC0) Interrupt Disable Register */
#define AT91C_TC0_SR    ((AT91_REG *) 	0xFFFA0020) /* (TC0) Status Register */
#define AT91C_TC0_RB    ((AT91_REG *) 	0xFFFA0018) /* (TC0) Register B */
#define AT91C_TC0_CV    ((AT91_REG *) 	0xFFFA0010) /* (TC0) Counter Value */
#define AT91C_TC0_CCR   ((AT91_REG *) 	0xFFFA0000) /* (TC0) Channel Control Register */
/* ========== Register definition for TC1 peripheral ==========  */
#define AT91C_TC1_IMR   ((AT91_REG *) 	0xFFFA006C) /* (TC1) Interrupt Mask Register */
#define AT91C_TC1_IER   ((AT91_REG *) 	0xFFFA0064) /* (TC1) Interrupt Enable Register */
#define AT91C_TC1_RC    ((AT91_REG *) 	0xFFFA005C) /* (TC1) Register C */
#define AT91C_TC1_RA    ((AT91_REG *) 	0xFFFA0054) /* (TC1) Register A */
#define AT91C_TC1_CMR   ((AT91_REG *) 	0xFFFA0044) /* (TC1) Channel Mode Register (Capture Mode / Waveform Mode) */
#define AT91C_TC1_IDR   ((AT91_REG *) 	0xFFFA0068) /* (TC1) Interrupt Disable Register */
#define AT91C_TC1_SR    ((AT91_REG *) 	0xFFFA0060) /* (TC1) Status Register */
#define AT91C_TC1_RB    ((AT91_REG *) 	0xFFFA0058) /* (TC1) Register B */
#define AT91C_TC1_CV    ((AT91_REG *) 	0xFFFA0050) /* (TC1) Counter Value */
#define AT91C_TC1_CCR   ((AT91_REG *) 	0xFFFA0040) /* (TC1) Channel Control Register */
/* ========== Register definition for TC2 peripheral ==========  */
#define AT91C_TC2_IMR   ((AT91_REG *) 	0xFFFA00AC) /* (TC2) Interrupt Mask Register */
#define AT91C_TC2_IER   ((AT91_REG *) 	0xFFFA00A4) /* (TC2) Interrupt Enable Register */
#define AT91C_TC2_RC    ((AT91_REG *) 	0xFFFA009C) /* (TC2) Register C */
#define AT91C_TC2_RA    ((AT91_REG *) 	0xFFFA0094) /* (TC2) Register A */
#define AT91C_TC2_CMR   ((AT91_REG *) 	0xFFFA0084) /* (TC2) Channel Mode Register (Capture Mode / Waveform Mode) */
#define AT91C_TC2_IDR   ((AT91_REG *) 	0xFFFA00A8) /* (TC2) Interrupt Disable Register */
#define AT91C_TC2_SR    ((AT91_REG *) 	0xFFFA00A0) /* (TC2) Status Register */
#define AT91C_TC2_RB    ((AT91_REG *) 	0xFFFA0098) /* (TC2) Register B */
#define AT91C_TC2_CV    ((AT91_REG *) 	0xFFFA0090) /* (TC2) Counter Value */
#define AT91C_TC2_CCR   ((AT91_REG *) 	0xFFFA0080) /* (TC2) Channel Control Register */
/* ========== Register definition for TC3 peripheral ==========  */
#define AT91C_TC3_IMR   ((AT91_REG *) 	0xFFFDC02C) /* (TC3) Interrupt Mask Register */
#define AT91C_TC3_IER   ((AT91_REG *) 	0xFFFDC024) /* (TC3) Interrupt Enable Register */
#define AT91C_TC3_RC    ((AT91_REG *) 	0xFFFDC01C) /* (TC3) Register C */
#define AT91C_TC3_RA    ((AT91_REG *) 	0xFFFDC014) /* (TC3) Register A */
#define AT91C_TC3_CMR   ((AT91_REG *) 	0xFFFDC004) /* (TC3) Channel Mode Register (Capture Mode / Waveform Mode) */
#define AT91C_TC3_IDR   ((AT91_REG *) 	0xFFFDC028) /* (TC3) Interrupt Disable Register */
#define AT91C_TC3_SR    ((AT91_REG *) 	0xFFFDC020) /* (TC3) Status Register */
#define AT91C_TC3_RB    ((AT91_REG *) 	0xFFFDC018) /* (TC3) Register B */
#define AT91C_TC3_CV    ((AT91_REG *) 	0xFFFDC010) /* (TC3) Counter Value */
#define AT91C_TC3_CCR   ((AT91_REG *) 	0xFFFDC000) /* (TC3) Channel Control Register */
/* ========== Register definition for TC4 peripheral ==========  */
#define AT91C_TC4_IMR   ((AT91_REG *) 	0xFFFDC06C) /* (TC4) Interrupt Mask Register */
#define AT91C_TC4_IER   ((AT91_REG *) 	0xFFFDC064) /* (TC4) Interrupt Enable Register */
#define AT91C_TC4_RC    ((AT91_REG *) 	0xFFFDC05C) /* (TC4) Register C */
#define AT91C_TC4_RA    ((AT91_REG *) 	0xFFFDC054) /* (TC4) Register A */
#define AT91C_TC4_CMR   ((AT91_REG *) 	0xFFFDC044) /* (TC4) Channel Mode Register (Capture Mode / Waveform Mode) */
#define AT91C_TC4_IDR   ((AT91_REG *) 	0xFFFDC068) /* (TC4) Interrupt Disable Register */
#define AT91C_TC4_SR    ((AT91_REG *) 	0xFFFDC060) /* (TC4) Status Register */
#define AT91C_TC4_RB    ((AT91_REG *) 	0xFFFDC058) /* (TC4) Register B */
#define AT91C_TC4_CV    ((AT91_REG *) 	0xFFFDC050) /* (TC4) Counter Value */
#define AT91C_TC4_CCR   ((AT91_REG *) 	0xFFFDC040) /* (TC4) Channel Control Register */
/* ========== Register definition for TC5 peripheral ==========  */
#define AT91C_TC5_IDR   ((AT91_REG *) 	0xFFFDC0A8) /* (TC5) Interrupt Disable Register */
#define AT91C_TC5_CMR   ((AT91_REG *) 	0xFFFDC084) /* (TC5) Channel Mode Register (Capture Mode / Waveform Mode) */
#define AT91C_TC5_RB    ((AT91_REG *) 	0xFFFDC098) /* (TC5) Register B */
#define AT91C_TC5_CV    ((AT91_REG *) 	0xFFFDC090) /* (TC5) Counter Value */
#define AT91C_TC5_CCR   ((AT91_REG *) 	0xFFFDC080) /* (TC5) Channel Control Register */
#define AT91C_TC5_SR    ((AT91_REG *) 	0xFFFDC0A0) /* (TC5) Status Register */
#define AT91C_TC5_RA    ((AT91_REG *) 	0xFFFDC094) /* (TC5) Register A */
#define AT91C_TC5_RC    ((AT91_REG *) 	0xFFFDC09C) /* (TC5) Register C */
#define AT91C_TC5_IMR   ((AT91_REG *) 	0xFFFDC0AC) /* (TC5) Interrupt Mask Register */
#define AT91C_TC5_IER   ((AT91_REG *) 	0xFFFDC0A4) /* (TC5) Interrupt Enable Register */
/* ========== Register definition for TCB0 peripheral ==========  */
#define AT91C_TCB0_BMR  ((AT91_REG *) 	0xFFFA00C4) /* (TCB0) TC Block Mode Register */
#define AT91C_TCB0_BCR  ((AT91_REG *) 	0xFFFA00C0) /* (TCB0) TC Block Control Register */
/* ========== Register definition for TCB1 peripheral ==========  */
#define AT91C_TCB1_BCR  ((AT91_REG *) 	0xFFFDC0C0) /* (TCB1) TC Block Control Register */
#define AT91C_TCB1_BMR  ((AT91_REG *) 	0xFFFDC0C4) /* (TCB1) TC Block Mode Register */
/* ========== Register definition for PDC_US0 peripheral ==========  */
#define AT91C_US0_TNCR  ((AT91_REG *) 	0xFFFB011C) /* (PDC_US0) Transmit Next Counter Register */
#define AT91C_US0_RNCR  ((AT91_REG *) 	0xFFFB0114) /* (PDC_US0) Receive Next Counter Register */
#define AT91C_US0_TCR   ((AT91_REG *) 	0xFFFB010C) /* (PDC_US0) Transmit Counter Register */
#define AT91C_US0_RCR   ((AT91_REG *) 	0xFFFB0104) /* (PDC_US0) Receive Counter Register */
#define AT91C_US0_PTCR  ((AT91_REG *) 	0xFFFB0120) /* (PDC_US0) PDC Transfer Control Register */
#define AT91C_US0_TNPR  ((AT91_REG *) 	0xFFFB0118) /* (PDC_US0) Transmit Next Pointer Register */
#define AT91C_US0_RNPR  ((AT91_REG *) 	0xFFFB0110) /* (PDC_US0) Receive Next Pointer Register */
#define AT91C_US0_PTSR  ((AT91_REG *) 	0xFFFB0124) /* (PDC_US0) PDC Transfer Status Register */
#define AT91C_US0_RPR   ((AT91_REG *) 	0xFFFB0100) /* (PDC_US0) Receive Pointer Register */
#define AT91C_US0_TPR   ((AT91_REG *) 	0xFFFB0108) /* (PDC_US0) Transmit Pointer Register */
/* ========== Register definition for US0 peripheral ==========  */
#define AT91C_US0_IF    ((AT91_REG *) 	0xFFFB004C) /* (US0) IRDA_FILTER Register */
#define AT91C_US0_NER   ((AT91_REG *) 	0xFFFB0044) /* (US0) Nb Errors Register */
#define AT91C_US0_RTOR  ((AT91_REG *) 	0xFFFB0024) /* (US0) Receiver Time-out Register */
#define AT91C_US0_THR   ((AT91_REG *) 	0xFFFB001C) /* (US0) Transmitter Holding Register */
#define AT91C_US0_CSR   ((AT91_REG *) 	0xFFFB0014) /* (US0) Channel Status Register */
#define AT91C_US0_IDR   ((AT91_REG *) 	0xFFFB000C) /* (US0) Interrupt Disable Register */
#define AT91C_US0_MR    ((AT91_REG *) 	0xFFFB0004) /* (US0) Mode Register */
#define AT91C_US0_FIDI  ((AT91_REG *) 	0xFFFB0040) /* (US0) FI_DI_Ratio Register */
#define AT91C_US0_TTGR  ((AT91_REG *) 	0xFFFB0028) /* (US0) Transmitter Time-guard Register */
#define AT91C_US0_BRGR  ((AT91_REG *) 	0xFFFB0020) /* (US0) Baud Rate Generator Register */
#define AT91C_US0_RHR   ((AT91_REG *) 	0xFFFB0018) /* (US0) Receiver Holding Register */
#define AT91C_US0_IMR   ((AT91_REG *) 	0xFFFB0010) /* (US0) Interrupt Mask Register */
#define AT91C_US0_IER   ((AT91_REG *) 	0xFFFB0008) /* (US0) Interrupt Enable Register */
#define AT91C_US0_CR    ((AT91_REG *) 	0xFFFB0000) /* (US0) Control Register */
/* ========== Register definition for PDC_US1 peripheral ==========  */
#define AT91C_US1_PTCR  ((AT91_REG *) 	0xFFFB4120) /* (PDC_US1) PDC Transfer Control Register */
#define AT91C_US1_TNPR  ((AT91_REG *) 	0xFFFB4118) /* (PDC_US1) Transmit Next Pointer Register */
#define AT91C_US1_RNPR  ((AT91_REG *) 	0xFFFB4110) /* (PDC_US1) Receive Next Pointer Register */
#define AT91C_US1_TPR   ((AT91_REG *) 	0xFFFB4108) /* (PDC_US1) Transmit Pointer Register */
#define AT91C_US1_RPR   ((AT91_REG *) 	0xFFFB4100) /* (PDC_US1) Receive Pointer Register */
#define AT91C_US1_PTSR  ((AT91_REG *) 	0xFFFB4124) /* (PDC_US1) PDC Transfer Status Register */
#define AT91C_US1_TNCR  ((AT91_REG *) 	0xFFFB411C) /* (PDC_US1) Transmit Next Counter Register */
#define AT91C_US1_RNCR  ((AT91_REG *) 	0xFFFB4114) /* (PDC_US1) Receive Next Counter Register */
#define AT91C_US1_TCR   ((AT91_REG *) 	0xFFFB410C) /* (PDC_US1) Transmit Counter Register */
#define AT91C_US1_RCR   ((AT91_REG *) 	0xFFFB4104) /* (PDC_US1) Receive Counter Register */
/* ========== Register definition for US1 peripheral ==========  */
#define AT91C_US1_FIDI  ((AT91_REG *) 	0xFFFB4040) /* (US1) FI_DI_Ratio Register */
#define AT91C_US1_TTGR  ((AT91_REG *) 	0xFFFB4028) /* (US1) Transmitter Time-guard Register */
#define AT91C_US1_BRGR  ((AT91_REG *) 	0xFFFB4020) /* (US1) Baud Rate Generator Register */
#define AT91C_US1_RHR   ((AT91_REG *) 	0xFFFB4018) /* (US1) Receiver Holding Register */
#define AT91C_US1_IMR   ((AT91_REG *) 	0xFFFB4010) /* (US1) Interrupt Mask Register */
#define AT91C_US1_IER   ((AT91_REG *) 	0xFFFB4008) /* (US1) Interrupt Enable Register */
#define AT91C_US1_CR    ((AT91_REG *) 	0xFFFB4000) /* (US1) Control Register */
#define AT91C_US1_IF    ((AT91_REG *) 	0xFFFB404C) /* (US1) IRDA_FILTER Register */
#define AT91C_US1_NER   ((AT91_REG *) 	0xFFFB4044) /* (US1) Nb Errors Register */
#define AT91C_US1_RTOR  ((AT91_REG *) 	0xFFFB4024) /* (US1) Receiver Time-out Register */
#define AT91C_US1_THR   ((AT91_REG *) 	0xFFFB401C) /* (US1) Transmitter Holding Register */
#define AT91C_US1_CSR   ((AT91_REG *) 	0xFFFB4014) /* (US1) Channel Status Register */
#define AT91C_US1_IDR   ((AT91_REG *) 	0xFFFB400C) /* (US1) Interrupt Disable Register */
#define AT91C_US1_MR    ((AT91_REG *) 	0xFFFB4004) /* (US1) Mode Register */
/* ========== Register definition for PDC_US2 peripheral ==========  */
#define AT91C_US2_PTSR  ((AT91_REG *) 	0xFFFB8124) /* (PDC_US2) PDC Transfer Status Register */
#define AT91C_US2_TNCR  ((AT91_REG *) 	0xFFFB811C) /* (PDC_US2) Transmit Next Counter Register */
#define AT91C_US2_RNCR  ((AT91_REG *) 	0xFFFB8114) /* (PDC_US2) Receive Next Counter Register */
#define AT91C_US2_TCR   ((AT91_REG *) 	0xFFFB810C) /* (PDC_US2) Transmit Counter Register */
#define AT91C_US2_RCR   ((AT91_REG *) 	0xFFFB8104) /* (PDC_US2) Receive Counter Register */
#define AT91C_US2_PTCR  ((AT91_REG *) 	0xFFFB8120) /* (PDC_US2) PDC Transfer Control Register */
#define AT91C_US2_TNPR  ((AT91_REG *) 	0xFFFB8118) /* (PDC_US2) Transmit Next Pointer Register */
#define AT91C_US2_RNPR  ((AT91_REG *) 	0xFFFB8110) /* (PDC_US2) Receive Next Pointer Register */
#define AT91C_US2_TPR   ((AT91_REG *) 	0xFFFB8108) /* (PDC_US2) Transmit Pointer Register */
#define AT91C_US2_RPR   ((AT91_REG *) 	0xFFFB8100) /* (PDC_US2) Receive Pointer Register */
/* ========== Register definition for US2 peripheral ==========  */
#define AT91C_US2_FIDI  ((AT91_REG *) 	0xFFFB8040) /* (US2) FI_DI_Ratio Register */
#define AT91C_US2_TTGR  ((AT91_REG *) 	0xFFFB8028) /* (US2) Transmitter Time-guard Register */
#define AT91C_US2_BRGR  ((AT91_REG *) 	0xFFFB8020) /* (US2) Baud Rate Generator Register */
#define AT91C_US2_RHR   ((AT91_REG *) 	0xFFFB8018) /* (US2) Receiver Holding Register */
#define AT91C_US2_IMR   ((AT91_REG *) 	0xFFFB8010) /* (US2) Interrupt Mask Register */
#define AT91C_US2_IER   ((AT91_REG *) 	0xFFFB8008) /* (US2) Interrupt Enable Register */
#define AT91C_US2_CR    ((AT91_REG *) 	0xFFFB8000) /* (US2) Control Register */
#define AT91C_US2_IF    ((AT91_REG *) 	0xFFFB804C) /* (US2) IRDA_FILTER Register */
#define AT91C_US2_NER   ((AT91_REG *) 	0xFFFB8044) /* (US2) Nb Errors Register */
#define AT91C_US2_RTOR  ((AT91_REG *) 	0xFFFB8024) /* (US2) Receiver Time-out Register */
#define AT91C_US2_THR   ((AT91_REG *) 	0xFFFB801C) /* (US2) Transmitter Holding Register */
#define AT91C_US2_CSR   ((AT91_REG *) 	0xFFFB8014) /* (US2) Channel Status Register */
#define AT91C_US2_IDR   ((AT91_REG *) 	0xFFFB800C) /* (US2) Interrupt Disable Register */
#define AT91C_US2_MR    ((AT91_REG *) 	0xFFFB8004) /* (US2) Mode Register */
/* ========== Register definition for PDC_US3 peripheral ==========  */
#define AT91C_US3_PTCR  ((AT91_REG *) 	0xFFFD0120) /* (PDC_US3) PDC Transfer Control Register */
#define AT91C_US3_TNPR  ((AT91_REG *) 	0xFFFD0118) /* (PDC_US3) Transmit Next Pointer Register */
#define AT91C_US3_RNPR  ((AT91_REG *) 	0xFFFD0110) /* (PDC_US3) Receive Next Pointer Register */
#define AT91C_US3_TPR   ((AT91_REG *) 	0xFFFD0108) /* (PDC_US3) Transmit Pointer Register */
#define AT91C_US3_RPR   ((AT91_REG *) 	0xFFFD0100) /* (PDC_US3) Receive Pointer Register */
#define AT91C_US3_PTSR  ((AT91_REG *) 	0xFFFD0124) /* (PDC_US3) PDC Transfer Status Register */
#define AT91C_US3_TNCR  ((AT91_REG *) 	0xFFFD011C) /* (PDC_US3) Transmit Next Counter Register */
#define AT91C_US3_RNCR  ((AT91_REG *) 	0xFFFD0114) /* (PDC_US3) Receive Next Counter Register */
#define AT91C_US3_TCR   ((AT91_REG *) 	0xFFFD010C) /* (PDC_US3) Transmit Counter Register */
#define AT91C_US3_RCR   ((AT91_REG *) 	0xFFFD0104) /* (PDC_US3) Receive Counter Register */
/* ========== Register definition for US3 peripheral ==========  */
#define AT91C_US3_IF    ((AT91_REG *) 	0xFFFD004C) /* (US3) IRDA_FILTER Register */
#define AT91C_US3_NER   ((AT91_REG *) 	0xFFFD0044) /* (US3) Nb Errors Register */
#define AT91C_US3_RTOR  ((AT91_REG *) 	0xFFFD0024) /* (US3) Receiver Time-out Register */
#define AT91C_US3_THR   ((AT91_REG *) 	0xFFFD001C) /* (US3) Transmitter Holding Register */
#define AT91C_US3_CSR   ((AT91_REG *) 	0xFFFD0014) /* (US3) Channel Status Register */
#define AT91C_US3_IDR   ((AT91_REG *) 	0xFFFD000C) /* (US3) Interrupt Disable Register */
#define AT91C_US3_MR    ((AT91_REG *) 	0xFFFD0004) /* (US3) Mode Register */
#define AT91C_US3_FIDI  ((AT91_REG *) 	0xFFFD0040) /* (US3) FI_DI_Ratio Register */
#define AT91C_US3_TTGR  ((AT91_REG *) 	0xFFFD0028) /* (US3) Transmitter Time-guard Register */
#define AT91C_US3_BRGR  ((AT91_REG *) 	0xFFFD0020) /* (US3) Baud Rate Generator Register */
#define AT91C_US3_RHR   ((AT91_REG *) 	0xFFFD0018) /* (US3) Receiver Holding Register */
#define AT91C_US3_IMR   ((AT91_REG *) 	0xFFFD0010) /* (US3) Interrupt Mask Register */
#define AT91C_US3_IER   ((AT91_REG *) 	0xFFFD0008) /* (US3) Interrupt Enable Register */
#define AT91C_US3_CR    ((AT91_REG *) 	0xFFFD0000) /* (US3) Control Register */
/* ========== Register definition for PDC_US4 peripheral ==========  */
#define AT91C_US4_PTCR  ((AT91_REG *) 	0xFFFD4120) /* (PDC_US4) PDC Transfer Control Register */
#define AT91C_US4_TNPR  ((AT91_REG *) 	0xFFFD4118) /* (PDC_US4) Transmit Next Pointer Register */
#define AT91C_US4_RNPR  ((AT91_REG *) 	0xFFFD4110) /* (PDC_US4) Receive Next Pointer Register */
#define AT91C_US4_TPR   ((AT91_REG *) 	0xFFFD4108) /* (PDC_US4) Transmit Pointer Register */
#define AT91C_US4_RPR   ((AT91_REG *) 	0xFFFD4100) /* (PDC_US4) Receive Pointer Register */
#define AT91C_US4_PTSR  ((AT91_REG *) 	0xFFFD4124) /* (PDC_US4) PDC Transfer Status Register */
#define AT91C_US4_TNCR  ((AT91_REG *) 	0xFFFD411C) /* (PDC_US4) Transmit Next Counter Register */
#define AT91C_US4_RNCR  ((AT91_REG *) 	0xFFFD4114) /* (PDC_US4) Receive Next Counter Register */
#define AT91C_US4_TCR   ((AT91_REG *) 	0xFFFD410C) /* (PDC_US4) Transmit Counter Register */
#define AT91C_US4_RCR   ((AT91_REG *) 	0xFFFD4104) /* (PDC_US4) Receive Counter Register */
/* ========== Register definition for US4 peripheral ==========  */
#define AT91C_US4_CSR   ((AT91_REG *) 	0xFFFD4014) /* (US4) Channel Status Register */
#define AT91C_US4_IDR   ((AT91_REG *) 	0xFFFD400C) /* (US4) Interrupt Disable Register */
#define AT91C_US4_MR    ((AT91_REG *) 	0xFFFD4004) /* (US4) Mode Register */
#define AT91C_US4_TTGR  ((AT91_REG *) 	0xFFFD4028) /* (US4) Transmitter Time-guard Register */
#define AT91C_US4_BRGR  ((AT91_REG *) 	0xFFFD4020) /* (US4) Baud Rate Generator Register */
#define AT91C_US4_RHR   ((AT91_REG *) 	0xFFFD4018) /* (US4) Receiver Holding Register */
#define AT91C_US4_IMR   ((AT91_REG *) 	0xFFFD4010) /* (US4) Interrupt Mask Register */
#define AT91C_US4_NER   ((AT91_REG *) 	0xFFFD4044) /* (US4) Nb Errors Register */
#define AT91C_US4_RTOR  ((AT91_REG *) 	0xFFFD4024) /* (US4) Receiver Time-out Register */
#define AT91C_US4_FIDI  ((AT91_REG *) 	0xFFFD4040) /* (US4) FI_DI_Ratio Register */
#define AT91C_US4_CR    ((AT91_REG *) 	0xFFFD4000) /* (US4) Control Register */
#define AT91C_US4_IER   ((AT91_REG *) 	0xFFFD4008) /* (US4) Interrupt Enable Register */
#define AT91C_US4_IF    ((AT91_REG *) 	0xFFFD404C) /* (US4) IRDA_FILTER Register */
#define AT91C_US4_THR   ((AT91_REG *) 	0xFFFD401C) /* (US4) Transmitter Holding Register */
/* ========== Register definition for PDC_US5 peripheral ==========  */
#define AT91C_US5_PTCR  ((AT91_REG *) 	0xFFFD8120) /* (PDC_US5) PDC Transfer Control Register */
#define AT91C_US5_TNPR  ((AT91_REG *) 	0xFFFD8118) /* (PDC_US5) Transmit Next Pointer Register */
#define AT91C_US5_RNPR  ((AT91_REG *) 	0xFFFD8110) /* (PDC_US5) Receive Next Pointer Register */
#define AT91C_US5_TPR   ((AT91_REG *) 	0xFFFD8108) /* (PDC_US5) Transmit Pointer Register */
#define AT91C_US5_RPR   ((AT91_REG *) 	0xFFFD8100) /* (PDC_US5) Receive Pointer Register */
#define AT91C_US5_PTSR  ((AT91_REG *) 	0xFFFD8124) /* (PDC_US5) PDC Transfer Status Register */
#define AT91C_US5_TNCR  ((AT91_REG *) 	0xFFFD811C) /* (PDC_US5) Transmit Next Counter Register */
#define AT91C_US5_RNCR  ((AT91_REG *) 	0xFFFD8114) /* (PDC_US5) Receive Next Counter Register */
#define AT91C_US5_TCR   ((AT91_REG *) 	0xFFFD810C) /* (PDC_US5) Transmit Counter Register */
#define AT91C_US5_RCR   ((AT91_REG *) 	0xFFFD8104) /* (PDC_US5) Receive Counter Register */
/* ========== Register definition for US5 peripheral ==========  */
#define AT91C_US5_IF    ((AT91_REG *) 	0xFFFD804C) /* (US5) IRDA_FILTER Register */
#define AT91C_US5_NER   ((AT91_REG *) 	0xFFFD8044) /* (US5) Nb Errors Register */
#define AT91C_US5_MR    ((AT91_REG *) 	0xFFFD8004) /* (US5) Mode Register */
#define AT91C_US5_RHR   ((AT91_REG *) 	0xFFFD8018) /* (US5) Receiver Holding Register */
#define AT91C_US5_IMR   ((AT91_REG *) 	0xFFFD8010) /* (US5) Interrupt Mask Register */
#define AT91C_US5_IER   ((AT91_REG *) 	0xFFFD8008) /* (US5) Interrupt Enable Register */
#define AT91C_US5_CR    ((AT91_REG *) 	0xFFFD8000) /* (US5) Control Register */
#define AT91C_US5_IDR   ((AT91_REG *) 	0xFFFD800C) /* (US5) Interrupt Disable Register */
#define AT91C_US5_CSR   ((AT91_REG *) 	0xFFFD8014) /* (US5) Channel Status Register */
#define AT91C_US5_THR   ((AT91_REG *) 	0xFFFD801C) /* (US5) Transmitter Holding Register */
#define AT91C_US5_RTOR  ((AT91_REG *) 	0xFFFD8024) /* (US5) Receiver Time-out Register */
#define AT91C_US5_FIDI  ((AT91_REG *) 	0xFFFD8040) /* (US5) FI_DI_Ratio Register */
#define AT91C_US5_BRGR  ((AT91_REG *) 	0xFFFD8020) /* (US5) Baud Rate Generator Register */
#define AT91C_US5_TTGR  ((AT91_REG *) 	0xFFFD8028) /* (US5) Transmitter Time-guard Register */
/* ========== Register definition for PDC_SPI0 peripheral ==========  */
#define AT91C_SPI0_PTSR ((AT91_REG *) 	0xFFFC8124) /* (PDC_SPI0) PDC Transfer Status Register */
#define AT91C_SPI0_TNCR ((AT91_REG *) 	0xFFFC811C) /* (PDC_SPI0) Transmit Next Counter Register */
#define AT91C_SPI0_RNCR ((AT91_REG *) 	0xFFFC8114) /* (PDC_SPI0) Receive Next Counter Register */
#define AT91C_SPI0_TCR  ((AT91_REG *) 	0xFFFC810C) /* (PDC_SPI0) Transmit Counter Register */
#define AT91C_SPI0_PTCR ((AT91_REG *) 	0xFFFC8120) /* (PDC_SPI0) PDC Transfer Control Register */
#define AT91C_SPI0_RCR  ((AT91_REG *) 	0xFFFC8104) /* (PDC_SPI0) Receive Counter Register */
#define AT91C_SPI0_TNPR ((AT91_REG *) 	0xFFFC8118) /* (PDC_SPI0) Transmit Next Pointer Register */
#define AT91C_SPI0_RPR  ((AT91_REG *) 	0xFFFC8100) /* (PDC_SPI0) Receive Pointer Register */
#define AT91C_SPI0_TPR  ((AT91_REG *) 	0xFFFC8108) /* (PDC_SPI0) Transmit Pointer Register */
#define AT91C_SPI0_RNPR ((AT91_REG *) 	0xFFFC8110) /* (PDC_SPI0) Receive Next Pointer Register */
/* ========== Register definition for SPI0 peripheral ==========  */
#define AT91C_SPI0_CSR  ((AT91_REG *) 	0xFFFC8030) /* (SPI0) Chip Select Register */
#define AT91C_SPI0_IDR  ((AT91_REG *) 	0xFFFC8018) /* (SPI0) Interrupt Disable Register */
#define AT91C_SPI0_SR   ((AT91_REG *) 	0xFFFC8010) /* (SPI0) Status Register */
#define AT91C_SPI0_RDR  ((AT91_REG *) 	0xFFFC8008) /* (SPI0) Receive Data Register */
#define AT91C_SPI0_CR   ((AT91_REG *) 	0xFFFC8000) /* (SPI0) Control Register */
#define AT91C_SPI0_IMR  ((AT91_REG *) 	0xFFFC801C) /* (SPI0) Interrupt Mask Register */
#define AT91C_SPI0_IER  ((AT91_REG *) 	0xFFFC8014) /* (SPI0) Interrupt Enable Register */
#define AT91C_SPI0_TDR  ((AT91_REG *) 	0xFFFC800C) /* (SPI0) Transmit Data Register */
#define AT91C_SPI0_MR   ((AT91_REG *) 	0xFFFC8004) /* (SPI0) Mode Register */
/* ========== Register definition for PDC_SPI1 peripheral ==========  */
#define AT91C_SPI1_PTSR ((AT91_REG *) 	0xFFFCC124) /* (PDC_SPI1) PDC Transfer Status Register */
#define AT91C_SPI1_TNCR ((AT91_REG *) 	0xFFFCC11C) /* (PDC_SPI1) Transmit Next Counter Register */
#define AT91C_SPI1_RNCR ((AT91_REG *) 	0xFFFCC114) /* (PDC_SPI1) Receive Next Counter Register */
#define AT91C_SPI1_TCR  ((AT91_REG *) 	0xFFFCC10C) /* (PDC_SPI1) Transmit Counter Register */
#define AT91C_SPI1_RCR  ((AT91_REG *) 	0xFFFCC104) /* (PDC_SPI1) Receive Counter Register */
#define AT91C_SPI1_PTCR ((AT91_REG *) 	0xFFFCC120) /* (PDC_SPI1) PDC Transfer Control Register */
#define AT91C_SPI1_TNPR ((AT91_REG *) 	0xFFFCC118) /* (PDC_SPI1) Transmit Next Pointer Register */
#define AT91C_SPI1_RNPR ((AT91_REG *) 	0xFFFCC110) /* (PDC_SPI1) Receive Next Pointer Register */
#define AT91C_SPI1_TPR  ((AT91_REG *) 	0xFFFCC108) /* (PDC_SPI1) Transmit Pointer Register */
#define AT91C_SPI1_RPR  ((AT91_REG *) 	0xFFFCC100) /* (PDC_SPI1) Receive Pointer Register */
/* ========== Register definition for SPI1 peripheral ==========  */
#define AT91C_SPI1_IMR  ((AT91_REG *) 	0xFFFCC01C) /* (SPI1) Interrupt Mask Register */
#define AT91C_SPI1_IER  ((AT91_REG *) 	0xFFFCC014) /* (SPI1) Interrupt Enable Register */
#define AT91C_SPI1_TDR  ((AT91_REG *) 	0xFFFCC00C) /* (SPI1) Transmit Data Register */
#define AT91C_SPI1_MR   ((AT91_REG *) 	0xFFFCC004) /* (SPI1) Mode Register */
#define AT91C_SPI1_CSR  ((AT91_REG *) 	0xFFFCC030) /* (SPI1) Chip Select Register */
#define AT91C_SPI1_IDR  ((AT91_REG *) 	0xFFFCC018) /* (SPI1) Interrupt Disable Register */
#define AT91C_SPI1_SR   ((AT91_REG *) 	0xFFFCC010) /* (SPI1) Status Register */
#define AT91C_SPI1_RDR  ((AT91_REG *) 	0xFFFCC008) /* (SPI1) Receive Data Register */
#define AT91C_SPI1_CR   ((AT91_REG *) 	0xFFFCC000) /* (SPI1) Control Register */
/* ========== Register definition for EMACB peripheral ==========  */
#define AT91C_EMACB_SA1L ((AT91_REG *) 	0xFFFC4098) /* (EMACB) Specific Address 1 Bottom, First 4 bytes */
#define AT91C_EMACB_SA2H ((AT91_REG *) 	0xFFFC40A4) /* (EMACB) Specific Address 2 Top, Last 2 bytes */
#define AT91C_EMACB_FRO ((AT91_REG *) 	0xFFFC404C) /* (EMACB) Frames Received OK Register */
#define AT91C_EMACB_NCFGR ((AT91_REG *) 	0xFFFC4004) /* (EMACB) Network Configuration Register */
#define AT91C_EMACB_TID ((AT91_REG *) 	0xFFFC40B8) /* (EMACB) Type ID Checking Register */
#define AT91C_EMACB_SA3L ((AT91_REG *) 	0xFFFC40A8) /* (EMACB) Specific Address 3 Bottom, First 4 bytes */
#define AT91C_EMACB_ECOL ((AT91_REG *) 	0xFFFC4060) /* (EMACB) Excessive Collision Register */
#define AT91C_EMACB_FCSE ((AT91_REG *) 	0xFFFC4050) /* (EMACB) Frame Check Sequence Error Register */
#define AT91C_EMACB_NSR ((AT91_REG *) 	0xFFFC4008) /* (EMACB) Network Status Register */
#define AT91C_EMACB_RBQP ((AT91_REG *) 	0xFFFC4018) /* (EMACB) Receive Buffer Queue Pointer */
#define AT91C_EMACB_TPQ ((AT91_REG *) 	0xFFFC40BC) /* (EMACB) Transmit Pause Quantum Register */
#define AT91C_EMACB_SA3H ((AT91_REG *) 	0xFFFC40AC) /* (EMACB) Specific Address 3 Top, Last 2 bytes */
#define AT91C_EMACB_RSE ((AT91_REG *) 	0xFFFC4074) /* (EMACB) Receive Symbol Errors Register */
#define AT91C_EMACB_TUND ((AT91_REG *) 	0xFFFC4064) /* (EMACB) Transmit Underrun Error Register */
#define AT91C_EMACB_TBQP ((AT91_REG *) 	0xFFFC401C) /* (EMACB) Transmit Buffer Queue Pointer */
#define AT91C_EMACB_IDR ((AT91_REG *) 	0xFFFC402C) /* (EMACB) Interrupt Disable Register */
#define AT91C_EMACB_USRIO ((AT91_REG *) 	0xFFFC40C0) /* (EMACB) USER Input/Output Register */
#define AT91C_EMACB_RLE ((AT91_REG *) 	0xFFFC4088) /* (EMACB) Receive Length Field Mismatch Register */
#define AT91C_EMACB_ELE ((AT91_REG *) 	0xFFFC4078) /* (EMACB) Excessive Length Errors Register */
#define AT91C_EMACB_IMR ((AT91_REG *) 	0xFFFC4030) /* (EMACB) Interrupt Mask Register */
#define AT91C_EMACB_RSR ((AT91_REG *) 	0xFFFC4020) /* (EMACB) Receive Status Register */
#define AT91C_EMACB_SA1H ((AT91_REG *) 	0xFFFC409C) /* (EMACB) Specific Address 1 Top, Last 2 bytes */
#define AT91C_EMACB_TPF ((AT91_REG *) 	0xFFFC408C) /* (EMACB) Transmitted Pause Frames Register */
#define AT91C_EMACB_MAN ((AT91_REG *) 	0xFFFC4034) /* (EMACB) PHY Maintenance Register */
#define AT91C_EMACB_SA2L ((AT91_REG *) 	0xFFFC40A0) /* (EMACB) Specific Address 2 Bottom, First 4 bytes */
#define AT91C_EMACB_REV ((AT91_REG *) 	0xFFFC40FC) /* (EMACB) Revision Register */
#define AT91C_EMACB_FTO ((AT91_REG *) 	0xFFFC4040) /* (EMACB) Frames Transmitted OK Register */
#define AT91C_EMACB_SCF ((AT91_REG *) 	0xFFFC4044) /* (EMACB) Single Collision Frame Register */
#define AT91C_EMACB_ALE ((AT91_REG *) 	0xFFFC4054) /* (EMACB) Alignment Error Register */
#define AT91C_EMACB_SA4L ((AT91_REG *) 	0xFFFC40B0) /* (EMACB) Specific Address 4 Bottom, First 4 bytes */
#define AT91C_EMACB_MCF ((AT91_REG *) 	0xFFFC4048) /* (EMACB) Multiple Collision Frame Register */
#define AT91C_EMACB_DTF ((AT91_REG *) 	0xFFFC4058) /* (EMACB) Deferred Transmission Frame Register */
#define AT91C_EMACB_CSE ((AT91_REG *) 	0xFFFC4068) /* (EMACB) Carrier Sense Error Register */
#define AT91C_EMACB_NCR ((AT91_REG *) 	0xFFFC4000) /* (EMACB) Network Control Register */
#define AT91C_EMACB_WOL ((AT91_REG *) 	0xFFFC40C4) /* (EMACB) Wake On LAN Register */
#define AT91C_EMACB_SA4H ((AT91_REG *) 	0xFFFC40B4) /* (EMACB) Specific Address 4 Top, Last 2 bytes */
#define AT91C_EMACB_LCOL ((AT91_REG *) 	0xFFFC405C) /* (EMACB) Late Collision Register */
#define AT91C_EMACB_RRE ((AT91_REG *) 	0xFFFC406C) /* (EMACB) Receive Ressource Error Register */
#define AT91C_EMACB_RJA ((AT91_REG *) 	0xFFFC407C) /* (EMACB) Receive Jabbers Register */
#define AT91C_EMACB_ISR ((AT91_REG *) 	0xFFFC4024) /* (EMACB) Interrupt Status Register */
#define AT91C_EMACB_TSR ((AT91_REG *) 	0xFFFC4014) /* (EMACB) Transmit Status Register */
#define AT91C_EMACB_HRB ((AT91_REG *) 	0xFFFC4090) /* (EMACB) Hash Address Bottom[31:0] */
#define AT91C_EMACB_ROV ((AT91_REG *) 	0xFFFC4070) /* (EMACB) Receive Overrun Errors Register */
#define AT91C_EMACB_USF ((AT91_REG *) 	0xFFFC4080) /* (EMACB) Undersize Frames Register */
#define AT91C_EMACB_IER ((AT91_REG *) 	0xFFFC4028) /* (EMACB) Interrupt Enable Register */
#define AT91C_EMACB_PTR ((AT91_REG *) 	0xFFFC4038) /* (EMACB) Pause Time Register */
#define AT91C_EMACB_HRT ((AT91_REG *) 	0xFFFC4094) /* (EMACB) Hash Address Top[63:32] */
#define AT91C_EMACB_STE ((AT91_REG *) 	0xFFFC4084) /* (EMACB) SQE Test Error Register */
#define AT91C_EMACB_PFR ((AT91_REG *) 	0xFFFC403C) /* (EMACB) Pause Frames received Register */
/* ========== Register definition for UDP peripheral ==========  */
#define AT91C_UDP_FDR   ((AT91_REG *) 	0xFFFA4050) /* (UDP) Endpoint FIFO Data Register */
#define AT91C_UDP_IER   ((AT91_REG *) 	0xFFFA4010) /* (UDP) Interrupt Enable Register */
#define AT91C_UDP_FADDR ((AT91_REG *) 	0xFFFA4008) /* (UDP) Function Address Register */
#define AT91C_UDP_NUM   ((AT91_REG *) 	0xFFFA4000) /* (UDP) Frame Number Register */
#define AT91C_UDP_TXVC  ((AT91_REG *) 	0xFFFA4074) /* (UDP) Transceiver Control Register */
#define AT91C_UDP_GLBSTATE ((AT91_REG *) 	0xFFFA4004) /* (UDP) Global State Register */
#define AT91C_UDP_IDR   ((AT91_REG *) 	0xFFFA4014) /* (UDP) Interrupt Disable Register */
#define AT91C_UDP_ISR   ((AT91_REG *) 	0xFFFA401C) /* (UDP) Interrupt Status Register */
#define AT91C_UDP_CSR   ((AT91_REG *) 	0xFFFA4030) /* (UDP) Endpoint Control and Status Register */
#define AT91C_UDP_RSTEP ((AT91_REG *) 	0xFFFA4028) /* (UDP) Reset Endpoint Register */
#define AT91C_UDP_IMR   ((AT91_REG *) 	0xFFFA4018) /* (UDP) Interrupt Mask Register */
#define AT91C_UDP_ICR   ((AT91_REG *) 	0xFFFA4020) /* (UDP) Interrupt Clear Register */
/* ========== Register definition for UHP peripheral ==========  */
#define AT91C_UHP_HcRhPortStatus ((AT91_REG *) 	0x00500054) /* (UHP) Root Hub Port Status Register */
#define AT91C_UHP_HcRhDescriptorB ((AT91_REG *) 	0x0050004C) /* (UHP) Root Hub characteristics B */
#define AT91C_UHP_HcLSThreshold ((AT91_REG *) 	0x00500044) /* (UHP) LS Threshold */
#define AT91C_UHP_HcFmNumber ((AT91_REG *) 	0x0050003C) /* (UHP) Frame number */
#define AT91C_UHP_HcFmInterval ((AT91_REG *) 	0x00500034) /* (UHP) Bit time between 2 consecutive SOFs */
#define AT91C_UHP_HcBulkCurrentED ((AT91_REG *) 	0x0050002C) /* (UHP) Current endpoint of the Bulk list */
#define AT91C_UHP_HcControlCurrentED ((AT91_REG *) 	0x00500024) /* (UHP) Endpoint Control and Status Register */
#define AT91C_UHP_HcPeriodCurrentED ((AT91_REG *) 	0x0050001C) /* (UHP) Current Isochronous or Interrupt Endpoint Descriptor */
#define AT91C_UHP_HcInterruptDisable ((AT91_REG *) 	0x00500014) /* (UHP) Interrupt Disable Register */
#define AT91C_UHP_HcInterruptStatus ((AT91_REG *) 	0x0050000C) /* (UHP) Interrupt Status Register */
#define AT91C_UHP_HcControl ((AT91_REG *) 	0x00500004) /* (UHP) Operating modes for the Host Controller */
#define AT91C_UHP_HcRhStatus ((AT91_REG *) 	0x00500050) /* (UHP) Root Hub Status register */
#define AT91C_UHP_HcRhDescriptorA ((AT91_REG *) 	0x00500048) /* (UHP) Root Hub characteristics A */
#define AT91C_UHP_HcPeriodicStart ((AT91_REG *) 	0x00500040) /* (UHP) Periodic Start */
#define AT91C_UHP_HcFmRemaining ((AT91_REG *) 	0x00500038) /* (UHP) Bit time remaining in the current Frame */
#define AT91C_UHP_HcBulkDoneHead ((AT91_REG *) 	0x00500030) /* (UHP) Last completed transfer descriptor */
#define AT91C_UHP_HcBulkHeadED ((AT91_REG *) 	0x00500028) /* (UHP) First endpoint register of the Bulk list */
#define AT91C_UHP_HcControlHeadED ((AT91_REG *) 	0x00500020) /* (UHP) First Endpoint Descriptor of the Control list */
#define AT91C_UHP_HcHCCA ((AT91_REG *) 	0x00500018) /* (UHP) Pointer to the Host Controller Communication Area */
#define AT91C_UHP_HcInterruptEnable ((AT91_REG *) 	0x00500010) /* (UHP) Interrupt Enable Register */
#define AT91C_UHP_HcCommandStatus ((AT91_REG *) 	0x00500008) /* (UHP) Command & status Register */
#define AT91C_UHP_HcRevision ((AT91_REG *) 	0x00500000) /* (UHP) Revision */

/* ***************************************************************************** */
/*               PIO DEFINITIONS FOR AT91SAM9260 */
/* ***************************************************************************** */
#define AT91C_PIO_PA0        ((unsigned int) 1 <<  0) /* Pin Controlled by PA0 */
#define AT91C_PA0_SPI0_MISO ((unsigned int) AT91C_PIO_PA0) /*  SPI 0 Master In Slave */
#define AT91C_PA0_MCDB0    ((unsigned int) AT91C_PIO_PA0) /*  Multimedia Card B Data 0 */
#define AT91C_PIO_PA1        ((unsigned int) 1 <<  1) /* Pin Controlled by PA1 */
#define AT91C_PA1_SPI0_MOSI ((unsigned int) AT91C_PIO_PA1) /*  SPI 0 Master Out Slave */
#define AT91C_PA1_MCCDB    ((unsigned int) AT91C_PIO_PA1) /*  Multimedia Card B Command */
#define AT91C_PIO_PA10       ((unsigned int) 1 << 10) /* Pin Controlled by PA10 */
#define AT91C_PA10_MCDA2    ((unsigned int) AT91C_PIO_PA10) /*  Multimedia Card A Data 2 */
#define AT91C_PA10_ETX2     ((unsigned int) AT91C_PIO_PA10) /*  Ethernet MAC Transmit Data 2 */
#define AT91C_PIO_PA11       ((unsigned int) 1 << 11) /* Pin Controlled by PA11 */
#define AT91C_PA11_MCDA3    ((unsigned int) AT91C_PIO_PA11) /*  Multimedia Card A Data 3 */
#define AT91C_PA11_ETX3     ((unsigned int) AT91C_PIO_PA11) /*  Ethernet MAC Transmit Data 3 */
#define AT91C_PIO_PA12       ((unsigned int) 1 << 12) /* Pin Controlled by PA12 */
#define AT91C_PA12_ETX0     ((unsigned int) AT91C_PIO_PA12) /*  Ethernet MAC Transmit Data 0 */
#define AT91C_PIO_PA13       ((unsigned int) 1 << 13) /* Pin Controlled by PA13 */
#define AT91C_PA13_ETX1     ((unsigned int) AT91C_PIO_PA13) /*  Ethernet MAC Transmit Data 1 */
#define AT91C_PIO_PA14       ((unsigned int) 1 << 14) /* Pin Controlled by PA14 */
#define AT91C_PA14_ERX0     ((unsigned int) AT91C_PIO_PA14) /*  Ethernet MAC Receive Data 0 */
#define AT91C_PIO_PA15       ((unsigned int) 1 << 15) /* Pin Controlled by PA15 */
#define AT91C_PA15_ERX1     ((unsigned int) AT91C_PIO_PA15) /*  Ethernet MAC Receive Data 1 */
#define AT91C_PIO_PA16       ((unsigned int) 1 << 16) /* Pin Controlled by PA16 */
#define AT91C_PA16_ETXEN    ((unsigned int) AT91C_PIO_PA16) /*  Ethernet MAC Transmit Enable */
#define AT91C_PIO_PA17       ((unsigned int) 1 << 17) /* Pin Controlled by PA17 */
#define AT91C_PA17_ERXDV    ((unsigned int) AT91C_PIO_PA17) /*  Ethernet MAC Receive Data Valid */
#define AT91C_PIO_PA18       ((unsigned int) 1 << 18) /* Pin Controlled by PA18 */
#define AT91C_PA18_ERXER    ((unsigned int) AT91C_PIO_PA18) /*  Ethernet MAC Receive Error */
#define AT91C_PIO_PA19       ((unsigned int) 1 << 19) /* Pin Controlled by PA19 */
#define AT91C_PA19_ETXCK    ((unsigned int) AT91C_PIO_PA19) /*  Ethernet MAC Transmit Clock/Reference Clock */
#define AT91C_PIO_PA2        ((unsigned int) 1 <<  2) /* Pin Controlled by PA2 */
#define AT91C_PA2_SPI0_SPCK ((unsigned int) AT91C_PIO_PA2) /*  SPI 0 Serial Clock */
#define AT91C_PIO_PA20       ((unsigned int) 1 << 20) /* Pin Controlled by PA20 */
#define AT91C_PA20_EMDC     ((unsigned int) AT91C_PIO_PA20) /*  Ethernet MAC Management Data Clock */
#define AT91C_PIO_PA21       ((unsigned int) 1 << 21) /* Pin Controlled by PA21 */
#define AT91C_PA21_EMDIO    ((unsigned int) AT91C_PIO_PA21) /*  Ethernet MAC Management Data Input/Output */
#define AT91C_PIO_PA22       ((unsigned int) 1 << 22) /* Pin Controlled by PA22 */
#define AT91C_PA22_ADTRG    ((unsigned int) AT91C_PIO_PA22) /*  ADC Trigger */
#define AT91C_PA22_ETXER    ((unsigned int) AT91C_PIO_PA22) /*  Ethernet MAC Transmikt Coding Error */
#define AT91C_PIO_PA23       ((unsigned int) 1 << 23) /* Pin Controlled by PA23 */
#define AT91C_PA23_TWD      ((unsigned int) AT91C_PIO_PA23) /*  TWI Two-wire Serial Data */
#define AT91C_PA23_ETX2     ((unsigned int) AT91C_PIO_PA23) /*  Ethernet MAC Transmit Data 2 */
#define AT91C_PIO_PA24       ((unsigned int) 1 << 24) /* Pin Controlled by PA24 */
#define AT91C_PA24_TWCK     ((unsigned int) AT91C_PIO_PA24) /*  TWI Two-wire Serial Clock */
#define AT91C_PA24_ETX3     ((unsigned int) AT91C_PIO_PA24) /*  Ethernet MAC Transmit Data 3 */
#define AT91C_PIO_PA25       ((unsigned int) 1 << 25) /* Pin Controlled by PA25 */
#define AT91C_PA25_TCLK0    ((unsigned int) AT91C_PIO_PA25) /*  Timer Counter 0 external clock input */
#define AT91C_PA25_ERX2     ((unsigned int) AT91C_PIO_PA25) /*  Ethernet MAC Receive Data 2 */
#define AT91C_PIO_PA26       ((unsigned int) 1 << 26) /* Pin Controlled by PA26 */
#define AT91C_PA26_TIOA0    ((unsigned int) AT91C_PIO_PA26) /*  Timer Counter 0 Multipurpose Timer I/O Pin A */
#define AT91C_PA26_ERX3     ((unsigned int) AT91C_PIO_PA26) /*  Ethernet MAC Receive Data 3 */
#define AT91C_PIO_PA27       ((unsigned int) 1 << 27) /* Pin Controlled by PA27 */
#define AT91C_PA27_TIOA1    ((unsigned int) AT91C_PIO_PA27) /*  Timer Counter 1 Multipurpose Timer I/O Pin A */
#define AT91C_PA27_ERXCK    ((unsigned int) AT91C_PIO_PA27) /*  Ethernet MAC Receive Clock */
#define AT91C_PIO_PA28       ((unsigned int) 1 << 28) /* Pin Controlled by PA28 */
#define AT91C_PA28_TIOA2    ((unsigned int) AT91C_PIO_PA28) /*  Timer Counter 2 Multipurpose Timer I/O Pin A */
#define AT91C_PA28_ECRS     ((unsigned int) AT91C_PIO_PA28) /*  Ethernet MAC Carrier Sense/Carrier Sense and Data Valid */
#define AT91C_PIO_PA29       ((unsigned int) 1 << 29) /* Pin Controlled by PA29 */
#define AT91C_PA29_SCK1     ((unsigned int) AT91C_PIO_PA29) /*  USART 1 Serial Clock */
#define AT91C_PA29_ECOL     ((unsigned int) AT91C_PIO_PA29) /*  Ethernet MAC Collision Detected */
#define AT91C_PIO_PA3        ((unsigned int) 1 <<  3) /* Pin Controlled by PA3 */
#define AT91C_PA3_SPI0_NPCS0 ((unsigned int) AT91C_PIO_PA3) /*  SPI 0 Peripheral Chip Select 0 */
#define AT91C_PA3_MCDB3    ((unsigned int) AT91C_PIO_PA3) /*  Multimedia Card B Data 3 */
#define AT91C_PIO_PA30       ((unsigned int) 1 << 30) /* Pin Controlled by PA30 */
#define AT91C_PA30_SCK2     ((unsigned int) AT91C_PIO_PA30) /*  USART 2 Serial Clock */
#define AT91C_PA30_RXD4     ((unsigned int) AT91C_PIO_PA30) /*  USART 4 Receive Data */
#define AT91C_PIO_PA31       ((unsigned int) 1 << 31) /* Pin Controlled by PA31 */
#define AT91C_PA31_SCK0     ((unsigned int) AT91C_PIO_PA31) /*  USART 0 Serial Clock */
#define AT91C_PA31_TXD4     ((unsigned int) AT91C_PIO_PA31) /*  USART 4 Transmit Data */
#define AT91C_PIO_PA4        ((unsigned int) 1 <<  4) /* Pin Controlled by PA4 */
#define AT91C_PA4_RTS2     ((unsigned int) AT91C_PIO_PA4) /*  USART 2 Ready To Send */
#define AT91C_PA4_MCDB2    ((unsigned int) AT91C_PIO_PA4) /*  Multimedia Card B Data 2 */
#define AT91C_PIO_PA5        ((unsigned int) 1 <<  5) /* Pin Controlled by PA5 */
#define AT91C_PA5_CTS2     ((unsigned int) AT91C_PIO_PA5) /*  USART 2 Clear To Send */
#define AT91C_PA5_MCDB1    ((unsigned int) AT91C_PIO_PA5) /*  Multimedia Card B Data 1 */
#define AT91C_PIO_PA6        ((unsigned int) 1 <<  6) /* Pin Controlled by PA6 */
#define AT91C_PA6_MCDA0    ((unsigned int) AT91C_PIO_PA6) /*  Multimedia Card A Data 0 */
#define AT91C_PIO_PA7        ((unsigned int) 1 <<  7) /* Pin Controlled by PA7 */
#define AT91C_PA7_MCCDA    ((unsigned int) AT91C_PIO_PA7) /*  Multimedia Card A Command */
#define AT91C_PIO_PA8        ((unsigned int) 1 <<  8) /* Pin Controlled by PA8 */
#define AT91C_PA8_MCCK     ((unsigned int) AT91C_PIO_PA8) /*  Multimedia Card Clock */
#define AT91C_PIO_PA9        ((unsigned int) 1 <<  9) /* Pin Controlled by PA9 */
#define AT91C_PA9_MCDA1    ((unsigned int) AT91C_PIO_PA9) /*  Multimedia Card A Data 1 */
#define AT91C_PIO_PB0        ((unsigned int) 1 <<  0) /* Pin Controlled by PB0 */
#define AT91C_PB0_SPI1_MISO ((unsigned int) AT91C_PIO_PB0) /*  SPI 1 Master In Slave */
#define AT91C_PB0_TIOA3    ((unsigned int) AT91C_PIO_PB0) /*  Timer Counter 3 Multipurpose Timer I/O Pin A */
#define AT91C_PIO_PB1        ((unsigned int) 1 <<  1) /* Pin Controlled by PB1 */
#define AT91C_PB1_SPI1_MOSI ((unsigned int) AT91C_PIO_PB1) /*  SPI 1 Master Out Slave */
#define AT91C_PB1_TIOB3    ((unsigned int) AT91C_PIO_PB1) /*  Timer Counter 3 Multipurpose Timer I/O Pin B */
#define AT91C_PIO_PB10       ((unsigned int) 1 << 10) /* Pin Controlled by PB10 */
#define AT91C_PB10_TXD3     ((unsigned int) AT91C_PIO_PB10) /*  USART 3 Transmit Data */
#define AT91C_PB10_ISI_D8   ((unsigned int) AT91C_PIO_PB10) /*  Image Sensor Data 8 */
#define AT91C_PIO_PB11       ((unsigned int) 1 << 11) /* Pin Controlled by PB11 */
#define AT91C_PB11_RXD3     ((unsigned int) AT91C_PIO_PB11) /*  USART 3 Receive Data */
#define AT91C_PB11_ISI_D9   ((unsigned int) AT91C_PIO_PB11) /*  Image Sensor Data 9 */
#define AT91C_PIO_PB12       ((unsigned int) 1 << 12) /* Pin Controlled by PB12 */
#define AT91C_PB12_TXD5     ((unsigned int) AT91C_PIO_PB12) /*  USART 5 Transmit Data */
#define AT91C_PB12_ISI_D10  ((unsigned int) AT91C_PIO_PB12) /*  Image Sensor Data 10 */
#define AT91C_PIO_PB13       ((unsigned int) 1 << 13) /* Pin Controlled by PB13 */
#define AT91C_PB13_RXD5     ((unsigned int) AT91C_PIO_PB13) /*  USART 5 Receive Data */
#define AT91C_PB13_ISI_D11  ((unsigned int) AT91C_PIO_PB13) /*  Image Sensor Data 11 */
#define AT91C_PIO_PB14       ((unsigned int) 1 << 14) /* Pin Controlled by PB14 */
#define AT91C_PB14_DRXD     ((unsigned int) AT91C_PIO_PB14) /*  DBGU Debug Receive Data */
#define AT91C_PIO_PB15       ((unsigned int) 1 << 15) /* Pin Controlled by PB15 */
#define AT91C_PB15_DTXD     ((unsigned int) AT91C_PIO_PB15) /*  DBGU Debug Transmit Data */
#define AT91C_PIO_PB16       ((unsigned int) 1 << 16) /* Pin Controlled by PB16 */
#define AT91C_PB16_TK0      ((unsigned int) AT91C_PIO_PB16) /*  SSC0 Transmit Clock */
#define AT91C_PB16_TCLK3    ((unsigned int) AT91C_PIO_PB16) /*  Timer Counter 3 external clock input */
#define AT91C_PIO_PB17       ((unsigned int) 1 << 17) /* Pin Controlled by PB17 */
#define AT91C_PB17_TF0      ((unsigned int) AT91C_PIO_PB17) /*  SSC0 Transmit Frame Sync */
#define AT91C_PB17_TCLK4    ((unsigned int) AT91C_PIO_PB17) /*  Timer Counter 4 external clock input */
#define AT91C_PIO_PB18       ((unsigned int) 1 << 18) /* Pin Controlled by PB18 */
#define AT91C_PB18_TD0      ((unsigned int) AT91C_PIO_PB18) /*  SSC0 Transmit data */
#define AT91C_PB18_TIOB4    ((unsigned int) AT91C_PIO_PB18) /*  Timer Counter 4 Multipurpose Timer I/O Pin B */
#define AT91C_PIO_PB19       ((unsigned int) 1 << 19) /* Pin Controlled by PB19 */
#define AT91C_PB19_RD0      ((unsigned int) AT91C_PIO_PB19) /*  SSC0 Receive Data */
#define AT91C_PB19_TIOB5    ((unsigned int) AT91C_PIO_PB19) /*  Timer Counter 5 Multipurpose Timer I/O Pin B */
#define AT91C_PIO_PB2        ((unsigned int) 1 <<  2) /* Pin Controlled by PB2 */
#define AT91C_PB2_SPI1_SPCK ((unsigned int) AT91C_PIO_PB2) /*  SPI 1 Serial Clock */
#define AT91C_PB2_TIOA4    ((unsigned int) AT91C_PIO_PB2) /*  Timer Counter 4 Multipurpose Timer I/O Pin A */
#define AT91C_PIO_PB20       ((unsigned int) 1 << 20) /* Pin Controlled by PB20 */
#define AT91C_PB20_RK0      ((unsigned int) AT91C_PIO_PB20) /*  SSC0 Receive Clock */
#define AT91C_PB20_ISI_D0   ((unsigned int) AT91C_PIO_PB20) /*  Image Sensor Data 0 */
#define AT91C_PIO_PB21       ((unsigned int) 1 << 21) /* Pin Controlled by PB21 */
#define AT91C_PB21_RF0      ((unsigned int) AT91C_PIO_PB21) /*  SSC0 Receive Frame Sync */
#define AT91C_PB21_ISI_D1   ((unsigned int) AT91C_PIO_PB21) /*  Image Sensor Data 1 */
#define AT91C_PIO_PB22       ((unsigned int) 1 << 22) /* Pin Controlled by PB22 */
#define AT91C_PB22_DSR0     ((unsigned int) AT91C_PIO_PB22) /*  USART 0 Data Set ready */
#define AT91C_PB22_ISI_D2   ((unsigned int) AT91C_PIO_PB22) /*  Image Sensor Data 2 */
#define AT91C_PIO_PB23       ((unsigned int) 1 << 23) /* Pin Controlled by PB23 */
#define AT91C_PB23_DCD0     ((unsigned int) AT91C_PIO_PB23) /*  USART 0 Data Carrier Detect */
#define AT91C_PB23_ISI_D3   ((unsigned int) AT91C_PIO_PB23) /*  Image Sensor Data 3 */
#define AT91C_PIO_PB24       ((unsigned int) 1 << 24) /* Pin Controlled by PB24 */
#define AT91C_PB24_DTR0     ((unsigned int) AT91C_PIO_PB24) /*  USART 0 Data Terminal ready */
#define AT91C_PB24_ISI_D4   ((unsigned int) AT91C_PIO_PB24) /*  Image Sensor Data 4 */
#define AT91C_PIO_PB25       ((unsigned int) 1 << 25) /* Pin Controlled by PB25 */
#define AT91C_PB25_RI0      ((unsigned int) AT91C_PIO_PB25) /*  USART 0 Ring Indicator */
#define AT91C_PB25_ISI_D5   ((unsigned int) AT91C_PIO_PB25) /*  Image Sensor Data 5 */
#define AT91C_PIO_PB26       ((unsigned int) 1 << 26) /* Pin Controlled by PB26 */
#define AT91C_PB26_RTS0     ((unsigned int) AT91C_PIO_PB26) /*  USART 0 Ready To Send */
#define AT91C_PB26_ISI_D6   ((unsigned int) AT91C_PIO_PB26) /*  Image Sensor Data 6 */
#define AT91C_PIO_PB27       ((unsigned int) 1 << 27) /* Pin Controlled by PB27 */
#define AT91C_PB27_CTS0     ((unsigned int) AT91C_PIO_PB27) /*  USART 0 Clear To Send */
#define AT91C_PB27_ISI_D7   ((unsigned int) AT91C_PIO_PB27) /*  Image Sensor Data 7 */
#define AT91C_PIO_PB28       ((unsigned int) 1 << 28) /* Pin Controlled by PB28 */
#define AT91C_PB28_RTS1     ((unsigned int) AT91C_PIO_PB28) /*  USART 1 Ready To Send */
#define AT91C_PB28_ISI_PCK  ((unsigned int) AT91C_PIO_PB28) /*  Image Sensor Data Clock */
#define AT91C_PIO_PB29       ((unsigned int) 1 << 29) /* Pin Controlled by PB29 */
#define AT91C_PB29_CTS1     ((unsigned int) AT91C_PIO_PB29) /*  USART 1 Clear To Send */
#define AT91C_PB29_ISI_VSYNC ((unsigned int) AT91C_PIO_PB29) /*  Image Sensor Vertical Synchro */
#define AT91C_PIO_PB3        ((unsigned int) 1 <<  3) /* Pin Controlled by PB3 */
#define AT91C_PB3_SPI1_NPCS0 ((unsigned int) AT91C_PIO_PB3) /*  SPI 1 Peripheral Chip Select 0 */
#define AT91C_PB3_TIOA5    ((unsigned int) AT91C_PIO_PB3) /*  Timer Counter 5 Multipurpose Timer I/O Pin A */
#define AT91C_PIO_PB30       ((unsigned int) 1 << 30) /* Pin Controlled by PB30 */
#define AT91C_PB30_PCK0_0   ((unsigned int) AT91C_PIO_PB30) /*  PMC Programmable Clock Output 0 */
#define AT91C_PB30_ISI_HSYNC ((unsigned int) AT91C_PIO_PB30) /*  Image Sensor Horizontal Synchro */
#define AT91C_PIO_PB31       ((unsigned int) 1 << 31) /* Pin Controlled by PB31 */
#define AT91C_PB31_PCK1_0   ((unsigned int) AT91C_PIO_PB31) /*  PMC Programmable Clock Output 1 */
#define AT91C_PB31_ISI_MCK  ((unsigned int) AT91C_PIO_PB31) /*  Image Sensor Reference Clock */
#define AT91C_PIO_PB4        ((unsigned int) 1 <<  4) /* Pin Controlled by PB4 */
#define AT91C_PB4_TXD0     ((unsigned int) AT91C_PIO_PB4) /*  USART 0 Transmit Data */
#define AT91C_PIO_PB5        ((unsigned int) 1 <<  5) /* Pin Controlled by PB5 */
#define AT91C_PB5_RXD0     ((unsigned int) AT91C_PIO_PB5) /*  USART 0 Receive Data */
#define AT91C_PIO_PB6        ((unsigned int) 1 <<  6) /* Pin Controlled by PB6 */
#define AT91C_PB6_TXD1     ((unsigned int) AT91C_PIO_PB6) /*  USART 1 Transmit Data */
#define AT91C_PB6_TCLK1    ((unsigned int) AT91C_PIO_PB6) /*  Timer Counter 1 external clock input */
#define AT91C_PIO_PB7        ((unsigned int) 1 <<  7) /* Pin Controlled by PB7 */
#define AT91C_PB7_RXD1     ((unsigned int) AT91C_PIO_PB7) /*  USART 1 Receive Data */
#define AT91C_PB7_TCLK2    ((unsigned int) AT91C_PIO_PB7) /*  Timer Counter 2 external clock input */
#define AT91C_PIO_PB8        ((unsigned int) 1 <<  8) /* Pin Controlled by PB8 */
#define AT91C_PB8_TXD2     ((unsigned int) AT91C_PIO_PB8) /*  USART 2 Transmit Data */
#define AT91C_PIO_PB9        ((unsigned int) 1 <<  9) /* Pin Controlled by PB9 */
#define AT91C_PB9_RXD2     ((unsigned int) AT91C_PIO_PB9) /*  USART 2 Receive Data */
#define AT91C_PIO_PC0        ((unsigned int) 1 <<  0) /* Pin Controlled by PC0 */
#define AT91C_PC0_AD0      ((unsigned int) AT91C_PIO_PC0) /*  ADC Analog Input 0 */
#define AT91C_PC0_SCK3     ((unsigned int) AT91C_PIO_PC0) /*  USART 3 Serial Clock */
#define AT91C_PIO_PC1        ((unsigned int) 1 <<  1) /* Pin Controlled by PC1 */
#define AT91C_PC1_AD1      ((unsigned int) AT91C_PIO_PC1) /*  ADC Analog Input 1 */
#define AT91C_PC1_PCK0     ((unsigned int) AT91C_PIO_PC1) /*  PMC Programmable Clock Output 0 */
#define AT91C_PIO_PC10       ((unsigned int) 1 << 10) /* Pin Controlled by PC10 */
#define AT91C_PC10_A25_CFRNW ((unsigned int) AT91C_PIO_PC10) /*  Address Bus[25] */
#define AT91C_PC10_CTS3     ((unsigned int) AT91C_PIO_PC10) /*  USART 3 Clear To Send */
#define AT91C_PIO_PC11       ((unsigned int) 1 << 11) /* Pin Controlled by PC11 */
#define AT91C_PC11_NCS2     ((unsigned int) AT91C_PIO_PC11) /*  Chip Select Line 2 */
#define AT91C_PC11_SPI0_NPCS1 ((unsigned int) AT91C_PIO_PC11) /*  SPI 0 Peripheral Chip Select 1 */
#define AT91C_PIO_PC12       ((unsigned int) 1 << 12) /* Pin Controlled by PC12 */
#define AT91C_PC12_IRQ0     ((unsigned int) AT91C_PIO_PC12) /*  External Interrupt 0 */
#define AT91C_PC12_NCS7     ((unsigned int) AT91C_PIO_PC12) /*  Chip Select Line 7 */
#define AT91C_PIO_PC13       ((unsigned int) 1 << 13) /* Pin Controlled by PC13 */
#define AT91C_PC13_FIQ      ((unsigned int) AT91C_PIO_PC13) /*  AIC Fast Interrupt Input */
#define AT91C_PC13_NCS6     ((unsigned int) AT91C_PIO_PC13) /*  Chip Select Line 6 */
#define AT91C_PIO_PC14       ((unsigned int) 1 << 14) /* Pin Controlled by PC14 */
#define AT91C_PC14_NCS3_NANDCS ((unsigned int) AT91C_PIO_PC14) /*  Chip Select Line 3 */
#define AT91C_PC14_IRQ2     ((unsigned int) AT91C_PIO_PC14) /*  External Interrupt 2 */
#define AT91C_PIO_PC15       ((unsigned int) 1 << 15) /* Pin Controlled by PC15 */
#define AT91C_PC15_NWAIT    ((unsigned int) AT91C_PIO_PC15) /*  External Wait Signal */
#define AT91C_PC15_IRQ1     ((unsigned int) AT91C_PIO_PC15) /*  External Interrupt 1 */
#define AT91C_PIO_PC16       ((unsigned int) 1 << 16) /* Pin Controlled by PC16 */
#define AT91C_PC16_D16      ((unsigned int) AT91C_PIO_PC16) /*  Data Bus[16] */
#define AT91C_PC16_SPI0_NPCS2 ((unsigned int) AT91C_PIO_PC16) /*  SPI 0 Peripheral Chip Select 2 */
#define AT91C_PIO_PC17       ((unsigned int) 1 << 17) /* Pin Controlled by PC17 */
#define AT91C_PC17_D17      ((unsigned int) AT91C_PIO_PC17) /*  Data Bus[17] */
#define AT91C_PC17_SPI0_NPCS3 ((unsigned int) AT91C_PIO_PC17) /*  SPI 0 Peripheral Chip Select 3 */
#define AT91C_PIO_PC18       ((unsigned int) 1 << 18) /* Pin Controlled by PC18 */
#define AT91C_PC18_D18      ((unsigned int) AT91C_PIO_PC18) /*  Data Bus[18] */
#define AT91C_PC18_SPI1_NPCS1 ((unsigned int) AT91C_PIO_PC18) /*  SPI 1 Peripheral Chip Select 1 */
#define AT91C_PIO_PC19       ((unsigned int) 1 << 19) /* Pin Controlled by PC19 */
#define AT91C_PC19_D19      ((unsigned int) AT91C_PIO_PC19) /*  Data Bus[19] */
#define AT91C_PC19_SPI1_NPCS2 ((unsigned int) AT91C_PIO_PC19) /*  SPI 1 Peripheral Chip Select 2 */
#define AT91C_PIO_PC2        ((unsigned int) 1 <<  2) /* Pin Controlled by PC2 */
#define AT91C_PC2_AD2      ((unsigned int) AT91C_PIO_PC2) /*  ADC Analog Input 2 */
#define AT91C_PC2_PCK1     ((unsigned int) AT91C_PIO_PC2) /*  PMC Programmable Clock Output 1 */
#define AT91C_PIO_PC20       ((unsigned int) 1 << 20) /* Pin Controlled by PC20 */
#define AT91C_PC20_D20      ((unsigned int) AT91C_PIO_PC20) /*  Data Bus[20] */
#define AT91C_PC20_SPI1_NPCS3 ((unsigned int) AT91C_PIO_PC20) /*  SPI 1 Peripheral Chip Select 3 */
#define AT91C_PIO_PC21       ((unsigned int) 1 << 21) /* Pin Controlled by PC21 */
#define AT91C_PC21_D21      ((unsigned int) AT91C_PIO_PC21) /*  Data Bus[21] */
#define AT91C_PC21_EF100    ((unsigned int) AT91C_PIO_PC21) /*  Ethernet MAC Force 100 Mbits/sec */
#define AT91C_PIO_PC22       ((unsigned int) 1 << 22) /* Pin Controlled by PC22 */
#define AT91C_PC22_D22      ((unsigned int) AT91C_PIO_PC22) /*  Data Bus[22] */
#define AT91C_PC22_TCLK5    ((unsigned int) AT91C_PIO_PC22) /*  Timer Counter 5 external clock input */
#define AT91C_PIO_PC23       ((unsigned int) 1 << 23) /* Pin Controlled by PC23 */
#define AT91C_PC23_D23      ((unsigned int) AT91C_PIO_PC23) /*  Data Bus[23] */
#define AT91C_PIO_PC24       ((unsigned int) 1 << 24) /* Pin Controlled by PC24 */
#define AT91C_PC24_D24      ((unsigned int) AT91C_PIO_PC24) /*  Data Bus[24] */
#define AT91C_PIO_PC25       ((unsigned int) 1 << 25) /* Pin Controlled by PC25 */
#define AT91C_PC25_D25      ((unsigned int) AT91C_PIO_PC25) /*  Data Bus[25] */
#define AT91C_PIO_PC26       ((unsigned int) 1 << 26) /* Pin Controlled by PC26 */
#define AT91C_PC26_D26      ((unsigned int) AT91C_PIO_PC26) /*  Data Bus[26] */
#define AT91C_PIO_PC27       ((unsigned int) 1 << 27) /* Pin Controlled by PC27 */
#define AT91C_PC27_D27      ((unsigned int) AT91C_PIO_PC27) /*  Data Bus[27] */
#define AT91C_PIO_PC28       ((unsigned int) 1 << 28) /* Pin Controlled by PC28 */
#define AT91C_PC28_D28      ((unsigned int) AT91C_PIO_PC28) /*  Data Bus[28] */
#define AT91C_PIO_PC29       ((unsigned int) 1 << 29) /* Pin Controlled by PC29 */
#define AT91C_PC29_D29      ((unsigned int) AT91C_PIO_PC29) /*  Data Bus[29] */
#define AT91C_PIO_PC3        ((unsigned int) 1 <<  3) /* Pin Controlled by PC3 */
#define AT91C_PC3_AD3      ((unsigned int) AT91C_PIO_PC3) /*  ADC Analog Input 3 */
#define AT91C_PC3_SPI1_NPCS3 ((unsigned int) AT91C_PIO_PC3) /*  SPI 1 Peripheral Chip Select 3 */
#define AT91C_PIO_PC30       ((unsigned int) 1 << 30) /* Pin Controlled by PC30 */
#define AT91C_PC30_D30      ((unsigned int) AT91C_PIO_PC30) /*  Data Bus[30] */
#define AT91C_PIO_PC31       ((unsigned int) 1 << 31) /* Pin Controlled by PC31 */
#define AT91C_PC31_D31      ((unsigned int) AT91C_PIO_PC31) /*  Data Bus[31] */
#define AT91C_PIO_PC4        ((unsigned int) 1 <<  4) /* Pin Controlled by PC4 */
#define AT91C_PC4_A23      ((unsigned int) AT91C_PIO_PC4) /*  Address Bus[23] */
#define AT91C_PC4_SPI1_NPCS2 ((unsigned int) AT91C_PIO_PC4) /*  SPI 1 Peripheral Chip Select 2 */
#define AT91C_PIO_PC5        ((unsigned int) 1 <<  5) /* Pin Controlled by PC5 */
#define AT91C_PC5_A24      ((unsigned int) AT91C_PIO_PC5) /*  Address Bus[24] */
#define AT91C_PC5_SPI1_NPCS1 ((unsigned int) AT91C_PIO_PC5) /*  SPI 1 Peripheral Chip Select 1 */
#define AT91C_PIO_PC6        ((unsigned int) 1 <<  6) /* Pin Controlled by PC6 */
#define AT91C_PC6_TIOB2    ((unsigned int) AT91C_PIO_PC6) /*  Timer Counter 2 Multipurpose Timer I/O Pin B */
#define AT91C_PC6_CFCE1    ((unsigned int) AT91C_PIO_PC6) /*  Compact Flash Enable 1 */
#define AT91C_PIO_PC7        ((unsigned int) 1 <<  7) /* Pin Controlled by PC7 */
#define AT91C_PC7_TIOB1    ((unsigned int) AT91C_PIO_PC7) /*  Timer Counter 1 Multipurpose Timer I/O Pin B */
#define AT91C_PC7_CFCE2    ((unsigned int) AT91C_PIO_PC7) /*  Compact Flash Enable 2 */
#define AT91C_PIO_PC8        ((unsigned int) 1 <<  8) /* Pin Controlled by PC8 */
#define AT91C_PC8_NCS4_CFCS0 ((unsigned int) AT91C_PIO_PC8) /*  Chip Select Line 4 */
#define AT91C_PC8_RTS3     ((unsigned int) AT91C_PIO_PC8) /*  USART 3 Ready To Send */
#define AT91C_PIO_PC9        ((unsigned int) 1 <<  9) /* Pin Controlled by PC9 */
#define AT91C_PC9_NCS5_CFCS1 ((unsigned int) AT91C_PIO_PC9) /*  Chip Select Line 5 */
#define AT91C_PC9_TIOB0    ((unsigned int) AT91C_PIO_PC9) /*  Timer Counter 0 Multipurpose Timer I/O Pin B */

/* ***************************************************************************** */
/*               PERIPHERAL ID DEFINITIONS FOR AT91SAM9260 */
/* ***************************************************************************** */
#define AT91C_ID_FIQ    ((unsigned int)  0) /* Advanced Interrupt Controller (FIQ) */
#define AT91C_ID_SYS    ((unsigned int)  1) /* System Controller */
#define AT91C_ID_PIOA   ((unsigned int)  2) /* Parallel IO Controller A */
#define AT91C_ID_PIOB   ((unsigned int)  3) /* Parallel IO Controller B */
#define AT91C_ID_PIOC   ((unsigned int)  4) /* Parallel IO Controller C */
#define AT91C_ID_ADC    ((unsigned int)  5) /* ADC */
#define AT91C_ID_US0    ((unsigned int)  6) /* USART 0 */
#define AT91C_ID_US1    ((unsigned int)  7) /* USART 1 */
#define AT91C_ID_US2    ((unsigned int)  8) /* USART 2 */
#define AT91C_ID_MCI    ((unsigned int)  9) /* Multimedia Card Interface 0 */
#define AT91C_ID_UDP    ((unsigned int) 10) /* USB Device Port */
#define AT91C_ID_TWI    ((unsigned int) 11) /* Two-Wire Interface */
#define AT91C_ID_SPI0   ((unsigned int) 12) /* Serial Peripheral Interface 0 */
#define AT91C_ID_SPI1   ((unsigned int) 13) /* Serial Peripheral Interface 1 */
#define AT91C_ID_SSC0   ((unsigned int) 14) /* Serial Synchronous Controller 0 */
#define AT91C_ID_TC0    ((unsigned int) 17) /* Timer Counter 0 */
#define AT91C_ID_TC1    ((unsigned int) 18) /* Timer Counter 1 */
#define AT91C_ID_TC2    ((unsigned int) 19) /* Timer Counter 2 */
#define AT91C_ID_UHP    ((unsigned int) 20) /* USB Host Port */
#define AT91C_ID_EMAC   ((unsigned int) 21) /* Ethernet Mac */
#define AT91C_ID_HISI   ((unsigned int) 22) /* Image Sensor Interface */
#define AT91C_ID_US3    ((unsigned int) 23) /* USART 3 */
#define AT91C_ID_US4    ((unsigned int) 24) /* USART 4 */
#define AT91C_ID_US5    ((unsigned int) 25) /* USART 5 */
#define AT91C_ID_TC3    ((unsigned int) 26) /* Timer Counter 3 */
#define AT91C_ID_TC4    ((unsigned int) 27) /* Timer Counter 4 */
#define AT91C_ID_TC5    ((unsigned int) 28) /* Timer Counter 5 */
#define AT91C_ID_IRQ0   ((unsigned int) 29) /* Advanced Interrupt Controller (IRQ0) */
#define AT91C_ID_IRQ1   ((unsigned int) 30) /* Advanced Interrupt Controller (IRQ1) */
#define AT91C_ID_IRQ2   ((unsigned int) 31) /* Advanced Interrupt Controller (IRQ2) */
#define AT91C_ALL_INT   ((unsigned int) 0xFFFE7FFF) /* ALL VALID INTERRUPTS */

/* ***************************************************************************** */
/*               BASE ADDRESS DEFINITIONS FOR AT91SAM9260 */
/* ***************************************************************************** */
#define AT91C_BASE_SYS       ((AT91PS_SYS) 	0xFFFFFD00) /* (SYS) Base Address */
#define AT91C_BASE_EBI       ((AT91PS_EBI) 	0xFFFFEA00) /* (EBI) Base Address */
#define AT91C_BASE_HECC      ((AT91PS_ECC) 	0xFFFFE800) /* (HECC) Base Address */
#define AT91C_BASE_SDRAMC    ((AT91PS_SDRAMC) 	0xFFFFEA00) /* (SDRAMC) Base Address */
#define AT91C_BASE_SMC       ((AT91PS_SMC) 	0xFFFFEC00) /* (SMC) Base Address */
#define AT91C_BASE_MATRIX    ((AT91PS_MATRIX) 	0xFFFFEE00) /* (MATRIX) Base Address */
#define AT91C_BASE_CCFG      ((AT91PS_CCFG) 	0xFFFFEF10) /* (CCFG) Base Address */
#define AT91C_BASE_PDC_DBGU  ((AT91PS_PDC) 	0xFFFFF300) /* (PDC_DBGU) Base Address */
#define AT91C_BASE_DBGU      ((AT91PS_DBGU) 	0xFFFFF200) /* (DBGU) Base Address */
#define AT91C_BASE_AIC       ((AT91PS_AIC) 	0xFFFFF000) /* (AIC) Base Address */
#define AT91C_BASE_PIOA      ((AT91PS_PIO) 	0xFFFFF400) /* (PIOA) Base Address */
#define AT91C_BASE_PIOB      ((AT91PS_PIO) 	0xFFFFF600) /* (PIOB) Base Address */
#define AT91C_BASE_PIOC      ((AT91PS_PIO) 	0xFFFFF800) /* (PIOC) Base Address */
#define AT91C_BASE_CKGR      ((AT91PS_CKGR) 	0xFFFFFC20) /* (CKGR) Base Address */
#define AT91C_BASE_PMC       ((AT91PS_PMC) 	0xFFFFFC00) /* (PMC) Base Address */
#define AT91C_BASE_RSTC      ((AT91PS_RSTC) 	0xFFFFFD00) /* (RSTC) Base Address */
#define AT91C_BASE_SHDWC     ((AT91PS_SHDWC) 	0xFFFFFD10) /* (SHDWC) Base Address */
#define AT91C_BASE_RTTC      ((AT91PS_RTTC) 	0xFFFFFD20) /* (RTTC) Base Address */
#define AT91C_BASE_PITC      ((AT91PS_PITC) 	0xFFFFFD30) /* (PITC) Base Address */
#define AT91C_BASE_WDTC      ((AT91PS_WDTC) 	0xFFFFFD40) /* (WDTC) Base Address */
#define AT91C_BASE_TC0       ((AT91PS_TC) 	0xFFFA0000) /* (TC0) Base Address */
#define AT91C_BASE_TC1       ((AT91PS_TC) 	0xFFFA0040) /* (TC1) Base Address */
#define AT91C_BASE_TC2       ((AT91PS_TC) 	0xFFFA0080) /* (TC2) Base Address */
#define AT91C_BASE_TC3       ((AT91PS_TC) 	0xFFFDC000) /* (TC3) Base Address */
#define AT91C_BASE_TC4       ((AT91PS_TC) 	0xFFFDC040) /* (TC4) Base Address */
#define AT91C_BASE_TC5       ((AT91PS_TC) 	0xFFFDC080) /* (TC5) Base Address */
#define AT91C_BASE_TCB0      ((AT91PS_TCB) 	0xFFFA0000) /* (TCB0) Base Address */
#define AT91C_BASE_TCB1      ((AT91PS_TCB) 	0xFFFDC000) /* (TCB1) Base Address */
#define AT91C_BASE_PDC_MCI   ((AT91PS_PDC) 	0xFFFA8100) /* (PDC_MCI) Base Address */
#define AT91C_BASE_MCI       ((AT91PS_MCI) 	0xFFFA8000) /* (MCI) Base Address */
#define AT91C_BASE_PDC_TWI   ((AT91PS_PDC) 	0xFFFAC100) /* (PDC_TWI) Base Address */
#define AT91C_BASE_TWI       ((AT91PS_TWI) 	0xFFFAC000) /* (TWI) Base Address */
#define AT91C_BASE_PDC_US0   ((AT91PS_PDC) 	0xFFFB0100) /* (PDC_US0) Base Address */
#define AT91C_BASE_US0       ((AT91PS_USART) 	0xFFFB0000) /* (US0) Base Address */
#define AT91C_BASE_PDC_US1   ((AT91PS_PDC) 	0xFFFB4100) /* (PDC_US1) Base Address */
#define AT91C_BASE_US1       ((AT91PS_USART) 	0xFFFB4000) /* (US1) Base Address */
#define AT91C_BASE_PDC_US2   ((AT91PS_PDC) 	0xFFFB8100) /* (PDC_US2) Base Address */
#define AT91C_BASE_US2       ((AT91PS_USART) 	0xFFFB8000) /* (US2) Base Address */
#define AT91C_BASE_PDC_US3   ((AT91PS_PDC) 	0xFFFD0100) /* (PDC_US3) Base Address */
#define AT91C_BASE_US3       ((AT91PS_USART) 	0xFFFD0000) /* (US3) Base Address */
#define AT91C_BASE_PDC_US4   ((AT91PS_PDC) 	0xFFFD4100) /* (PDC_US4) Base Address */
#define AT91C_BASE_US4       ((AT91PS_USART) 	0xFFFD4000) /* (US4) Base Address */
#define AT91C_BASE_PDC_US5   ((AT91PS_PDC) 	0xFFFD8100) /* (PDC_US5) Base Address */
#define AT91C_BASE_US5       ((AT91PS_USART) 	0xFFFD8000) /* (US5) Base Address */
#define AT91C_BASE_PDC_SSC0  ((AT91PS_PDC) 	0xFFFBC100) /* (PDC_SSC0) Base Address */
#define AT91C_BASE_SSC0      ((AT91PS_SSC) 	0xFFFBC000) /* (SSC0) Base Address */
#define AT91C_BASE_PDC_SPI0  ((AT91PS_PDC) 	0xFFFC8100) /* (PDC_SPI0) Base Address */
#define AT91C_BASE_SPI0      ((AT91PS_SPI) 	0xFFFC8000) /* (SPI0) Base Address */
#define AT91C_BASE_PDC_SPI1  ((AT91PS_PDC) 	0xFFFCC100) /* (PDC_SPI1) Base Address */
#define AT91C_BASE_SPI1      ((AT91PS_SPI) 	0xFFFCC000) /* (SPI1) Base Address */
#define AT91C_BASE_PDC_ADC   ((AT91PS_PDC) 	0xFFFE0100) /* (PDC_ADC) Base Address */
#define AT91C_BASE_ADC       ((AT91PS_ADC) 	0xFFFE0000) /* (ADC) Base Address */
#define AT91C_BASE_EMACB     ((AT91PS_EMAC) 	0xFFFC4000) /* (EMACB) Base Address */
#define AT91C_BASE_UDP       ((AT91PS_UDP) 	0xFFFA4000) /* (UDP) Base Address */
#define AT91C_BASE_UHP       ((AT91PS_UHP) 	0x00500000) /* (UHP) Base Address */
#define AT91C_BASE_HISI      ((AT91PS_ISI) 	0xFFFC0000) /* (HISI) Base Address */

/* ***************************************************************************** */
/*               MEMORY MAPPING DEFINITIONS FOR AT91SAM9260 */
/* ***************************************************************************** */
/* IROM */
#define AT91C_IROM 	 ((char *) 	0x00100000) /* Internal ROM base address */
#define AT91C_IROM_SIZE	 ((unsigned int) 0x00008000) /* Internal ROM size in byte (32 Kbytes) */
/* IRAM_1 */
#define AT91C_IRAM_1	 ((char *) 	0x00200000) /* Maximum IRAM_1 Area : 4Kbyte base address */
#define AT91C_IRAM_1_SIZE	 ((unsigned int) 0x00001000) /* Maximum IRAM_1 Area : 4Kbyte size in byte (4 Kbytes) */
/* IRAM_2 */
#define AT91C_IRAM_2	 ((char *) 	0x00300000) /* Maximum IRAM_2 AREA : 4 Kbyte base address */
#define AT91C_IRAM_2_SIZE	 ((unsigned int) 0x00001000) /* Maximum IRAM_2 AREA : 4 Kbyte size in byte (4 Kbytes) */
/* EBI_CS0 */
#define AT91C_EBI_CS0	 ((char *) 	0x10000000) /* EBI Chip Select 0 base address */
#define AT91C_EBI_CS0_SIZE	 ((unsigned int) 0x10000000) /* EBI Chip Select 0 size in byte (262144 Kbytes) */
/* EBI_CS1 */
#define AT91C_EBI_CS1	 ((char *) 	0x20000000) /* EBI Chip Select 1 base address */
#define AT91C_EBI_CS1_SIZE	 ((unsigned int) 0x10000000) /* EBI Chip Select 1 size in byte (262144 Kbytes) */
/* EBI_SDRAM */
#define AT91C_EBI_SDRAM	 ((char *) 	0x20000000) /* SDRAM on EBI Chip Select 1 base address */
#define AT91C_EBI_SDRAM_SIZE	 ((unsigned int) 0x10000000) /* SDRAM on EBI Chip Select 1 size in byte (262144 Kbytes) */
/* EBI_SDRAM_16BIT */
#define AT91C_EBI_SDRAM_16BIT	 ((char *) 	0x20000000) /* SDRAM on EBI Chip Select 1 base address */
#define AT91C_EBI_SDRAM_16BIT_SIZE	 ((unsigned int) 0x02000000) /* SDRAM on EBI Chip Select 1 size in byte (32768 Kbytes) */
/* EBI_SDRAM_32BIT */
#define AT91C_EBI_SDRAM_32BIT	 ((char *) 	0x20000000) /* SDRAM on EBI Chip Select 1 base address */
#define AT91C_EBI_SDRAM_32BIT_SIZE	 ((unsigned int) 0x04000000) /* SDRAM on EBI Chip Select 1 size in byte (65536 Kbytes) */
/* EBI_CS2 */
#define AT91C_EBI_CS2	 ((char *) 	0x30000000) /* EBI Chip Select 2 base address */
#define AT91C_EBI_CS2_SIZE	 ((unsigned int) 0x10000000) /* EBI Chip Select 2 size in byte (262144 Kbytes) */
/* EBI_CS3 */
#define AT91C_EBI_CS3	 ((char *) 	0x40000000) /* EBI Chip Select 3 base address */
#define AT91C_EBI_CS3_SIZE	 ((unsigned int) 0x10000000) /* EBI Chip Select 3 size in byte (262144 Kbytes) */
/* EBI_SM */
#define AT91C_EBI_SM	 ((char *) 	0x40000000) /* SmartMedia on Chip Select 3 base address */
#define AT91C_EBI_SM_SIZE	 ((unsigned int) 0x10000000) /* SmartMedia on Chip Select 3 size in byte (262144 Kbytes) */
/* EBI_CS4 */
#define AT91C_EBI_CS4	 ((char *) 	0x50000000) /* EBI Chip Select 4 base address */
#define AT91C_EBI_CS4_SIZE	 ((unsigned int) 0x10000000) /* EBI Chip Select 4 size in byte (262144 Kbytes) */
/* EBI_CF0 */
#define AT91C_EBI_CF0	 ((char *) 	0x50000000) /* CompactFlash 0 on Chip Select 4 base address */
#define AT91C_EBI_CF0_SIZE	 ((unsigned int) 0x10000000) /* CompactFlash 0 on Chip Select 4 size in byte (262144 Kbytes) */
/* EBI_CS5 */
#define AT91C_EBI_CS5	 ((char *) 	0x60000000) /* EBI Chip Select 5 base address */
#define AT91C_EBI_CS5_SIZE	 ((unsigned int) 0x10000000) /* EBI Chip Select 5 size in byte (262144 Kbytes) */
/* EBI_CF1 */
#define AT91C_EBI_CF1	 ((char *) 	0x60000000) /* CompactFlash 1 on Chip Select 5 base address */
#define AT91C_EBI_CF1_SIZE	 ((unsigned int) 0x10000000) /* CompactFlash 1 on Chip Select 5 size in byte (262144 Kbytes) */
/* EBI_CS6 */
#define AT91C_EBI_CS6	 ((char *) 	0x70000000) /* EBI Chip Select 6 base address */
#define AT91C_EBI_CS6_SIZE	 ((unsigned int) 0x10000000) /* EBI Chip Select 6 size in byte (262144 Kbytes) */
/* EBI_CS7 */
#define AT91C_EBI_CS7	 ((char *) 	0x80000000) /* EBI Chip Select 7 base address */
#define AT91C_EBI_CS7_SIZE	 ((unsigned int) 0x10000000) /* EBI Chip Select 7 size in byte (262144 Kbytes) */

#endif
