 /*
 * NOTE:	DAVICOM ethernet Physical layer
 *
 * Version:	@(#)KSZ8041NL.h	1.0.0	01/10/2001
 *
 * Authors:	ATMEL Rousset
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */


/* DAVICOM PHYSICAL LAYER TRANSCEIVER  */

#define	BMCR 		0	/* Basic Mode Control Register */
#define BMSR		1	/* Basic Mode Status Register */
#define PHYID1		2	/* PHY Idendifier Register 1 */
#define PHYID2		3	/* PHY Idendifier Register 2 */
#define ANAR		4	/* Auto_Negotiation Advertisement Register  */
#define ANLPAR		5	/* Auto_negotiation Link Partner Ability Register */
#define ANER		6	/* Auto-negotiation Expansion Register  */

/* --Bit definitions: BMCR */
#define RESET   	         (1 << 15)	/* 1= Software Reset; 0=Normal Operation */
#define LOOPBACK	         (1 << 14)	/* 1=loopback Enabled; 0=Normal Operation */
#define SPEED_SELECT      (1 << 13)	/* 1=100Mbps; 0=10Mbps */
#define AUTONEG	         (1 << 12)
#define POWER_DOWN        (1 << 11)
#define ISOLATE           (1 << 10)
#define RESTART_AUTONEG   (1 << 9)
#define DUPLEX_MODE       (1 << 8)
#define COLLISION_TEST    (1 << 7)

/*--Bit definitions: BMSR */
#define SPEED_100BASE_T4        (1 << 15)
#define SPEED_100BASE_TX_FD     (1 << 14)
#define SPEED_100BASE_TX_HD     (1 << 13)
#define SPEED_10BASE_T_FD       (1 << 12)
#define SPEED_10BASE_T_HD       (1 << 11)
#define MF_PREAMB_SUPPR   (1 << 6)
#define AUTONEG_COMP      (1 << 5)
#define REMOTE_FAULT      (1 << 4)
#define AUTONEG_ABILITY   (1 << 3)
#define LINK_STATUS       (1 << 2)
#define JABBER_DETECT     (1 << 1)
#define EXTEND_CAPAB      (1 << 0)

/*--definitions: OUI */
#define KSZ8041NL_OUI_HIGH      0x05 // the 19rd through 24th bits of Micrel OUI
#define KSZ8041NL_OUI_LOW       0x22 // the 3rd through 18th bits of Micrel OUI
#define LAN8700_OUI_HIGH        0x30 // the 19rd through 24th bits of SMSC LAN8700 OUI
#define LAN8700_OUI_LOW         0x07 // the 3rd through 18th bits of SMSC LAN8700 OUI
#define RTL8201CP_OUI_HIGH      0x20 // the 19rd through 24th bits of Micrel OUI
#define RTL8201CP_OUI_LOW       0x00 // the 3rd through 18th bits of Micrel OUI  

/*--Bit definitions:  ANLPAR */
#define NP               (1 << 15)
#define ACK              (1 << 14)
#define RF               (1 << 13)
#define FCS              (1 << 10)
#define T4               (1 << 9)
#define TX_FDX           (1 << 8)
#define TX_HDX           (1 << 7)
#define SPEED_10_FDX           (1 << 6)
#define SPEED_10_HDX           (1 << 5)
#define AN_IEEE_802_3	0x0001

/*--Bit definitions: ANER */
#define PDF              (1 << 4)
#define LP_NP_ABLE       (1 << 3)
#define NP_ABLE          (1 << 2)
#define PAGE_RX          (1 << 1)
#define LP_AN_ABLE       (1 << 0)


/******************  function prototypes **********************/
static unsigned int  IsPhyConnected(AT91PS_EMAC p_mac);
static unsigned char GetLinkSpeed(AT91PS_EMAC p_mac);
static unsigned char AutoNegotiate(AT91PS_EMAC p_mac, int *status);
static unsigned char InitPhy(AT91PS_EMAC p_mac);
static unsigned char GetAddr(void);
