/******************************************************************
 * @file   dbgfp.c
 * @author Richard Luo
 * @date   2008-08-20
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#include "dbgfp.h"
#include <linux/slab.h>

#include <linux/module.h>

MODULE_LICENSE("Dual BSD/GPL");


struct dfp_buf {
    char buf_[DFP_BUF_SIZE];
    int cur_;
};


/* int __init_or_module at91_set_gpio_output(unsigned pin, int value) */
/* EXPORT_SYMBOL(at91_set_gpio_input); */

dfp_t* __init_or_module dfp_alloc (void)
{
    dfp_t* p = kmalloc(sizeof(dfp_t), GFP_KERNEL);
    if (p) memset(p, 0, sizeof(*p));
    return p;
}
EXPORT_SYMBOL(dfp_alloc);

void __init_or_module dfp_free (dfp_t *p)
{
    kfree(p);
}
EXPORT_SYMBOL(dfp_free);

static int dfp_buf_remain (dfp_t *p)
{
    return (DFP_BUF_SIZE - p->cur_);
}

static void *dfp_buf_current (dfp_t *p)
{
    return (void*) (p->buf_+p->cur_);
}

static void dfp_buf_advance (dfp_t *p, int n)
{
    p->cur_ += n;
    p->cur_ %= DFP_BUF_SIZE;
}

size_t __init_or_module dfp_mem_dump (dfp_t *p, void *mem, size_t memsz)
{
    size_t limit = min(memsz, (size_t)DFP_BUF_SIZE);
    memcpy(mem, p->buf_, limit);
    return limit;
}
EXPORT_SYMBOL(dfp_mem_dump);

int __init_or_module dfp_printf (dfp_t *p, const char * fmt, ...)
{
	va_list args;
	char * pbuf = (char*) dfp_buf_current(p);
    int n, need, limit = dfp_buf_remain(p);

	/* 
	 * First, try the static array 
	 */
	va_start(args,fmt);
	need = vsnprintf(pbuf,limit,fmt,args);
	va_end(args);

    n = need < limit ? need : limit;

    dfp_buf_advance(p, n);

    return n;
}
EXPORT_SYMBOL(dfp_printf);

static __init int dfp_init (void)
{
    printk("hello dfp \n");
    return 0;
}

static void dfp_exit (void)
{
    printk("goodby dfp \n");
}


module_init(dfp_init);
module_exit(dfp_exit);
