/******************************************************************
 * @file   testfuncs.h
 * @author Richard Luo
 * @date   2008-10-20
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _TESTFUNCS_H
#define _TESTFUNCS_H 1

static psoc_vector_t vector1 = { 
    .data_ = {
        //       0x000001d3, 0x00000000,
       0x000000d3, 0x00000000,
    },
    .vec_type_ = VEC_TYPE_PURE_OUTPUT,
    .n_ = 48,
    .cycle_l = 2600,
    .cycle_h = 1300,
    .sp_ = {
        {7, SP_DOUBLE_CYCLE},
        {15,SP_DOUBLE_CYCLE},
        {23,SP_DOUBLE_CYCLE},
        {31,SP_DOUBLE_CYCLE},
        {39,SP_DOUBLE_CYCLE},
        {47,SP_DOUBLE_CYCLE},
        {0, 0},
    }
};
static psoc_vector_t vector2 = { 
    .data_ = {
        0x000007ff, 
    },
    .vec_type_ = VEC_TYPE_PURE_OUTPUT,
    .n_ = 11,
    .cycle_l = 3100,
    .cycle_h = 1400,
    .sp_ = {
        {3, SP_HALF_DELAY_LOW},
        {10,SP_DOUBLE_CYCLE},
        {0, 0},
    }
};

static void test_high_z (void)
{
    psoc_sample_vector(&read_id_samp_v1);
    psoc_dump_vector("read sample v1", &read_id_samp_v1);
}

static void test_make_write_byte_vector (void)
{
    psoc_vector_t wbv;
    uint8_t address, value = 0x7e;

    /* for (address = 0; address < 64; ++address) { */
    /*     make_write_byte_vector(&wbv, address, value); */
    /*     printk("write_byte_vec, address:%02x value:%02x \n", address, value); */
    /*     psoc_dump_vector("test_make_write_byte_vector, address change:", &wbv); */
    /* } */

    for (address=0, value=0; value < 255; ++value) {
        make_write_byte_vector(&wbv, address, value);
        printk("write_byte_vec, address:%02x value:%02x \n", address, value);
        psoc_dump_vector("test_make_write_byte_vector, value change:", &wbv);
    }
    
}

static void compare_read_byte_vector_group (uint8_t address)
{
    psoc_vector_t read_byte_vecs[3];
    vector_grp_t read_group = {
        .grp_ = { &read_byte_vecs[0], &read_byte_vecs[1], &read_byte_vecs[2] },
        .n_ = 3,
    };
    make_read_byte_vector_group(&read_group, address);
    get_read_byte_vector_group(address);
    
//    psoc_dump_vector("read_byte_vecs0", &read_byte_vecs[0]);
    psoc_dump_vector("read_byte_v1", &read_byte_v1);

    /* psoc_dump_vector("read_byte_vecs1", &read_byte_vecs[1]); */
    /* psoc_dump_vector("read_byte_v2", &read_byte_v2); */

    /* psoc_dump_vector("read_byte_vecs2", &read_byte_vecs[2]); */
    /* psoc_dump_vector("read_byte_v3", &read_byte_v3); */

}

static void test_compare_read_byte_vector_group (void)
{
    uint8_t address;

    for (address = 0; address < 64; ++address)
        compare_read_byte_vector_group(address);
}

static void test_send_one_byte (void)
{
    psoc_vector_t wbv;
    uint8_t address = 0x05, value = 0x6a;

    make_write_byte_vector(&wbv, address, value);
    printk("write_byte_vec, address:%02x value:%02x \n", address, value);
    psoc_dump_vector("test_make_write_byte_vector, value change:", &wbv);
    psoc_send_output_vecor(&wbv);
    
}

static void test_get_write_byte_vector (void)
{
    uint8_t address, value;

    for (value = 0, address = 0; address < 64; ++address) {
        psoc_vector_t wbv;
        psoc_vector_t *pbv = get_write_byte_vector(address, value);
        make_write_byte_vector(&wbv, address, value);
        if ( 0 == memcmp(&wbv, pbv, sizeof(wbv)) )
            printk("get_write_byte_vector ok \n");
        else
            WARN_ON(1);
    }

    for (value = 0, address = 0; value < 255; ++value) {
        psoc_vector_t wbv;
        psoc_vector_t *pbv = get_write_byte_vector(address, value);
        make_write_byte_vector(&wbv, address, value);
        if ( 0 == memcmp(&wbv, pbv, sizeof(wbv)) )
            printk("get_write_byte_vector ok \n");
        else
            WARN_ON(1);
    }
}

static void test_get_block_num_vector (void)
{
    uint8_t i;

    for (i=0; i < 255; ++i) {
        psoc_vector_t wbv, *pbv;
        make_set_block_num_vector(&wbv, i);
        pbv = get_block_num_vector(i);
        if ( 0 == memcmp(&wbv, pbv, sizeof(wbv)) )
            printk("get_block_num_vector ok \n");
        else
            WARN_ON(1);
    }
}

static void test_make_set_block_num_vector (void)
{
    int i;
    psoc_vector_t wbv;

    for (i=0; i < 64; ++i) {
        make_set_block_num_vector(&wbv, i);
        psoc_dump_vector("test make set block num", &wbv);
    }
}

static void test_make_read_byte_vector_group (void)
{

    int address;
    psoc_vector_t read_byte_vecs[3];

    vector_grp_t read_group = {
        .grp_ = { &read_byte_vecs[0], &read_byte_vecs[1], &read_byte_vecs[2] },
        .n_ = 3,
    };

    for (address = 0; address < 64; ++address) {
        make_read_byte_vector_group(&read_group, address);
        psoc_dump_vector("test_make_read_byte_vector_group_0", &read_byte_vecs[0]);
        psoc_dump_vector("test_make_read_byte_vector_group_1", &read_byte_vecs[1]);
        psoc_dump_vector("test_make_read_byte_vector_group_2", &read_byte_vecs[2]);
    }

    /* psoc_process_vector_grp(&read_group); */
    /* ak_debug("after psoc_process_vector_grp \n"); */
    /* retrieve_read_byte(&read_byte_vecs[2], c); */
    /* ak_debug("after retrieve_read_byte \n"); */

}

static void run_unit_test (void)
{

    psoc_hw_init();

//    read_from_block(buf, 64, i);
//    test_high_z();
//    test_make_write_byte_vector();
//    test_make_set_block_num_vector();

    /* test_make_read_byte_vector_group(); */

//    test_send_one_byte();

    /* test_get_block_num_vector(); */

    /* test_get_write_byte_vector(); */


    /* test_compare_read_byte_vector_group(); */
    

}

#endif /* _TESTFUNCS_H */



