/******************************************************************
 * @file   card_reader.h
 * @author Richard Luo
 * @date   2008-05-21
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _CARD_READER_H
#define _CARD_READER_H 1

#include <linux/cdev.h>
#include "reader_ioctls.h"

/**
 * 
 * 
 */
struct card_reader_dev {
    int num_;                   // num of readers
    gpio_reader_t *rds_;        // pointer to all readers

    wait_queue_head_t wait_;    // for blocking read
    struct cdev cdev_;
	struct semaphore sem_;     /* Mutual exclusion */

};

typedef struct card_reader_dev card_reader_dev_t;

#ifdef DEBUG_READER
#define PDEBUG(fmt, args...)                    \
    printk(KERN_DEBUG "[%s:%d] " fmt,                      \
           __FUNCTION__, __LINE__ , ## args)
#else
	#define PDEBUG(fmt, args...) do {} while(0)
#endif


#endif /* _CARD_READER_H */



