/******************************************************************
 * @file   reader_buf.c
 * @author Richard Luo
 * @date   2008-05-20
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#include <linux/types.h>	/* size_t */
#include <linux/kernel.h>	/* printk() */

#include "reader_buf.h"

static inline void reader_buf_overwrite_one (reader_buf_t *rb)
{
    if ( !reader_buf_full(rb) )
        return;
    circular_inc(&rb->rd_);
}

card_buf_t* reader_buf_get_for_read (reader_buf_t *rb)
{

    int ridx;

    if ( reader_buf_empty(rb) )
        return NULL;

    ridx = rb->rd_;
    circular_inc(&rb->rd_);

    return &rb->cards_[ridx];
}

void reader_buf_wr_inc (reader_buf_t *rb)
{
    while ( reader_buf_full(rb) )
        reader_buf_overwrite_one(rb);
    circular_inc(&rb->wr_);
}
