/******************************************************************
 * @file   ak_DIP.h
 * @author Richard Luo
 * @date   2008-08-19
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _AK_DIP_H
#define _AK_DIP_H 1

#include <linux/ioctl.h>

#ifdef _FIRST_VERSION
#define DIP1    AT91_PIN_PC8
#define DIP2    AT91_PIN_PC15
#define DIP3    AT91_PIN_PB19
#define DIP4    AT91_PIN_PB17
#define DIP5    AT91_PIN_PB18
#define DIP6    AT91_PIN_PA3
#define DIP7    AT91_PIN_PA7
#define DIP8    AT91_PIN_PA9
#else
#define DIP1    AT91_PIN_PB18
#define DIP2    AT91_PIN_PA3
#define DIP3    AT91_PIN_PB17
#define DIP4    AT91_PIN_PB19
#define DIP5    AT91_PIN_PC15
#define DIP6    AT91_PIN_PC8
#define DIP7    AT91_PIN_PA31
#define DIP8    AT91_PIN_PA30
#endif


/* Use 'D' as magic number */
#define AK_DIP_IOC_MAGIC  'D'

#define AK_DIP_IOCRESET         _IO(AK_DIP_IOC_MAGIC, 0)

#define AK_DIP_VALUE_GET        _IOR(AK_DIP_IOC_MAGIC, 1, int)
#define AK_DIP_IOC_MAXNR        1

#endif /* _AK_RELAY_H */
