/*
 * Net9eth
 * Version for linux (i386)
 * This is the hardware dependent part
 * only for _one_ 16550A !!!
 *
 *
 * Copyright (C) 2001,2002 by Joachim Franek (joachim.franek@t-online.de)
 * for more information see: rs485.de-franek.de
 * Redistribution of this file is permitted under the terms of the GNU Public License (GPL)
 *
 */


#define net9_rx_min_empty  256	//min buffer free for rx
#define NET9_RX_BUF 32*1024			//receive bufer
#define NET9_TX_BUF 8*1024			//transmit bufer

#define _INLINE_

static char *Net9eth_version = "0.0.1\n";
static char *Net9eth_revdate = "2002-02-15\n";

/*todo: change this to linux code conformance */

/* Set of debugging defines */
#undef Net9_DEBUG_INTR
#undef Net9_DEBUG_OPEN
#undef Net9_DEBUG_FLOW

/* Section includes */
#include <asm/io.h>							/*for inb, outb functions */
#include <linux/serial.h>
#include <linux/serialP.h>
#include <linux/serial_reg.h>
#define UART_IER_DISABLE	0x00	/*disable interrupts, is missing from serial-reg.h */
#define UART_FCR_DISABLE_FIFO	0x00	/*disable fifo */
#include <asm/serial.h>
#define LCR_ADDR  (UART_LCR_WLEN8 | UART_LCR_PARITY | UART_LCR_SPAR)
#define LCR_DATA  (UART_LCR_WLEN8 | UART_LCR_PARITY | UART_LCR_SPAR | UART_LCR_EPAR)
#define UART_FIFO_SETUP (UART_FCR_ENABLE_FIFO | UART_FCR_CLEAR_RCVR | UART_FCR_CLEAR_XMIT | UART_FCR_TRIGGER_1)

#include "net9.h"
#include "crc.h"

#define uint32	__u32
#define uint16	__u16
#define uint8	__u8
#define sint32	__s32
#define sint16	__s16
#define sint8	__s8
#define byte 	__u8


extern u8 n9adr;


/* Macros */
/*------------------------------------------------------------------------*/
#define inportb(port) (uint)(inb(ser_dev+port))
#define outportb(port,value) outb(value,ser_dev+port)
#define setbit(port,bits) outportb(port,(inportb(port)|bits))
#define clrbit(port,bits) outportb(port,inportb(port) & ~bits)
#define net9_put_tx_byte_r(b) {outportb(UART_TX,b);};
#define net9_par_adr_rx_r() {setbit(UART_LCR,LCR_ADDR);};
#define net9_par_txrx_mp_r() {outportb(UART_LCR,LCR_ADDR);};
#define net9_par_data_tx_r() {outportb(UART_LCR,LCR_DATA);};


#define net9_int_rx_on_r() {setbit(UART_IER,UART_IER_RDI);};
#define net9_int_rx_off_r() {clrbit(UART_IER,UART_IER_RDI);};
#define net9_int_tx_on_r() {setbit(UART_IER,UART_IER_THRI);};
#define net9_int_tx_off_r() {clrbit(UART_IER,UART_IER_THRI);};
#define net9_int_sci_init_r() {outportb(UART_IER,UART_IER_RDI);	setbit(UART_MCR,UART_MCR_OUT2);};
#define net9_tm_on_r() {setbit(UART_MCR,UART_MCR_RTS);};
#define net9_tm_off_r() {clrbit(UART_MCR,UART_MCR_RTS);};
#define net9_endirq() {outportb(UART_IER, 0); net9_tm_off_r();};

/*------------------------------------------------------------------------*/
u8 net9_test_tx_adr_out_r(void)
{
if ((inportb(UART_LSR)&UART_LSR_TEMT)==UART_LSR_TEMT) return(0);
else  return(1);
};

/*------------------------------------------------------------------------*/
void net9_hw_init_r(void)
{
(void)outportb(UART_MCR, 0x00);
(void)outportb(UART_IER, UART_IER_DISABLE);
(void)outportb(UART_FCR, UART_FCR_DISABLE_FIFO);
(void)outportb(UART_FCR, UART_FIFO_SETUP);
(void)outportb(UART_LCR, 0x00);
while((inportb(UART_IIR) & 0x01) == 0)
	{
	(void)inportb(UART_LSR);
	(void)inportb(UART_MSR);
	(void)inportb(UART_RX);
	}
};

/*------------------------------------------------------------------------*/
void net9_sci_init_baud(baud)
		 uint32 baud;
{
uint32 divisor;
divisor = BASE_BAUD / baud;
setbit(UART_LCR, UART_LCR_DLAB);
outportb(UART_DLL, (divisor & 0xff));
outportb(UART_DLM, ((divisor >> 8) & 0xff));
clrbit(UART_LCR, UART_LCR_DLAB);
};

/*------------------------------------------------------------------------*/
void net9_sci_init_r(void)
{
outportb(UART_FCR, UART_FIFO_SETUP);
net9_sci_init_baud(38400);
net9_tm_off_r();
net9_par_adr_rx_r();
net9_int_rx_on_r();
setbit(UART_MCR, (UART_MCR_OUT1 | UART_MCR_OUT2));
setbit(UART_MCR, UART_MCR_DTR);
};

/*------------------------------------------------------------------------
linux related code
------------------------------------------------------------------------*/
#include <linux/interrupt.h>
#include <linux/delay.h>

struct net9_rx_frame_struct
	{
	unsigned char ram_rx[NET9_RX_BUF];
	byte *puffer_start;
	byte *puffer_ende;
	byte *frame_wr;
	byte *frame_rd;
	byte *pointer_mem;
	u32 count, octets;
	u8 type;
	u8 crc8;
	u16 crc16;
	u32 crc32;
	u8 crc_hh, crc_hl, crc_lh, crc_ll;
	u8 complete;
	};

struct net9_tx_frame_struct
	{
	unsigned char ram_tx[NET9_TX_BUF];
	byte *puffer_start;
	byte *puffer_ende;
	byte *frame_wr;
	byte *frame_rd;
	byte *pointer_mem;
	byte *last;
	byte *txrx_compare_mem;
	u8 bit9;
	u8 crc8;
	u16 crc16;
	u32 crc32;
	u8 crc_hh, crc_hl, crc_lh, crc_ll;
	};
static struct net9_tx_frame_struct net9_tx_frame;
static struct net9_rx_frame_struct net9_rx_frame;
u8 net9_flag;

/*--------------------------------------------------------------------------*/
void net9_buffer_pointer_init()
{
net9_rx_frame.puffer_start = &net9_rx_frame.ram_rx[0];
net9_rx_frame.puffer_ende = &net9_rx_frame.ram_rx[NET9_RX_BUF-1];
net9_rx_frame.frame_wr = &net9_rx_frame.ram_rx[0];
net9_rx_frame.frame_rd = &net9_rx_frame.ram_rx[0];
net9_rx_frame.pointer_mem = &net9_rx_frame.ram_rx[0];
net9_tx_frame.puffer_start = &net9_tx_frame.ram_tx[0];
net9_tx_frame.puffer_ende = &net9_tx_frame.ram_tx[NET9_TX_BUF-1];
net9_tx_frame.frame_wr = &net9_tx_frame.ram_tx[0];
net9_tx_frame.frame_rd = &net9_tx_frame.ram_tx[0];
net9_tx_frame.pointer_mem = &net9_tx_frame.ram_tx[0];
net9_tx_frame.txrx_compare_mem = &net9_tx_frame.ram_tx[0];
};

/*------------------------------------------------------------------------*/
byte *pinc_rx(byte * zeiger)
{
zeiger = zeiger++;
if(zeiger > net9_rx_frame.puffer_ende)
	{
	zeiger = net9_rx_frame.puffer_start;
	};
return (zeiger);
};

/*------------------------------------------------------------------------*/
byte *pinc_tx(byte * zeiger)
{
zeiger = zeiger++;
if(zeiger > net9_tx_frame.puffer_ende)
	{
	zeiger = net9_tx_frame.puffer_start;
	};
return (zeiger);
};

/*------------------------------------------------------------------------*/
u32 net9_free_rx()
{
u32 f;
if(net9_rx_frame.frame_wr >= net9_rx_frame.frame_rd)
	{
	f = (net9_rx_frame.puffer_ende - net9_rx_frame.puffer_start) - (net9_rx_frame.frame_wr - net9_rx_frame.frame_rd);
	}
else
	{
	f = net9_rx_frame.frame_wr - net9_rx_frame.frame_rd;
	};
if(f > 0)
	{
	f -= 1;
	};
return (f);
};

/*------------------------------------------------------------------------*/
u32 net9_free_tx()
{
u32 f;
if(net9_tx_frame.frame_wr >= net9_tx_frame.frame_rd)
	{
	f = (net9_tx_frame.puffer_ende - net9_tx_frame.puffer_start) - (net9_tx_frame.frame_wr - net9_tx_frame.frame_rd);
	}
else
	{
	f = net9_tx_frame.frame_wr - net9_tx_frame.frame_rd;
	};
if(f > 0)
	{
	f -= 1;
	};
return (f);
};

void net9_send_frame();

/*------------------------------------------------------------------------*/
static unsigned net9_detect_uart_irq()
{
int irq;
unsigned long irqs;
unsigned char save_mcr, save_ier;

probe_irq_off(probe_irq_on());
save_mcr = inportb(UART_MCR);
save_ier = inportb(UART_IER);
outportb(UART_MCR, (UART_MCR_DTR | UART_MCR_OUT1 | UART_MCR_OUT2));
irqs = probe_irq_on();
outportb(UART_MCR, 0);
udelay(10);
outportb(UART_MCR, UART_MCR_DTR | UART_MCR_RTS | UART_MCR_OUT2);
outportb(UART_IER, 0x0f);
(void)inportb(UART_LSR);
(void)inportb(UART_RX);
(void)inportb(UART_IIR);
(void)inportb(UART_MSR);
udelay(20);
irq = probe_irq_off(irqs);
outportb(UART_MCR, save_mcr);
outportb(UART_IER, save_ier);
return (irq > 0) ? irq : 0;
}

/*------------------------------------------------------------------------*/
void net9_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
static uint irqcount;						/*number of irqs */
static u8 rec_char;
static u8 rec_lstatus;
static u8 iir;
static u16 rec_crc16;
static u32 rec_crc32;

irqcount += 1;
iir = inportb(UART_IIR);
while((iir & 0x01) == 0)
	{
	rec_lstatus = inportb(UART_LSR);
	rec_char = inportb(UART_RX);
	iir = inportb(UART_IIR);
	switch (net9_flag)
		{
		case 0:
			{
			if((rec_lstatus & 0x04) == 0x04)
				{
				if((rec_char == OWN_ADR) || (rec_char == 0xff) ||	//0xff and 0x00 are broadcast addresses
					 (rec_char == 0x00))
					{
					if((net9_free_rx()) > net9_rx_min_empty)
						{
						net9_rx_frame.crc8 = crc8_init;
						net9_rx_frame.crc16 = crc16_init;
						net9_rx_frame.crc32 = crc32_init;
						net9_rx_frame.pointer_mem = net9_rx_frame.frame_wr;
						*(net9_rx_frame.pointer_mem) = rec_char;
						net9_rx_frame.pointer_mem = pinc_rx(net9_rx_frame.pointer_mem);
						net9_rx_frame.crc8 = UpdCRC8(rec_char, net9_rx_frame.crc8);
						net9_rx_frame.crc16 = UpdCRC16(rec_char, net9_rx_frame.crc16);
						net9_rx_frame.crc32 = UpdCRC32(rec_char, net9_rx_frame.crc32);
						net9_flag = 2;			//
						net9_rx_frame.count = 0;
						net9_rx_frame.octets = 4;
						net9_rx_frame.complete = 0;
						}
					else
						{
						printk("net9eth: rx free to small\n");
						};
					};
				};
			break;
			};
		case 1:
			{
			if(rec_char != (*net9_tx_frame.txrx_compare_mem))
				{
				net9_tm_off_r();
				net9_flag = 0;
				printk("net9eth tx nequ:%02x:%02x\n", (*net9_tx_frame.txrx_compare_mem), rec_char);
				}
			else
				{
				if(net9_tx_frame.bit9 == 1)
					{
					net9_par_data_tx_r();
					net9_tx_frame.bit9 = 0;
					};
				net9_tx_frame.txrx_compare_mem = pinc_tx(net9_tx_frame.txrx_compare_mem);
				if(net9_tx_frame.pointer_mem != net9_tx_frame.last)
					{
					net9_put_tx_byte_r(*net9_tx_frame.pointer_mem);
					net9_tx_frame.pointer_mem = pinc_tx(net9_tx_frame.pointer_mem);
					}
				else
					{
          net9_tm_off_r();
          net9_tx_frame.frame_rd = net9_tx_frame.last;
          net9_flag = 0;
					if(net9_test_tx_adr_out_r() != 0)	//this must be valid, because we get a rx int
            {
            printk("net9eth: big error tx_adr_out\n");
            };
          if(net9_tx_frame.frame_rd != net9_tx_frame.frame_wr)
						{
						net9_send_frame();
            };
					};
				};
			break;
			};
		case 2:
			{
			if((rec_lstatus & 0x04) == 0x04)
				{
				net9_flag = 0;
				break;
				};
			*(net9_rx_frame.pointer_mem) = rec_char;
			net9_rx_frame.pointer_mem = pinc_rx(net9_rx_frame.pointer_mem);
			net9_rx_frame.count += 1;
			if(net9_rx_frame.count == 2)
				{
				net9_rx_frame.type = rec_char;
				};
			if(net9_rx_frame.count > 2)
				{
				switch (net9_rx_frame.type)
					{
					case frame_type_0:
						{
						if(net9_rx_frame.count == 3)
							{
							net9_rx_frame.octets = rec_char + 4;
							if((net9_free_rx()) < (net9_rx_frame.octets + 2))
								{
								net9_flag = 0;
								printk("net9eth rx buf to small\n");
								};
							};
						if(net9_rx_frame.count >= net9_rx_frame.octets)
							{
							if(rec_char == net9_rx_frame.crc8)
								{
								net9_rx_frame.complete = 1;
								net9_rx_frame.frame_wr = net9_rx_frame.pointer_mem;
								net9_new_frame();
								}
							else
								{
								printk("net9eth t0 crc error\n");
								};
							net9_flag = 0;
							};
						break;
						};
					case frame_type_1:
						{
						if(net9_rx_frame.count == 3)
							{
							net9_rx_frame.octets = (rec_char << 8);
							};
						if(net9_rx_frame.count == 4)
							{
							net9_rx_frame.octets += (rec_char + 5);
							if((net9_free_rx()) < (net9_rx_frame.octets + 2))
								{
								net9_flag = 0;
								printk("net9eth rx buf to small\n");
								};
							};
						if(net9_rx_frame.count == net9_rx_frame.octets)
							{
							rec_crc16 = net9_rx_frame.crc16;
							if(rec_char == ((rec_crc16 >> 8) & 0xff))
								{
								}
							else
								{
								net9_flag = 0;
								printk("net9eth crc error\n");
								};
							};
						if(net9_rx_frame.count == (net9_rx_frame.octets + 1))
							{
							if(rec_char == (rec_crc16 & 0xff))
								{
								net9_rx_frame.complete = 1;
								net9_rx_frame.frame_wr = net9_rx_frame.pointer_mem;
								net9_new_frame();
								}
							else
								{
								printk("net9eth crc error\n");
								};
							net9_flag = 0;
							};
						break;
						};
					case frame_type_2:
						{
						if(net9_rx_frame.count == 3)
							{
							net9_rx_frame.octets = (rec_char << 8) + 5;
							};
						if(net9_rx_frame.count == 4)
							{
							net9_rx_frame.octets += (rec_char);
							if((net9_free_rx()) < (net9_rx_frame.octets + 2))
								{
								net9_flag = 0;
								printk("net9eth rx buf to small\n");
								};
							};
						if(net9_rx_frame.count == net9_rx_frame.octets)
							{
							rec_crc32 = net9_rx_frame.crc32;
							if(rec_char == ((rec_crc32 >> 24) & 0xff))
								{
								}
							else
								{
								net9_flag = 0;
								printk("net9eth crc error\n");
								};
							};
						if(net9_rx_frame.count == (net9_rx_frame.octets + 1))
							{
							if(rec_char == ((rec_crc32 >> 16) & 0xff))
								{
								}
							else
								{
								net9_flag = 0;
								printk("net9eth crc error\n");
								};
							};
						if(net9_rx_frame.count == (net9_rx_frame.octets + 2))
							{
							if(rec_char == ((rec_crc32 >> 8) & 0xff))
								{
								}
							else
								{
								net9_flag = 0;
								printk("net9eth crc error\n");
								};
							};
						if(net9_rx_frame.count == (net9_rx_frame.octets + 3))
							{
							if(rec_char == (rec_crc32 & 0xff))
								{
								net9_rx_frame.complete = 1;
								net9_rx_frame.frame_wr = net9_rx_frame.pointer_mem;
  							net9_flag = 0;
								net9_new_frame();
								}
							else
								{
	  						net9_flag = 0;
								printk("net9eth crc error\n");
								};
							};
						break;
						};
					default:
						{
						printk("net9eth wrong type1:%i\n", net9_rx_frame.type);
						net9_flag = 0;
						break;
						};
					};
				};
			net9_rx_frame.crc8 = UpdCRC8(rec_char, net9_rx_frame.crc8);
			net9_rx_frame.crc16 = UpdCRC16(rec_char, net9_rx_frame.crc16);
			net9_rx_frame.crc32 = UpdCRC32(rec_char, net9_rx_frame.crc32);
			break;
			};
		default:
			{
			printk("net9eth flag wrong:%i\n", net9_flag);
			net9_flag = 0;
			break;
			};
		};
	};
};

void net9eth_rx_drop();					//move the code to this position

extern void net9eth_interrupt(int irq, void *dev_id, struct pt_regs *regs);


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Second part: Send/Receive a Net9-frame
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void net9_new_frame()
{
//inform eth stuff about a new frame: at this time if type==frame_type_2

unsigned char *p;
unsigned char type,src,dst;

net9_rx_frame.complete = 0;
if(net9_rx_frame.frame_wr == net9_rx_frame.frame_rd) return;	//some error
p = net9_rx_frame.frame_rd;	dst=*p;
p = pinc_rx(p);							src=*p;
p = pinc_rx(p);             type = *p;

switch (type)
	{
	case frame_type_0:
		{
		net9eth_rx_drop();
		break;
		};
	case frame_type_1:
		{
		net9eth_rx_drop();
		break;
		};
	case frame_type_2:						//at this time we can only handle type 2 frames
		{
    if ((dst==0xff) || (dst==0x00))
      {
  		net9eth_rx_drop();
      }
    else
      {
      net9eth_interrupt(0, NULL, NULL);
      }
		break;
		};
	default:
		{
		printk("net9eth: error wrong type2\n");
		return;
		break;
		};
	};
if(net9_tx_frame.frame_rd != net9_tx_frame.frame_wr)
  {
  net9_send_frame();
  printk("net9eth: tx was waiting 2\n");
  };
};

/*------------------------------------------------------------------------*/
unsigned int net9_frame_length()
{
unsigned char *p;
unsigned char type;
unsigned char temp;

unsigned int i;

if(net9_rx_frame.frame_wr == net9_rx_frame.frame_rd) return 0;
p = net9_rx_frame.frame_rd;
temp = *p;
p = pinc_rx(p);
temp = *p;
p = pinc_rx(p);
type = *p;
temp = (int)type;
p = pinc_rx(p);
switch (type)
	{
	case frame_type_0:
		{
		i = *p;
		break;
		};
	case frame_type_1:
		{
		i = ((*p) << 8);
		p = pinc_rx(p);
		i += (*p);
		break;
		};
	case frame_type_2:						//at this time we can only handle type 2 frames
		{
		temp = *p;
		i = (unsigned int)temp;
		i = (i << 8);
		p = pinc_rx(p);
		i += (*p);
		break;
		};
	default:
		{
		printk("net9eth error wrong type3\n");
		return 0;
		break;
		};
	};
return i;
};

/*------------------------------------------------------------------------
function is called from eth code (non interrupt)
as from code during interrupt!!!
------------------------------------------------------------------------*/
void net9_send_frame()
{
byte *p;
u16 i, j;
byte error = 0;
byte type,dest,src;
if(net9_tx_frame.frame_rd == net9_tx_frame.frame_wr)
	{
	printk("net9eth error send_frame no bytes\n");
	return;
	};
net9_tx_frame.pointer_mem = net9_tx_frame.frame_rd;
net9_tx_frame.txrx_compare_mem = net9_tx_frame.frame_rd;
p = net9_tx_frame.frame_rd;
dest=*p;
p = pinc_tx(p);
src=*p;
p = pinc_tx(p);
type=*p;
switch (type)
	{
	case frame_type_0:
		{
		p = pinc_tx(p);
		j = *p;
		p = pinc_tx(p);
		for(i = 0; i < j; i++)
			{
			p = pinc_tx(p);
			};
		p = pinc_tx(p);
		break;
		};
	case frame_type_1:
		{
		p = pinc_tx(p);
		j = ((*p) << 8);
		p = pinc_tx(p);
		j += (*p);
		p = pinc_tx(p);
		for(i = 0; i < j; i++)
			{
			p = pinc_tx(p);
			};
		p = pinc_tx(p);
		p = pinc_tx(p);
		break;
		};
	case frame_type_2:
		{
		p = pinc_tx(p);
		j = ((*p) << 8);
		p = pinc_tx(p);
		j += (*p);
		p = pinc_tx(p);
		for(i = 0; i < j; i++)
			{
			p = pinc_tx(p);
			};
		p = pinc_tx(p);
		p = pinc_tx(p);
		p = pinc_tx(p);
		p = pinc_tx(p);
		break;
		};
	default:
		{
		error = 1;
		printk("net9eth error wrong type4 d:%02x s:%02x t:%02x\n",dest&0xff,src&0xff,type&0xff);
		net9_tx_frame.frame_rd = net9_tx_frame.frame_wr; //skipp the bad bytes
    return;
		break;
		};
	};
net9_tx_frame.last = p;

//============================================================
//!!! delay recomended for min. one byte !!! -> future version
//============================================================
net9_flag = 1;
net9_par_txrx_mp_r();
net9_tx_frame.bit9 = 1;
net9_tm_on_r();
net9_put_tx_byte_r(*(net9_tx_frame.pointer_mem));
net9_tx_frame.pointer_mem = pinc_tx(net9_tx_frame.pointer_mem);
};

/*------------------------------------------------------------------------*/
int net9_test_frame_type0(void)
{
int i;
byte *p;
if(10 > net9_free_tx())
	{
	return -1;
	};
p = net9_tx_frame.frame_wr;
net9_tx_frame.crc8 = crc8_init;
*p = 0x10;
net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
p = pinc_tx(p);
*p = OWN_ADR;
net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
p = pinc_tx(p);
*p = 0x00;
net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
p = pinc_tx(p);
*p = 0x02;
net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
p = pinc_tx(p);
for(i = 4; i <= 5; i++)
	{
	*p = (unsigned char)(i + 20);
	net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
	p = pinc_tx(p);
	};
*p = net9_tx_frame.crc8;
p = pinc_tx(p);
net9_tx_frame.frame_wr = p;
net9_send_frame();
return 0;
};

/*------------------------------------------------------------------------*/
int net9_test_frame_type1(void)
{
int i;
byte *p;
if(20 > net9_free_tx())
	{
	return -1;
	};
p = net9_tx_frame.frame_wr;
net9_tx_frame.crc16 = crc16_init;
*p = 0x10;											//dest
net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
p = pinc_tx(p);
*p = OWN_ADR;										//source
net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
p = pinc_tx(p);
*p = 0x01;											//type
net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
p = pinc_tx(p);
*p = 0x02;											//count
net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
p = pinc_tx(p);
for(i = 4; i <= 5; i++)
	{
	*p = (unsigned char)(i + 20);
	net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
	p = pinc_tx(p);
	};
*p = (net9_tx_frame.crc16 >> 8) & 0xff;	//high
p = pinc_tx(p);
*p = (net9_tx_frame.crc16 & 0xff);	//low
p = pinc_tx(p);
net9_tx_frame.frame_wr = p;
net9_send_frame();
return 0;
};

/*------------------------------------------------------------------------*/
int net9_test_frame_type2(void)
{
int i;
byte *p;
if(30 > net9_free_tx())
	{
	return -1;
	};
p = net9_tx_frame.frame_wr;
net9_tx_frame.crc32 = crc32_init;
*p = 0x10;											//dest
net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
p = pinc_tx(p);
*p = OWN_ADR;										//source
net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
p = pinc_tx(p);
*p = 0x01;											//type
net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
p = pinc_tx(p);
*p = 0x02;											//count
net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
p = pinc_tx(p);
for(i = 4; i <= 5; i++)
	{
	*p = (unsigned char)(i + 20);
	net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
	p = pinc_tx(p);
	};
*p = (net9_tx_frame.crc32 >> 24) & 0xff;	//highhigh
p = pinc_tx(p);
*p = (net9_tx_frame.crc32 >> 16) & 0xff;	//highlow
p = pinc_tx(p);
*p = (net9_tx_frame.crc32 >> 8) & 0xff;	//lowhigh
p = pinc_tx(p);
*p = (net9_tx_frame.crc32 & 0xff);	//low
p = pinc_tx(p);
net9_tx_frame.frame_wr = p;
net9_send_frame();
return 0;
};

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
third part: NET9 interface
- Device Declarations
- Device Functions
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include "net9_ioctrl.h"

/*------------------------------------------------------------------------*/
ssize_t net9eth_read(char *buffer, size_t length)
{
int bytes_read = 0;
unsigned char *p;
unsigned char type;
u16 i, j;
if(net9_rx_frame.frame_wr == net9_rx_frame.frame_rd) return 0;
if(length < 4) return 0;
p = net9_rx_frame.frame_rd;
*buffer++ = *p;
p = pinc_rx(p);
*buffer++ = *p;
p = pinc_rx(p);
type = *p;
*buffer++ = *p;
p = pinc_rx(p);
switch (type)
	{
	case frame_type_0:
		{
		j = *p;
		bytes_read = j + 5;
		*buffer++ = *p;
		if(length < (j + 2))
			{
			printk("net9eth low mem length t0\n");
			return 0;
			};
		p = pinc_rx(p);
		for(i = 0; i < j; i++)
			{
			*buffer++ = *p;
			p = pinc_rx(p);
			};
		p = pinc_rx(p);
		*buffer++ = *p;
		break;
		};
	case frame_type_1:
		{
		j = ((*p) << 8);
		*buffer++ = *p;
		p = pinc_rx(p);
		j += *p;
		bytes_read = j + 5;
		*buffer++ = *p;
		p = pinc_rx(p);
		if(length < (j + 2))
			{
			printk("net9eth low mem length t1\n");
			return 0;
			};
		for(i = 0; i < j; i++)
			{
			*buffer++ = *p;
			p = pinc_rx(p);
			};
		p = pinc_rx(p);
		*buffer++ = *p;
		p = pinc_rx(p);
		*buffer++ = *p;
		break;
		};
	case frame_type_2:
		{
		j = ((*p) << 8);
		*buffer++ = *p;
		p = pinc_rx(p);
		j += *p;
		bytes_read = j + 5;
		*buffer++ = *p;
		p = pinc_rx(p);
		if(length < (j + 2))
			{
			printk("net9eth low mem length t2\n");
			return 0;
			};
		for(i = 0; i < j; i++)
			{
			*buffer++ = *p;
			p = pinc_rx(p);
			};
		p = pinc_rx(p);
		*buffer++ = *p;
		p = pinc_rx(p);
		*buffer++ = *p;
		p = pinc_rx(p);
		*buffer++ = *p;
		p = pinc_rx(p);
		*buffer++ = *p;
		break;
		};
	default:
		{
		printk("net9eth error wrong type5\n");
		return 0;
		break;
		};
	};
net9_rx_frame.frame_rd = p;
return (ssize_t) bytes_read;
};

/*------------------------------------------------------------------------*/
ssize_t net9eth_read_payload_t2(char *buffer, size_t length)
{
int bytes_read = 0;
unsigned char *p;
unsigned char type;
u16 i, j;
if(net9_rx_frame.frame_wr == net9_rx_frame.frame_rd) return 0;
if(length < 4) return 0;
p = net9_rx_frame.frame_rd;
p = pinc_rx(p);
p = pinc_rx(p);
type = *p;
p = pinc_rx(p);
switch (type)
	{
	case frame_type_0:
		{
		return 0;
		break;
		};
	case frame_type_1:
		{
		return 0;
		break;
		};
	case frame_type_2:
		{
		j = (((u16)(*p)) << 8);

		p = pinc_rx(p);
		j += (u16)(*p);
		bytes_read = j + 5;
		p = pinc_rx(p);
		if(length < j)
			{
			printk("net9eth low mem length:%i\n", length);
			return 0;
			};
		for(i = 0; i < j; i++)
			{
			*buffer++ = *p;
			p = pinc_rx(p);
			};
		p = pinc_rx(p);
		p = pinc_rx(p);
		p = pinc_rx(p);
		p = pinc_rx(p);
		break;
		};
	default:
		{
		printk("net9eth error wrong type6\n");
		return 0;
		break;
		};
	};
net9_rx_frame.frame_rd = p;
return (ssize_t) bytes_read;
};

/*------------------------------------------------------------------------*/
void net9eth_rx_drop()
{
unsigned char *p;
unsigned char type;
u16 i, j;
if(net9_rx_frame.frame_wr == net9_rx_frame.frame_rd) return;
p = net9_rx_frame.frame_rd;
p = pinc_rx(p);
p = pinc_rx(p);
type = *p;
p = pinc_rx(p);
switch (type)
	{
	case frame_type_0:
		{
		j = *p;
		p = pinc_rx(p);
		for(i = 0; i < j; i++)
			{
			p = pinc_rx(p);
			};
		p = pinc_rx(p);
		break;
		};
	case frame_type_1:
		{
		j = ((*p) << 8);
		p = pinc_rx(p);
		j += *p;
		p = pinc_rx(p);
		for(i = 0; i < j; i++)
			{
			p = pinc_rx(p);
			};
		p = pinc_rx(p);
		p = pinc_rx(p);
		break;
		};
	case frame_type_2:
		{
		j = ((*p) << 8);
		p = pinc_rx(p);
		j += *p;
		p = pinc_rx(p);
		for(i = 0; i < j; i++)
			{
			p = pinc_rx(p);
			};
		p = pinc_rx(p);
		p = pinc_rx(p);
		p = pinc_rx(p);
		p = pinc_rx(p);
		break;
		};
	default:
		{
		printk("net9eth error wrong type7\n");
		return;
		break;
		};
	};
net9_rx_frame.frame_rd = p;
};

/*--------------------------------------------------------------------------
this is the entry point for transmitting
Attention: own address, byte count and crc is inserted by driver!
return 0: accepted, -1 buffer full, -2 not valid net9 frame, -3 to long, -4 dest=source -5 unknown type
--------------------------------------------------------------------------*/
ssize_t net9eth_write(char *buffer, size_t length, char dest, char ftype)
{
uint l;
byte *p;
u8 type;

if(length < 1) return -2;
l = length;
if(length >= (net9_free_tx()) + 3) {return -1;};
p = net9_tx_frame.frame_wr;
net9_tx_frame.crc8 = crc8_init;
net9_tx_frame.crc16 = crc16_init;
net9_tx_frame.crc32 = crc32_init;
*p = dest;
if((*p) == OWN_ADR)	{return -4;};
net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
p = pinc_tx(p);
*p = OWN_ADR;
net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
p = pinc_tx(p);
*p = ftype;
type = ftype;
if ( !((type==frame_type_0) || (type==frame_type_1) || (type==frame_type_2))  )
  {
  printk("net9eth: wrong type 8 t:%02x\n",type);
  return -5;
  }
net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
p = pinc_tx(p);
switch (type)
	{
	case frame_type_0:
		{
		if(l > 255)
			{
			return -3;
			};
		*p = l;
		net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
		p = pinc_tx(p);
		while(l > 0)
			{
			*p = *buffer++;
			net9_tx_frame.crc8 = UpdCRC8(*p, net9_tx_frame.crc8);
			p = pinc_tx(p);
			l--;
			};
		*p = net9_tx_frame.crc8;
		p = pinc_tx(p);
		break;
		};
	case frame_type_1:
		{
		if(l > 65000)
			{
			return -3;
			};
		*p = ((l >> 8) & 0xff);
		net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
		p = pinc_tx(p);
		*p = (l & 0xff);
		net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
		p = pinc_tx(p);
		while(l > 0)
			{
			*p = *buffer++;
			net9_tx_frame.crc16 = UpdCRC16(*p, net9_tx_frame.crc16);
			p = pinc_tx(p);
			l--;
			};
		*p = (net9_tx_frame.crc16 >> 8) & 0xff;
		p = pinc_tx(p);
		*p = (net9_tx_frame.crc16 & 0xff);
		p = pinc_tx(p);
		break;
		};
	case frame_type_2:
		{
		if(l > 2000)
			{
			return -3;
			};
		*p = ((l >> 8) & 0xff);
		net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
		p = pinc_tx(p);
		*p = (l & 0xff);
		net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
		p = pinc_tx(p);
		while(l > 0)
			{
			*p = *buffer++;
			net9_tx_frame.crc32 = UpdCRC32(*p, net9_tx_frame.crc32);
			p = pinc_tx(p);
			l--;
			};
		*p = (net9_tx_frame.crc32 >> 24) & 0xff;
		p = pinc_tx(p);
		*p = (net9_tx_frame.crc32 >> 16) & 0xff;
		p = pinc_tx(p);
		*p = (net9_tx_frame.crc32 >> 8) & 0xff;
		p = pinc_tx(p);
		*p = (net9_tx_frame.crc32 & 0xff);
		p = pinc_tx(p);
		break;
		};
	default:
		{
		printk("net9eth: (wr) error wrong type %i\n", type);
		return -2;
		break;
		};
	};
net9_tx_frame.frame_wr = p;

if(net9_flag == 0)
	{
	net9_send_frame();
	};
return 0;
};

/*--------------------------------------------------------------------------
new: baud, my_adr set, my_adr read, debug, etc
!!! is not working/testet yet !!!
--------------------------------------------------------------------------*/
int net9eth_ioctl_old(unsigned int ioctl_num, unsigned long ioctl_param)
{
char *buffer;
unsigned char *p;
int i;
switch (ioctl_num)
	{
	case IOCTL_SET_ADR:
		{
		break;
		};
	case IOCTL_GET_ADR:
		{
		ioctl_param = (unsigned long)OWN_ADR;
		break;
		};
	case IOCTL_GET_VERSION:
		{
		buffer = (char *)ioctl_param;
		p = Net9eth_version;
		for(i = 0; i < strlen(p); i++)
			{
			*buffer++ = *p++;
			};
		break;
		};
	case IOCTL_GET_REVDATE:
		{
		buffer = (char *)ioctl_param;
		p = Net9eth_revdate;
		for(i = 0; i < strlen(p); i++)
			{
			*buffer++ = *(p++);
			};
		break;
		};
	default:
		{
		printk("net9eth: undefined ioctl_num:%i\n", ioctl_num);
		return -1;
		break;
		};
	};
return 0;
}

static unsigned int irqnum;
static int irqnumber;

/*------------------------------------------------------------------------
0: success
negative: error
------------------------------------------------------------------------*/
int net9eth_get_irq()
{
irqnum = net9_detect_uart_irq();
if(irqnum > 0)
	{
	irqnumber = request_irq(irqnum, net9_interrupt, SA_INTERRUPT, "net9eth", NULL);
	if(irqnumber < 0)
		{
		printk("net9eth: can't get assigned irq %i\n", irqnum);
		return irqnumber;
		};
	};
net9_buffer_pointer_init();			//init memory
net9_sci_init_r();							//init hardware
return 0;
}

/*------------------------------------------------------------------------*/
void net9eth_cleanup_irq()
{
if(irqnumber == 0)
	{
	net9_endirq();
	free_irq(irqnum, NULL);
	};
};

//the end
