 /*
 * NOTE:	DAVICOM ethernet Physical layer
 *
 * Version:	@(#)KSZ8041NL.h	1.0.0	01/10/2001
 *
 * Authors:	ATMEL Rousset
 *
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */


/* DAVICOM PHYSICAL LAYER TRANSCEIVER KSZ8041NL */

#define	KSZ8041NL_BMCR 		0	/* Basic Mode Control Register */
#define KSZ8041NL_BMSR		1	/* Basic Mode Status Register */
#define KSZ8041NL_PHYID1		2	/* PHY Idendifier Register 1 */
#define KSZ8041NL_PHYID2		3	/* PHY Idendifier Register 2 */
#define KSZ8041NL_ANAR		4	/* Auto_Negotiation Advertisement Register  */
#define KSZ8041NL_ANLPAR		5	/* Auto_negotiation Link Partner Ability Register */
#define KSZ8041NL_ANER		6	/* Auto-negotiation Expansion Register  */
#define KSZ8041NL_DSCR		16	/* Specified Configuration Register */
#define KSZ8041NL_DSCSR		17	/* Specified Configuration and Status Register */
#define KSZ8041NL_10BTCSR		18	/* 10BASE-T Configuration and Satus Register */
#define KSZ8041NL_MDINTR		0x1B	/* Interrupt control/Status Register */
#define KSZ8041NL_RECR		22	/* Specified Receive Error Counter Register */
#define KSZ8041NL_DISCR		23	/* Specified Disconnect Counter Register */
#define KSZ8041NL_RLSR		24	/* Hardware Reset Latch State Register */
#define KSZ8041NL_PHY_CTRL_1 0x1E // PHY Control 1
#define KSZ8041NL_PHY_CTRL_2 0x1F // PHY Control 2

/* --Bit definitions: KSZ8041NL_BMCR */
#define KSZ8041NL_RESET   	         (1 << 15)	/* 1= Software Reset; 0=Normal Operation */
#define KSZ8041NL_LOOPBACK	         (1 << 14)	/* 1=loopback Enabled; 0=Normal Operation */
#define KSZ8041NL_SPEED_SELECT      (1 << 13)	/* 1=100Mbps; 0=10Mbps */
#define KSZ8041NL_AUTONEG	         (1 << 12)
#define KSZ8041NL_POWER_DOWN        (1 << 11)
#define KSZ8041NL_ISOLATE           (1 << 10)
#define KSZ8041NL_RESTART_AUTONEG   (1 << 9)
#define KSZ8041NL_DUPLEX_MODE       (1 << 8)
#define KSZ8041NL_COLLISION_TEST    (1 << 7)

/*--Bit definitions: KSZ8041NL_BMSR */
#define KSZ8041NL_100BASE_T4        (1 << 15)
#define KSZ8041NL_100BASE_TX_FD     (1 << 14)
#define KSZ8041NL_100BASE_TX_HD     (1 << 13)
#define KSZ8041NL_10BASE_T_FD       (1 << 12)
#define KSZ8041NL_10BASE_T_HD       (1 << 11)
#define KSZ8041NL_MF_PREAMB_SUPPR   (1 << 6)
#define KSZ8041NL_AUTONEG_COMP      (1 << 5)
#define KSZ8041NL_REMOTE_FAULT      (1 << 4)
#define KSZ8041NL_AUTONEG_ABILITY   (1 << 3)
#define KSZ8041NL_LINK_STATUS       (1 << 2)
#define KSZ8041NL_JABBER_DETECT     (1 << 1)
#define KSZ8041NL_EXTEND_CAPAB      (1 << 0)

/*--definitions: KSZ8041NL_PHYID1 */
#define KSZ8041NL_PHYID1_OUI	 0x885
#define KSZ8041NL_LSB_MASK	         0x3F

/*--Bit definitions: KSZ8041NL_ANAR, KSZ8041NL_ANLPAR */
#define KSZ8041NL_NP               (1 << 15)
#define KSZ8041NL_ACK              (1 << 14)
#define KSZ8041NL_RF               (1 << 13)
#define KSZ8041NL_FCS              (1 << 10)
#define KSZ8041NL_T4               (1 << 9)
#define KSZ8041NL_TX_FDX           (1 << 8)
#define KSZ8041NL_TX_HDX           (1 << 7)
#define KSZ8041NL_10_FDX           (1 << 6)
#define KSZ8041NL_10_HDX           (1 << 5)
#define KSZ8041NL_AN_IEEE_802_3	0x0001

/*--Bit definitions: KSZ8041NL_ANER */
#define KSZ8041NL_PDF              (1 << 4)
#define KSZ8041NL_LP_NP_ABLE       (1 << 3)
#define KSZ8041NL_NP_ABLE          (1 << 2)
#define KSZ8041NL_PAGE_RX          (1 << 1)
#define KSZ8041NL_LP_AN_ABLE       (1 << 0)

/*--Bit definitions: KSZ8041NL_DSCR */
#define KSZ8041NL_BP4B5B           (1 << 15)
#define KSZ8041NL_BP_SCR           (1 << 14)
#define KSZ8041NL_BP_ALIGN         (1 << 13)
#define KSZ8041NL_BP_ADPOK         (1 << 12)
#define KSZ8041NL_REPEATER         (1 << 11)
#define KSZ8041NL_TX               (1 << 10)
#define KSZ8041NL_RMII_ENABLE      (1 << 8)
#define KSZ8041NL_F_LINK_100       (1 << 7)
#define KSZ8041NL_SPLED_CTL        (1 << 6)
#define KSZ8041NL_COLLED_CTL       (1 << 5)
#define KSZ8041NL_RPDCTR_EN        (1 << 4)
#define KSZ8041NL_SM_RST           (1 << 3)
#define KSZ8041NL_MFP SC           (1 << 2)
#define KSZ8041NL_SLEEP            (1 << 1)
#define KSZ8041NL_RLOUT            (1 << 0)

/*--Bit definitions: KSZ8041NL_10BTCSR */
#define KSZ8041NL_LP_EN           (1 << 14)
#define KSZ8041NL_HBE             (1 << 13)
#define KSZ8041NL_SQUELCH         (1 << 12)
#define KSZ8041NL_JABEN           (1 << 11)
#define KSZ8041NL_10BT_SER        (1 << 10)
#define KSZ8041NL_POLR            (1 << 0)


/*--Bit definitions: KSZ8041NL_MDINTR */
#define KSZ8041NL_JABBER_MASK        (1 << 15)
#define KSZ8041NL_REV_ERROR__MASK        (1 << 14)
#define KSZ8041NL_PAGE_MASK       (1 << 9)
#define KSZ8041NL_PARALLEL_MASK       (1 << 8)
#define KSZ8041NL_LINK_DOWN_MASK      (1 << 10)
#define KSZ8041NL_LINK_UP_MASK      (1 << 8)
#define KSZ8041NL_LINK_CHANGE     (1 << 2)
#define KSZ8041NL_INTR_STATUS     (1 << 0)

// Bit Definiations: KSZ8041NL_PHY_CTRL_2
#define KSZ8041NL_10HDX (1 << 2)
#define KSZ8041NL_100HDX (2 << 2)
#define KSZ8041NL_10FDX (5 << 2)
#define KSZ8041NL_100FDX (6 << 2)

/******************  function prototypes **********************/
static unsigned int  ksz8041nl_IsPhyConnected(AT91PS_EMAC p_mac);
static unsigned char ksz8041nl_GetLinkSpeed(AT91PS_EMAC p_mac);
static unsigned char ksz8041nl_AutoNegotiate(AT91PS_EMAC p_mac, int *status);
static unsigned char ksz8041nl_InitPhy(AT91PS_EMAC p_mac);
