/******************************************************************
 * @file   psoc_fw.h
 * @author Richard Luo
 * @date   2008-09-22
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _PSOC_FW_H
#define _PSOC_FW_H 1

#ifdef __KERNEL__

#include <linux/types.h>
#include <linux/firmware.h>

#else

#include <stddef.h>
#include <stdint.h>

struct firmware {
	size_t size;
	uint8_t *data;
};


#endif

typedef struct psoc_fw_record psoc_fw_record_t;

enum FW_VECTOR_TYPES {
    FWV_DATA = 0,
    FWV_END_OF_FILE = 1,
    FWV_EXTENDED_ADDR = 4,
};

struct psoc_fw_record {
    uint8_t num_;           /* number of data bytes to follow */
    uint8_t type_;          /* record type -- 0x00 = Data */
    uint16_t saddr_;        /* starting addres int the FLASH for record  */
    uint8_t data_[0];       /* data */
};


int psoc_record_next (psoc_fw_record_t **prec);
void psoc_fw_set_firmware (const struct firmware *p);
int psoc_validate_checksum ( const psoc_fw_record_t *prec );
uint8_t twos_complete_checksum (const void *buf, size_t size);
uint8_t psoc_get_record_checksum ( const psoc_fw_record_t *prec );
int psoc_validate_firmware ( const struct firmware *fwm);


#endif /* _PSOC_FW_H */



