#!/bin/sh
################################################################
# psoc.sh
# Richard Luo
# 2008-07-24
################################################################

kmodule=$1
devname=$2

major=0

get_dev_major () {

    if [ -z $1 ] ; then
        echo "please input your module name"
        return 0
    else
        echo "module name:[$1]"
    fi

    eval "$2=$(awk "\$2==\"$1\" {print \$1}" /proc/devices)"
}


if [ -z $kmodule ] || [ -z $devname ] ; then 
    echo -ne "usage: \n\t./$0 <module name> <device file name> \n"
    return 0
fi

get_dev_major $kmodule major

echo "\$major: $major"

full_devname="/dev/$devname"

if [ -e $full_devname ] ; then
    echo "$full_devname exist, delete it"
    rm -f $full_devname
    if [ -e $full_devname ] ; then
        echo "delete $full_devname failed, exit"
        return 0
    else
        echo "delete $full_devname ok"
    fi
fi

mknod $full_devname c $major 0 

if [ ! -c $full_devname ] ; then
    echo "create dev file $full_devname failed!!!"
    exit -1;
fi

echo "****************************************************************"
echo "device file [$full_devname] of module [$kmodule] have been crated ok!!"
echo "****************************************************************"




