/******************************************************************
 * @file   card_buf.c
 * @author Richard Luo
 * @date   2008-05-19
 * 
 * @brief  
 * 
 ****************************************************************** 
 */


#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/init.h>

#include <linux/string.h>
#include <asm/bitops.h>
#include "card_buf.h"


void card_buf_clear (card_buf_t *b)
{
    memset(b, 0, sizeof(*b));
}

/** 
 * 
 * 
 * @param b 
 * @param val 
 * 
 * @return 0 on success.
 */
int card_buf_append_bit (card_buf_t *b, char val)
{
    int nr = b->bits_;
    void *addr = b->buf_;

    if (nr >= MAX_BUF_NUM_OF_BITS)
        return -1;
    
    if (val) set_bit(nr, addr);
    else clear_bit(nr, addr);

    ++b->bits_;

    return 0;
}


static inline void dump_one_bit(unsigned char b, int idx)
{
    unsigned char c = 0x1 << idx;
    printk(KERN_DEBUG "%d", (b&c) ? 1 : 0);
}


static inline void dump_one_byte(unsigned char b)
{
    int i;
    for (i=0; i < 8; ++i) {
        unsigned char c = 0x1 << i;
        printk(KERN_DEBUG "%d", (b&c) ? 1 : 0);
    }
}


void mem_byte_bits_dump (void *addr, int bitsnum)
{
    uint8_t c;
    int i, nbyte, nbits;
    uint8_t *p = (uint8_t*)addr;

    nbyte = bitsnum/8;
    nbits = bitsnum%8;


    printk(KERN_DEBUG "bits num: [%d] \n", bitsnum);
    printk(KERN_DEBUG "bits val: ");

    for (i=0; i < nbyte; ++i) {
        c = (uint8_t)p[i];
        dump_one_byte(c);
    }
    
    c = (uint8_t)p[nbyte];

    for (i=0; i < nbits; ++i)
        dump_one_bit(p[nbyte], i);

    printk(KERN_DEBUG "\n");

}

void card_buf_dump (card_buf_t *b)
{
    mem_byte_bits_dump(b->buf_, b->bits_);
}

/** 
 * 
 * 
 * @param b assumed not to be NULL
 */
void card_buf_align_8 (card_buf_t *b)
{
    for ( ; b->bits_%8; ++b->bits_)
        clear_bit(b->bits_, (void*)b->buf_);
}

