/******************************************************************
 * @file   card_buf.h
 * @author Richard Luo
 * @date   2008-05-19
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#ifndef _CARD_BUF_H
#define _CARD_BUF_H 1

#include "reader_consts.h"

enum {
    MAX_BUF_NUM_OF_BITS = MAX_CARD_DATA_SIZE * 8
};

typedef struct {
    char buf_[MAX_CARD_DATA_SIZE];
    unsigned bits_;
} card_buf_t;


void card_buf_clear (card_buf_t *b);
int card_buf_append_bit (card_buf_t *b, char val);
void card_buf_align_8 (card_buf_t *b);
void card_buf_dump (card_buf_t *b);
void mem_byte_bits_dump (void *addr, int bitsnum);

static inline unsigned card_buf_bytes_num (const card_buf_t *b)
{
    return (b->bits_+7)/8;
}

#endif /* _CARD_BUF_H */



