/******************************************************************
 * @file   testdrv.c
 * @author Richard Luo
 * @date   2008-05-21
 * 
 * @brief  
 * 
 ****************************************************************** 
 */

#include <stdio.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <unistd.h>

#include <linux/ioctl.h>
#include "reader_ioctls.h"



static inline void dump_one_bit(unsigned char b, int idx)
{
    unsigned char c = 0x1 << idx;
    printf("%d", (b&c) ? 1 : 0);
}


static inline void dump_one_byte(unsigned char b)
{
    int i;
    for (i=0; i < 8; ++i) {
        unsigned char c = 0x1 << i;
        printf("%d", (b&c) ? 1 : 0);
    }
}


/* static inline void dump_buf (void *buf, int bits) */
/* { */

/*     int i; */
/*     unsigned char *pv = (unsigned char*)buf; */
    
/*     printf("num of bytes: %d\n", n); */

/*     for (i=0; i < n; ++i) */
/*         dump_one_byte(pv[i]); */
/* } */

static void dump_buf (void *buf, int bits)
{
    unsigned char c;
    unsigned char *pb = (unsigned char *)buf;
    int i, nbyte, nbits;
    nbyte = bits/8;
    nbits = bits%8;

    printf("==== bits: [%d] \n", bits);

    for (i=0; i < nbyte; ++i)
        dump_one_byte(pb[i]);
    
    for (i=0; i < nbits; ++i)
        dump_one_bit(pb[nbyte], i);

    printf("\n");
}


static inline int to_num_of_bytes ( int bitsn )
{
    return (bitsn+7)/8;
}

static int format_card_data (void *drvdata, int nbits, size_t size)
{
    struct format {
        uint8_t reader_no_;
        uint8_t num_of_bits_;
        uint8_t num_of_bytes_;
        uint8_t num_of_ignore_bits_;
        uint8_t data_[128];
    };

    format f;

    f.num_of_bytes_ = to_num_of_bytes(nbits);

    if (++f.num_of_bytes_ < size) // why ++? reader no occupied one byte.
        return -1;
    
    f.num_of_bits_ = nbits;

    f.reader_no_ = *(uint8_t*)drvdata;

    f.num_of_ignore_bits_ = 8 - f.num_of_bits_%8;

    memcpy(f.data_, drvdata+1, f.num_of_bytes_);
    memcpy(drvdata, &f, size);
    return 0;
}

int main(int argc, char *argv[])
{
    assert(argc == 2);
    
    printf("before open:%s \n", argv[1]);

    int fd = open(argv[1], O_RDONLY);


    char buf[128] = {0};

    assert(fd >= 0);

    printf("before read :%d \n", fd);
    sleep(3);

    int sz;

    while ( (sz= read(fd, buf, sizeof(buf))) > 0) {
        assert(sz >= 0);
        printf("card info \n");
        dump_buf(buf, sz);
        printf ("\n");

        printf("before trun on \n");
        ioctl(fd, READER_IOCT_RELAY_ON, 0);
        ioctl(fd, READER_IOCT_LED_ON, 0);
        printf("after trun on \n");

        sleep(2);

        printf("before turn off \n");
        ioctl(fd, READER_IOCT_RELAY_OFF, 0);
        ioctl(fd, READER_IOCT_LED_OFF, 0);
        printf("after turn off \n");

    }
    
    return 0;
}

