/******************************************************************
 * @file   treader.c
 * @author Richard Luo
 * @date   2008-08-19
 * 
 * @brief  
 * 
 ****************************************************************** 
 */


#include <stdint.h>
#include <stdio.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <getopt.h>
#include <stdlib.h>

#include <stdio.h>
#include <errno.h>

static const char *dev_name = "/dev/reader33";


static void print_usage(const char *prog)
{
	printf("Usage: %s [-nofOFlt]\n", prog);
	puts(
        "  -d --device-file   specify the relay device file, default is \"/dev/card_reader\"\n"
        );
	exit(1);
}


static void parse_opts(int argc, char *argv[])
{
	while (1) {
		static const struct option lopts[] = {
			{ "device-file",    1, 0, 'd' },
			{ NULL, 0, 0, 0 },
		};
		int c;

		c = getopt_long(argc, argv, "d:", lopts, NULL);

		if (c == -1)
			break;

		switch (c) {
		case 'd':
			dev_name = optarg;
			break;

		default:
			print_usage(argv[0]);
			break;
		}
	}
}


struct format {
    uint8_t reader_no_;
    uint8_t num_of_bits_;
    uint8_t num_of_bytes_;
    uint8_t num_of_ignore_bits_;
    uint8_t data_[128];
};

static dump_format (struct format *fmt)
{
    printf("\t reader_no_:%d\n", fmt->reader_no_);
    printf("\t num_of_bits_:%d\n", fmt->num_of_bits_);
    printf("\t num_of_bytes_:%d\n", fmt->num_of_bytes_);
    printf("\t num_of_ignore_bits_:%d\n", fmt->num_of_ignore_bits_);
}

static int reader_available (int fd)
{
    fd_set rset;
    FD_ZERO(&rset);
    FD_SET(fd, &rset);

    for (;;) {
        printf("before select reader: \n");
        const int ret = select(fd+1, &rset, NULL, NULL, NULL);
        if (ret < 0) {
            if (errno == EINTR)
                continue;     /* back to for() */
            else
                return 0;
        }
        else if (0 == ret)
            return 0;
        else {
            assert(FD_ISSET(fd, &rset));
            return 1;
        }
    }
}


int main(int argc, char *argv[])
{
    int sz;
    char buf[128] = {0};
    int fd = open(dev_name, O_RDONLY|O_NONBLOCK);
    assert(fd >= 0);

    for ( ; ; ) {
        if (reader_available(fd) > 0) {
            sz = read(fd, buf, sizeof(buf));
            struct format *fmt = (struct format *) buf;
            dump_format(fmt);
        }
        else {
            perror("select error:");
            break;
        }
    }

    return 0;
}

