/******************************************************************
 * @file   locked_file_stream.c
 * @author Richard Luo, cdominant7@gmail.com
 * @date   2010/10/27 07:24:52
 * 
 * @brief  Did he have passion?
 * 
 ****************************************************************** 
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <strings.h>

#include <fcntl.h>
#include <stdio.h>
#include <pthread.h>
#include <assert.h>

static int turn_on_mandatory_lock(int fd) 
{
    struct stat		statbuf;
    /* turn on set-group-ID and turn off group-execute */
    if (fstat(fd, &statbuf) < 0)
        return -1;

    if (fchmod(fd, (statbuf.st_mode & ~S_IXGRP) | S_ISGID) < 0)
        return -1;

    return 0;
}

static int lock_reg(int fd, int cmd, int type, off_t offset, int whence, off_t len)
{
    struct flock	lock;

    lock.l_type = type;		/* F_RDLCK, F_WRLCK, F_UNLCK */
    lock.l_start = offset;	/* byte offset, relative to l_whence */
    lock.l_whence = whence;	/* SEEK_SET, SEEK_CUR, SEEK_END */
    lock.l_len = len;		/* #bytes (0 means to EOF) */

    return(fcntl(fd, cmd, &lock));
}

#include <sys/file.h>


//lock_reg((fd), F_SETLKW, F_WRLCK, (offset), (whence), (len));
static int lockw_whole(int fd, int lock_type) // block if mutexed.
{
    return lock_reg(fd, F_SETLKW, lock_type, 0, SEEK_SET, 0);
//    return flock(fd, lock_type);
}

FILE *fopen_locked(const char *path, const char *mode)
{
    int m, type, fd;
    
    if (!mode || !path)
        return NULL;

    if (mode[0] == 'w') {
        m = O_WRONLY;
        type = F_WRLCK;
//        type = LOCK_EX;
    }
    else if (mode[0] == 'r') {
        m = O_RDONLY;
        type = F_RDLCK;
//        type = LOCK_SH;
    }
    else {
        return NULL;
    }

    if ((fd = open(path, m, S_IRWXU)) < 0 ) {
        goto over;
    }

    if (turn_on_mandatory_lock(fd) < 0) {
        goto failed;
    }

    if (lockw_whole(fd, type) < 0 ) {
        goto failed;
    }

    return fdopen(fd, mode);

failed:
    close(fd);

over:
    return NULL;
}

