#!/bin/sh
#
# App backup config file
#

echo "App backup config file" OUTPUT_REDIRECT

INIT_FILE=/etc/network/interfaces
BACKUP_FILE=/etc/network/interfaces.old

# if network init file doesn't exist or size of zero
if [[ $(find $INIT_FILE -type f -size +10c 2>/dev/null) ]]
then
	echo "$INIT_FILE OK" OUTPUT_REDIRECT
	:
else
	# init doesn't exist or zero on size, copy backup to its place
	echo "$INIT_FILE corrupted, using backup" OUTPUT_REDIRECT
	cp $BACKUP_FILE $INIT_FILE
fi

