//==========================================================================
//
//      devs/watchdog/cortexm/lm3s/current/src/watchdog_lm3s.cxx
//
//      Watchdog implementation for Cortex-M LM3S.
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2011 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    stuartw
// Date:         2011-07-12
// Purpose:      Watchdog class implementation
// Description:  Contains an implementation of the Watchdog class for use
//               with the Cortex-M LM3S processors.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/system.h>             // system configuration file
#include <pkgconf/watchdog.h>           // configuration for this package
#include <pkgconf/kernel.h>             // kernel config

#include <cyg/infra/cyg_trac.h>         // tracing macros
#include <cyg/kernel/instrmnt.h>        // instrumentation

#include <cyg/hal/hal_io.h>             // IO register access

#include <cyg/io/watchdog.hxx>          // watchdog API

// -------------------------------------------------------------------------

// We are using Watchdog0
#define CYGHWR_HAL_LM3S_WDOG_BASE   CYGHWR_HAL_LM3S_WDT0

// Define the individual registers
#define WDTLOAD_REG   ( CYGHWR_HAL_LM3S_WDOG_BASE + CYGHWR_HAL_LM3S_WDT_LOAD )
#define WDTVALUE_REG  ( CYGHWR_HAL_LM3S_WDOG_BASE + CYGHWR_HAL_LM3S_WDT_VALUE )
#define WDTCTL_REG    ( CYGHWR_HAL_LM3S_WDOG_BASE + CYGHWR_HAL_LM3S_WDT_CTL )

// Desired watchdog resolution in seconds. Note that because the hardware
// counts down twice it will take twice this long to reset.
#define LM3S_WATCHDOG_RESOLUTION    30

// Used to convert the resolution to that expected by eCos.
#define LM3S_WATCHDOG_RESOLUTION_MULTIPLIER 100000000

// The maximum value we can configure for the watchdog load.
#define LM3S_WATCHDOG_MAX_VALUE 0xFFFFFFFF

// Calculate the value we need to configure to get the desired resolution.
// Throw up an error if the value is invalid.
#define LM3S_WATCHDOG_VALUE                                             \
            ( LM3S_WATCHDOG_RESOLUTION * CYGHWR_HAL_CORTEXM_LM3S9XXX_SYSCLK )
#if ( LM3S_WATCHDOG_VALUE > LM3S_WATCHDOG_MAX_VALUE )
#error "Requested watchdog resolution too large"
#endif


// -------------------------------------------------------------------------
// Called by the constructor

void
Cyg_Watchdog::init_hw(void)
{
    CYG_REPORT_FUNCTION();
    
    // Set the resolution up in the units expected by eCos
    // resolution is a cyg_uint64 filed, we need the cast below to keep the
    // compiler happy.
    resolution = ( (cyg_uint64)LM3S_WATCHDOG_RESOLUTION *
                   LM3S_WATCHDOG_RESOLUTION_MULTIPLIER );

    CYG_REPORT_RETURN();
}

// -------------------------------------------------------------------------
// Start the watchdog running.

void
Cyg_Watchdog::start()
{
    CYG_REPORT_FUNCTION();

    CYG_ADDRESS     sc = CYGHWR_HAL_LM3S_SC;

    cyg_uint32 val;

    // Enable the Watchdog0 module
    HAL_READ_UINT32(( sc + CYGHWR_HAL_LM3S_SC_RCGC0 ), val );
    val |= CYGHWR_HAL_LM3S_SC_RCGC0_WDT0;
    HAL_WRITE_UINT32(( sc + CYGHWR_HAL_LM3S_SC_RCGC0 ), val );
    
    // Write the load value
    HAL_WRITE_UINT32( WDTLOAD_REG, LM3S_WATCHDOG_VALUE );

    // Enable the watchdog
    HAL_WRITE_UINT32( WDTCTL_REG,
                      ( CYGHWR_HAL_LM3S_WDT_CTL_INTEN |
                        CYGHWR_HAL_LM3S_WDT_CTL_RESEN ));

    CYG_REPORT_RETURN();
}

// -------------------------------------------------------------------------
// Reset watchdog timer. This needs to be called regularly to prevent
// the watchdog firing.

void
Cyg_Watchdog::reset()
{    
    CYG_REPORT_FUNCTION();

    // Write the load value
    HAL_WRITE_UINT32( WDTLOAD_REG, LM3S_WATCHDOG_VALUE );
    
    CYG_REPORT_RETURN();
}

// -------------------------------------------------------------------------
// Configure the watchdog to trigger immediately.

void
Cyg_Watchdog::trigger()
{
    CYG_REPORT_FUNCTION();

    // Write the load value to zero which causes the system to reset.
    HAL_WRITE_UINT32( WDTLOAD_REG, 0 );

    CYG_REPORT_RETURN();
}

// -------------------------------------------------------------------------
// EOF watchdog_lm3s.cxx
