#
# CPU
#  Use to define the core CPU you are building for.
#
# TARGET
#  The target embedded platform you are building for. (Including trailing -)
#  For example   arm-elf-
#  If not building a cross compiled system then leave blank
#
CPU=X86

ifeq ($(CPU),X86)
# Specify cross-compiler target
TARGET=
GCCPREFIX =
# Specify CPU flags
CPUFLAGS =
GNULIBS = -lc -lgcc
endif

ifeq ($(CPU),AT91)
# Specify cross-compiler target
TARGET=arm-elf-
GCCPREFIX = arm-elf
# Chip used for compilation
# (can be overriden by adding CHIP=chip to the command-line)
CHIP  = at91sam7xc512
# Specify CPU flags
CPUFLAGS = -D$(CHIP) -mcpu=arm7tdmi
CPUFLAGS += -mlong-calls -ffunction-sections
CPUFLAGS += -D__THUMB_LIBRARY__
CPUFLAGS += -DNO_SYSLOG
GNUPATH  = "C:\Program Files\Yagarto\lib\gcc\arm-elf\4.2.2"
GNULIBS = -lc -lgcc
endif

ifeq ($(CPU),H8S)
# Specify cross-compiler target
TARGET=h8300-elf-
GCCPREFIX = h8300-elf
# Chip used for compilation
# (can be overriden by adding CHIP=chip to the command-line)
CHIP  = h8s2676
# Specify CPU flags
# CPUFLAGS = -D$(CHIP) -ms -ms2600 -mint32
CPUFLAGS = -D$(CHIP) -ms -ms2600
CPUFLAGS += -DNO_SYSLOG -DAES_LONG -DSIXTEEN_BIT

GNUPATH  = "C:\Program Files\KPIT Cummins\GNUH8v0402-ELF\h8300-elf\h8300-elf\lib\h8300s"
GNU2PATH = "C:\Program Files\KPIT Cummins\GNUH8v0402-ELF\h8300-elf\lib\gcc\h8300-elf\3.4-GNUH8_v0402\h8300s"
GNULIBS = -lc -lgcc
endif

# Tool Names
CROSS_COMPILE   = ${TARGET}
AS              = $(CROSS_COMPILE)as
AR              = $(CROSS_COMPILE)ar
CC              = $(CROSS_COMPILE)gcc
CPP             = $(CC) -E
CPLUSPLUS       = $(CROSS_COMPILE)g++
LD              = $(CROSS_COMPILE)ld
NM              = $(CROSS_COMPILE)nm
OBJCOPY         = $(CROSS_COMPILE)objcopy
OBJDUMP         = $(CROSS_COMPILE)objdump
RANLIB          = $(CROSS_COMPILE)ranlib
READELF         = $(CROSS_COMPILE)readelf
SIZE            = $(CROSS_COMPILE)size
STRINGS         = $(CROSS_COMPILE)strings
STRIP           = $(CROSS_COMPILE)strip

ifeq ($(DEBUG),yes)
DEBUG_FLAGS = -g -O0 -gdwarf-2
else
# Turn on full optimisation and disable ASSERTs for non-debug builds
DEBUG_FLAGS = -O3 -DNOASSERT
endif

#
# Top level includes
#
TOPINCLUDE=$(TOPLEVEL)/src/include

#
# Location of the crypto meter directory with respect to the Makefile which
# includes this file.
#
CRYPTODIR=$(TOPLEVEL)/src/crypto

#
# Location of the include directory with respect to the Makefile which
# includes this file.
#
INCLUDEDIR=$(TOPLEVEL)/src/crypto/include

#
# Location of the obj directory with respect to the Makefile which
# includes this file.
#
OBJDIR=$(TOPLEVEL)/$(OBJDIRNAME)

#
# Location of libraries with respect to the Makefile which
# includes this file.
#
LIBDIR      = $(TOPLEVEL)/lib

#
# Location of binaries with respect to the Makefile which
# includes this file.
#
BINDIR      = $(TOPLEVEL)/bin

# Macro used when comparing object files
ifneq ($(COMPARE), yes)
CFLAGS += -D__L_I_N_E__=__LINE__ -D__F_I_L_E__=__FILE__ -DINCLUDE_BUILD_DATE
else
CFLAGS += -D__L_I_N_E__=0 -D__F_I_L_E__=\"File\"
endif

# Create a dependancy file from a C source file.
$(OBJDIR)/%.d: %.c
	@set -e; $(CC) -MM $(CFLAGS) $<                                           \
                | sed 's^\($(*F)\)\.o[ :]*^$(@D)/\1.o $@ : ^g' > $@;    \
        echo 'created dependency file $@';                              \
        [ -s $@ ] || rm -f $@

# Create an object file from a C source file.
$(OBJDIR)/%.o: %.c
	$(CC) $(CFLAGS) -c -o $@ $<

# Common compiler flags
CFLAGS += -I. -I$(INCLUDEDIR)
CFLAGS += $(CPUFLAGS) -ffunction-sections -Wall -Werror
CFLAGS += -fno-builtin -fsigned-char -Wno-trigraphs -Wpointer-arith
CFLAGS += -Wwrite-strings -Wstrict-prototypes -Wshadow -fomit-frame-pointer
CFLAGS += -DOPENSSL_NO_SOCK -DOPENSSL_NO_ENGINE -DOPENSSL_NO_OBJECT
CFLAGS += -DOPENSSL_NO_EVP
ifneq ($(FULL), yes)
CFLAGS += -DOPENSSL_NO_BIO -DOPENSSL_NO_ERR -DOPENSSL_NO_FP_API
endif

CFLAGS += $(DEBUG_FLAGS)

ifeq ($(PERFTEST),yes)
CFLAGS += -DPERFTEST
endif

ifeq ($(TEST),yes)
CFLAGS += -DTEST
else
CFLAGS += -DNTEST
endif

ASFLAGS += -g -I$(INCLUDEDIR) $(CPUFLAGS) $(DEBUG_FLAGS)
ASFLAGS += -D__ASSEMBLY__

ALL_FLAGS = $(CFLAGS) $(DEBUG_FLAGS) $(CPU)
