/*!
 * \file    display_entropy.c
 * \brief   This file contains the code to dislpaly the generated entropy.
 *
 * \par File contents
 * This file contains the code to print out the entropy values generated by the
 * "GenEntropy()" and "GenEntropyTest()" functions. The entropy values are
 * printed out in ascii format in blocks of 16. Therefore, 1 printed block
 * corresponds to the equivalent plaintext block read in.
 */
#include "gen_entropy.h"

#if TEST
void DisplayEntropy( unsigned char *_entropy, unsigned int NUM_BYTES_ENTROPY )
{
    static unsigned int print_i = 0;
    static unsigned int print_j = 0;
    static unsigned int print_limit = 0;

    if ( NUM_BYTES_ENTROPY % AES_BLOCK_SIZE == 0 )
    {
        print_limit = NUM_BYTES_ENTROPY / AES_BLOCK_SIZE;
    }
    else
    {
        print_limit = ( NUM_BYTES_ENTROPY / AES_BLOCK_SIZE ) + 1;
    }

    printf( "\n--------------------------- ENTROPY ---------------------------\n" );

    for (print_i = 0; print_i < print_limit; print_i++)
    {
        for ( print_j = 0; print_j < AES_BLOCK_SIZE; print_j++ )
        {
            printf( "%03d ", _entropy[print_j + ( print_i * AES_BLOCK_SIZE )] );
        }
        printf( "\n" );
    }

    printf( "---------------------------------------------------------------\n" );

    return;
}
#endif /* TEST */
/******************************************************************************/
