# Custom post build script for sam9g25-isp20 release build

#!/bin/sh
TARGETDIR=$1

# Remove unused initialisation scripts
rm -f $TARGETDIR/etc/init.d/S50sshd

# Disable scripts outputs and console for release configuration
sed -i -- 's/OUTPUT_REDIRECT/>> \/dev\/null/g' $TARGETDIR/etc/init.d/*
sed -i -- 's/OUTPUT_REDIRECT/>> \/dev\/null/g' $TARGETDIR/opt/isp20/*.sh
sed -i -- '/getty/s/^\t\t/\t\t# Disabled for release build: /g' $TARGETDIR/opt/isp20/*.sh

# Do not try to mount devpts - no support in kernel
sed -i -- 's/^devpts/# devpts/g' $TARGETDIR/etc/fstab

# Strip libpthread*.so* and ld-*.so*. The top level Buildroot Makefile treats these differently to
# support debug. Access toolchain using HOST_DIR environment variable
$HOST_DIR/bin/arm-none-linux-gnueabi-strip --remove-section=.comment --remove-section=.note $TARGETDIR/lib/ld-*.so*
$HOST_DIR/bin/arm-none-linux-gnueabi-strip --remove-section=.comment --remove-section=.note $TARGETDIR/lib/libpthread*.so*

