################################################################################
#
# Names of sources and paths to them
#
################################################################################
#
# Description:
# This file defines names of files and folders of libraries for ISP20 project.
# Moreover it defines script and library paths.
#
################################################################################

# Names of top level scripts
BUILD_SCRIPT_NAME="build_libs.sh"
CLEAN_SCRIPT_NAME="clean_libs.sh"
GET_SCRIPT_NAME="get_libs.sh"

# Names of library scripts
# build (compile)
BUILD_OPENSSL_SCRIPT_NAME="build_openssl.sh"
BUILD_POCO_SCRIPT_NAME="build_poco.sh"
BUILD_PROTOBUF_SCRIPT_NAME="build_protobuf.sh"
BUILD_JSON_SCRIPT_NAME="build_json.sh"
BUILD_ISOM_SCRIPT_NAME="build_isom.sh"
# clean (delete)
CLEAN_OPENSSL_SCRIPT_NAME="clean_openssl.sh"
CLEAN_POCO_SCRIPT_NAME="clean_poco.sh"
CLEAN_PROTOBUF_SCRIPT_NAME="clean_protobuf.sh"
CLEAN_JSON_SCRIPT_NAME="clean_json.sh"
CLEAN_ISOM_SCRIPT_NAME="clean_isom.sh"
# get (download)
GET_OPENSSL_SCRIPT_NAME="get_openssl.sh"
GET_POCO_SCRIPT_NAME="get_poco.sh"
GET_PROTOBUF_SCRIPT_NAME="get_protobuf.sh"
GET_JSON_SCRIPT_NAME="get_json.sh"
GET_ISOM_SCRIPT_NAME="get_isom.sh"

# Names of library folders
OPENSSL_DIR_NAME="openssl"
POCO_DIR_NAME="poco"
PROTOBUF_DIR_NAME="protobuf"
JSON_DIR_NAME="libjson"
ISOM_DIR_NAME="isom"

# Names of library sub-folders
SOURCE_DIR_NAME="src"
HOST_DIR_NAME="host"
BUILD_DIR_NAME="build"

########################################
# Paths to top level scripts
# Note: Each path is relative to this file location itself.
########################################
LIB_BUILD_SCRIPT_FILE="${BUILD_SCRIPT_NAME}"
LIB_CLEAN_SCRIPT_FILE="${CLEAN_SCRIPT_NAME}"
LIB_GET_SCRIPT_FILE="${GET_SCRIPT_NAME}"

########################################
# Paths to library scripts and libraries themselves
# Note: Each path is relative to this file location itself.
########################################
# OpenSSL Library
LIB_OPENSSL_DIR="${OPENSSL_DIR_NAME}"
#LIB_OPENSSL_BUILD_SCRIPT_FILE="${LIB_OPENSSL_DIR}/${BUILD_OPENSSL_SCRIPT_NAME}"
#LIB_OPENSSL_CLEAN_SCRIPT_FILE="${LIB_OPENSSL_DIR}/${CLEAN_OPENSSL_SCRIPT_NAME}"
#LIB_OPENSSL_GET_SCRIPT_FILE="${LIB_OPENSSL_DIR}/${GET_OPENSSL_SCRIPT_NAME}"
#LIB_OPENSSL_SRC_DIR="${LIB_OPENSSL_DIR}/${SOURCE_DIR_NAME}"
#LIB_OPENSSL_HOST_DIR="${LIB_OPENSSL_DIR}/${HOST_DIR_NAME}"
#LIB_OPENSSL_LIB_DIR="${LIB_OPENSSL_HOST_DIR}/lib"
LIB_OPENSSL_LIB_DIR="ExtLibs/ExtLibs_Output/crypto-engine-openssl/lib"
LIB_OPENSSL_INC_DIR="ExtLibs/ExtLibs_Output/crypto-engine-openssl/include"
# POCO C++ Libraries
#LIB_POCO_DIR="${POCO_DIR_NAME}"
#LIB_POCO_BUILD_SCRIPT_FILE="${LIB_POCO_DIR}/${BUILD_POCO_SCRIPT_NAME}"
#LIB_POCO_CLEAN_SCRIPT_FILE="${LIB_POCO_DIR}/${CLEAN_POCO_SCRIPT_NAME}"
#LIB_POCO_GET_SCRIPT_FILE="${LIB_POCO_DIR}/${GET_POCO_SCRIPT_NAME}"
#LIB_POCO_SRC_DIR="${LIB_POCO_DIR}/${SOURCE_DIR_NAME}"
#LIB_POCO_HOST_DIR="${LIB_POCO_DIR}/${HOST_DIR_NAME}"
LIB_POCO_LIB_DIR="ExtLibs/ExtLibs_Output/lib"
LIB_POCO_INC_DIR="ExtLibs/ExtLibs_Output/Inc"
# Protocol Buffers Library
#LIB_PROTOBUF_DIR="${PROTOBUF_DIR_NAME}"
#LIB_PROTOBUF_BUILD_SCRIPT_FILE="${LIB_PROTOBUF_DIR}/${BUILD_PROTOBUF_SCRIPT_NAME}"
#LIB_PROTOBUF_CLEAN_SCRIPT_FILE="${LIB_PROTOBUF_DIR}/${CLEAN_PROTOBUF_SCRIPT_NAME}"
#LIB_PROTOBUF_GET_SCRIPT_FILE="${LIB_PROTOBUF_DIR}/${GET_PROTOBUF_SCRIPT_NAME}"
#LIB_PROTOBUF_SRC_DIR="${LIB_PROTOBUF_DIR}/${SOURCE_DIR_NAME}"
#LIB_PROTOBUF_HOST_DIR="${LIB_PROTOBUF_DIR}/${HOST_DIR_NAME}"
#LIB_PROTOBUF_BUILD_DIR="${LIB_PROTOBUF_DIR}/${BUILD_DIR_NAME}"
LIB_PROTOBUF_LIB_DIR="ExtLibs/ExtLibs_Output/lib"
LIB_PROTOBUF_INC_DIR="ExtLibs/ExtLibs_Output/Inc"
LIB_PROTOBUF_DESCRIPTOR_DIR="${LIB_PROTOBUF_INC_DIR}"
#LIB_PROTOBUF_COMPILER_DIR="${LIB_PROTOBUF_BUILD_DIR}/bin"
#LIB_PROTOBUF_COMPILER_FILE="${LIB_PROTOBUF_COMPILER_DIR}/protoc"
# JavaScript Object Notation (JSON) Library
#LIB_JSON_DIR="${JSON_DIR_NAME}"
#LIB_JSON_BUILD_SCRIPT_FILE="${LIB_JSON_DIR}/${BUILD_JSON_SCRIPT_NAME}"
#LIB_JSON_CLEAN_SCRIPT_FILE="${LIB_JSON_DIR}/${CLEAN_JSON_SCRIPT_NAME}"
#LIB_JSON_GET_SCRIPT_FILE="${LIB_JSON_DIR}/${GET_JSON_SCRIPT_NAME}"
#LIB_JSON_SRC_DIR="${LIB_JSON_DIR}/${SOURCE_DIR_NAME}"
#LIB_JSON_HOST_DIR="${LIB_JSON_DIR}/${HOST_DIR_NAME}"
LIB_JSON_LIB_DIR="ExtLibs/ExtLibs_Output/lib"
LIB_JSON_INC_DIR="ExtLibs/ExtLibs_Output/Inc"
# Integrated Security Object Model (ISOM) Library
LIB_ISOM_DIR="${ISOM_DIR_NAME}"
LIB_ISOM_BUILD_SCRIPT_FILE="${LIB_ISOM_DIR}/${BUILD_ISOM_SCRIPT_NAME}"
LIB_ISOM_CLEAN_SCRIPT_FILE="${LIB_ISOM_DIR}/${CLEAN_ISOM_SCRIPT_NAME}"
LIB_ISOM_GET_SCRIPT_FILE="${LIB_ISOM_DIR}/${GET_ISOM_SCRIPT_NAME}"
LIB_ISOM_SRC_DIR="${LIB_ISOM_DIR}/${SOURCE_DIR_NAME}"
LIB_ISOM_SRC_SCHEMAS_PROTO_DIR="${LIB_ISOM_DIR}/${SOURCE_DIR_NAME}/Schemas/Proto"
LIB_ISOM_HOST_DIR="${LIB_ISOM_DIR}/${HOST_DIR_NAME}"
LIB_ISOM_LIB_DIR="${LIB_ISOM_HOST_DIR}/lib"
LIB_ISOM_INC_DIR="${LIB_ISOM_HOST_DIR}/include"

