//==========================================================================
//
//      devs/wallclock/arm/lpc2xxx/VERSION/src/lpc2xxx.cxx
//
//      Wallclock implementation for Philips LPC2xxx CPUs
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     jlarmour
// Contributors:  
// Date:          2004-08-06
// Purpose:       Wallclock driver for on-board RTC of Philips LPC2xxx CPUs.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/wallclock.h>          // Wallclock device config
#include <pkgconf/hal.h>                // HAL config including PCLK speed
#include <pkgconf/devices_wallclock_arm_lpc2xxx.h>

#include <cyg/hal/hal_io.h>             // IO macros
#include <cyg/infra/cyg_type.h>         // Common type definitions and support

#include <cyg/io/wallclock.hxx>         // The WallClock API
#include <cyg/io/wallclock/wallclock.inl> // Helpers

#include <cyg/infra/diag.h>             // For debugging

//-----------------------------------------------------------------------------
// Functions required for the hardware-driver API.

// Returns the number of seconds elapsed since 1970-01-01 00:00:00.
cyg_uint32 
Cyg_WallClock::get_hw_seconds(void)
{
    cyg_uint32 year, month, mday, hour, minute, second;

    HAL_READ_UINT16( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_YEAR,
                     year );
    year &= 0xfff; // 12 bits valid
    HAL_READ_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_MONTH,
                    month );
    month &= 0xf; // 4 bits valid
    HAL_READ_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_DOM,
                    mday );
    mday &= 0x1f; // 5 bits valid
    HAL_READ_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_HOUR,
                    hour);
    hour &= 0x1f; // 5 bits valid
    HAL_READ_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_MIN,
                    minute);
    minute &= 0x3f; // 6 bits valid
    HAL_READ_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_SEC,
                    second );
    second &= 0x3f; // 6 bits valid

#if 0
    // This will cause the test to eventually fail due to these printouts
    // causing timer interrupts to be lost...
    diag_printf("year %02d\n", year);
    diag_printf("month %02d\n", month);
    diag_printf("mday %02d\n", mday);
    diag_printf("hour %02d\n", hour);
    diag_printf("minute %02d\n", minute);
    diag_printf("second %02d\n", second);
#endif

    cyg_uint32 now = _simple_mktime(year, month, mday, hour, minute, second);
    return now;
}

static void
set_hwclock(cyg_uint32 year, cyg_uint32 month, cyg_uint32 mday,
            cyg_uint32 hour, cyg_uint32 minute, cyg_uint32 second)
{
    // Disable and reset clock (so it is fully synchronised)
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_CCR,
                     CYGARC_HAL_LPC2XXX_REG_RTC_CCR_CTCRST );

    // DOW and DOY are unused
    HAL_WRITE_UINT16( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_YEAR,
                      year );
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_MONTH,
                      month );
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_DOM,
                      mday );
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_HOUR,
                     hour);
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_MIN,
                     minute);
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_SEC,
                     second );

    // (Re-)enable clock
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_CCR,
#ifdef CYGPKG_DEVICES_WALLCLOCK_ARM_LPC2XXX_USE_RTCX
                     CYGARC_HAL_LPC2XXX_REG_RTC_CCR_CLKSRC_RTCX |
#endif
                     CYGARC_HAL_LPC2XXX_REG_RTC_CCR_CLKEN );
}

#ifdef CYGSEM_WALLCLOCK_SET_GET_MODE

// Sets the clock. Argument is seconds elapsed since 1970-01-01 00:00:00.
void
Cyg_WallClock::set_hw_seconds( cyg_uint32 secs )
{
    cyg_uint32 year, month, mday, hour, minute, second;

    _simple_mkdate(secs, &year, &month, &mday, &hour, &minute, &second);

    set_hwclock(year, month, mday, hour, minute, second);
}

#endif

void
Cyg_WallClock::init_hw_seconds(void)
{
    // Make sure clock is disabled while we fiddle
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_CCR, 0 );

    // Clear any pending interrupts, just in case
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_ILR,
                     CYGARC_HAL_LPC2XXX_REG_RTC_ILR_CIF|CYGARC_HAL_LPC2XXX_REG_RTC_ILR_ALF );
    // Disable increment interrupt
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_CIIR, 0);
    // Disable alarm interrupt
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_AMR, 0xff);

#ifndef CYGPKG_DEVICES_WALLCLOCK_ARM_LPC2XXX_USE_RTCX

    cyg_uint32 pclk = CYGNUM_HAL_ARM_LPC2XXX_PCLK_SPEED;
#if defined(CYGHWR_HAL_ARM_LPC2XXX_LPC23XX) || defined(CYGHWR_HAL_ARM_LPC2XXX_LPC24XX)
    // On 23xx and 24xx parts, PCLK cannot be fed directly to the RTC,
    // only a divided value. We choose to divide by 4, which must be
    // set in hal_platform_setup.h.
    pclk /= 4;
#endif
    
    // Set clock prescaler/divider, as per RTC docs
    const cyg_uint16 preint = (pclk / 32768) - 1;
    HAL_WRITE_UINT16( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_PREINT,
                      preint );
    HAL_WRITE_UINT16( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_PREFRAC,
                      (pclk - ((preint+1) * 32768)) );
#endif
    
#ifndef CYGSEM_WALLCLOCK_SET_GET_MODE
    // This is our base: 1970-01-01 00:00:00
    // Set the HW clock - if for nothing else, just to be sure it's in a
    // legal range. Any arbitrary base could be used.
    // After this the hardware clock is only read.
    //
    // Note this will also enable clock
    set_hwclock(1970,1,1,0,0,0);
#else
    // Enable clock
    HAL_WRITE_UINT8( CYGARC_HAL_LPC2XXX_REG_RTC_BASE + CYGARC_HAL_LPC2XXX_REG_RTC_CCR,
#ifdef CYGPKG_DEVICES_WALLCLOCK_ARM_LPC2XXX_USE_RTCX
                     CYGARC_HAL_LPC2XXX_REG_RTC_CCR_CLKSRC_RTCX |
#endif
                     CYGARC_HAL_LPC2XXX_REG_RTC_CCR_CLKEN );
#endif    
}

//-----------------------------------------------------------------------------
// End of devs/wallclock/arm/lpc2xxx/wallclock_lpc2xxx.cxx
