#ifndef CYGONCE_IO_WALLCLOCK_DS1306_H
# define CYGONCE_IO_WALLCLOCK_DS1306_H
//==========================================================================
//
//      ds1306.h
//
//      Extra support functions for the DS1306 wallclock device
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008 Free Software Foundation, Inc.                        
// Copyright (C) 2008 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     bartv
// Date:          2008-05-08
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/devices_wallclock_dallas_ds1306.h>
#include <cyg/infra/cyg_type.h>

externC void    cyg_wallclock_ds1306_read_regs(int /* offset */, unsigned char* /* buf */, int /* len */);
externC void    cyg_wallclock_ds1306_write_regs(int /* offset */, const unsigned char* /* buf */, int /* len */);
externC void    cyg_wallclock_ds1306_read_ram(int /* offset */, unsigned char* /* buf */, int /* len */);
externC void    cyg_wallclock_ds1306_write_ram(int /* offset */, const unsigned char* /* buf */, int /* len */);

# ifdef CYGHWR_WALLCLOCK_DALLAS_DS1306_3WIRE
typedef enum cyg_ds1306_bitbang_op {
    CYG_DS1306_BITBANG_INIT                 = 0,
    CYG_DS1306_BITBANG_CE_HIGH              = 1,
    CYG_DS1306_BITBANG_CE_LOW               = 2,
    CYG_DS1306_BITBANG_SCLK_HIGH            = 3,
    CYG_DS1306_BITBANG_SCLK_LOW             = 4,
    CYG_DS1306_BITBANG_DATA_HIGH            = 5,
    CYG_DS1306_BITBANG_DATA_LOW             = 6,
    CYG_DS1306_BITBANG_DATA_READ            = 7,
    CYG_DS1306_BITBANG_INPUT                = 8,
    CYG_DS1306_BITBANG_OUTPUT               = 9
} cyg_ds1306_bitbang_op;
externC cyg_bool hal_ds1306_bitbang(cyg_ds1306_bitbang_op);
# endif

#endif  // ifndef CYGONCE_IO_WALLCLOCK_DS1302_H
