//==========================================================================
//
//      devs/watchdog/arm/mc9328mxl/watchdog_mc9328mxl.cxx
//
//      Watchdog implementation for Motorola MC9328MXL PrimeCell controller
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2009 eCosCentric Limited
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: nickg
// Date:         2004-07-05
// Purpose:      Watchdog class implementation
// Description:  Contains an implementation of the Watchdog class for use
//               with the Motorola MC9328MXL watchdog timer.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/kernel.h>
#include <pkgconf/infra.h>
#include <pkgconf/kernel.h>
#include <pkgconf/watchdog.h>
#include <pkgconf/devs_watchdog_arm_mc9328mxl.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h>

#include <cyg/hal/mc9328mxl.h>

#include <cyg/io/watchdog.hxx>

#if !defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)
#include <cyg/hal/hal_intr.h>
#include <cyg/kernel/intr.hxx>
#endif

//==========================================================================

static CYG_ADDRESS wd_base = MC9328MXL_WDOG;

//==========================================================================

#define RESOLUTION (CYGNUM_DEVS_WATCHDOG_ARM_MC9328MXL_DESIRED_TIMEOUT_MS*1000000)
#define WATCHDOG_INIT ((CYGNUM_DEVS_WATCHDOG_ARM_MC9328MXL_DESIRED_TIMEOUT_MS+499)/500)

//==========================================================================

#if defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT)

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();
  resolution = RESOLUTION;
  CYG_REPORT_RETURN();
}

#define WDOG_CTRL 0

#else /* defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT) */

//==========================================================================

static Cyg_Watchdog *wd;

//==========================================================================

static cyg_uint32
isr(cyg_vector vector, CYG_ADDRWORD data)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARG2XV(vector, data);

  HAL_WRITE_UINT32( wd_base+MC9328MXL_WDOG_SR, MC9328MXL_WDOG_SR_VAL1 );
  HAL_WRITE_UINT32( wd_base+MC9328MXL_WDOG_SR, MC9328MXL_WDOG_SR_VAL2 );
    
  wd->trigger();
  Cyg_Interrupt::acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETVAL(Cyg_Interrupt::HANDLED);
  return Cyg_Interrupt::HANDLED;
}

//==========================================================================

static CYGBLD_ATTRIB_INIT_PRI( CYG_INIT_INTERRUPTS ) Cyg_Interrupt wdint(
    CYGNUM_HAL_INTERRUPT_WATCHDOG,
    4,
    0,
    isr,
    NULL
    );

//==========================================================================

void
Cyg_Watchdog::init_hw(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();

  wd = this;
  resolution = RESOLUTION;
  wdint.configure_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG, false, true);
  wdint.attach();
  wdint.acknowledge_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  wdint.unmask_interrupt(CYGNUM_HAL_INTERRUPT_WATCHDOG);
  CYG_REPORT_RETURN();
}

#define WDOG_CTRL (MC9328MXL_WDOG_CR_WIE)

#endif	/* defined(CYGSEM_WATCHDOG_RESETS_ON_TIMEOUT) */

//==========================================================================
/*
 * Reset watchdog timer. This needs to be called regularly to prevent
 * the watchdog from firing.
 */

void
Cyg_Watchdog::reset(void)
{
  CYG_REPORT_FUNCTION();
  CYG_REPORT_FUNCARGVOID();

  HAL_WRITE_UINT32( wd_base+MC9328MXL_WDOG_SR, MC9328MXL_WDOG_SR_VAL1 );
  HAL_WRITE_UINT32( wd_base+MC9328MXL_WDOG_SR, MC9328MXL_WDOG_SR_VAL2 );
    
  CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Start watchdog to generate a hardware reset
 * or interrupt when expiring.
 */

void
Cyg_Watchdog::start(void)
{
    cyg_uint32 cr;
    
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    wd_base = CYGARC_VIRTUAL_ADDRESS( MC9328MXL_WDOG );

    cr = WDOG_CTRL | (WATCHDOG_INIT<<MC9328MXL_WDOG_CR_WT_SHIFT);
    HAL_WRITE_UINT32( wd_base+MC9328MXL_WDOG_CR, cr );
    HAL_WRITE_UINT32( wd_base+MC9328MXL_WDOG_CR, cr | MC9328MXL_WDOG_CR_WDE );
    
    CYG_REPORT_RETURN();
}

//==========================================================================
// End of watchdog_mc9328mxl.cxx
