//==========================================================================
//
//      devs/watchdog/arm/at91/watchdog_omap_l1xx.cxx
//
//      Watchdog implementation for ARM AT91 CPUs using the WDTC
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2006, 2009 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    tkoeller
// Contributors: tkoeller, nickg, asl
// Date:         2006-02-18
// Purpose:      Watchdog class implementation
// Description:  Contains an implementation of the Watchdog class for use
//               with the ATMEL AT91 watchdog timer controller.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/kernel.h>
#include <pkgconf/infra.h>
#include <pkgconf/kernel.h>
#include <pkgconf/watchdog.h>
#include <pkgconf/devs_watchdog_arm_omap_l1xx.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/cyg_trac.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h>

#include <cyg/io/watchdog.hxx>

#include <cyg/infra/diag.h>
#include <cyg/kernel/kapi.h>

//==========================================================================
// Select timer to use for watchdog
//
// Only Timer 1 is attached to the reset line.

#define CYGHWR_HAL_L1XX_TIMER_WATCHDOG  CYGHWR_HAL_L1XX_TIMER1

//==========================================================================

void
Cyg_Watchdog::init_hw(void)
{
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();
    resolution = CYGNUM_DEVS_WATCHDOG_ARM_OMAP_L1XX_DESIRED_TIMEOUT_MS * 1000000;
    CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Reset watchdog timer. This needs to be called regularly to prevent
 * the watchdog from firing.
 */

void
Cyg_Watchdog::reset(void)
{
    cyg_uint32 timer = CYGHWR_HAL_L1XX_TIMER_WATCHDOG;
    
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    cyg_uint32 tcr12, tcr34;
    cyg_uint32 prd12, prd34;

    HAL_READ_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_TIM12, tcr12 );
    HAL_READ_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_TIM34, tcr34 );
    HAL_READ_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_PRD12, prd12 );
    HAL_READ_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_PRD34, prd34 );
    
    // Write reset values to watchdog register.
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_WDTCR, CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY0 );
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_WDTCR, CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY1 );
//    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_WDTCR, CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY0 );
//    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_WDTCR, CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY1 );
//    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_WDTCR, CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY0|CYGHWR_HAL_L1XX_TIMER_WDTCR_WDEN );
//    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_WDTCR, CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY1|CYGHWR_HAL_L1XX_TIMER_WDTCR_WDEN );

    cyg_uint64 now = cyg_current_time();
    
    CYG_REPORT_RETURN();
}

//==========================================================================
/*
 * Start watchdog to generate a hardware reset
 * or interrupt when expiring.
 */

void
Cyg_Watchdog::start(void)
{
    cyg_uint32 timer = CYGHWR_HAL_L1XX_TIMER_WATCHDOG;    
    cyg_uint32 tgcr;
    cyg_uint64  period;
    
    CYG_REPORT_FUNCTION();
    CYG_REPORT_FUNCARGVOID();

    // Stop and reset timer, disable interrupts
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_TGCR, 0 );
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_TCR, 0 );
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_INTCTLSTAT, 0 );

    // Configure timer for 64 bit watchdog mode, enable counters 1:2
    // and 3:4.
    HAL_READ_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_TGCR, tgcr );
    tgcr |= CYGHWR_HAL_L1XX_TIMER_TGCR_TIMMODE_64WD;
    tgcr |= CYGHWR_HAL_L1XX_TIMER_TGCR_TIM12RS;
    tgcr |= CYGHWR_HAL_L1XX_TIMER_TGCR_TIM34RS;
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_TGCR, tgcr );    

    // Timeout is given in milliseconds. Each ms is (AUXCLOCK/1000)
    // cycles, multiply these together to give timer period.
    period = ((cyg_uint64)CYGNUM_DEVS_WATCHDOG_ARM_OMAP_L1XX_DESIRED_TIMEOUT_MS) *
             ((cyg_uint64)CYGHWR_HAL_ARM_ARM9_OMAP_L1XX_CLOCK_AUXCLK/1000LL);

    // TODO: While Timer1 is meant to run from the same clock as
    // Timer0 (AUXCLOCK at 24MHz) it seems to be running from a higher
    // frequency clock than Timer0. We need to find out what the truth
    // is, but for now, increase the period by 50%.
    period += period/2;

    // Zero timer and set period
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_TIM12, 0 );
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_TIM34, 0 );
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_PRD12, (cyg_uint32)(period&0xFFFFFFFF) );
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_PRD34, (cyg_uint32)((period>>32)&0xFFFFFFFF) );

    // Enable watchdog
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_WDTCR, CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY0|CYGHWR_HAL_L1XX_TIMER_WDTCR_WDEN );
    HAL_WRITE_UINT32( timer+CYGHWR_HAL_L1XX_TIMER_WDTCR, CYGHWR_HAL_L1XX_TIMER_WDTCR_WDKEY1|CYGHWR_HAL_L1XX_TIMER_WDTCR_WDEN );
    
    CYG_REPORT_RETURN();
}

//==========================================================================
// End of watchdog_at91.cxx
