#ifndef CYGONCE_HAL_VAR_INTS_H
#define CYGONCE_HAL_VAR_INTS_H
//==========================================================================
//
//      var_ints.h
//
//      ARM9/AT91RM9200 variant Interrupt and clock support
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, 2005 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: 
// Date:         2003-09-27
// Purpose:      Define Interrupt support
// Description:  The interrupt details for the Atmel AT91RM9200 are defined here.
// Usage:
//               #include <cyg/hal/hal_var_ints.h>
//               ...
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <cyg/hal/at91rm9200.h>
#include <cyg/hal/hal_io.h>

// These are interrupts on the AT91RM9200 core

#define CYGNUM_HAL_INTERRUPT_FIQ     0 // Advanced Interrupt Controller (FIQ)
#define CYGNUM_HAL_INTERRUPT_SYSTEM  1 // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_INTERRUPT_PIOA    2 // Parallel IO Controller A
#define CYGNUM_HAL_INTERRUPT_PIOB    3 // Parallel IO Controller B
#define CYGNUM_HAL_INTERRUPT_PIOC    4 // Parallel IO Controller C
#define CYGNUM_HAL_INTERRUPT_PIOD    5 // Parallel IO Controller D
#define CYGNUM_HAL_INTERRUPT_US0     6 // USART 0
#define CYGNUM_HAL_INTERRUPT_US1     7 // USART 1
#define CYGNUM_HAL_INTERRUPT_US2     8 // USART 2
#define CYGNUM_HAL_INTERRUPT_US3     9 // USART 3
#define CYGNUM_HAL_INTERRUPT_MCI    10 // Multimedia Card Interface
#define CYGNUM_HAL_INTERRUPT_UDP    11 // USB Device Port
#define CYGNUM_HAL_INTERRUPT_TWI    12 // Two-Wire Interface
#define CYGNUM_HAL_INTERRUPT_SPI    13 // Serial Peripheral Interface
#define CYGNUM_HAL_INTERRUPT_SSC0   14 // Serial Synchronous Controller 0
#define CYGNUM_HAL_INTERRUPT_SSC1   15 // Serial Synchronous Controller 1
#define CYGNUM_HAL_INTERRUPT_SSC2   16 // Serial Synchronous Controller 2
#define CYGNUM_HAL_INTERRUPT_TC0    17 // Timer Counter 0
#define CYGNUM_HAL_INTERRUPT_TC1    18 // Timer Counter 1
#define CYGNUM_HAL_INTERRUPT_TC2    19 // Timer Counter 2
#define CYGNUM_HAL_INTERRUPT_TC3    20 // Timer Counter 3
#define CYGNUM_HAL_INTERRUPT_TC4    21 // Timer Counter 4
#define CYGNUM_HAL_INTERRUPT_TC5    22 // Timer Counter 5
#define CYGNUM_HAL_INTERRUPT_UHP    23 // USB Host port
#define CYGNUM_HAL_INTERRUPT_EMAC   24 // Ethernet MAC
#define CYGNUM_HAL_INTERRUPT_IRQ0   25 // Advanced Interrupt Controller (IRQ0)
#define CYGNUM_HAL_INTERRUPT_IRQ1   26 // Advanced Interrupt Controller (IRQ1)
#define CYGNUM_HAL_INTERRUPT_IRQ2   27 // Advanced Interrupt Controller (IRQ2)
#define CYGNUM_HAL_INTERRUPT_IRQ3   28 // Advanced Interrupt Controller (IRQ3)
#define CYGNUM_HAL_INTERRUPT_IRQ4   29 // Advanced Interrupt Controller (IRQ4)
#define CYGNUM_HAL_INTERRUPT_IRQ5   30 // Advanced Interrupt Controller (IRQ5)
#define CYGNUM_HAL_INTERRUPT_IRQ6   31 // Advanced Interrupt Controller (IRQ6)

// The following interrupts are derived from the SYSTEM interrupt
#define CYGNUM_HAL_INTERRUPT_DEBUG  32 // Debug unit
#define CYGNUM_HAL_INTERRUPT_PMC    33 // Power Management Controller
#define CYGNUM_HAL_INTERRUPT_RTCH   34 // Real Time Clock
#define CYGNUM_HAL_INTERRUPT_PIT    35 // System Timer Period Interval Timer
#define CYGNUM_HAL_INTERRUPT_WDOVF  36 // System Timer Watchdog Overflow
#define CYGNUM_HAL_INTERRUPT_RTTINC 37 // System Timer Real-Time Timer Increment
#define CYGNUM_HAL_INTERRUPT_ALM    38 // System Timer Alarm

#define CYGNUM_HAL_INTERRUPT_NONE    -1

#define CYGNUM_HAL_ISR_MIN            0
#define CYGNUM_HAL_ISR_MAX           38

#define CYGNUM_HAL_ISR_COUNT         (CYGNUM_HAL_ISR_MAX-CYGNUM_HAL_ISR_MIN+1)

// The vector used by the Real time clock
#define CYGNUM_HAL_INTERRUPT_RTC      CYGNUM_HAL_INTERRUPT_TC0

//==========================================================================
// VSR table extension
//
// The AT91RM9200 Advanced Interrupt Controller has a vector unit that decodes
// incoming interrupt sources into one of the thirty-two interrupts. The vector
// for the current source is then available via another register. Here we
// virtually extend the VSR table to include the controller's thirty-two
// AIC vector registers and replace the IRQ and FIQ vector instructions to
// jump via the current vector register.

// FIQ is already defined as vector 7 in the architecture hal_intr.h
#define CYGNUM_HAL_VECTOR_SYSTEM  8 // System Peripheral (debug unit, system timer)
#define CYGNUM_HAL_VECTOR_PIOA    9 // Parallel IO Controller A
#define CYGNUM_HAL_VECTOR_PIOB   10 // Parallel IO Controller B
#define CYGNUM_HAL_VECTOR_PIOC   11 // Parallel IO Controller C
#define CYGNUM_HAL_VECTOR_PIOD   12 // Parallel IO Controller D
#define CYGNUM_HAL_VECTOR_US0    13 // USART 0
#define CYGNUM_HAL_VECTOR_US1    14 // USART 1
#define CYGNUM_HAL_VECTOR_US2    15 // USART 2
#define CYGNUM_HAL_VECTOR_US3    16 // USART 3
#define CYGNUM_HAL_VECTOR_MCI    17 // Multimedia Card Interface
#define CYGNUM_HAL_VECTOR_UDP    18 // USB Device Port
#define CYGNUM_HAL_VECTOR_TWI    19 // Two-Wire Interface
#define CYGNUM_HAL_VECTOR_SPI    20 // Serial Peripheral Interface
#define CYGNUM_HAL_VECTOR_SSC0   21 // Serial Synchronous Controller 0
#define CYGNUM_HAL_VECTOR_SSC1   22 // Serial Synchronous Controller 1
#define CYGNUM_HAL_VECTOR_SSC2   23 // Serial Synchronous Controller 2
#define CYGNUM_HAL_VECTOR_TC0    24 // Timer Counter 0
#define CYGNUM_HAL_VECTOR_TC1    25 // Timer Counter 1
#define CYGNUM_HAL_VECTOR_TC2    26 // Timer Counter 2
#define CYGNUM_HAL_VECTOR_TC3    27 // Timer Counter 3
#define CYGNUM_HAL_VECTOR_TC4    28 // Timer Counter 4
#define CYGNUM_HAL_VECTOR_TC5    29 // Timer Counter 5
#define CYGNUM_HAL_VECTOR_UHP    30 // USB Host port
#define CYGNUM_HAL_VECTOR_EMAC   31 // Ethernet MAC
#define CYGNUM_HAL_VECTOR_IRQ0   32 // Advanced Interrupt Controller (IRQ0)
#define CYGNUM_HAL_VECTOR_IRQ1   33 // Advanced Interrupt Controller (IRQ1)
#define CYGNUM_HAL_VECTOR_IRQ2   34 // Advanced Interrupt Controller (IRQ2)
#define CYGNUM_HAL_VECTOR_IRQ3   35 // Advanced Interrupt Controller (IRQ3)
#define CYGNUM_HAL_VECTOR_IRQ4   36 // Advanced Interrupt Controller (IRQ4)
#define CYGNUM_HAL_VECTOR_IRQ5   37 // Advanced Interrupt Controller (IRQ5)
#define CYGNUM_HAL_VECTOR_IRQ6   38 // Advanced Interrupt Controller (IRQ6)

// This makes the maximum acceptable VSR support all the above VSRs (checked
// in the kernel VSR support for example). But in practice the underlying
// hal_vsr_table remains at 8 entries.
#define CYGNUM_HAL_VSR_MAX       38


#if CYGINT_HAL_AT91RM9200_AIC_VSR

#define HAL_VSR_GET( _vector_, _pvsr_ )                                 \
CYG_MACRO_START                                                         \
    CYG_ADDRESS __p;                                                    \
    if( (_vector_) < CYGNUM_HAL_VECTOR_FIQ )                            \
        __p = hal_vsr_table[(_vector_)];                                \
    else                                                                \
        HAL_READ_UINT32( _AIC_SVR + 4*((_vector_) - 7),  __p);          \
    *(CYG_ADDRESS *)(_pvsr_) = __p;                                     \
CYG_MACRO_END

#define HAL_VSR_SET( _vector_, _vsr_, _poldvsr_ )                       \
CYG_MACRO_START                                                         \
    if( (_poldvsr_) != NULL )                                           \
        HAL_VSR_GET( _vector_, _poldvsr_ );                             \
    if( (_vector_) < CYGNUM_HAL_VECTOR_FIQ )                            \
        hal_vsr_table[(_vector_)] = (CYG_ADDRESS)(_vsr_);               \
    else                                                                \
        HAL_WRITE_UINT32( _AIC_SVR + 4*((_vector_) - 7),                \
                          (CYG_ADDRESS)(_vsr_));                        \
CYG_MACRO_END

#endif
//==========================================================================
// Reset.

externC void cyg_hal_at91rm9200_reset(void);
#define HAL_PLATFORM_RESET() cyg_hal_at91rm9200_reset()

#define HAL_PLATFORM_RESET_ENTRY 0x00000000

//==========================================================================
// Power saving support.

__externC void cyg_hal_at91rm9200_powersave_init( cyg_uint32 ip_addr );

__externC void cyg_hal_at91rm9200_powerdown( void );

//==========================================================================
#endif // CYGONCE_HAL_VAR_INTS_H
