#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      Platform specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2005, 2006, 2008 Free Software Foundation, Inc.
// Copyright (C) 2003, 2005, 2006, 2008 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric, jskov
// Contributors: 
// Date:         2006-06-01
// Purpose:      SSV DNP/SK23 platform specific registers
// Description: 
// Usage:        #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <cyg/hal/dnp_sk23.h>
#include <pkgconf/hal_arm_arm9_at91rm9200.h>

//-----------------------------------------------------------------------------
// Address space translation macros

#define CYGARC_PHYSICAL_ADDRESS(_x_)                                    \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= DNP_SK23_SDRAM_VIRT_BASE &&                                  \
     _p < (DNP_SK23_SDRAM_VIRT_BASE+DNP_SK23_SDRAM_SIZE))               \
     _p = (_p & DNP_SK23_SDRAM_MASK) + DNP_SK23_SDRAM_PHYS_BASE;        \
 else if (_p >= DNP_SK23_SRAM_VIRT_BASE &&                              \
          _p < (DNP_SK23_SRAM_VIRT_BASE+DNP_SK23_SRAM_SIZE))            \
     _p = (_p & DNP_SK23_SRAM_MASK) + DNP_SK23_SRAM_PHYS_BASE;          \
 else if (_p >= DNP_SK23_FLASH_VIRT_BASE &&                             \
          _p < (DNP_SK23_FLASH_VIRT_BASE+DNP_SK23_FLASH_SIZE))          \
     _p = (_p & DNP_SK23_FLASH_MASK) + DNP_SK23_FLASH_PHYS_BASE;        \
 else if (_p >= DNP_SK23_IROM_VIRT_BASE &&                              \
          _p < (DNP_SK23_IROM_VIRT_BASE+DNP_SK23_IROM_SIZE))            \
     _p = (_p & DNP_SK23_IROM_MASK) + DNP_SK23_IROM_PHYS_BASE;          \
 else if (_p >= DNP_SK23_UHPREG_VIRT_BASE &&                            \
          _p < (DNP_SK23_UHPREG_VIRT_BASE+DNP_SK23_UHPREG_SIZE))        \
     _p = (_p & DNP_SK23_UHPREG_MASK) + DNP_SK23_UHPREG_PHYS_BASE;      \
 _p; })

#define CYGARC_VIRTUAL_ADDRESS(_x_)                                     \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= DNP_SK23_SDRAM_PHYS_BASE &&                                  \
     _p < (DNP_SK23_SDRAM_PHYS_BASE+DNP_SK23_SDRAM_SIZE))               \
     _p = (_p & DNP_SK23_SDRAM_MASK) + DNP_SK23_SDRAM_VIRT_BASE;        \
 else if (_p >= DNP_SK23_SRAM_PHYS_BASE &&                              \
          _p < (DNP_SK23_SRAM_PHYS_BASE+DNP_SK23_SRAM_SIZE))            \
     _p = (_p & DNP_SK23_SRAM_MASK) + DNP_SK23_SRAM_VIRT_BASE;          \
 else if (_p >= DNP_SK23_FLASH_PHYS_BASE &&                             \
          _p < (DNP_SK23_FLASH_PHYS_BASE+DNP_SK23_FLASH_SIZE))          \
     _p = (_p & DNP_SK23_FLASH_MASK) + DNP_SK23_FLASH_VIRT_BASE;        \
 else if (_p >= DNP_SK23_IROM_PHYS_BASE &&                              \
          _p < (DNP_SK23_IROM_PHYS_BASE+DNP_SK23_IROM_SIZE))            \
     _p = (_p & DNP_SK23_IROM_MASK) + DNP_SK23_IROM_VIRT_BASE;          \
 else if (_p >= DNP_SK23_UHPREG_PHYS_BASE &&                            \
          _p < (DNP_SK23_UHPREG_PHYS_BASE+DNP_SK23_UHPREG_SIZE))        \
     _p = (_p & DNP_SK23_UHPREG_MASK) + DNP_SK23_UHPREG_VIRT_BASE;      \
 _p; })

#define CYGARC_UNCACHED_ADDRESS(_x_)                                    \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= DNP_SK23_SDRAM_VIRT_BASE &&                                  \
     _p < (DNP_SK23_SDRAM_VIRT_BASE+DNP_SK23_SDRAM_SIZE))               \
     _p = (_p & DNP_SK23_SDRAM_MASK) + DNP_SK23_SDRAM_UNCACHED_BASE;    \
 else if (_p >= DNP_SK23_SRAM_VIRT_BASE &&                              \
     _p < (DNP_SK23_SRAM_VIRT_BASE+DNP_SK23_SRAM_SIZE))                 \
     _p = _p + DNP_SK23_SRAM_UNCACHED_OFFSET;                           \
 else if (_p >= DNP_SK23_FLASH_VIRT_BASE &&                             \
          _p < (DNP_SK23_FLASH_VIRT_BASE+DNP_SK23_FLASH_SIZE))          \
     _p = _p + DNP_SK23_FLASH_UNCACHED_OFFSET;                          \
 else if (_p >= DNP_SK23_IROM_VIRT_BASE &&                              \
          _p < (DNP_SK23_IROM_VIRT_BASE+DNP_SK23_IROM_SIZE))            \
     _p = _p + DNP_SK23_IROM_UNCACHED_OFFSET;                           \
 else if (_p >= DNP_SK23_UHPREG_VIRT_BASE &&                            \
          _p < (DNP_SK23_UHPREG_VIRT_BASE+DNP_SK23_UHPREG_SIZE))        \
     _p = _p + DNP_SK23_UHPREG_UNCACHED_OFFSET;                         \
 _p; })

//-----------------------------------------------------------------------------
// TWI (I2C) bus

#ifdef CYGPKG_HAL_AT91RM9200_TWI
# define HAL_I2C_EXPORTED_DEVICES \
    extern cyg_i2c_bus hal_at91rm9200_i2c_bus;
#endif

//-----------------------------------------------------------------------------
// MMC Interface (MCI) bus

// Only files that need the below defines will have set __MMCSD_DRIVER_PRIVATE before inclusion.
#if defined(__MMCSD_DRIVER_PRIVATE) && defined(CYGPKG_HAL_ARM_ARM9_AT91RM9200_MCI)
#include <cyg/infra/cyg_type.h>

// Only one socket, so ignore card and bus

#define HAL_MMCSD_PLF_GET_SOCKET_CAPABILITY(_bus_, _socket_, _err_)     \
    CYG_MACRO_START                                                     \
    (_socket_)->sockethw_caps.valid = 1;                                \
    (_socket_)->sockethw_caps.sd = 1;                                   \
    (_socket_)->sockethw_caps.fourbit = 1;                              \
    (_socket_)->sockethw_caps.card_detect = 0;                          \
    (_socket_)->sockethw_caps.card_detect_int = 0;                      \
    (_socket_)->sockethw_vdd = MMCSD_OCR_REGISTER_VDD_32_33;            \
    (_socket_)->sockethw_caps.multiblock_io = 0;                        \
    CYG_MACRO_END


// No card detection or write protect switch sampling (none wired up on
// board), nor any other initialisation required. So that's it.
    
#endif // if defined(__MMCSD_DRIVER_PRIVATE) && defined(CYGPKG_HAL_ARM_ARM9_AT91RM9200_MCI)


//-----------------------------------------------------------------------------
// end of plf_io.h
#endif // CYGONCE_HAL_PLF_IO_H
