#ifndef CYGONCE_KB9200_H
#define CYGONCE_KB9200_H
/*=============================================================================
//
//      kb9200.h
//
//      Platform specific support (register layout, etc)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2005, 2007 Free Software Foundation, Inc.
// Copyright (C) 2003, 2005, 2007 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: eCosCentric, jskov
// Date:         2001-10-30
// Purpose:      KwikByte KB9200 platform specific support routines
// Description: 
// Usage:        #include <cyg/hal/kb9200.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/system.h>
#include CYGBLD_HAL_PLATFORM_H
#include <cyg/hal/at91rm9200.h>        // CPU details

//---------------------------------------------------------------------------
// Memory layout details needed by conversion macro


#if defined(CYGHWR_HAL_ARM_ARM9_KB920x_BOARD_VARIANT_KB9202B)
#define KB9200_SDRAM_SIZE              0x04000000
#else
#define KB9200_SDRAM_SIZE              0x02000000
#endif
#define KB9200_SDRAM_MASK              (KB9200_SDRAM_SIZE-1)
#define KB9200_SDRAM_PHYS_BASE         0x20000000

#define KB9200_SRAM_SIZE               0x00004000
#define KB9200_SRAM_MASK               (KB9200_SRAM_SIZE-1)
#define KB9200_SRAM_PHYS_BASE          0x00200000

#define KB9200_FLASH_PHYS_BASE         0x10000000

#if defined(CYGHWR_HAL_ARM_ARM9_KB920x_BOARD_VARIANT_KB9202) || \
    defined(CYGHWR_HAL_ARM_ARM9_KB920x_BOARD_VARIANT_KB9202B)
#define KB9200_FLASH_SIZE              0x01000000
#else
#define KB9200_FLASH_SIZE              0x00200000
#endif
#define KB9200_FLASH_MASK              (KB9200_FLASH_SIZE-1)

#define KB9200_IROM_PHYS_BASE          0x00100000
#define KB9200_IROM_VIRT_BASE          0x71000000
#define KB9200_IROM_UNCACHED_OFFSET    0x00800000
#define KB9200_IROM_SIZE               0x00020000
#define KB9200_IROM_MASK               (KB9200_IROM_SIZE-1)

#define KB9200_UHPREG_PHYS_BASE        0x00300000
#define KB9200_UHPREG_VIRT_BASE        0x72000000
#define KB9200_UHPREG_UNCACHED_OFFSET  0x00800000
#define KB9200_UHPREG_SIZE             0x00100000
#define KB9200_UHPREG_MASK             (KB9200_UHPREG_SIZE-1)

#ifdef CYG_HAL_STARTUP_SRAM

#define KB9200_SDRAM_VIRT_BASE         0x20000000

#define KB9200_SRAM_VIRT_BASE          0x00200000
#define KB9200_SRAM_UNCACHED_OFFSET    0x00000000

#define KB9200_FLASH_VIRT_BASE         0x10000000
#define KB9200_FLASH_UNCACHED_OFFSET   0x00000000

#else

#define KB9200_SDRAM_VIRT_BASE         0x00000000

#define KB9200_SRAM_VIRT_BASE          0x70000000
#define KB9200_SRAM_UNCACHED_OFFSET    0x00100000

#define KB9200_FLASH_VIRT_BASE         0x60000000
#define KB9200_FLASH_UNCACHED_OFFSET   0xb0000000

#endif

/*---------------------------------------------------------------------------*/
/* end of kb9200.h                                                          */
#endif /* CYGONCE_KB9200_H */
