//==========================================================================
//
//      sam9261ek_spi.c
//
//      Support for the Spi devices on Atmel SAM9261-EK
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2005, 2006 Free Software Foundation, Inc.                  
// Copyright (C) 2005, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Date:        2005-08-17
//
//####DESCRIPTIONEND####
//=============================================================================

#include <pkgconf/system.h>
#include <pkgconf/hal.h>
#include <pkgconf/io_spi.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/io/spi.h>
#include <cyg/io/spi_at91.h>

// -------------------------------------------------------------------------
// SAM9261EK SPI exported devices 

#ifdef CYGHWR_HAL_ARM_ARM9_SAM9261EK_DATAFLASH
// -------------------------------------------------------------------------
// AT45 DataFlash on-board on SPI0 CS 0, or card socket on SPI0 CS 0
// if option CYGHWR_HAL_ARM_ARM9_SAM9261EK_DATAFLASH_NPCS0_SOCKET set.

cyg_spi_at91_device_t spi_dataflash_dev0 CYG_SPI_DEVICE_ON_BUS(0) = 
{
    .spi_device.spi_bus = &cyg_spi_at91_bus0.spi_bus,

    .dev_num     = 0,       // Device number
    .cl_pol      = 1,       // Clock polarity (0 or 1)
    .cl_pha      = 0,       // Clock phase (0 or 1)
    .cl_brate    = 8192000, // Clock baud rate
    .cs_up_udly  = 1,       // Delay in usec between CS up and transfer start
    .cs_dw_udly  = 1,       // Delay in usec between transfer end and CS down
    .tr_bt_udly  = 1        // Delay in usec between two transfers
};

cyg_spi_device *cyg_spi_dataflash_dev0 = &spi_dataflash_dev0.spi_device;

#ifndef CYGHWR_HAL_ARM_ARM9_SAM9261EK_DATAFLASH_NPCS0_SOCKET
// -------------------------------------------------------------------------
// AT45 DataFlash card slot on SPI0 CS 3.

cyg_spi_at91_device_t spi_dataflash_dev1 CYG_SPI_DEVICE_ON_BUS(0) = 
{
    .spi_device.spi_bus = &cyg_spi_at91_bus0.spi_bus,

    .dev_num     = 3,       // Device number
    .cl_pol      = 1,       // Clock polarity (0 or 1)
    .cl_pha      = 0,       // Clock phase (0 or 1)
    .cl_brate    = 8192000, // Clock baud rate    
    .cs_up_udly  = 1,       // Delay in usec between CS up and transfer start
    .cs_dw_udly  = 1,       // Delay in usec between transfer end and CS down
    .tr_bt_udly  = 1        // Delay in usec between two transfers
};

cyg_spi_device *cyg_spi_dataflash_dev1 = &spi_dataflash_dev1.spi_device;

#endif

#endif // ifdef CYGHWR_HAL_ARM_ARM9_SAM9261EK_DATAFLASH

// -------------------------------------------------------------------------
// MMC card slot on SPI0 CS 3.


#ifdef CYGHWR_HAL_ARM_ARM9_SAM9261EK_SPI_MMC
# include <pkgconf/devs_disk_mmc.h>
cyg_spi_at91_device_t cyg_spi_mmc_dev0 CYG_SPI_DEVICE_ON_BUS(0) = 
{
    .spi_device.spi_bus = &cyg_spi_at91_bus0.spi_bus,

    .dev_num     = 3,       // Device number
    .cl_pol      = 0,       // Clock polarity (0 or 1)
    .cl_pha      = 1,       // Clock phase (0 or 1)
    .cl_brate    = 400000,  // Clock baud rate - Max f(OD) from MMC spec is 400kHz,
                            // and we can't do less because we have a minimum SPI bus
                            // clock speed of MCK/255 == 389.5kHZ for 100MHz MCK.
    .cs_up_udly  = 1,       // Delay in usec between CS up and transfer start
    .cs_dw_udly  = 1,       // Delay in usec between transfer end and CS down
    .tr_bt_udly  = 1        // Delay in usec between two transfers
};

#endif

//=============================================================================
// EOF sam9261ek_spi.c
