#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H
/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, eCosCentric Limited                            
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: 
// Date:         2003-09-15
// Purpose:      ARM VPB926EJS platform specific support routines
// Description: 
// Usage:        #include <cyg/hal/hal_platform_setup.h>
//     Only used by "vectors.S"         
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/system.h>             // System-wide configuration info
#include CYGBLD_HAL_VARIANT_H           // Variant specific configuration
#include CYGBLD_HAL_PLATFORM_H          // Platform specific configuration
#include <cyg/hal/hal_mmu.h>            // MMU definitions
#include <cyg/hal/vpb926ejs.h>          // Platform specific hardware definitions

//--------------------------------------------------------------------------------

//===========================================================================*/

#define CYGHWR_LED_MACRO                \
        ldr     r0,=VPB926EJS_SYS     ; \
        mov     r1,#\x                ; \
        str     r1,[r0, #_SYS_LED]    ;



//--------------------------------------------------------------------------------

        
        .macro  _platform_setup1

#ifndef CYG_HAL_STARTUP_RAM
//--------------------------------------------------------------------------------

#ifdef CYG_HAL_STARTUP_ROMRAM
        ldr     r10,=(0x34000000-0x8000)
#else
        mov     r10,#0        
#endif        
        
        ldr     r0,=1f
        add     r0,r0,r10
        mov     pc,r0
1:   

        ldr     r0, =0x2001           // allow access to all coprocessors
        mcr     p15,0,r0,c15,c1,0
        nop
        nop
        nop

        ldr     r0, =0x00000078
        mcr     p15,0,r0,c1,c0,0      // Disable MMU, caches, write buffer 
        nop
        nop
        nop

        ldr     r0, =0x00000000
        mcr     p15,0,r0,c8,c7,0      // flush TLB's 
        mcr     p15,0,r0,c7,c7,0      // flush Caches 
        mcr     p15,0,r0,c7,c10,4     // Flush Write Buffer 
        nop
        nop
        nop

        mvn     r0, #0                // grant manager access to all domains
        mcr     p15,0,r0,c3,c0,0  

        // Start up the Memory controllers

#define DONE 0        
#define LOOP 1
#define READ 2
                      
        ldr     r0, =8f
        add     r0,r0,r10
1:      
        ldr     r1,[r0]
        ldr     r2,[r0,#4]
        add     r0,r0,#8
        cmp     r1,#DONE
        beq     99f
        cmp     r1,#LOOP
        bne     3f
2:      
        sub     r1,r1,#1
        bne     2b
        b       1b
3:
        cmp     r1,#READ
        bne     4f
        ldr     r1,[r2]
        b       1b
4:                      
        str     r2,[r1]
        b       1b
        
8:
        // Set up Static RAM controller for 32 bit devices
        .long   VPB926EJS_SSMC+_SSMC_BANK0_CR,          0x00303021
        .long   VPB926EJS_SSMC+_SSMC_BANK1_CR,          0x00303021
        .long   VPB926EJS_SSMC+_SSMC_BANK2_CR,          0x00303021
        .long   VPB926EJS_SSMC+_SSMC_BANK3_CR,          0x00303021

        // Set up DRAM controller        
        .long   VPB926EJS_MPMC+_MPMC_CONFIG, 0

        // AHB timeouts
        .long   VPB926EJS_MPMC+_MPMC_AHBTimeout0,       0x00000002
        .long   VPB926EJS_MPMC+_MPMC_AHBTimeout1,       0x00000000
        .long   VPB926EJS_MPMC+_MPMC_AHBTimeout2,       0x00000000
        .long   VPB926EJS_MPMC+_MPMC_AHBTimeout3,       0x00000000
        .long   VPB926EJS_MPMC+_MPMC_AHBTimeout4,       0x00000000
        .long   VPB926EJS_MPMC+_MPMC_AHBTimeout5,       0x00000000

        // Clocking
        .long   VPB926EJS_MPMC+_MPMC_DynamicReadConfig, 0x00000111

        // Init value to NOP
        .long   VPB926EJS_MPMC+_MPMC_DynamicControl,    0x0000C183

        // Init value to PALL
        .long   VPB926EJS_MPMC+_MPMC_DynamicControl,    0x0000C103

        // Refresh = 1 (x16 == 16 cycles between refreshes)
        // Then loop to let refresh happen
        .long   VPB926EJS_MPMC+_MPMC_DynamicRefresh,    0x00000001
        .long   LOOP, 32

        // Refresh = 0x3c
        .long   VPB926EJS_MPMC+_MPMC_DynamicRefresh,    0x0000003c

        // Set RAS/CAS latency
        .long   VPB926EJS_MPMC+_MPMC_DynamicRasCas0,    0x00000202
        .long   VPB926EJS_MPMC+_MPMC_DynamicRasCas1,    0x00000202
        .long   VPB926EJS_MPMC+_MPMC_DynamicRasCas2,    0x00000202
        .long   VPB926EJS_MPMC+_MPMC_DynamicRasCas3,    0x00000202

        // Set operational values in config regs
        .long   VPB926EJS_MPMC+_MPMC_DynamicConfig0,    0x00005880
        .long   VPB926EJS_MPMC+_MPMC_DynamicConfig1,    0x00005880
        .long   VPB926EJS_MPMC+_MPMC_DynamicConfig2,    0x00005880
        .long   VPB926EJS_MPMC+_MPMC_DynamicConfig3,    0x00005880

        // Set remaining registers
        .long   VPB926EJS_MPMC+_MPMC_DynamictRP,        0x00000002
        .long   VPB926EJS_MPMC+_MPMC_DynamictRAS,       0x00000003
        .long   VPB926EJS_MPMC+_MPMC_DynamictSREX,      0x00000005
        .long   VPB926EJS_MPMC+_MPMC_DynamictWR,        0x00000004
        .long   VPB926EJS_MPMC+_MPMC_DynamictRC,        0x00000005
        .long   VPB926EJS_MPMC+_MPMC_DynamictRFC,       0x00000005
        .long   VPB926EJS_MPMC+_MPMC_DynamictXSR,       0x00000005
        .long   VPB926EJS_MPMC+_MPMC_DynamictRRD,       0x00000005
        .long   VPB926EJS_MPMC+_MPMC_DynamictMRD,       0x00000004
        .long   VPB926EJS_MPMC+_MPMC_DynamictCDLR,      0x00000005

        // Init value to MODE
        .long   VPB926EJS_MPMC+_MPMC_DynamicControl,    0x00000083

        // Program the mode registers
        // This is done by reading a location in the SDRAM that
	// corresponds to the value we want to set.
        .long   READ, 0x04020000
        .long   READ, 0x08020000
        .long   READ, 0x70020000
        .long   READ, 0x78020000

        // Init value to PALL
        .long   VPB926EJS_MPMC+_MPMC_DynamicControl,    0x00000103

        // Init value to NORMAL
        .long   VPB926EJS_MPMC+_MPMC_DynamicControl,    0x00000003
              
        .long   DONE, DONE
        
99:          
sdram_running:

        // Undo location 0 remap
        
        // First set the Remap bit in the chip system controller
        // Also sets timers to use TIMCLK rather than REFCLK
        ldr     r0,=VPB926EJS_SC
        ldr     r1,[r0, #_SC_CTRL]
        ldr     r2,=0x002a8109
        orr     r1,r1,r2
        orr     r1,r1,#_SC_CTRL_REMAP
        str     r1,[r0, #_SC_CTRL]

        // Now clear the FPGA remap bit
        ldr     r0,=VPB926EJS_SYS
        ldr     r1,[r0, #_SYS_MISC]        
        bic     r1,r1,#_SYS_FPGA_REMAP
        str     r1,[r0, #_SYS_MISC]        

        // We should now have SDRAM at 0
        
#endif  // CYG_HAL_STARTUP_RAM

#ifdef CYG_HAL_STARTUP_ROMRAM
        // Compute [logical] base address of this image in ROM
        bl      10f
10:     mov     r9,lr
        ldr     r8,=~0xFF01FFFF         // Bits to ignore
        and     r9,r9,r8
        orr     r9,r9,#0x34000000       // Turn into ROM address 3
#endif

        // Test whether MMU is already running. If it is then we skip
	// over the setup code.
        ldr     r1,=MMU_Control_M
        mrc     MMU_CP,0,r2,MMU_Control,c0
        and     r1,r1,r2
        cmp     r1,#0
        bne     mmu_ok
        
        // Set up a stack [for calling C code]
        ldr     r1,=__startup_stack
        ldr     r2,=VPB926EJS_SDRAM_PHYS_BASE
        orr     sp,r1,r2

        // Create MMU tables
        bl      hal_mmu_init

        // Enable MMU
        ldr     r2,=10f
#ifdef CYG_HAL_STARTUP_ROMRAM
        ldr     r1,=__exception_handlers
        sub     r1,r2,r1
        add     r2,r9,r1        // r9 has ROM offset
#endif        
        ldr    r1,=MMU_Control_Init|MMU_Control_M
        mcr    MMU_CP,0,r1,MMU_Control,c0
        mov    pc,r2    /* Change address spaces */
        nop
        nop
        nop
10:

mmu_ok:
        
#ifdef CYG_HAL_STARTUP_ROMRAM
        mov     r0,r9                     // Relocate FLASH/ROM to RAM
        ldr     r1,=__exception_handlers  // ram base & length
        ldr     r2,=__rom_data_end
20:     ldr     r3,[r0],#4
        str     r3,[r1],#4
        cmp     r1,r2
        bne     20b
        ldr     r0,=30f
        mov     pc,r0
        nop
        nop
        nop
        nop
30:             
#endif
        .endm
        
#define CYGHWR_HAL_ARM_HAS_MMU
#define PLATFORM_SETUP1 _platform_setup1
#define CYGSEM_HAL_ROM_RESET_USES_JUMP

//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
#endif // CYGONCE_HAL_PLATFORM_SETUP_H
