#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H
/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, 2005, 2006, 2009 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: eCosCentric
// Date:         2009-12-09
// Purpose:      Platform specific support routines
// Description: 
// Usage:        #include <cyg/hal/hal_platform_setup.h>
//               Only used by "vectors.S"         
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/system.h>                  // System-wide configuration info
#include <pkgconf/hal_arm.h>
#include <pkgconf/hal_arm_arm9.h>
#include <pkgconf/hal_arm_arm9_omap_l1xx.h>

#include CYGBLD_HAL_VARIANT_H                // Variant specific configuration
#include CYGBLD_HAL_PLATFORM_H               // Platform specific configuration
#include <cyg/hal/hal_mmu.h>                 // MMU definitions
//#include <cyg/hal/sam9260ek.h>
#include <cyg/hal/omap_l1xx.h>               // Platform specific hardware definitions
#include <cyg/hal/omap_l1xx_init.inc>        // Common init helper macros
#include <cyg/hal/plf_io.h>                  // Memory addresses        

//===========================================================================*/
// User LED display

        .macro  ldrc reg,val
#ifdef __thumb__
        ldr     \reg,=\val
#else
        mov     \reg,#\val
#endif
        .endm

        .macro _led y
        .endm
        
#define CYGHWR_LED_MACRO _led \x

//================================================================================
// This macro implements the initial startup code for the platform. Mostly it
// consists of calls on macros defined in the generic OMAP L1xx HAL.        

        .macro  _platform_setup1

//--------------------------------------------------------------------------------
// Set up the CPU

        omap_l1xx_init_cpu

//--------------------------------------------------------------------------------
// Get the clocks running
//

         omap_l1xx_init_clocks 
                           
//--------------------------------------------------------------------------------            
// GPIO Initialization
//
                           
      
//--------------------------------------------------------------------------------                    
// SDRAM Initialization
//

#ifndef CYG_HAL_STARTUP_RAM
                
        omap_l1xx_init_sdram
             
#endif
                
        _led 1        
//--------------------------------------------------------------------------------
// This will cause hal_mmu_init to be called

        omap_l1xx_init_mmu CYGHWR_HAL_ZOOM_L138_RAM_PHYS_BASE
                        
        .endm

//--------------------------------------------------------------------------------
                
#define PLATFORM_SETUP1 _platform_setup1
#define CYGSEM_HAL_ROM_RESET_USES_JUMP

#endif // CYGONCE_HAL_PLATFORM_SETUP_H
//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
