#ifndef CYGONCE_HAL_PLATFORM_SETUP_H
#define CYGONCE_HAL_PLATFORM_SETUP_H

/*=============================================================================
//
//      hal_platform_setup.h
//
//      Platform specific support for HAL (assembly code)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2008 Free Software Foundation, Inc.
// Copyright (C) 2004, 2008 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour, nickg
// Contributors:nickg
// Date:        2004-09-27
// Purpose:     EA QuickStart platform specific support routines
// Description:
// Usage:       #include <cyg/hal/hal_platform_setup.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <cyg/hal/var_io.h>

#define CYGHWR_LED_MACRO _led \x

        // ----------------------------------------------------------------
        .macro  _led_init
        // Set GPIO direction for LED pins (P0.10-P0.13, P0.17-P0.21) on prototype board.
        // Don't touch others.
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_GPIO_BASE
        ldr     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_GPIO_DIR]
        ldr     r2,=0x003e3c00
        orr     r1,r1,r2
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_GPIO_DIR]

        // All LEDs on to start with
        _led    511
        .endm

        // ----------------------------------------------------------------
        .macro _led y
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_GPIO_BASE
        ldr     r1,=0x003e3c00
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_GPIO_SET]
        ldr     r1,=(((\y<<10)&0x3c00)|((\y<<13)&0x003e0000))
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_GPIO_CLR]
        .endm


        // ----------------------------------------------------------------
        
        .macro lpc2xxx_common_init

        // First be sure that all GPIOs are set as inputs (all bits of DIR to 0 in both ports)
        
        ldr     r0,=CYGARC_HAL_LPC2XXX_REG_GPIO_BASE
        mov     r1,#0
        str     r1,[r0,#CYGARC_HAL_LPC2XXX_REG_GPIO_DIR]
        str     r1,[r0,#(CYGARC_HAL_LPC2XXX_REG_GPIO_DIR+CYGARC_HAL_LPC2XXX_REG_GPIO_PORT_OFFSET)]

#if defined(CYGHWR_HAL_ARM_LPC2XXX_EA_QUICKSTART_LPC2148)
        // Set PINSEL0 with:
        //  P0.0/P0.1 for UART0
        //  P0.2/P0.3 for I2C
        //  P0.4/P0.5/P0.6 for SPI
        //  P0.7 as PWM2 for buzzer on Prototype board
        //  P0.8/P0.9 for UART1 (which is available on prototype board)
        //  P0.10-P0.13 as GPIO-controlled LEDs
        //  P0.14 EINT1 (available as button on prototype board)
        //  P0.15 EINT2 (available as button on prototype board)

        lpc2xxx_init_pinsel0 0xa0059555

        // Set PINSEL1 with:
        //  P0.16 EINT0 (available as button on prototype board)
        //  P0.17-P0.21 as GPIO-controlled LEDs
        //  P0.22 as GPIO output for SPI_SEL_MMC on prototype board
        //  P0.23 as GPIO output for SPI_SEL_LED on prototype board
        //  P0.29 as GPIO input for MMC/SD card detect on prototype board
        //  P0.30 as EINT3  (available as button on prototype board)
        //                  (rather than GPIO input for SD write protect on prototype board)
        // All other pins set as GPIO inputs

        lpc2xxx_init_pinsel1 0x20000001
        
        //  P1.26-P1.31 for JTAG
        // All other pins set as inputs

        lpc2xxx_init_pinsel2_masked 0x00000004 0x00000004
             
#else
#error No EA QuickStart variant defined        
#endif                
        _led_init
        .endm

        // ----------------------------------------------------------------
        
        .macro  lpc2xxx_rom_init
        lpc2xxx_common_init
        _led    0
        lpc2xxx_init_pll
        _led    12
             // lpc2xxx_init_emc 0,0x20001c20,0,0                                              
        lpc2xxx_copy_romram
        _led    13
        lpc2xxx_remap
        _led    14
        lpc2xxx_init_mam        
        _led    15
        .endm

#if defined(CYG_HAL_STARTUP_ROM) || defined(CYG_HAL_STARTUP_ROMRAM) || defined(CYG_HAL_STARTUP_JTAG)        
#define CYGSEM_HAL_ROM_RESET_USES_JUMP
#define PLATFORM_SETUP1     lpc2xxx_rom_init

// The unused vector must contain the 2's complement of the sum
// of the other vectors for the on-chip bootstrap to recognize
// the executable image as valid.

#define CYGSEM_HAL_ARM_VECTOR_UNUSED
        .macro  unused_vector
        .long   0xb4405f62             // -((b reset_vector) + 6*(ldr pc,[pc,#24]))
        .endm

#else
#define PLATFORM_SETUP1     lpc2xxx_common_init
#endif
        
//-----------------------------------------------------------------------------
// end of hal_platform_setup.h
#endif // CYGONCE_HAL_PLATFORM_SETUP_H
