//==========================================================================
//
//      hal_stddiag.c
//
//      Hardware-independent HAL diagnostics support
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2007 Free Software Foundation, Inc.                        
// Copyright (C) 2007 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    bartv
// Date:         2007-11-27
//
//####DESCRIPTIONEND####
//
//========================================================================*/

#include <pkgconf/hal.h>

#include <cyg/hal/hal_arch.h>
#include <cyg/hal/hal_if.h>
#include <cyg/hal/drv_api.h>
#include <cyg/hal/hal_intr.h>
#include <cyg/hal/hal_misc.h>           // our header
#include <cyg/infra/cyg_type.h>         // Base types
#include <stdarg.h>
#include <cyg/hal/hal_diag.h>           // HAL_DELAY_US

// Discard diagnostics functions are only needed when virtual
// vectors are enabled. In non-virtual-vector configs everything
// can be handled by empty macros.

#ifdef CYGSEM_HAL_VIRTUAL_VECTOR_SUPPORT
static int  msec_timeout;

static void
hal_diag_discard_putc(void* channel_data, char c)
{
    CYG_UNUSED_PARAM(void*, channel_data);
    CYG_UNUSED_PARAM(char, c);
}

static void
hal_diag_discard_getc(void* channel_data)
{
    CYG_UNUSED_PARAM(void*, channel_data);
    while ( 1 ) ;
}

static void
hal_diag_discard_write(void* channel_data, const cyg_uint8* buf, cyg_uint32 len)
{
    CYG_UNUSED_PARAM(void*, channel_data);
    CYG_UNUSED_PARAM(const cyg_uint8*, buf);
    CYG_UNUSED_PARAM(cyg_uint32, len);
}

static void
hal_diag_discard_read(void* channel_data, cyg_uint8* buf, cyg_uint32 len)
{
    CYG_UNUSED_PARAM(void*, channel_data);
    CYG_UNUSED_PARAM(cyg_uint8*, buf);
    CYG_UNUSED_PARAM(cyg_uint32, len);
}

static cyg_bool
hal_diag_discard_getc_timeout(void* channel_data, cyg_uint8* ch)
{
    CYG_UNUSED_PARAM(void*, channel_data);
    CYG_UNUSED_PARAM(cyg_uint8*, ch);
    HAL_DELAY_US(msec_timeout * 1000);
    return 0;
}

static int
hal_diag_discard_isr(void* channel_data, int* ctrl_c, CYG_ADDRWORD isr_vector, CYG_ADDRWORD isr_data)
{
    CYG_UNUSED_PARAM(void*, channel_data);
    CYG_UNUSED_PARAM(CYG_ADDRWORD, isr_vector);
    CYG_UNUSED_PARAM(CYG_ADDRWORD, isr_data);
    *ctrl_c = 0;
    return CYG_ISR_HANDLED;
}

static int
hal_diag_discard_control(void* channel_data, __comm_control_cmd_t func, ...)
{
    int     result  = -1;
    va_list args;

    va_start(args, func);
    switch(func) {
      case __COMMCTL_IRQ_ENABLE:
        result = 0;
        break;
      case __COMMCTL_IRQ_DISABLE:
        result = 0;
        break;
      case __COMMCTL_DBG_ISR_VECTOR:
        result = -1;
        break;
      case __COMMCTL_SET_TIMEOUT:
        result = msec_timeout;
        msec_timeout = va_arg(args, cyg_uint32);
        break;
      default:
        break;
    }
    CYG_UNUSED_PARAM(void*, channel_data);
    return result;
}

// This routine can be called from a cyg_hal_plf_comms_init()
// function when discard diagnostics should be used.
void
hal_diag_discard_comms_init(void)
{
    hal_virtual_comm_table_t*   comm;
    int                         cur;

    cur = CYGACC_CALL_IF_SET_CONSOLE_COMM(CYGNUM_CALL_IF_SET_COMM_ID_QUERY_CURRENT);
    CYGACC_CALL_IF_SET_CONSOLE_COMM(0);
    comm    = CYGACC_CALL_IF_CONSOLE_PROCS();
    CYGACC_COMM_IF_CH_DATA_SET(*comm, 0);
    CYGACC_COMM_IF_WRITE_SET(*comm, hal_diag_discard_write);
    CYGACC_COMM_IF_READ_SET(*comm, hal_diag_discard_read);
    CYGACC_COMM_IF_PUTC_SET(*comm, hal_diag_discard_putc);
    CYGACC_COMM_IF_GETC_SET(*comm, hal_diag_discard_getc);
    CYGACC_COMM_IF_CONTROL_SET(*comm, hal_diag_discard_control);
    CYGACC_COMM_IF_DBG_ISR_SET(*comm, hal_diag_discard_isr);
    CYGACC_COMM_IF_GETC_TIMEOUT_SET(*comm, hal_diag_discard_getc_timeout);
    CYGACC_CALL_IF_SET_CONSOLE_COMM(cur);
}
#else
void
hal_diag_discard_comms_init(void)
{
}
#endif
