#include <pkgconf/system.h>
#include <pkgconf/libstdcxx.h> // config header
#ifdef CYGPKG_ISOINFRA
# include <pkgconf/isoinfra.h>
#endif
#include <cyg/infra/testcase.h>

#if !defined(CYGPKG_ISOINFRA)
# define NA_MSG "Requires isoinfra package"
#elif !defined(CYGPKG_LIBSTDCXX_LIBRARY)
# define NA_MSG "Requires libstdc++ library support"
#elif !CYGINT_ISO_MAIN_STARTUP
# define NA_MSG "Requires main() startup"
#endif

#ifdef NA_MSG

externC void
cyg_start()
{
    CYG_TEST_INIT();
    CYG_TEST_NA( NA_MSG );
    CYG_TEST_FINISH("Done");
}
#else

// 19990805 gdr
//
// XXX: to impove later.
// Origin: Andreas Amann <amann@physik.tu-berlin.de>
// CXXFLAGS: -g

#include <iostream>
#include <valarray>


int main()
{
    CYG_TEST_INIT();
    std::valarray<double> a(10), b(10), c(10), d(10);

    a = 1.2;
    b = 3.1;

    c = 4.0;

    d = ( 2.0 * b + a );  // works
    std::cout << "d[4] = " << d[4] << std::endl;

    d = (a * 2.0 + b ); // works
    std::cout << "d[4] = " << d[4] << std::endl;

    d = (a + b * 2.0 ); // segfaults!
    std::cout << "d[4] = " << d[4] << std::endl;
    d = (a + 2.0* b );

    std::cout << "d[4] = " << d[4] << std::endl;
    d = (a + 2.0* b );
    std::cout << "d[4] = " << d[4] << std::endl;
    d = (a + 2.0* b );

    std::cout << "d[4] = " << d[4] << std::endl;

    CYG_TEST_PASS_FINISH( "binary_closure done" );
    return 0;
}

#endif // !NA_MSG

// EOF
