//===========================================================================
//
//      infconst.c
//
//      Infinity constant
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    jlarmour
// Contributors: jlarmour
// Date:         2004-03-01
// Purpose:     
// Description:  Defines a constant cyg_libm_infinity so that we can define
//               HUGE_VAL. Similarly for single precision and HUGE_VALF.
// Usage:       
//
//####DESCRIPTIONEND####
//
//===========================================================================

// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header

// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
                                   // including endian-ness
#include <math.h>                  // Main header for math library
#include <sys/ieeefp.h>            // Cyg_libm_ieee_double_shape_type


// GLOBALS

#ifndef _DOUBLE_IS_32BITS
#if (CYG_DOUBLE_BYTEORDER == CYG_MSBFIRST) // Big endian
const Cyg_libm_ieee_double_shape_type __infinity[1] = {{{0x7ff00000, 0}}};
#else  // Little endian
const Cyg_libm_ieee_double_shape_type __infinity[1] = {{{0, 0x7ff00000}}};
#endif
#else /* defined (_DOUBLE_IS_32BITS) */
const Cyg_libm_ieee_double_shape_type  __infinity[1] = {{{ 0x7f800000, 0 }}};
#endif /* defined (_DOUBLE_IS_32BITS) */

const Cyg_libm_ieee_float_shape_type __infinityf[1] = {{0x7f800000}};

// EOF infconst.c
