//========================================================================
//
//      frag.c
//
//      IP fragmentation testing
//
//========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2006 Free Software Foundation, Inc.                        
// Copyright (C) 2006 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
/*
 * Copyright (c) 2001, Swedish Institute of Computer Science.
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 3. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 *
 * This file is part of the lwIP TCP/IP stack.
 * 
 * Author: Adam Dunkels <adam@sics.se>
 *
 */

#include <pkgconf/net_lwip.h>
#include <cyg/infra/testcase.h>

#if !defined(CYGPKG_LWIP_UDP)
# define NA_MSG "UDP support disabled"
#elif !defined(CYGFUN_LWIP_SEQUENTIAL_API)
# define NA_MSG "No lwIP sequential API"
#elif !defined(CYGFUN_LWIP_IP_FRAG)
# define NA_MSG "No IP fragmentation support"
#endif

#ifdef NA_MSG
__externC void
cyg_start( void )
{
    CYG_TEST_INIT();
    CYG_TEST_NA(NA_MSG);
}
#else

#include "lwip/sys.h"
#include "lwip/api.h"
#include <cyg/kernel/kapi.h>
#include <cyg/hal/hal_arch.h> // CYGNUM_HAL_STACK_SIZE_TYPICAL

#define BUFFERSIZE 3004

/*-----------------------------------------------------------------------------------*/
const char line[50] = "XXXXXstart lineABCDEFGHIJKLMNOPQRSTUVWXYZend line\n";
char buffer[BUFFERSIZE];

void 
ipfrag_thread(cyg_addrword_t arg)
{
  struct netconn *conn;
  struct netbuf *buf, *sendbuf;
  struct ip_addr *addr;
  unsigned short port;
  int i;
  err_t err;
  
  CYG_TEST_INFO( "Starting lwIP IP fragmentation test");
  cyg_lwip_init();	
  CYG_TEST_PASS( "Completed cyg_lwip_init");

  conn = netconn_new(NETCONN_UDP);
  CYG_TEST_PASS_FAIL( NULL != conn, "Created new connection");
  
  err = netconn_bind(conn, NULL, 7);

  CYG_TEST_PASS_FAIL( ERR_OK == err, "Bind");
  CYG_TEST_INFO("Listening on UDP port 7");

  for (i=0; i<sizeof(buffer); i++) {
      buffer[i] = line[i%sizeof(line)];
  }
  // set line numbers
  for (i=0; i<sizeof(buffer); i+=sizeof(line)) {
      if ( sizeof(buffer) - i >= 5 ) {
          buffer[i]   = '0'+((i/10000) % 10);
          buffer[i+1] = '0'+((i/1000) % 10);
          buffer[i+2] = '0'+((i/100) % 10);
          buffer[i+3] = '0'+((i/10) % 10);
          buffer[i+4] = '0'+(i % 10);
      }
  }

  CYG_TEST_INFO("Will wait for two connections");
  for (i=0; i<2; i++) {
    buf = netconn_recv(conn);
    CYG_TEST_PASS_FAIL( NULL != buf, "Received connection OK" );

    addr = netbuf_fromaddr(buf);
    port = netbuf_fromport(buf);
    err = netconn_connect(conn, addr, port);
    CYG_TEST_PASS_FAIL( ERR_OK == err, "Created connection back to source" );

    err = netconn_send(conn, buf);
    CYG_TEST_PASS_FAIL( ERR_OK == err, "Echoing data" );

    sendbuf = netbuf_new();
    CYG_TEST_PASS_FAIL( NULL != sendbuf, "Created send buffer" );

    netbuf_ref( sendbuf, buffer, sizeof(buffer) );
    err = netconn_send(conn, sendbuf);
    CYG_TEST_PASS_FAIL( ERR_OK == err, "Sending large UDP datagram" );

    netbuf_delete(sendbuf);
    netbuf_delete(buf);
    err = netconn_disconnect(conn);
    CYG_TEST_PASS_FAIL( ERR_OK == err, "Disconnecting" );
  }
  CYG_TEST_PASS_FINISH("IP fragmentation test");
}

/*-----------------------------------------------------------------------------------*/

#define STACK_SIZE CYGNUM_HAL_STACK_SIZE_TYPICAL
static char stack[STACK_SIZE] CYGBLD_ATTRIB_ALIGN_MAX;
static cyg_thread thread_data;
static cyg_handle_t thread_handle;

void
cyg_user_start(void)
{
    CYG_TEST_INIT();
    // Create a main thread, so we can run the scheduler and have time 'pass'
    CYG_TEST_INFO( "Creating IP frag test thread");
    cyg_thread_create(7,                 // Priority - just a number
                      ipfrag_thread,     // entry
                      0,                 // entry parameter
                      "IP frag test",   // Name
                      &stack[0],         // Stack
                      STACK_SIZE,        // Size
                      &thread_handle,    // Handle
                      &thread_data       // Thread data structure
            );
    cyg_thread_resume(thread_handle);  // Start it
}

#endif // !defined NA_MSG

// EOF frag.c
