//========================================================================
//
//      tcpecho.c
//
//      TCP echo testing
//
//========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2006 Free Software Foundation, Inc.                        
// Copyright (C) 2006 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
/*
 * Copyright (c) 2001, Swedish Institute of Computer Science.
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 3. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 *
 * This file is part of the lwIP TCP/IP stack.
 * 
 * Author: Adam Dunkels <adam@sics.se>
 *
 */

#include <pkgconf/net_lwip.h>
#include <cyg/infra/testcase.h>

#if !defined(CYGPKG_LWIP_TCP)
# define NA_MSG "TCP support disabled"
#elif !defined(CYGFUN_LWIP_SEQUENTIAL_API)
# define NA_MSG "No lwIP sequential API"
#endif

#ifdef NA_MSG
__externC void
cyg_start( void )
{
    CYG_TEST_INIT();
    CYG_TEST_NA(NA_MSG);
}
#else

#include "lwip/sys.h"
#include "lwip/api.h"
#include <cyg/kernel/kapi.h>
#include <cyg/hal/hal_arch.h> // CYGNUM_HAL_STACK_SIZE_TYPICAL

static void 
tcpecho_thread(cyg_addrword_t arg)
{
    struct netconn *conn, *newconn;
    err_t err;
    int loops;

    CYG_TEST_INFO( "Starting lwIP tcpecho test");
    cyg_lwip_init();	
    CYG_TEST_PASS( "Completed cyg_lwip_init");

    /* Create a new connection identifier. */
    conn = netconn_new(NETCONN_TCP);

    CYG_TEST_PASS_FAIL( NULL != conn, "Created new connection");

    /* Bind connection to well known port number 7. */
    err = netconn_bind(conn, NULL, 7);

    CYG_TEST_PASS_FAIL( ERR_OK == err, "Bind");

    /* Tell connection to go into listening mode. */
    err = netconn_listen(conn);
    CYG_TEST_PASS_FAIL( ERR_OK == err, "Listening on TCP port 7" );

    CYG_TEST_INFO("Will wait for two connections");
    for (loops=0; loops<2; loops++) {

        /* Grab new connection. */
        newconn = netconn_accept(conn);

        CYG_TEST_PASS_FAIL( NULL != newconn, "Received connection OK" );

        /* Process the new connection. */
        if (newconn != NULL) {
            struct netbuf *buf;
            void *data;
            u16_t len;
            
            while((buf = netconn_recv(newconn)) != NULL) {
                netbuf_first(buf);
          
                do {
                    err = netbuf_data(buf, &data, &len);
                    CYG_TEST_PASS_FAIL( ERR_OK == err, "Accessed rx data" );
                    
                    err = netconn_write(newconn, data, len, NETCONN_COPY);
                    CYG_TEST_PASS_FAIL( ERR_OK == err, "Echoing data" );
                } while(netbuf_next(buf) >= 0);
                netbuf_delete(buf);	
            }
            /* Close connection and discard connection identifier. */
            err = netconn_delete(newconn);
            CYG_TEST_PASS_FAIL( ERR_OK == err, "Closed connection" );
        }
    }
    CYG_TEST_PASS_FINISH("tcpecho test");
}

#define STACK_SIZE CYGNUM_HAL_STACK_SIZE_TYPICAL
static char stack[STACK_SIZE] CYGBLD_ATTRIB_ALIGN_MAX;
static cyg_thread thread_data;
static cyg_handle_t thread_handle;

externC void
cyg_user_start( void )
{
    CYG_TEST_INIT();
    CYG_TEST_INFO("Creating tcpecho test thread");
    
    // Create a main thread, so we can run the scheduler and have time 'pass'
    cyg_thread_create(7,                // Priority - just a number
                      tcpecho_thread,    // entry
                      0,                 // entry parameter
                      "TCP echo test",        // Name
                      &stack[0],         // Stack
                      STACK_SIZE,        // Size
                      &thread_handle,    // Handle
                      &thread_data       // Thread data structure
            );
            
    cyg_thread_resume(thread_handle);  // Start it   
}

#endif // !defined NA_MSG

// EOF tcpecho.c
