/* Script for ld -r: link without relocation */
ENTRY(_start)
 /* For some reason, the Solaris linker makes bad executables
  if gld -r is used and the intermediate file has sections starting
  at non-zero addresses.  Could be a Solaris ld bug, could be a GNU ld
  bug.  But for now assigning the zero vmas works.  */
SECTIONS
{
  /* Read-only sections, merged into text segment: */
  .interp       0 : { *(.interp) }
  .hash         0 : { *(.hash) }
  .dynsym       0 : { *(.dynsym) }
  .dynstr       0 : { *(.dynstr) }
  .gnu.version  0 : { *(.gnu.version) }
  .gnu.version_d 0: { *(.gnu.version_d) }
  .gnu.version_r 0: { *(.gnu.version_r) }
  .rel.init     0 : { *(.rel.init) }
  .rela.init    0 : { *(.rela.init) }
  .rel.text     0 : { *(.rel.text) }
  .rela.text    0 : { *(.rela.text) }
  .rel.fini     0 : { *(.rel.fini) }
  .rela.fini    0 : { *(.rela.fini) }
  .rel.rodata   0 : { *(.rel.rodata) }
  .rela.rodata  0 : { *(.rela.rodata) }
  .rel.data.rel.ro 0 : { *(.rel.data.rel.ro) }
  .rela.data.rel.ro 0 : { *(.rel.data.rel.ro) }
  .rel.data     0 : { *(.rel.data) }
  .rela.data    0 : { *(.rela.data) }
  .rel.tdata	0 : { *(.rel.tdata) }
  .rela.tdata	0 : { *(.rela.tdata) }
  .rel.tbss	0 : { *(.rel.tbss) }
  .rela.tbss	0 : { *(.rela.tbss) }
  .rel.ctors    0 : { *(.rel.ctors) }
  .rela.ctors   0 : { *(.rela.ctors) }
  .rel.dtors    0 : { *(.rel.dtors) }
  .rela.dtors   0 : { *(.rela.dtors) }
  .rel.got      0 : { *(.rel.got) }
  .rela.got     0 : { *(.rela.got) }
  .rel.bss      0 : { *(.rel.bss) }
  .rela.bss     0 : { *(.rela.bss) }
  .rel.plt      0 : { *(.rel.plt) }
  .rela.plt     0 : { *(.rela.plt) }
  .init         0 :
  {
    KEEP (*(.init))
  } =0
  .plt          0 : { *(.plt) }
  .text         0 :
  {
    *(.text*) *(.gnu.warning) *(.gnu.linkonce.t.*) *(.init)
    *(.glue_7) *(.glue_7t) *(.rodata*)
  } =0
  .fini         0 :
  {
    KEEP (*(.fini))
  } =0
  .ARM.extab 0 : { *(.ARM.extab) }
  .ARM.exidx 0 : { *(.ARM.exidx) }
  /* Exception handling  */
  .eh_frame_hdr : { *(.eh_frame_hdr) }
  .eh_frame     0 : { KEEP (*(.eh_frame)) }
  .gcc_except_table 0 : { KEEP (*(.gcc_except_table)) *(.gcc_except_table.*) }
  /* Thread Local Storage sections  */
  .tdata	0 : { *(.tdata) }
  .tbss		0 : { *(.tbss) }
  /* Ensure the __preinit_array_start label is properly aligned.  We
     could instead move the label definition inside the section, but
     the linker would then create the section even if it turns out to
     be empty, which isn't pretty.  */
  .preinit_array   0 : { KEEP (*(.preinit_array)) }
  .init_array   0 : { KEEP (*(.init_array)) }
  .fini_array   0 : { KEEP (*(.fini_array)) }
  .jcr          0 : { KEEP (*(.jcr)) }
  .dynamic      0 : { *(.dynamic) }
  .got          0 : { *(.got.plt) *(.got) }
  .data         0 :
  {
    *(.data*) *(.data1) *(.gnu.linkonce.d.*)
    . = ALIGN (4);
    KEEP(*( SORT (.ecos.table.*))) ;
    . = ALIGN (4);
    KEEP (*(.gnu.linkonce.d.*personality*))
  }
  .data1        0 : { *(.data1) }
  .bss          0 :
  {
    *(.scommon) *(.dynsbss) *(.sbss*) *(.gnu.linkonce.sb.*)
    *(.dynbss) *(.bss*) *(.gnu.linkonce.b.*) *(COMMON)
   /* Align here to ensure that the .bss section occupies space up to
      _end.  Align after .bss to ensure correct alignment even if the
      .bss section disappears because there are no input sections.  */
  }
  /* Stabs debugging sections.  */
  .stab          0 : { *(.stab) }
  .stabstr       0 : { *(.stabstr) }
  .stab.excl     0 : { *(.stab.excl) }
  .stab.exclstr  0 : { *(.stab.exclstr) }
  .stab.index    0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment       0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
    .stack        0 :
  {
    *(.stack)
  }
  .note.gnu.arm.ident 0 : { KEEP (*(.note.gnu.arm.ident)) }
}

