# =====================================================================
#
#     gcov.gdb
#
# =====================================================================
# ####ECOSHOSTGPLCOPYRIGHTBEGIN####                                         
# -------------------------------------------                               
# This file is part of the eCos host tools.                                 
# Copyright (C) 2003, 2005 Free Software Foundation, Inc.                   
# Copyright (C) 2003, 2005 eCosCentric Limited                              
#
# This program is free software; you can redistribute it and/or modify      
# it under the terms of the GNU General Public License as published by      
# the Free Software Foundation; either version 2 or (at your option) any    
# later version.                                                            
#
# This program is distributed in the hope that it will be useful, but       
# WITHOUT ANY WARRANTY; without even the implied warranty of                
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         
# General Public License for more details.                                  
#
# You should have received a copy of the GNU General Public License         
# along with this program; if not, write to the                             
# Free Software Foundation, Inc., 51 Franklin Street,                       
# Fifth Floor, Boston, MA  02110-1301, USA.                                 
# -------------------------------------------                               
# ####ECOSHOSTGPLCOPYRIGHTEND####                                           
# =====================================================================
######DESCRIPTIONBEGIN####
#
# Author(s):	bartv
# Date:		2003-09-01
# Purpose:	extract gcov data from the target
#
#####DESCRIPTIONEND####
# =====================================================================

define _gcov_dump_string
  set $_gcov_string_end = $arg0
  while '\0' != *(char*)$_gcov_string_end
    set $_gcov_string_end = $_gcov_string_end + 1
  end
  # Include the terminator
  # and adjust to the next 4-byte boundary, as per the tftp version
  set $_gcov_string_len = $_gcov_string_end - $arg0
  set $_gcov_string_len = ($_gcov_string_len + 4) & ~3
  set $_gcov_string_end = $arg0 + $_gcov_string_len
  append binary memory ecosgcov.out ($arg0) ($_gcov_string_end)
end

define _gcov_dump_3_2_1
  dump   binary memory ecosgcov.out (gcov_data_format) ((char*)gcov_data_format + 16)
  append binary memory ecosgcov.out (&gcov_sample)  ((char*)&gcov_sample + sizeof(gcov_type))
  append binary memory ecosgcov.out (&gcov_crc32)   ((char*)&gcov_crc32  + sizeof(int))
  set $gcov_current = gcov_head
  while 0 != $gcov_current
    if 0 != $gcov_current->gc_counts
      append binary memory ecosgcov.out ($gcov_current) ($gcov_current + 1)
      _gcov_dump_string $gcov_current->gc_filename
      append binary memory ecosgcov.out ($gcov_current->gc_counts) (&($gcov_current->gc_counts[$gcov_current->gc_ncounts]))
    end
    set $gcov_current = $gcov_current->gc_next
  end
end

define _gcov_dump_3_3_x
  dump   binary memory ecosgcov.out (gcov_data_format) ((char*)gcov_data_format + 16)
  append binary memory ecosgcov.out (&gcov_sample)  ((char*)&gcov_sample + sizeof(gcov_type))
  append binary memory ecosgcov.out (&gcov_crc32)   ((char*)&gcov_crc32  + sizeof(int))
  set $gcov_current = (gcov_module*)gcov_head
  while 0 != $gcov_current
    if 0 != $gcov_current->gc_counts
      append binary memory ecosgcov.out ($gcov_current) ($gcov_current + 1)
      _gcov_dump_string $gcov_current->gc_filename
      append binary memory ecosgcov.out ($gcov_current->gc_counts) (&($gcov_current->gc_counts[$gcov_current->gc_ncounts]))
      set $gcov_n_functions = 0
      while -1 != $gcov_current->gc_function_infos[$gcov_n_functions].gc_arc_count
        set $gcov_n_functions = $gcov_n_functions + 1
      end
      set gcov_spare = $gcov_n_functions
      append binary memory ecosgcov.out (&gcov_spare) ((&gcov_spare) + 1)
      append binary memory ecosgcov.out &($gcov_current->gc_function_infos[0]) &($gcov_current->gc_function_infos[$gcov_n_functions])
      set $gcov_i = 0
      while $gcov_i < $gcov_n_functions
        _gcov_dump_string $gcov_current->gc_function_infos[$gcov_i].gc_name
        set $gcov_i = $gcov_i + 1
      end
    end
    set $gcov_current = $gcov_current->gc_next
  end
end

define _gcov_dump_3_4_x
  dump   binary memory ecosgcov.out (gcov_data_format) ((char*)gcov_data_format + 16)
  append binary memory ecosgcov.out (&gcov_sample)  ((char*)&gcov_sample + sizeof(gcov_type))
  append binary memory ecosgcov.out (&gcov_crc32)   ((char*)&gcov_crc32  + sizeof(int))
  set $gcov_current = gcov_head
  while 0 != $gcov_current
    if (0 != $gcov_current->gc_ctr_mask) && (0 != $gcov_current->gc_n_functions)
      set $gcov_n_counters = $gcov_current->gc_counts[0].gc_merge.gc_merge_id & 0x000000FF
      append binary memory ecosgcov.out $gcov_current &($gcov_current->gc_counts[$gcov_n_counters])
      _gcov_dump_string $gcov_current->gc_filename
      append binary memory ecosgcov.out $gcov_current->gc_functions (((char*)$gcov_current->gc_functions) + ($gcov_current->gc_n_functions * (sizeof(gcov_fn_info) + ($gcov_n_counters * sizeof(cyg_uint32)))))
      set $gcov_i = 0
      while $gcov_i < $gcov_n_counters
        append binary memory ecosgcov.out $gcov_current->gc_counts[$gcov_i].gc_values &($gcov_current->gc_counts[$gcov_i].gc_values[$gcov_current->gc_counts[$gcov_i].gc_num])
        set $gcov_i = $gcov_i + 1
      end
    end
    set $gcov_current = $gcov_current->gc_next
  end
end

define gcov_dump
  if (0x003d != gcov_data_format[0]) || (0x0065 != gcov_data_format[1]) || (0x009e != gcov_data_format[2]) || (0x00dc != gcov_data_format[3])
    echo Target-side gcov data missing or in wrong format.
  else
    set $gcov_compiler_version = ((10000 * gcov_data_format[5]) + (100 * gcov_data_format[6]) + (gcov_data_format[7]))
    if $gcov_compiler_version < 30300
      _gcov_dump_3_2_1
    else
      if $gcov_compiler_version < 30400
        _gcov_dump_3_3_x
      else
        # For now assume the 3.4 macro will work for all subsequent releases.
        _gcov_dump_3_4_x
      end
    end
  end
end

document gcov_dump
Extract gcov test coverage data from the target and dump it to
a file ecosgcov.out for subsequent processing. This macro should
only be used with eCos configurations that contain the gcov
package.
end
