#ifndef __ASM_BUG_H__
#define __ASM_BUG_H__

#include <pkgconf/hal.h>
#include <cyg/infra/cyg_ass.h>

#ifdef CYGDBG_HAL_DEBUG_GDB_INCLUDE_STUBS
__externC void breakpoint(void);
# define BP() breakpoint()
#else
# define BP() do { } while (0)
#endif

/* We try various things to halt execution:
   - A standard ecos assert
   - a breakpoint
   - a divide by zero error
   - an attempt to modify 0
   - an endless loop
   It is nevertheless possible for none of these to halt the program,
   but at least there will be the diag_printf.
*/

#define BUG() do {                                                      \
        volatile int _x,_n = 0;                                         \
        diag_printf("BUG() at %s %d\n", __FILE__, __LINE__);            \
        CYG_FAIL("BUG!\n");                                             \
        BP();                                                           \
        _x = 0/_n;                                                      \
        for (;;);                                                       \
        *(int *)0=0; } while (0)

#endif /* __ASM_BUG_H__ */
