//==========================================================================
//
//      arm_cerf_disk_ide_drivers.inl
//
//      PC target IDE disk driver configuration
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2006 Free Software Foundation, Inc.                  
// Copyright (C) 2004, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2004-01-19
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/devs_disk_arm_cerf.h>

#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_sa11x0.h>

#ifdef CYGPKG_DEVS_DISK_ARM_CERF_CF

// ----------------------------------------------------------------------------
// IDE Register Indices

#define IDE_REG_DATA      0
#define IDE_REG_ERROR     1
#define IDE_REG_FEATURES  1
#define IDE_REG_COUNT     2
#define IDE_REG_REASON    2  // ATAPI
#define IDE_REG_LBALOW    3
#define IDE_REG_LBAMID    4
#define IDE_REG_LBAHI     5
#define IDE_REG_DEVICE    6
#define IDE_REG_STATUS    7
#define IDE_REG_COMMAND   7

// Commands
#define	IDE_CMD_ATAPI_RESET 0x08	/* ATAPI soft reset		*/
#define IDE_CMD_RESTORE     0x10	/* Restore			*/
#define IDE_CMD_READ        0x20	/* Read sectors			*/
#define IDE_CMD_READLONG    0x22	/* Read long			*/
#define IDE_CMD_WRITE       0x30	/* Write sectors		*/
#define IDE_CMD_WRITELONG   0x32	/* Write long			*/
#define IDE_CMD_VERIFY      0x40	/* Read/Verify			*/
#define IDE_CMD_FORMAT      0x50	/* Format track			*/
#define IDE_CMD_SEEK        0x70	/* Seek				*/
#define IDE_CMD_DIAG        0x90	/* Diagnostic tests		*/
#define IDE_CMD_PACKET	    0xA0	/* ATAPI packet function	*/
#define IDE_CMD_PACKET_ID   0xA1	/* ATAPI packet identify	*/	
#define IDE_CMD_READMUL     0xc4	/* Multiple read		*/
#define IDE_CMD_WRITEMUL    0xc5	/* Multiple write		*/
#define IDE_CMD_SETMUL      0xc6	/* Set multiple mode		*/
#define IDE_CMD_STANDBY     0xe0	/* Standby			*/
#define IDE_CMD_IDLE        0xe1	/* Idle				*/
#define IDE_CMD_STANDBYTO   0xe2	/* Timeout standby		*/
#define IDE_CMD_IDLETO      0xe3	/* Timeout idle			*/
#define IDE_CMD_RDBUF       0xe4	/* Read buffer			*/
#define IDE_CMD_CHKPOWER    0xe5	/* Check power mode		*/
#define IDE_CMD_SLEEP       0xe6	/* Set sleep mode		*/
#define IDE_CMD_WRBUF       0xe8	/* Write buffer			*/
#define IDE_CMD_GETID       0xec	/* Get drive's ID		*/
#define IDE_CMD_SETSUP      0xef	/* Set features supported	*/

#define IDE_STAT_BSY      0x80
#define IDE_STAT_DRDY     0x40
#define IDE_STAT_DWF      0x20
#define IDE_STAT_SERVICE  0x10
#define IDE_STAT_DRQ      0x08
#define IDE_STAT_CORR     0x04
#define IDE_STAT_ERR      0x01

#define IDE_REASON_REL    0x04
#define IDE_REASON_IO     0x02
#define IDE_REASON_COD    0x01

//
// Drive ID offsets of interest
//
#define IDE_DEVID_GENCONFIG      0
#define IDE_DEVID_CYLS           2
#define IDE_DEVID_HEADS          6
#define IDE_DEVID_SECTORS       12
#define IDE_DEVID_SERNO         20
#define IDE_DEVID_FIRMWARE_REV  46
#define IDE_DEVID_MODEL         54
#define IDE_DEVID_LBA_CAPACITY 120


#define SECTOR_SIZE      512

#define CDROM_SECTOR_SIZE 2048
#define SECTORS_PER_CDROM_SECTOR (CDROM_SECTOR_SIZE/SECTOR_SIZE)

// ----------------------------------------------------------------------------

#define HAL_IDE_NUM_CONTROLLERS 1

#define HAL_IDE_INTERRUPT_PRI   CYGNUM_HAL_INTERRUPT_GPIO22

static int hal_ide_init(void)
{
#ifdef CYGVAR_DEVS_DISK_IDE_POLLED
    *SA11X0_GPIO_PIN_DIRECTION &= ~(1<<22);
    cyg_drv_interrupt_configure( HAL_IDE_INTERRUPT_PRI, 0, 0 );
#endif
    *SA11X0_EXP_BUS_CONFIGURATION = 0x7fff7fff;
    return HAL_IDE_NUM_CONTROLLERS;
}

// Initialize the IDE controller(s).
#define HAL_IDE_INIT() hal_ide_init()

#define __PCMB_IDE_PRI_CMD   0x2c000000
#define __PCMB_IDE_PRI_CTL   0x2c00000e

#define __CMD_ADDR(__n) (__PCMB_IDE_PRI_CMD)
#define __CTL_ADDR(__n) (__PCMB_IDE_PRI_CTL)

#define HAL_IDE_READ_UINT8( __ctlr, __regno, __val )  \
    HAL_READ_UINT8(__CMD_ADDR(__ctlr) + (__regno), (__val))
#define HAL_IDE_READ_UINT16( __ctlr, __regno, __val )  \
    HAL_READ_UINT16(__CMD_ADDR(__ctlr) + (__regno), (__val))
#undef HAL_IDE_READ_ALTSTATUS
#define HAL_IDE_READ_ALTSTATUS( __ctlr, __val )  \
    HAL_READ_UINT8(__CTL_ADDR(__ctlr) + 2, (__val))

#define HAL_IDE_WRITE_UINT8( __ctlr, __regno, __val )  \
    HAL_WRITE_UINT8(__CMD_ADDR(__ctlr) + (__regno), (__val))
#define HAL_IDE_WRITE_UINT16( __ctlr, __regno, __val )  \
    HAL_WRITE_UINT16(__CMD_ADDR(__ctlr) + (__regno), (__val))
#undef HAL_IDE_WRITE_CONTROL
#define HAL_IDE_WRITE_CONTROL( __ctlr, __val )  \
    HAL_WRITE_UINT8(__CTL_ADDR(__ctlr) + 2, (__val))


//==========================================================================
// IDE disks

// ----------------------------------------------------------------------------

static ide_controller_info_t ide_controller_info_0 = {
    ctlr:       0,
#ifndef CYGVAR_DEVS_DISK_IDE_POLLED    
    vector:     HAL_IDE_INTERRUPT_PRI
#endif
};

DISK_CONTROLLER( ide_disk_controller_0, ide_controller_info_0 );

// ----------------------------------------------------------------------------

#define IDE_DISK_INSTANCE(_number_,_ctlr_,_dev_,_mbr_supp_)     \
static ide_disk_info_t ide_disk_info##_number_ = {              \
    num:           _number_,                                    \
    ctlr:          &ide_controller_info_##_ctlr_,               \
    dev:           _dev_,                                       \
};                                                              \
DISK_CHANNEL(ide_disk_channel##_number_,                        \
             ide_disk_funs,                                     \
             ide_disk_info##_number_,                           \
             ide_disk_controller_##_ctlr_,                      \
             _mbr_supp_,                                        \
             4                                                  \
);                                                              \
BLOCK_DEVTAB_ENTRY(ide_disk_io##_number_,                       \
             CYGDAT_IO_DISK_IDE_DISK##_number_##_NAME,          \
             0,                                                 \
             &cyg_io_disk_devio,                                \
             ide_disk_init,                                     \
             ide_disk_lookup,                                   \
             &ide_disk_channel##_number_                        \
);

// ----------------------------------------------------------------------------

IDE_DISK_INSTANCE(0, 0, 0, true);
//IDE_DISK_INSTANCE(1, 0, 1, true);

#endif

// ----------------------------------------------------------------------------
// EOF arm_cerf_disk_ide_drivers.inl
