#ifndef CYGONCE_DEVS_ETH_LPC2XXX_PHY_H
#define CYGONCE_DEVS_ETH_LPC2XXX_PHY_H
//==========================================================================
//
//      lpc2xxx_phy.h
//
//      Access to PHY access for use by LPC2XXX ethernet driver
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008 Free Software Foundation, Inc.                        
// Copyright (C) 2008 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2008-02-11
// Purpose:
// Description:  PHY access for use by LPC2XXX ethernet driver
//
//####DESCRIPTIONEND####
//
//========================================================================*/

#include <pkgconf/system.h>
#include <pkgconf/hal.h> // clock speed definitions
#include <pkgconf/devs_eth_arm_lpc2xxx.h>
#if defined(CYGPKG_REDBOOT)
# include <pkgconf/redboot.h>
#endif

#include <cyg/infra/cyg_type.h>
#include <cyg/infra/cyg_ass.h>
#include <cyg/infra/diag.h>
#include <cyg/hal/hal_io.h>
#include <cyg/hal/hal_diag.h> // HAL_DELAY_US
#include <cyg/io/eth_phy.h>

//============================================================================
// PHY access bits and pieces
// 

// ---------------------------------------------------------------------
// Write one of the PHY registers via the MII bus

static void
lpc2xxx_write_phy(int reg_addr, int phy_addr, unsigned short data)
{
    cyg_uint32 base = CYGARC_HAL_LPC2XXX_REG_ETH_BASE;
    cyg_uint32 mind, mwtd;

    phy_debug_printf("phy %d reg %d data %04x\n", phy_addr, reg_addr, data);
    
    mwtd = data;    
    
    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MCMD, 0 );
    
    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MADR,
                      CYGARC_HAL_LPC2XXX_REG_ETH_MADR_REG(reg_addr) |
                      CYGARC_HAL_LPC2XXX_REG_ETH_MADR_PHY(phy_addr) );

    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MWTD, mwtd );
    
    do
    {
        HAL_READ_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MIND, mind );
        phy_debug_printf("mind %08x\n", mind );        
    } while( mind & CYGARC_HAL_LPC2XXX_REG_ETH_MIND_BUSY );
}

// ---------------------------------------------------------------------
// Read one of the PHY registers via the MII bus

static bool
lpc2xxx_read_phy(int reg_addr, int phy_addr, unsigned short *data)
{
    cyg_uint32 base = CYGARC_HAL_LPC2XXX_REG_ETH_BASE;
    cyg_uint32 mind, mrdd;

    phy_debug_printf("phy %d reg %d\n", phy_addr, reg_addr);
    
    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MCMD, CYGARC_HAL_LPC2XXX_REG_ETH_MCMD_READ );
    
    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MADR,
                      CYGARC_HAL_LPC2XXX_REG_ETH_MADR_REG(reg_addr) |
                      CYGARC_HAL_LPC2XXX_REG_ETH_MADR_PHY(phy_addr) );

    do
    {
        HAL_READ_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MIND, mind );
        phy_debug_printf("mind %08x\n", mind );
    } while( mind & CYGARC_HAL_LPC2XXX_REG_ETH_MIND_BUSY );

    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MCMD, 0 );

    HAL_READ_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MRDD, mrdd );

    *data = (unsigned short)mrdd;

    phy_debug_printf("mrdd %08x data %04x\n", mrdd, *data);
    
    return (true);
}

// ---------------------------------------------------------------------
// 
// Set the clock divider so that MDC is less than 2.5MHz.

static void 
lpc2xxx_init_phy(void)
{
    cyg_uint32 base = CYGARC_HAL_LPC2XXX_REG_ETH_BASE;
    cyg_uint32 cmd;

    phy_debug_printf("\n");
    
    // Set MII mgmt clock to /20
//    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MCFG, CYGARC_HAL_LPC2XXX_REG_ETH_MCFG_CLOCK_20 );
    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_MCFG, CYGARC_HAL_LPC2XXX_REG_ETH_MCFG_CLOCK_28 );

    // Set RMII mode
    HAL_READ_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_CMD, cmd );
    cmd |= CYGARC_HAL_LPC2XXX_REG_ETH_CMD_RMII;
    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_CMD, cmd );    

    // Set 100 MBps, other bit unknown, but duplicated from EA's Linux driver.
    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_SUPP, 0x0900 );

    LPC2XXX_ETH_DELAY_US(50);

    HAL_WRITE_UINT32( base + CYGARC_HAL_LPC2XXX_REG_ETH_SUPP, 0x0100 );

}

ETH_PHY_REG_LEVEL_ACCESS_FUNS(lpc2xxx_phy, 
                              lpc2xxx_init_phy,
                              NULL,
                              lpc2xxx_write_phy,
                              lpc2xxx_read_phy);

#endif // ifdef CYGONCE_DEVS_ETH_LPC2XXX_PHY_H
//======================================================================
// EOF lpc2xxx_phy.h
