//==========================================================================
//
//      lan9118.h
//
//	    Ethernet driver for SMSC LAN9118
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2005 Free Software Foundation, Inc.                        
// Copyright (C) 2005 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   bartv
// Date:        2005-07-20
//
//####DESCRIPTIONEND####
//=============================================================================

#include <pkgconf/devs_eth_smsc_lan9118.h>
#include <cyg/infra/cyg_type.h>
#include <cyg/hal/hal_io.h>
#define _KERNEL 1
#define __ECOS  1
#include <cyg/io/eth/netdev.h>
#include <cyg/io/eth/eth_drv.h>

// ----------------------------------------------------------------------------
// The LAN9118 is inherently little-endian. All accesses are 32-bit
// wide. The registers are also 32-bit wide so no problem there, but
// the data is just a byte vector and endianness is a major issue. On
// a big-endian cpu there are two options:
//
// 1) set up the bus controller and the chip for big-endian mode,
//    which means the registers can be read directly but the packets
//    have to be swapped.
// 2) set up the bus controller and the chip for little-endian, which
//    means the data can be read and written directly but all command
//    and status words need swapping.
//
// Option 2 is much more efficient, especially since the
// command/status swapping can be mostly done at compile-time.

#ifndef HAL_LAN9118_SWAP_COMMANDS

# define LAN9118_SWAP16(_val_)  (_val_)
# define LAN9118_SHIFT0          0
# define LAN9118_SHIFT1          1
# define LAN9118_SHIFT2          2
# define LAN9118_SHIFT3          3
# define LAN9118_SHIFT4          4
# define LAN9118_SHIFT5          5
# define LAN9118_SHIFT6          6
# define LAN9118_SHIFT7          7
# define LAN9118_SHIFT8          8
# define LAN9118_SHIFT9          9
# define LAN9118_SHIFT10        10
# define LAN9118_SHIFT11        11
# define LAN9118_SHIFT12        12
# define LAN9118_SHIFT13        13
# define LAN9118_SHIFT14        14
# define LAN9118_SHIFT15        15
# define LAN9118_SHIFT16        16
# define LAN9118_SHIFT17        17
# define LAN9118_SHIFT18        18
# define LAN9118_SHIFT19        19
# define LAN9118_SHIFT20        20
# define LAN9118_SHIFT21        21
# define LAN9118_SHIFT22        22
# define LAN9118_SHIFT23        23
# define LAN9118_SHIFT24        24
# define LAN9118_SHIFT25        25
# define LAN9118_SHIFT26        26
# define LAN9118_SHIFT27        27
# define LAN9118_SHIFT28        28
# define LAN9118_SHIFT29        29
# define LAN9118_SHIFT30        30
# define LAN9118_SHIFT31        31

#else

# define LAN9118_SWAP16(_val_)                                          \
    ({ cyg_uint32 _copy_ = (_val_);                                     \
       cyg_uint32 _result_;                                             \
       _result_ = ((_copy_ & 0x00FF) << 8) | ((_copy_ >> 8) & 0x00FF);  \
       _result_ ; })
# define LAN9118_SHIFT0         24
# define LAN9118_SHIFT1         25
# define LAN9118_SHIFT2         26
# define LAN9118_SHIFT3         27
# define LAN9118_SHIFT4         28
# define LAN9118_SHIFT5         29
# define LAN9118_SHIFT6         30
# define LAN9118_SHIFT7         31
# define LAN9118_SHIFT8         16
# define LAN9118_SHIFT9         17
# define LAN9118_SHIFT10        18
# define LAN9118_SHIFT11        19
# define LAN9118_SHIFT12        20
# define LAN9118_SHIFT13        21
# define LAN9118_SHIFT14        21
# define LAN9118_SHIFT15        23
# define LAN9118_SHIFT16         8
# define LAN9118_SHIFT17         9
# define LAN9118_SHIFT18        10
# define LAN9118_SHIFT19        11
# define LAN9118_SHIFT20        12
# define LAN9118_SHIFT21        13
# define LAN9118_SHIFT22        14
# define LAN9118_SHIFT23        15
# define LAN9118_SHIFT24         0
# define LAN9118_SHIFT25         1
# define LAN9118_SHIFT26         2
# define LAN9118_SHIFT27         3
# define LAN9118_SHIFT28         4
# define LAN9118_SHIFT29         5
# define LAN9118_SHIFT30         6
# define LAN9118_SHIFT31         7

#endif

#define LAN9118_BIT0            (0x01 << LAN9118_SHIFT0)
#define LAN9118_BIT1            (0x01 << LAN9118_SHIFT1)
#define LAN9118_BIT2            (0x01 << LAN9118_SHIFT2)
#define LAN9118_BIT3            (0x01 << LAN9118_SHIFT3)
#define LAN9118_BIT4            (0x01 << LAN9118_SHIFT4)
#define LAN9118_BIT5            (0x01 << LAN9118_SHIFT5)
#define LAN9118_BIT6            (0x01 << LAN9118_SHIFT6)
#define LAN9118_BIT7            (0x01 << LAN9118_SHIFT7)
#define LAN9118_BIT8            (0x01 << LAN9118_SHIFT8)
#define LAN9118_BIT9            (0x01 << LAN9118_SHIFT9)
#define LAN9118_BIT10           (0x01 << LAN9118_SHIFT10)
#define LAN9118_BIT11           (0x01 << LAN9118_SHIFT11)
#define LAN9118_BIT12           (0x01 << LAN9118_SHIFT12)
#define LAN9118_BIT13           (0x01 << LAN9118_SHIFT13)
#define LAN9118_BIT14           (0x01 << LAN9118_SHIFT14)
#define LAN9118_BIT15           (0x01 << LAN9118_SHIFT15)
#define LAN9118_BIT16           (0x01 << LAN9118_SHIFT16)
#define LAN9118_BIT17           (0x01 << LAN9118_SHIFT17)
#define LAN9118_BIT18           (0x01 << LAN9118_SHIFT18)
#define LAN9118_BIT19           (0x01 << LAN9118_SHIFT19)
#define LAN9118_BIT20           (0x01 << LAN9118_SHIFT20)
#define LAN9118_BIT21           (0x01 << LAN9118_SHIFT21)
#define LAN9118_BIT22           (0x01 << LAN9118_SHIFT22)
#define LAN9118_BIT23           (0x01 << LAN9118_SHIFT23)
#define LAN9118_BIT24           (0x01 << LAN9118_SHIFT24)
#define LAN9118_BIT25           (0x01 << LAN9118_SHIFT25)
#define LAN9118_BIT26           (0x01 << LAN9118_SHIFT26)
#define LAN9118_BIT27           (0x01 << LAN9118_SHIFT27)
#define LAN9118_BIT28           (0x01 << LAN9118_SHIFT28)
#define LAN9118_BIT29           (0x01 << LAN9118_SHIFT29)
#define LAN9118_BIT30           (0x01 << LAN9118_SHIFT30)
#define LAN9118_BIT31           (0x01 << LAN9118_SHIFT31)

// ----------------------------------------------------------------------------
// The H/W.

// TX/RX command and status formats
#define LAN9118_TX_COMMANDA_INTERRUPT                   LAN9118_BIT31
#define LAN9118_TX_COMMANDA_END_ALIGNMENT_MASK          (0x03 << LAN9118_SHIFT24)
#define LAN9118_TX_COMMANDA_END_ALIGNMENT_SHIFT         (LAN9118_SHIFT24)
#define LAN9118_TX_COMMANDA_END_ALIGNMENT_4             (0x00 << LAN9118_SHIFT24)
#define LAN9118_TX_COMMANDA_END_ALIGNMENT_16            (0x01 << LAN9118_SHIFT24)
#define LAN9118_TX_COMMANDA_END_ALIGNMENT_32            (0x02 << LAN9118_SHIFT24)
#define LAN9118_TX_COMMANDA_DATA_START_OFFSET_MASK      (0x01F << LAN9118_SHIFT16)
#define LAN9118_TX_COMMANDA_DATA_START_OFFSET_SHIFT     (LAN9118_SHIFT16)
#define LAN9118_TX_COMMANDA_FIRST_SEGMENT               LAN9118_BIT13
#define LAN9118_TX_COMMANDA_LAST_SEGMENT                LAN9118_BIT12
#define LAN9118_TX_COMMANDB_ADD_CRC_DISABLE             LAN9118_BIT13
#define LAN9118_TX_COMMANDB_DISABLE_FRAME_PADDING       LAN9118_BIT12
#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_TX_COMMANDA_BUFFER_SIZE_MASK           (0x03FF << 0)
# define LAN9118_TX_COMMANDA_BUFFER_SIZE_SHIFT          (0)
# define LAN9118_TX_COMMANDB_PACKET_TAG_MASK            (0x0FFFF << 16)
# define LAN9118_TX_COMMANDB_PACKET_TAG_SHIFT           (16)
# define LAN9118_TX_COMMANDB_PACKET_LENGTH_MASK         (0x03FF << 0)
# define LAN9118_TX_COMMANDB_PACKET_LENGTH_SHIFT        (0)
#else
# define LAN9118_TX_COMMANDA_BUFFER_SIZE_MASK           (0xFF03 << 16)
# define LAN9118_TX_COMMANDA_BUFFER_SIZE_SHIFT          (16)
# define LAN9118_TX_COMMANDB_PACKET_TAG_MASK            (0x0FFFF << 0)
# define LAN9118_TX_COMMANDB_PACKET_TAG_SHIFT           (0)
# define LAN9118_TX_COMMANDB_PACKET_LENGTH_MASK         (0xFF03 << 16)
# define LAN9118_TX_COMMANDB_PACKET_LENGTH_SHIFT        (16)
#endif

#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_TX_STATUS_PACKET_TAG_MASK              (0x0FFFF << 16)
# define LAN9118_TX_STATUS_PACKET_TAG_SHIFT             (16)
#else
# define LAN9118_TX_STATUS_PACKET_TAG_MASK              (0x0FFFF << 0)
# define LAN9118_TX_STATUS_PACKET_TAG_SHIFT             (0)
#endif
#define LAN9118_TX_STATUS_ERROR                         LAN9118_BIT15
#define LAN9118_TX_STATUS_LOSS_OF_CARRIER               LAN9118_BIT11
#define LAN9118_TX_STATUS_NO_CARRIER                    LAN9118_BIT10
#define LAN9118_TX_STATUS_LATE_COLLISION                LAN9118_BIT9
#define LAN9118_TX_STATUS_EXCESSIVE_COLLISIONS          LAN9118_BIT8
#define LAN9118_TX_STATUS_COLLISION_COUNT_MASK          (0x0F << LAN9118_SHIFT3)
#define LAN9118_TX_STATUS_COLLISION_COUNT_SHIFT         (LAN9118_SHIFT3)
#define LAN9118_TX_STATUS_EXCESSIVE_DEFERRAL            LAN9118_BIT2
#define LAN9118_TX_STATUS_UNDERRUN                      LAN9118_BIT1
#define LAN9118_TX_STATUS_DEFERRED                      LAN9118_BIT0

#define LAN9118_RX_STATUS_FILTERING_FAIL                LAN9118_BIT30
#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_RX_STATUS_PACKET_LENGTH_MASK           (0x3FFF << 16)
# define LAN9118_RX_STATUS_PACKET_LENGTH_SHIFT          (16)
#else
# define LAN9118_RX_STATUS_PACKET_LENGTH_MASK           (0xFF3F << 0)
# define LAN9118_RX_STATUS_PACKET_LENGTH_SHIFT          (0)
#endif
#define LAN9118_RX_STATUS_ERROR                         LAN9118_BIT15
#define LAN9118_RX_STATUS_BROADCAST_FRAME               LAN9118_BIT13
#define LAN9118_RX_STATUS_LENGTH_ERROR                  LAN9118_BIT12
#define LAN9118_RX_STATUS_RUNT_FRAME                    LAN9118_BIT11
#define LAN9118_RX_STATUS_MULTICAST_FRAME               LAN9118_BIT10
#define LAN9118_RX_STATUS_FRAME_TOO_LONG                LAN9118_BIT7
#define LAN9118_RX_STATUS_COLLISION_SEEN                LAN9118_BIT6
#define LAN9118_RX_STATUS_FRAME_TYPE                    LAN9118_BIT5
#define LAN9118_RX_STATUS_RECEIVE_WATCHDOG_TIMEOUT      LAN9118_BIT4
#define LAN9118_RX_STATUS_MII_ERROR                     LAN9118_BIT3
#define LAN9118_RX_STATUS_DRIBBLING_BIT                 LAN9118_BIT2
#define LAN9118_RX_STATUS_CRC                           LAN9118_BIT1

// The core registers
#define LAN9118_RX_DATA_FIFO                            0x0000
#define LAN9118_TX_DATA_FIFO                            0x0020
#define LAN9118_RX_STATUS_FIFO                          0x0040
#define LAN9118_RX_STATUS_FIFO_PEEK                     0x0044
#define LAN9118_TX_STATUS_FIFO                          0x0048
#define LAN9118_TX_STATUS_FIFO_PEEK                     0x004C
#define LAN9118_ID_REV                                  0x0050
#define LAN9118_IRQ_CFG                                 0x0054
#define LAN9118_INT_STS                                 0x0058
#define LAN9118_INT_EN                                  0x005C
#define LAN9118_BYTE_TEST                               0x0064
#define LAN9118_FIFO_INT                                0x0068
#define LAN9118_RX_CFG                                  0x006C
#define LAN9118_TX_CFG                                  0x0070
#define LAN9118_HW_CFG                                  0x0074
#define LAN9118_RX_DP_CTL                               0x0078
#define LAN9118_RX_FIFO_INF                             0x007C
#define LAN9118_TX_FIFO_INF                             0x0080
#define LAN9118_PMT_CTRL                                0x0084
#define LAN9118_GPIO_CFG                                0x0088
#define LAN9118_GPT_CFG                                 0x008C
#define LAN9118_GPT_CNT                                 0x0090
#define LAN9118_ENDIAN                                  0x0098
#define LAN9118_FREE_RUN                                0x009C
#define LAN9118_RX_DROP                                 0x00A0
#define LAN9118_MAC_CSR_CMD                             0x00A4
#define LAN9118_MAC_CSR_DATA                            0x00A8
#define LAN9118_AFC_CFG                                 0x00AC
#define LAN9118_E2P_CMD                                 0x00B0
#define LAN9118_E2P_DATA                                0x00B4

#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_ID_REV_CHIP_ID_MASK                    (0x00FFFF << 16)
# define LAN9118_ID_REV_CHIP_ID_SHIFT                   (16)
# define LAN9118_ID_REV_CHIP_REVISION_MASK              (0x00FFFF << 0)
# define LAN9118_ID_REV_CHIP_REVISION_SHIFT             (0)
#else
# define LAN9118_ID_REV_CHIP_ID_MASK                    (0x00FFFF << 0)
# define LAN9118_ID_REV_CHIP_ID_SHIFT                   (0)
# define LAN9118_ID_REV_CHIP_REVISION_MASK              (0x00FFFF << 16)
# define LAN9118_ID_REV_CHIP_REVISION_SHIFT             (16)
#endif

#define LAN9118_IRQ_CFG_INT_DEAS_MASK                   (0x00FF << LAN9118_SHIFT24)
#define LAN9118_IRQ_CFG_INT_DEAS_SHIFT                  (LAN9118_SHIFT24)
#define LAN9118_IRQ_CFG_INT_DEAS_CLR                    LAN9118_BIT14)
#define LAN9118_IRQ_CFG_INT_DEAS_STS                    LAN9118_BIT13
#define LAN9118_IRQ_CFG_IRQ_INT                         LAN9118_BIT12
#define LAN9118_IRQ_CFG_IRQ_EN                          LAN9118_BIT8
#define LAN9118_IRQ_CFG_IRQ_POL                         LAN9118_BIT4
#define LAN9118_IRQ_CFG_IRQ_TYPE                        LAN9118_BIT0

#define LAN9118_INT_STS_SW                              LAN9118_BIT31
#define LAN9118_INT_STS_TXSTOP                          LAN9118_BIT25
#define LAN9118_INT_STS_RXSTOP                          LAN9118_BIT24
#define LAN9118_INT_STS_RXDFH                           LAN9118_BIT23
#define LAN9118_INT_STS_TX_IOC                          LAN9118_BIT21
#define LAN9118_INT_STS_RXD                             LAN9118_BIT20
#define LAN9118_INT_STS_GPT                             LAN9118_BIT19
#define LAN9118_INT_STS_PHY                             LAN9118_BIT18
#define LAN9118_INT_STS_PME                             LAN9118_BIT17
#define LAN9118_INT_STS_TXSO                            LAN9118_BIT16
#define LAN9118_INT_STS_RWT                             LAN9118_BIT15
#define LAN9118_INT_STS_RXE                             LAN9118_BIT14
#define LAN9118_INT_STS_TXE                             LAN9118_BIT13
#define LAN9118_INT_STS_TDFU                            LAN9118_BIT11
#define LAN9118_INT_STS_TDFO                            LAN9118_BIT10
#define LAN9118_INT_STS_TDFA                            LAN9118_BIT9
#define LAN9118_INT_STS_TSFF                            LAN9118_BIT8
#define LAN9118_INT_STS_TSFL                            LAN9118_BIT7
#define LAN9118_INT_STS_RXDF                            LAN9118_BIT6
#define LAN9118_INT_STS_RDFL                            LAN9118_BIT5
#define LAN9118_INT_STS_RSFF                            LAN9118_BIT4
#define LAN9118_INT_STS_RSFL                            LAN9118_BIT3
#define LAN9118_INT_STS_GPIO2                           LAN9118_BIT2
#define LAN9118_INT_STS_GPIO1                           LAN9118_BIT1
#define LAN9118_INT_STS_GPIO0                           LAN9118_BIT0

#define LAN9118_INT_EN_SW                               LAN9118_BIT31
#define LAN9118_INT_EN_TXSTOP                           LAN9118_BIT25
#define LAN9118_INT_EN_RXSTOP                           LAN9118_BIT24
#define LAN9118_INT_EN_RXDFH                            LAN9118_BIT23
#define LAN9118_INT_EN_TX_IOC                           LAN9118_BIT21
#define LAN9118_INT_EN_TIOC                             LAN9118_BIT21
#define LAN9118_INT_EN_RXD                              LAN9118_BIT20
#define LAN9118_INT_EN_GPT                              LAN9118_BIT19
#define LAN9118_INT_EN_PHY                              LAN9118_BIT18
#define LAN9118_INT_EN_PMT                              LAN9118_BIT17
#define LAN9118_INT_EN_TXSO                             LAN9118_BIT16
#define LAN9118_INT_EN_RWT                              LAN9118_BIT15
#define LAN9118_INT_EN_RXE                              LAN9118_BIT14
#define LAN9118_INT_EN_TXE                              LAN9118_BIT13
#define LAN9118_INT_EN_TDFU                             LAN9118_BIT11
#define LAN9118_INT_EN_TDFO                             LAN9118_BIT10
#define LAN9118_INT_EN_TDFA                             LAN9118_BIT9
#define LAN9118_INT_EN_TSFF                             LAN9118_BIT8
#define LAN9118_INT_EN_TSFL                             LAN9118_BIT7
#define LAN9118_INT_EN_RXDF                             LAN9118_BIT6
#define LAN9118_INT_EN_RDFL                             LAN9118_BIT5
#define LAN9118_INT_EN_RSFF                             LAN9118_BIT4
#define LAN9118_INT_EN_RSFL                             LAN9118_BIT3
#define LAN9118_INT_EN_GPIO2                            LAN9118_BIT2
#define LAN9118_INT_EN_GPIO1                            LAN9118_BIT1
#define LAN9118_INT_EN_GPIO0                            LAN9118_BIT0

#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_BYTE_TEST_MAGIC                        0x87654321
#else
# define LAN9118_BYTE_TEST_MAGIC                        0x21436587
#endif

#define LAN9118_FIFO_INT_TX_AVAIL_MASK                  (0x00FF << LAN9118_SHIFT24)
#define LAN9118_FIFO_INT_TX_AVAIL_SHIFT                 (LAN9118_SHIFT24)
#define LAN9118_FIFO_INT_TX_STATUS_MASK                 (0x00FF << LAN9118_SHIFT16)
#define LAN9118_FIFO_INT_TX_STATUS_SHIFT                (LAN9118_SHIFT16)
#define LAN9118_FIFO_INT_RX_AVAIL_MASK                  (0x00FF << LAN9118_SHIFT8)
#define LAN9118_FIFO_INT_RX_AVAIL_SHIFT                 (LAN9118_SHIFT8)
#define LAN9118_FIFO_INT_RX_STATUS_MASK                 (0x00FF << LAN9118_SHIFT0)
#define LAN9118_FIFO_INT_RX_STATUS_SHIFT                (LAN9118_SHIFT0)

#define LAN9118_RX_CFG_RX_END_MASK                      (0x03 << LAN9118_SHIFT30)
#define LAN9118_RX_CFG_RX_END_SHIFT                     (LAN9118_SHIFT30)
#define LAN9118_RX_CFG_RX_END_4                         (0x00 << LAN9118_SHIFT30)
#define LAN9118_RX_CFG_RX_END_16                        (0x01 << LAN9118_SHIFT30)
#define LAN9118_RX_CFG_RX_END_32                        (0x02 << LAN9118_SHIFT30)
#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_RX_CFG_RX_DMA_CNT_MASK                 (0x0FFF << 16)
# define LAN9118_RX_CFG_RX_DMA_CNT_SHIFT                (16)
#else
# define LAN9118_RX_CFG_RX_DMA_CNT_MASK                 (0xFF0F << 0)
# define LAN9118_RX_CFG_RX_DMA_CNT_SHIFT                (0)
#endif
#define LAN9118_RX_CFG_RX_DUMP                          LAN9118_BIT15
#define LAN9118_RX_CFG_RXDOFF_MASK                      (0x1F << LAN9118_SHIFT8)
#define LAN9118_RX_CFG_RXDOFF_SHIFT                     (LAN9118_SHIFT8)

#define LAN9118_TX_CFG_TXS_DUMP                         LAN9118_BIT15
#define LAN9118_TX_CFG_TXD_DUMP                         LAN9118_BIT14
#define LAN9118_TX_CFG_TXSAO                            LAN9118_BIT2
#define LAN9118_TX_CFG_TX_ON                            LAN9118_BIT1
#define LAN9118_TX_CFG_STOP_TX                          LAN9118_BIT0

#define LAN9118_HW_CFG_TTM                              LAN9118_BIT21
#define LAN9118_HW_CFG_SF                               LAN9118_BIT20
#define LAN9118_HW_CFG_TX_FIF_SZ_MASK                   (0x0F << LAN9118_SHIFT16)
#define LAN9118_HW_CFG_TX_FIF_SZ_SHIFT                  (LAN9118_SHIFT16)
#define LAN9118_HW_CFG_TR_MASK                          (0x03 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_SHIFT                         (LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_10_012                        (0x00 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_10_018                        (0x01 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_10_020                        (0x02 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_10_028                        (0x03 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_100_020                       (0x00 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_100_040                       (0x01 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_100_080                       (0x02 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_TR_100_100                       (0x03 << LAN9118_SHIFT12)
#define LAN9118_HW_CFG_32_16                            LAN9118_BIT2
#define LAN9118_HW_CFG_SRST_TO                          LAN9118_BIT1
#define LAN9118_HW_CFG_SRST                             LAN9118_BIT0

#define LAN9118_RX_DP_CTRL_RX_FFWD                      LAN9118_BIT31
#define LAN9118_RX_FIFO_INF_RXSUSED_MASK                (0x0FF << LAN9118_SHIFT16)
#define LAN9118_RX_FIFO_INF_RXSUSED_SHIFT               (LAN9118_SHIFT16)
#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_RX_FIFO_INF_RXDUSED_MASK               (0x0FFFF << 0)
# define LAN9118_RX_FIFO_INF_RXDUSED_SHIFT              (0)
#else
# define LAN9118_RX_FIFO_INF_RXDUSED_MASK               (0x0FFFF << 16)
# define LAN9118_RX_FIFO_INF_RXDUSED_SHIFT              (16)
#endif

#define LAN9118_TX_FIFO_INF_TXSUSED_MASK                (0x0FF << LAN9118_SHIFT16)
#define LAN9118_TX_FIFO_INF_TXSUSED_SHIFT               (LAN9118_SHIFT16)
#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_TX_FIFO_INF_TDFREE_MASK                (0x0FFFF << 0)
# define LAN9118_TX_FIFO_INF_TDFREE_SHIFT               (0)
#else
# define LAN9118_TX_FIFO_INF_TDFREE_MASK                (0x0FFFF << 16)
# define LAN9118_TX_FIFO_INF_TDFREE_SHIFT               (16)
#endif

#define LAN9118_PMT_CTRL_PM_MODE_MASK                   (0x03 << LAN9118_SHIFT12)
#define LAN9118_PMT_CTRL_PM_MODE_SHIFT                  (LAN9118_SHIFT12)
#define LAN9118_PMT_CTRL_PM_MODE_NORMAL                 (0x00 << LAN9118_SHIFT12)
#define LAN9118_PMT_CTRL_PM_MODE_D0                     (0x00 << LAN9118_SHIFT12)
#define LAN9118_PMT_CTRL_PM_MODE_WAKE_ON_LAN            (0x01 << LAN9118_SHIFT12)
#define LAN9118_PMT_CTRL_PM_MODE_D1                     (0x01 << LAN9118_SHIFT12)
#define LAN9118_PMT_CTRL_PM_MODE_PHY_ENERGY_DETECT      (0x02 << LAN9118_SHIFT12)
#define LAN9118_PMT_CTRL_PM_MODE_D2                     (0x02 << LAN9118_SHIFT12)
#define LAN9118_PMT_CTRL_PHY_RST                        LAN9118_BIT10
#define LAN9118_PMT_CTRL_WOL_EN                         LAN9118_BIT9
#define LAN9118_PMT_CTRL_ED_EN                          LAN9118_BIT8
#define LAN9118_PMT_CTRL_PME_TYPE                       LAN9118_BIT6
#define LAN9118_PMT_CTRL_WUPS_MASK                      (0x03 << LAN9118_SHIFT4)
#define LAN9118_PMT_CTRL_WUPS_SHIFT                     (LAN9118_SHIFT4)
#define LAN9118_PMT_CTRL_WUPS_NO_WAKEUP                 (0x00 << LAN9118_SHIFT4)
#define LAN9118_PMT_CTRL_WUPS_ENERGY_DETECT             (0x01 << LAN9118_SHIFT4)
#define LAN9118_PMT_CTRL_WUPS_WAKE_ON_LAN               (0x02 << LAN9118_SHIFT4)
#define LAN9118_PMT_CTRL_WUPS_MULTIPLE                  (0x03 << LAN9118_SHIFT4)
#define LAN9118_PMT_CTRL_PME_IND                        LAN9118_BIT3
#define LAN9118_PMT_CTRL_PME_POL                        LAN9118_BIT2
#define LAN9118_PMT_CTRL_PME_EN                         LAN9118_BIT1
#define LAN9118_PMT_CTRL_READY                          LAN9118_BIT0

#define LAN9118_GPIO_CFG_LED3_EN                        LAN9118_BIT30
#define LAN9118_GPIO_CFG_LED2_EN                        LAN9118_BIT29
#define LAN9118_GPIO_CFG_LED1_EN                        LAN9118_BIT28
#define LAN9118_GPIO_CFG_GPIO2_INT_POL                  LAN9118_BIT26
#define LAN9118_GPIO_CFG_GPIO1_INT_POL                  LAN9118_BIT25
#define LAN9118_GPIO_CFG_GPIO0_INT_POL                  LAN9118_BIT24
#define LAN9118_GPIO_CFG_EEPR_EN_MASK                   (0x07 << LAN9118_SHIFT20)
#define LAN9118_GPIO_CFG_EEPR_EN_SHIFT                  (LAN9118_SHIFT29)
#define LAN9118_GPIO_CFG_EEPR_EN_EEDIO_EECLK            (0x00 << LAN9118_SHIFT20)
#define LAN9118_GPIO_CFG_EEPR_EN_GPO3_GPO4              (0x01 << LAN9118_SHIFT20)
#define LAN9118_GPIO_CFG_EEPR_EN_GPO3_RX_DV             (0x03 << LAN9118_SHIFT20)
#define LAN9118_GPIO_CFG_EEPR_EN_TX_EN_GPO4             (0x05 << LAN9118_SHIFT20)
#define LAN9118_GPIO_CFG_EEPR_EN_TX_EN_RX_DV            (0x06 << LAN9118_SHIFT20)
#define LAN9118_GPIO_CFG_EEPR_EN_TX_CLK_RX_CLK          (0x07 << LAN9118_SHIFT20)
#define LAN9118_GPIO_CFG_GPIOBUF2                       LAN9118_BIT18
#define LAN9118_GPIO_CFG_GPIOBUF1                       LAN9118_BIT17
#define LAN9118_GPIO_CFG_GPIOBUF0                       LAN9118_BIT16
#define LAN9118_GPIO_CFG_GPDIR2                         LAN9118_BIT10
#define LAN9118_GPIO_CFG_GPDIR1                         LAN9118_BIT9
#define LAN9118_GPIO_CFG_GPDIR0                         LAN9118_BIT8
#define LAN9118_GPIO_CFG_GPOD4                          LAN9118_BIT4
#define LAN9118_GPIO_CFG_GPOD3                          LAN9118_BIT3
#define LAN9118_GPIO_CFG_GPIOD2                         LAN9118_BIT2
#define LAN9118_GPIO_CFG_GPIOD1                         LAN9118_BIT1
#define LAN9118_GPIO_CFG_GPIOD0                         LAN9118_BIT0

#define LAN9118_GPT_CFG_TIMER_EN                        LAN9118_BIT29
#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_GPT_CFG_GPT_LOAD_MASK                  (0x0FFFF << 0)
# define LAN9118_GPT_CFG_GPT_LOAD_SHIFT                 (0)
#else
# define LAN9118_GPT_CFG_GPT_LOAD_MASK                  (0x0FFFF << 16
# define LAN9118_GPT_CFG_GPT_LOAD_SHIFT                 (16)
#endif

#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_GPT_CNT_GPT_CNT_MASK                   (0x0FFFF << 0)
# define LAN9118_GPT_CNT_GPT_CNT_SHFIT                  (0)
#else
# define LAN9118_GPT_CNT_GPT_CNT_MASK                   (0x0FFFF << 16)
# define LAN9118_GPT_CNT_GPT_CNT_SHFIT                  (16)
#endif

#define LAN9118_ENDIAN_BIG_MAGIC                        0x0FFFFFFFF
#define LAN9118_ENDIAN_LITTLE_MAGIC                     0x0

#define LAN9118_MAC_CSR_CMD_CSR_BUSY                    LAN9118_BIT31
#define LAN9118_MAC_CSR_CMD_RnW                         LAN9118_BIT30
#define LAN9118_MAC_CSR_CMD_CSR_ADDRESS_MASK            (0x0FF << LAN9118_SHIFT0)
#define LAN9118_MAC_CSR_CMD_CSR_ADDRESS_SHIFT           (LAN9118_SHIFT0)

#define LAN9118_AFC_CFG_AFC_HI_MASK                     (0x0FF << LAN9118_SHIFT16)
#define LAN9118_AFC_CFG_AFC_HI_SHIFT                    (LAN9118_SHIFT16)
#define LAN9118_AFC_CFG_AFC_LO_MASK                     (0x0FF << LAN9118_SHIFT8)
#define LAN9118_AFC_CFG_AFC_LO_SHIFT                    (LAN9118_SHIFT8)
#define LAN9118_AFC_CFG_BACK_DUR_MASK                   (0x0F << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_SHIFT                  (LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_5                  (0x00 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_10                 (0x01 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_15                 (0x02 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_25                 (0x03 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_50                 (0x04 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_100                (0x05 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_150                (0x06 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_200                (0x07 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_250                (0x08 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_300                (0x09 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_350                (0x0A << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_400                (0x0B << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_450                (0x0C << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_500                (0x0D << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_550                (0x0E << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_100_600                (0x0F << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_7                   (0x00 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_12                  (0x01 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_17                  (0x02 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_27                  (0x03 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_52                  (0x04 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_102                 (0x05 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_152                 (0x06 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_202                 (0x07 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_252                 (0x08 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_302                 (0x09 << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_352                 (0x0A << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_402                 (0x0B << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_452                 (0x0C << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_502                 (0x0D << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_552                 (0x0E << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_BACK_DUR_10_602                 (0x0F << LAN9118_SHIFT4)
#define LAN9118_AFC_CFG_FCMULT                          LAN9118_BIT3
#define LAN9118_AFC_CFG_FCBRD                           LAN9118_BIT2
#define LAN9118_AFC_CFG_FCADD                           LAN9118_BIT1
#define LAN9118_AFC_CFG_FCANY                           LAN9118_BIT0

#define LAN9118_E2P_CMD_EPC_BUSY                        LAN9118_BIT31
#define LAN9118_E2P_CMD_EPC_COMMAND_MASK                (0x07 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_SHIFT               (LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_READ                (0x00 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_EWDS                (0x01 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_EWEN                (0x02 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_WRITE               (0x03 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_WRAL                (0x04 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_ERASE               (0x05 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_ERAL                (0x06 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_COMMAND_RELOAD              (0x07 << LAN9118_SHIFT28)
#define LAN9118_E2P_CMD_EPC_TIMEOUT                     LAN9118_BIT9
#define LAN9118_E2P_CMD_MAC_ADDRESS_LOADED              LAN9118_BIT8
#define LAN9118_E2P_CMD_E2P_ADDRESS_MASK                (0x0FF << LAN9118_SHIFT0)
#define LAN9118_E2P_CMD_E2P_ADDRESS_SHIFT               (LAN9118_SHIFT0)

#define LAN9118_E2P_DATA_MASK                           (0x0FF << LAN9118_SHIFT0)
#define LAN9118_E2P_DATA_SHIFT                          (LAN9118_SHIFT0)

// Now for the MAC registers
#define LAN9118_MAC_CR                                  0x01
#define LAN9118_MAC_ADDRH                               0x02
#define LAN9118_MAC_ADDRL                               0x03
#define LAN9118_MAC_HASHH                               0x04
#define LAN9118_MAC_HASHL                               0x05
#define LAN9118_MAC_MIIACC                              0x06
#define LAN9118_MAC_MIIDATA                             0x07
#define LAN9118_MAC_FLOW                                0x08
#define LAN9118_MAC_VLAN1                               0x09
#define LAN9118_MAC_VLAN2                               0x0A
#define LAN9118_MAC_WUFF                                0x0B
#define LAN9118_MAC_WUCSR                               0x0C

#define LAN9118_MAC_CR_RXALL                            LAN9118_BIT31
#define LAN9118_MAC_CR_RCVOWN                           LAN9118_BIT23
#define LAN9118_MAC_CR_LOOPBK                           LAN9118_BIT21
#define LAN9118_MAC_CR_FDPX                             LAN9118_BIT20
#define LAN9118_MAC_CR_MCPAS                            LAN9118_BIT19
#define LAN9118_MAC_CR_PRMS                             LAN9118_BIT18
#define LAN9118_MAC_CR_INVFILT                          LAN9118_BIT17
#define LAN9118_MAC_CR_PASSBAD                          LAN9118_BIT16
#define LAN9118_MAC_CR_HFILT                            LAN9118_BIT15
#define LAN9118_MAC_CR_HPFILT                           LAN9118_BIT13
#define LAN9118_MAC_CR_LCOLL                            LAN9118_BIT12
#define LAN9118_MAC_CR_BCAST                            LAN9118_BIT11
#define LAN9118_MAC_CR_DISRTY                           LAN9118_BIT10
#define LAN9118_MAC_CR_PADSTR                           LAN9118_BIT8
#define LAN9118_MAC_CR_BOLMT_MASK                       (0x03 << LAN9118_SHIFT6)
#define LAN9118_MAC_CR_BOLMT_SHIFT                      (LAN9118_SHIFT6)
#define LAN9118_MAC_CR_BOLMT_10                         (0x00 << LAN9118_SHIFT6)
#define LAN9118_MAC_CR_BOLMT_8                          (0x01 << LAN9118_SHIFT6)
#define LAN9118_MAC_CR_BOLMT_4                          (0x02 << LAN9118_SHIFT6)
#define LAN9118_MAC_CR_BOLMT_1                          (0x03 << LAN9118_SHIFT6)
#define LAN9118_MAC_CR_DFCHK                            LAN9118_BIT5
#define LAN9118_MAC_CR_TXEN                             LAN9118_BIT3
#define LAN9118_MAC_CR_RXEN                             LAN9118_BIT2

#define LAN9118_MAC_ADDRH_BYTE5_MASK                    (0x0FF << LAN9118_SHIFT8)
#define LAN9118_MAC_ADDRH_BYTE5_SHIFT                   (LAN9118_SHIFT8)
#define LAN9118_MAC_ADDRH_BYTE4_MASK                    (0x0FF << LAN9118_SHIFT0)
#define LAN9118_MAC_ADDRH_BYTE4_SHIFT                   (LAN9118_SHIFT0)
#define LAN9118_MAC_ADDRL_BYTE3_MASK                    (0x0FF << LAN9118_SHIFT24)
#define LAN9118_MAC_ADDRL_BYTE3_SHIFT                   (LAN9118_SHIFT24)
#define LAN9118_MAC_ADDRL_BYTE2_MASK                    (0x0FF << LAN9118_SHIFT16)
#define LAN9118_MAC_ADDRL_BYTE2_SHIFT                   (LAN9118_SHIFT16)
#define LAN9118_MAC_ADDRL_BYTE1_MASK                    (0x0FF << LAN9118_SHIFT8)
#define LAN9118_MAC_ADDRL_BYTE1_SHIFT                   (LAN9118_SHIFT8)
#define LAN9118_MAC_ADDRL_BYTE0_MASK                    (0x0FF << LAN9118_SHIFT0)
#define LAN9118_MAC_ADDRL_BYTE0_SHIFT                   (LAN9118_SHIFT0)

#define LAN9118_MAC_MIIACC_PHY_ADDRESS_MAGIC            LAN9118_BIT11
#define LAN9118_MAC_MIIACC_MIIRINDA_MASK                (0x1F << LAN9118_SHIFT6)
#define LAN9118_MAC_MIIACC_MIIRINDA_SHIFT               (LAN9118_SHIFT6)
#define LAN9118_MAC_MIIACC_MIIWnR                       LAN9118_BIT1
#define LAN9118_MAC_MIIACC_MIIBZY                       LAN9118_BIT0

#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_MAC_MII_DATA_MASK                      (0x0FFFF << 0)
# define LAN9118_MAC_MII_DATA_SHIFT                     (0)
#else
# define LAN9118_MAC_MII_DATA_MASK                      (0x0FFFF << 16)
# define LAN9118_MAC_MII_DATA_SHIFT                     (16)
#endif

#ifndef HAL_LAN9118_SWAP_COMMANDS
# define LAN9118_MAC_FLOW_FCPT_MASK                     (0x0FFFF << 16)
# define LAN9118_MAC_FLOW_FCPT_SHIFT                    (16)
#else
# define LAN9118_MAC_FLOW_FCPT_MASK                     (0x0FFFF << 0)
# define LAN9118_MAC_FLOW_FCPT_SHIFT                    (0)
#endif
#define LAN9118_MAC_FLOW_FCPASS                         LAN9118_BIT2
#define LAN9118_MAC_FLOW_FCEN                           LAN9118_BIT1
#define LAN9118_MAC_FLOW_FCBSY                          LAN9118_BIT0

#define LAN9118_MAC_WUCSR_GUE                           LAN9118_BIT9
#define LAN9118_MAC_WUCSR_WUFR                          LAN9118_BIT6
#define LAN9118_MAC_WUCSR_MPR                           LAN9118_BIT5
#define LAN9118_MAC_WUCSR_WUEN                          LAN9118_BIT2
#define LAN9118_MAC_WUCSR_MPEN                          LAN9118_BIT1

// And the PHY registers
#define LAN9118_PHY_BASIC_CTRL                          0x00
#define LAN9118_PHY_BASIC_STATUS                        0x01
#define LAN9118_PHY_ID1                                 0x02
#define LAN9118_PHY_ID2                                 0x03
#define LAN9118_PHY_AUTO_ADVERTISEMENT                  0x04
#define LAN9118_PHY_AUTO_LINK_PARTNER_ABILITY           0x05
#define LAN9118_PHY_AUTO_EXPANSION                      0x06
#define LAN9118_PHY_MODE_CONTROL_STATUS                 0x11
#define LAN9118_PHY_SPECIAL_MODES                       0x12
#define LAN9118_PHY_SPECIAL_CONTROL_STATUS_INDICATIONS  0x1B
#define LAN9118_PHY_INTERRUPT_SOURCE                    0x1D
#define LAN9118_PHY_INTERRUPT_MASK                      0x1E
#define LAN9118_PHY_SPECIAL_CONTROL_STATUS              0x1F

// Don't swap the phy registers. They are only 16 bits, not 32 bits,
// and accessed only via 2 utilities
#define LAN9118_PHY_BASIC_CTRL_RESET                                    (0x01 << 15)
#define LAN9118_PHY_BASIC_CTRL_LOOPBACK                                 (0x01 << 14)
#define LAN9118_PHY_BASIC_CTRL_SPEED_SELECT                             (0x01 << 13)
#define LAN9118_PHY_BASIC_CTRL_SPEED_SELECT_100                         (0x01 << 13)
#define LAN9118_PHY_BASIC_CTRL_SPEED_SELECT_10                          (0x00 << 13)
#define LAN9118_PHY_BASIC_CTRL_AUTO_ENABLE                              (0x01 << 12)
#define LAN9118_PHY_BASIC_CTRL_POWER_DOWN                               (0x01 << 11)
#define LAN9118_PHY_BASIC_CTRL_RESTART_AUTO                             (0x01 << 9)
#define LAN9118_PHY_BASIC_CTRL_DUPLEX                                   (0x01 << 8)
#define LAN9118_PHY_BASIC_CTRL_DUPLEX_FULL                              (0x01 << 8)
#define LAN9118_PHY_BASIC_CTRL_DUPLEX_HALF                              (0x00 << 8)
#define LAN9118_PHY_BASIC_CTRL_COLLISION_TEST                           (0x01 << 7)

#define LAN9118_PHY_BASIC_STATUS_100BASET4                              (0x01 << 15)
#define LAN9118_PHY_BASIC_STATUS_100BASE_TX_FULL_DUPLEX                 (0x01 << 14)
#define LAN9118_PHY_BASIC_STATUS_100BASE_TX_HALF_DUPLEX                 (0x01 << 13)
#define LAN9118_PHY_BASIC_STATUS_10BASET_FULL_DUPLEX                    (0x01 << 12)
#define LAN9118_PHY_BASIC_STATUS_10BASET_HALF_DUPLEX                    (0x01 << 11)
#define LAN9118_PHY_BASIC_STATUS_AUTO_COMPLETE                          (0x01 << 5)
#define LAN9118_PHY_BASIC_STATUS_REMOTE_FAULT                           (0x01 << 4)
#define LAN9118_PHY_BASIC_STATUS_AUTO_ABILITY                           (0x01 << 3)
#define LAN9118_PHY_BASIC_STATUS_LINK_STATUS                            (0x01 << 2)
#define LAN9118_PHY_BASIC_STATUS_JABBER_DETECT                          (0x01 << 1)
#define LAN9118_PHY_BASIC_STATUS_EXTENDED_CAPABILITIES                  (0x01 << 0)

#define LAN9118_PHY_AUTO_ADVERTISEMENT_NEXT_PAGE                        (0x01 << 15)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_REMOTE_FAULT                     (0x01 << 13)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_PAUSE_OPERATION_MASK             (0x03 << 10)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_PAUSE_OPERATION_SHIFT            (10)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_PAUSE_OPERATION_NONE             (0x00 << 10)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_PAUSE_OPERATION_SYMMETRIC        (0x01 << 10)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_PAUSE_OPERATION_ASYMMETRIC       (0x02 << 10)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_PAUSE_OPERATION_BOTH             (0x03 << 10)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_100BASET4                        (0x01 << 9)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_100BASE_TX_FULL_DUPLEX           (0x01 << 8)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_100BASE_TX                       (0x01 << 7)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_10BASET_FULL_DUPLEX              (0x01 << 6)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_10BASET                          (0x01 << 5)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_SELECTOR_MASK                    (0x1F << 0)
#define LAN9118_PHY_AUTO_ADVERTISEMENT_SELECTOR_SHIFT                   (0)

#define LAN9118_PHY_AUTO_LINK_PARTNER_NEXT_PAGE                         (0x01 << 15)
#define LAN9118_PHY_AUTO_LINK_PARTNER_ACKNOWLEDGE                       (0x01 << 14)
#define LAN9118_PHY_AUTO_LINK_PARTNER_REMOTE_FAULT                      (0x01 << 13)
#define LAN9118_PHY_AUTO_LINK_PARTNER_PAUSE_OPERATION_MASK              (0x03 << 10)
#define LAN9118_PHY_AUTO_LINK_PARTNER_PAUSE_OPERATION_SHIFT             (10)
#define LAN9118_PHY_AUTO_LINK_PARTNER_PAUSE_OPERATION_NONE              (0x00 << 10)
#define LAN9118_PHY_AUTO_LINK_PARTNER_PAUSE_OPERATION_SYMMETRIC         (0x01 << 10)
#define LAN9118_PHY_AUTO_LINK_PARTNER_PAUSE_OPERATION_ASYMMETRIC        (0x02 << 10)
#define LAN9118_PHY_AUTO_LINK_PARTNER_PAUSE_OPERATION_BOTH              (0x03 << 10)
#define LAN9118_PHY_AUTO_LINK_PARTNER_100BASET4                         (0x01 << 9)
#define LAN9118_PHY_AUTO_LINK_PARTNER_100BASE_TX_FULL_DUPLEX            (0x01 << 8)
#define LAN9118_PHY_AUTO_LINK_PARTNER_100BASE_TX                        (0x01 << 7)
#define LAN9118_PHY_AUTO_LINK_PARTNER_10BASET_FULL_DUPLEX               (0x01 << 6)
#define LAN9118_PHY_AUTO_LINK_PARTNER_10BASET                           (0x01 << 5)
#define LAN9118_PHY_AUTO_LINK_PARTNER_SELECTOR_MASK                     (0x1F << 0)
#define LAN9118_PHY_AUTO_LINK_PARTNER_SELECTOR_SHIFT                    (0)

#define LAN9118_PHY_AUTO_EXPANSION_PARALLEL_DETECTION_FAULT             (0x01 << 4)
#define LAN9118_PHY_AUTO_EXPANSION_LINK_PARTNER_NEXT_PAGE_ABLE          (0x01 << 3)
#define LAN9118_PHY_AUTO_EXPANSION_NEXT_PAGE_ABLE                       (0x01 << 2)
#define LAN9118_PHY_AUTO_EXPANSION_PAGE_RECEIVED                        (0x01 << 1)
#define LAN9118_PHY_AUTO_EXPANSION_LINK_PARTNER_AUTO_NEGOTIATION_ABLE   (0x01 << 0)

#define LAN9118_PHY_MODE_CONTROL_STATUS_EDPWRDOWN                       (0x01 << 13)
#define LAN9118_PHY_MODE_CONTROL_STATUS_ENERGY_ON                       (0x01 << 1)

#define LAN9118_PHY_SPECIAL_MODES_MODE_MASK                             (0x03 << 5)
#define LAN9118_PHY_SPECIAL_MODES_MODE_SHIFT                            (5)
#define LAN9118_PHY_SPECIAL_MODES_MODE_10BASET_HALF_NO_AUTO             (0x00 << 5)
#define LAN9118_PHY_SPECIAL_MODES_MODE_10BASET_FULL_NO_AUTO             (0x01 << 5)
#define LAN9118_PHY_SPECIAL_MODES_MODE_100BASET_HALF_NO_AUTO            (0x02 << 5)
#define LAN9118_PHY_SPECIAL_MODES_MODE_100BASET_FULL_NO_AUTO            (0x03 << 5)
#define LAN9118_PHY_SPECIAL_MODES_MODE_100BASET_HALF_AUTO               (0x04 << 5)
#define LAN9118_PHY_SPECIAL_MODES_MODE_REPEATER                         (0x05 << 5)
#define LAN9118_PHY_SPECIAL_MODES_MODE_ALL_AUTO                         (0x07 << 5)
#define LAN9118_PHY_SPECIAL_MODES_PHY_ADDRESS_MASK                      (0x1F << 0)
#define LAN9118_PHY_SPECIAL_MODES_PHY_ADDRESS_SHIFT                     (0)

#define LAN9118_PHY_CONTROL_STATUS_INDICATION_VCOOFF_LP                 (0x01 << 10)
#define LAN9118_PHY_CONTROL_STATUS_INDICATION_XPOL                      (0x01 << 4)
#define LAN9118_PHY_CONTROL_STATUS_INDICATION_XPOL_NORMAL               (0x01 << 4)
#define LAN9118_PHY_CONTROL_STATUS_INDICATION_XPOL_REVERSED             (0x01 << 4)

#define LAN9118_PHY_INTERRUPT_SOURCE_ENERGY_ON                          (0x01 << 7)
#define LAN9118_PHY_INTERRUPT_SOURCE_AUTO_COMPLETE                      (0x01 << 6)
#define LAN9118_PHY_INTERRUPT_SOURCE_REMOTE_FAULT                       (0x01 << 5)
#define LAN9118_PHY_INTERRUPT_SOURCE_LINK_DOWN                          (0x01 << 4)
#define LAN9118_PHY_INTERRUPT_SOURCE_AUTO_LP_ACKNOWLEDGE                (0x01 << 3)
#define LAN9118_PHY_INTERRUPT_SOURCE_PARALLEL_DETECTION_FAULT           (0x01 << 2)
#define LAN9118_PHY_INTERRUPT_SOURCE_AUTO_PAGE_RECEIVED                 (0x01 << 1)

#define LAN9118_PHY_INTERRUPT_MASK_ENERGY_ON                            (0x01 << 7)
#define LAN9118_PHY_INTERRUPT_MASK_AUTO_COMPLETE                        (0x01 << 6)
#define LAN9118_PHY_INTERRUPT_MASK_REMOTE_FAULT                         (0x01 << 5)
#define LAN9118_PHY_INTERRUPT_MASK_LINK_DOWN                            (0x01 << 4)
#define LAN9118_PHY_INTERRUPT_MASK_AUTO_LP_ACKNOWLEDGE                  (0x01 << 3)
#define LAN9118_PHY_INTERRUPT_MASK_PARALLEL_DETECTION_FAULT             (0x01 << 2)
#define LAN9118_PHY_INTERRUPT_MASK_AUTO_PAGE_RECEIVED                   (0x01 << 1)

#define LAN9118_PHY_SPECIAL_CONTROL_STATUS_AUTODONE                     (0x01 << 12)
#define LAN9118_PHY_SPECIAL_CONTROL_STATUS_SPEED_MASK                   (0x07 << 2)
#define LAN9118_PHY_SPECIAL_CONTROL_STATUS_SPEED_SHIFT                  (2)
#define LAN9118_PHY_SPECIAL_CONTROL_STATUS_SPEED_10_HALF                (0x01 << 2)
#define LAN9118_PHY_SPECIAL_CONTROL_STATUS_SPEED_10_FULL                (0x05 << 2)
#define LAN9118_PHY_SPECIAL_CONTROL_STATUS_SPEED_100_HALF               (0x02 << 2)
#define LAN9118_PHY_SPECIAL_CONTROL_STATUS_SPEED_100_FULL               (0x06 << 2)

// ----------------------------------------------------------------------------
// Per-device details.
typedef struct lan9118_instance {
    // base and isrvec are needed only if there are multiple lan9118
    // devices. Otherwise they are fixed at compile-time.
#if (CYGNUM_DEVS_ETH_SMSC_LAN9118_COUNT > 1)
    CYG_ADDRESS     lan9118_base;
    cyg_ucount32    lan9118_isrvec;
    cyg_ucount32    lan9118_isrpri;
#endif

    // This field should be provided by the platform instantiation
    cyg_uint32      lan9118_hw_flags;
    
    // The MAC address. If there is an EEPROM then the generic driver
    // code will fill it in. Otherwise the platform HAL should supply
    // the address, e.g. via an fconfig option.
    cyg_uint8       lan9118_mac[6];
    
    // These fields are used by the generic driver.
    // Interrupt support.
    cyg_handle_t    lan9118_isr_handle;
    cyg_interrupt   lan9118_isr_data;

    // Has there been a call to start()
    cyg_bool        lan9118_up;
    // Prevent excessive recursive calls to send()
    cyg_uint32      lan9118_in_send_count;
    
    // Statistics
#ifdef CYGFUN_DEVS_ETH_SMSC_LAN9118_STATISTICS
    cyg_uint32      lan9118_interrupts;
    cyg_uint32      lan9118_tx_count;
    cyg_uint32      lan9118_tx_good;
    cyg_uint32      lan9118_tx_max_collisions;
    cyg_uint32      lan9118_tx_late_collisions;
    cyg_uint32      lan9118_tx_underrun;
    cyg_uint32      lan9118_tx_carrier_loss;
    cyg_uint32      lan9118_tx_deferred;
    cyg_uint32      lan9118_tx_single_collisions;
    cyg_uint32      lan9118_tx_mult_collisions;
    cyg_uint32      lan9118_tx_total_collisions;
    
    cyg_uint32      lan9118_rx_count;
    cyg_uint32      lan9118_rx_good;
    cyg_uint32      lan9118_rx_crc_errors;
    cyg_uint32      lan9118_rx_align_errors;
    cyg_uint32      lan9118_rx_overrun_errors;
    cyg_uint32      lan9118_rx_collisions;
    cyg_uint32      lan9118_rx_short_frames;
    cyg_uint32      lan9118_rx_too_long_frames;
#endif
} lan9118_instance;

// ----------------------------------------------------------------------------
// Exported functions. First, ones that may be used by platform init code
// as well as by the driver itself.
externC void        cyg_lan9118_write_reg(lan9118_instance*, cyg_uint32 /* reg */, cyg_uint32 /* val */);
externC cyg_uint32  cyg_lan9118_read_reg(lan9118_instance*, cyg_uint32 /* reg */);
externC void        cyg_lan9118_write_mac_reg(lan9118_instance*, cyg_uint32 /* reg */, cyg_uint32 /* val */);
externC cyg_uint32  cyg_lan9118_read_mac_reg(lan9118_instance*, cyg_uint32 /* reg */);
externC void        cyg_lan9118_write_phy_reg(lan9118_instance*, cyg_uint32 /* reg */, cyg_uint32 /* val */);
externC cyg_uint32  cyg_lan9118_read_phy_reg(lan9118_instance*, cyg_uint32 /* reg */);

// The main table of functions.
extern struct eth_hwr_funs  cyg_lan9118_eth_funs;

// And a generic init function, to be called by the per-platform init function
externC bool        cyg_lan9118_eth_init(struct cyg_netdevtab_entry*);

// ----------------------------------------------------------------------------
// Device instantiation. The ETH_DRV_SC cannot be used here because it
// insists on the functions being declared static, which is not going to
// work if the driver and instantiation are in separate packages.
//
// The driver needs to know a couple of things about how the chip is
// wired up. These end up in the lan9118_flags field.

#define LAN9118_HW_FLAGS_16BIT_BE               (0x01 << 0)
#define LAN9118_HW_FLAGS_IRQ_POL_ACTIVE_HIGH    (0x01 << 1)
#define LAN9118_HW_FLAGS_IRQ_PUSH_PULL          (0x01 << 2)
#define LAN9118_HW_FLAGS_HAS_LED1               (0x01 << 3)
#define LAN9118_HW_FLAGS_HAS_LED2               (0x01 << 4)
#define LAN9118_HW_FLAGS_HAS_LED3               (0x01 << 5)
// NOTE: EEPROM settings should be added here

#define LAN9118_SC_NAME(_base_, _num_)         _base_ ## _eth_sc      ## _num_
#define LAN9118_NETDEVTAB_NAME(_base_, _num_)  _base_ ## _eth_netdev  ## _num_
#define LAN9118_INSTANCE_NAME(_base_, _num_)   _base_ ## _eth_lan9118 ## _num_

#define LAN9118_INSTANCE(_base_, _num_, _name_, _init_fn_)                      \
    static  lan9118_instance LAN9118_INSTANCE_NAME(_base_, _num_) ;             \
    static struct eth_drv_sc LAN9118_SC_NAME(_base_, _num_) = {                 \
        &cyg_lan9118_eth_funs,                                                  \
        (void*) & LAN9118_INSTANCE_NAME(_base_, _num_),                         \
        _name_                                                                  \
    };                                                                          \
    NETDEVTAB_ENTRY( LAN9118_NETDEVTAB_NAME(_base_, _num_),                     \
                    "lan9118-" _name_,                                          \
                    _init_fn_,                                                  \
                     & LAN9118_SC_NAME(_base_, _num_));

