//==========================================================================
//
//      io/serial/cortexm/cortexm_lm3s_ser.inl
//
//      LM3S Serial I/O definitions
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004, 2008, 2009 Free Software Foundation, Inc.                        
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: gthomas, jlarmour
// Date:         2009-07-30
// Purpose:      LM3S Serial I/O module
// Description: 
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <cyg/hal/hal_intr.h>
#include <cyg/hal/hal_io.h>

//-----------------------------------------------------------------------------

__externC cyg_uint32 hal_lm3s_sysclk;

#define _UART_CLK(__base) hal_lm3s_sysclk

//-----------------------------------------------------------------------------

#ifdef CYGPKG_IO_SERIAL_CORTEXM_LM3S_SERIAL0
static pl011_serial_info lm3s_serial_info0 = {CYGHWR_HAL_LM3S_UART0, CYGNUM_HAL_INTERRUPT_UART0};
#if CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL0_BUFSIZE > 0
static unsigned char lm3s_serial_out_buf0[CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL0_BUFSIZE];
static unsigned char lm3s_serial_in_buf0[CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL0_BUFSIZE];

static SERIAL_CHANNEL_USING_INTERRUPTS(lm3s_channel_serial0,
                                       pl011_serial_funs, 
                                       lm3s_serial_info0,
                                       CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL0_BAUD),
                                       CYG_SERIAL_STOP_DEFAULT,
                                       CYG_SERIAL_PARITY_DEFAULT,
                                       CYG_SERIAL_WORD_LENGTH_DEFAULT,
                                       CYG_SERIAL_FLAGS_DEFAULT,
                                       &lm3s_serial_out_buf0[0], sizeof(lm3s_serial_out_buf0),
                                       &lm3s_serial_in_buf0[0], sizeof(lm3s_serial_in_buf0)
    );
#else
static SERIAL_CHANNEL(lm3s_channel_serial0,
                      pl011_serial_funs, 
                      lm3s_serial_info0,
                      CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL0_BAUD),
                      CYG_SERIAL_STOP_DEFAULT,
                      CYG_SERIAL_PARITY_DEFAULT,
                      CYG_SERIAL_WORD_LENGTH_DEFAULT,
                      CYG_SERIAL_FLAGS_DEFAULT
    );
#endif

DEVTAB_ENTRY(lm3s_serial_io0, 
             CYGDAT_IO_SERIAL_CORTEXM_LM3S_SERIAL0_NAME,
             0,                     // Does not depend on a lower level interface
             &cyg_io_serial_devio, 
             pl011_serial_init, 
             pl011_serial_lookup,     // Serial driver may need initializing
             &lm3s_channel_serial0
    );
#endif //  CYGPKG_IO_SERIAL_CORTEXM_LM3S_SERIAL0

//-----------------------------------------------------------------------------

#ifdef CYGPKG_IO_SERIAL_CORTEXM_LM3S_SERIAL1
static pl011_serial_info lm3s_serial_info1 = {CYGHWR_HAL_LM3S_UART1, CYGNUM_HAL_INTERRUPT_UART1};
#if CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL1_BUFSIZE > 0
static unsigned char lm3s_serial_out_buf1[CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL1_BUFSIZE];
static unsigned char lm3s_serial_in_buf1[CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL1_BUFSIZE];

static SERIAL_CHANNEL_USING_INTERRUPTS(lm3s_channel_serial1,
                                       pl011_serial_funs, 
                                       lm3s_serial_info1,
                                       CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL1_BAUD),
                                       CYG_SERIAL_STOP_DEFAULT,
                                       CYG_SERIAL_PARITY_DEFAULT,
                                       CYG_SERIAL_WORD_LENGTH_DEFAULT,
                                       CYG_SERIAL_FLAGS_DEFAULT,
                                       &lm3s_serial_out_buf1[0], sizeof(lm3s_serial_out_buf1),
                                       &lm3s_serial_in_buf1[0], sizeof(lm3s_serial_in_buf1)
    );
#else
static SERIAL_CHANNEL(lm3s_channel_serial1,
                      pl011_serial_funs, 
                      lm3s_serial_info1,
                      CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL1_BAUD),
                      CYG_SERIAL_STOP_DEFAULT,
                      CYG_SERIAL_PARITY_DEFAULT,
                      CYG_SERIAL_WORD_LENGTH_DEFAULT,
                      CYG_SERIAL_FLAGS_DEFAULT
    );
#endif

DEVTAB_ENTRY(lm3s_serial_io1, 
             CYGDAT_IO_SERIAL_CORTEXM_LM3S_SERIAL1_NAME,
             0,                     // Does not depend on a lower level interface
             &cyg_io_serial_devio, 
             pl011_serial_init, 
             pl011_serial_lookup,     // Serial driver may need initializing
             &lm3s_channel_serial1
    );
#endif //  CYGPKG_IO_SERIAL_CORTEXM_LM3S_SERIAL1

//-----------------------------------------------------------------------------

#ifdef CYGPKG_IO_SERIAL_CORTEXM_LM3S_SERIAL2
static pl011_serial_info lm3s_serial_info2 = {CYGHWR_HAL_LM3S_UART2, CYGNUM_HAL_INTERRUPT_UART2};
#if CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL2_BUFSIZE > 0
static unsigned char lm3s_serial_out_buf2[CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL2_BUFSIZE];
static unsigned char lm3s_serial_in_buf2[CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL2_BUFSIZE];

static SERIAL_CHANNEL_USING_INTERRUPTS(lm3s_channel_serial2,
                                       pl011_serial_funs, 
                                       lm3s_serial_info2,
                                       CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL2_BAUD),
                                       CYG_SERIAL_STOP_DEFAULT,
                                       CYG_SERIAL_PARITY_DEFAULT,
                                       CYG_SERIAL_WORD_LENGTH_DEFAULT,
                                       CYG_SERIAL_FLAGS_DEFAULT,
                                       &lm3s_serial_out_buf2[0], sizeof(lm3s_serial_out_buf2),
                                       &lm3s_serial_in_buf2[0], sizeof(lm3s_serial_in_buf2)
    );
#else
static SERIAL_CHANNEL(lm3s_channel_serial2,
                      pl011_serial_funs, 
                      lm3s_serial_info2,
                      CYG_SERIAL_BAUD_RATE(CYGNUM_IO_SERIAL_CORTEXM_LM3S_SERIAL2_BAUD),
                      CYG_SERIAL_STOP_DEFAULT,
                      CYG_SERIAL_PARITY_DEFAULT,
                      CYG_SERIAL_WORD_LENGTH_DEFAULT,
                      CYG_SERIAL_FLAGS_DEFAULT
    );
#endif

DEVTAB_ENTRY(lm3s_serial_io2, 
             CYGDAT_IO_SERIAL_CORTEXM_LM3S_SERIAL2_NAME,
             0,                     // Does not depend on a lower level interface
             &cyg_io_serial_devio, 
             pl011_serial_init, 
             pl011_serial_lookup,     // Serial driver may need initializing
             &lm3s_channel_serial2
    );
#endif //  CYGPKG_IO_SERIAL_CORTEXM_LM3S_SERIAL2

//-----------------------------------------------------------------------------
// GPIO and clock setup
//
// An extra table containing the GPIO pin assignments and clock enable
// for each supported UART. This is here to avoid making major changes
// to the generic PL011 driver. Only the call to the macro needs to be
// added


struct
{
    cyg_addrword_t      base;
    cyg_uint32          rx_pin;
    cyg_uint32          tx_pin;
    cyg_uint32          clk_enable;
} lm3s_serial_config[] =
{
    {
        .base           = CYGHWR_HAL_LM3S_UART0,
        .rx_pin         = CYGHWR_HAL_LM3S_UART0_RX,
        .tx_pin         = CYGHWR_HAL_LM3S_UART0_TX,
        .clk_enable     = CYGHWR_HAL_LM3S_UART0_CLOCK
    },
    {
        .base           = CYGHWR_HAL_LM3S_UART1,
        .rx_pin         = CYGHWR_HAL_LM3S_UART1_RX,
        .tx_pin         = CYGHWR_HAL_LM3S_UART1_TX,
        .clk_enable     = CYGHWR_HAL_LM3S_UART1_CLOCK
    }
};


#define CYGHWR_IO_SERIAL_PL011_CONFIGURE( __info )                      \
{                                                                       \
    int i;                                                              \
    for( i = 0; i < sizeof(lm3s_serial_config)/sizeof(lm3s_serial_config[0]); i++ ) \
    {                                                                   \
        if( lm3s_serial_config[i].base == __info->base )                \
        {                                                               \
            CYGHWR_HAL_LM3S_GPIO_SET( lm3s_serial_config[i].rx_pin );   \
            CYGHWR_HAL_LM3S_GPIO_SET( lm3s_serial_config[i].tx_pin );   \
            CYGHWR_HAL_LM3S_CLOCK_ENABLE( lm3s_serial_config[i].clk_enable ); \
            break;                                                      \
        }                                                               \
    }                                                                   \
}

//-----------------------------------------------------------------------------
// EOF cortexm_lm3s_ser.inl
